/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.fenixedu.treasury.domain.tariff.InterestType;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class InterestRateBean
implements ITreasuryBean,
Serializable {
    private static final long serialVersionUID = 1L;
    private BigDecimal interestAmount;
    private InterestType interestType;
    private int numberOfDays;
    private int numberOfMonths;
    private String description;
    private List<InterestInformationDetail> interestInformationList = Lists.newArrayList();
    private List<CreatedInterestEntry> createdInterestEntriesList = Lists.newArrayList();

    public InterestRateBean() {
        this.setInterestType(null);
        this.setInterestAmount(BigDecimal.ZERO);
        this.setNumberOfDays(0);
        this.setNumberOfMonths(0);
    }

    public InterestRateBean(InterestType interestType) {
        this.setInterestType(interestType);
    }

    public InterestInformationDetail addDetail(BigDecimal amount, LocalDate begin, LocalDate end, BigDecimal amountPerUnit, BigDecimal affectedAmount, BigDecimal interestRate) {
        InterestInformationDetail detail = new InterestInformationDetail(amount, begin, end, amountPerUnit, affectedAmount, interestRate);
        this.interestInformationList.add(detail);
        return detail;
    }

    public CreatedInterestEntry addCreatedInterestEntry(LocalDate entryDate, BigDecimal amount) {
        CreatedInterestEntry entry = new CreatedInterestEntry(entryDate, amount);
        this.createdInterestEntriesList.add(entry);
        return entry;
    }

    public BigDecimal getInterestAmount() {
        return this.interestAmount;
    }

    public void setInterestAmount(BigDecimal amount) {
        this.interestAmount = amount;
    }

    public InterestType getInterestType() {
        return this.interestType;
    }

    public void setInterestType(InterestType interestType) {
        this.interestType = interestType;
    }

    public int getNumberOfDays() {
        return this.numberOfDays;
    }

    public void setNumberOfDays(int numberOfDays) {
        this.numberOfDays = numberOfDays;
    }

    public int getNumberOfMonths() {
        return this.numberOfMonths;
    }

    public void setNumberOfMonths(int numberOfMonths) {
        this.numberOfMonths = numberOfMonths;
    }

    public List<InterestInformationDetail> getInterestInformationList() {
        return this.interestInformationList;
    }

    public List<CreatedInterestEntry> getCreatedInterestEntriesList() {
        return this.createdInterestEntriesList;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static class CreatedInterestEntry
    implements ITreasuryBean,
    Serializable {
        private static final long serialVersionUID = 1L;
        private LocalDate entryDate;
        private BigDecimal amount;

        private CreatedInterestEntry(LocalDate entryDate, BigDecimal amount) {
            this.entryDate = entryDate;
            this.amount = amount;
        }

        public LocalDate getEntryDate() {
            return this.entryDate;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }
    }

    public static class InterestInformationDetail
    implements ITreasuryBean,
    Serializable {
        private static final long serialVersionUID = 1L;
        private BigDecimal amount;
        private LocalDate begin;
        private LocalDate end;
        private BigDecimal amountPerUnit;
        private BigDecimal affectedAmount;
        private BigDecimal interestRate;

        private InterestInformationDetail(BigDecimal amount, LocalDate begin, LocalDate end, BigDecimal amountPerUnit, BigDecimal affectedAmount, BigDecimal interestRate) {
            this.amount = amount;
            this.begin = begin;
            this.end = end;
            this.affectedAmount = affectedAmount;
            this.interestRate = interestRate;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public LocalDate getBegin() {
            return this.begin;
        }

        public LocalDate getEnd() {
            return this.end;
        }

        public BigDecimal getAmountPerUnit() {
            return this.amountPerUnit;
        }

        public int getNumberOfDays() {
            return Days.daysBetween((ReadablePartial)this.begin, (ReadablePartial)this.end).getDays() + 1;
        }

        public BigDecimal getAffectedAmount() {
            return this.affectedAmount;
        }

        public BigDecimal getInterestRate() {
            return this.interestRate;
        }
    }
}

