/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentPlan;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentEntry;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentSettlementEntry_Base;
import org.fenixedu.treasury.util.TreasuryConstants;
import pt.ist.fenixframework.FenixFramework;

public class InstallmentSettlementEntry
extends InstallmentSettlementEntry_Base {
    public InstallmentSettlementEntry() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    private InstallmentSettlementEntry(InstallmentEntry installmentEntry, SettlementEntry settlementEntry, BigDecimal debtAmount) {
        this();
        this.setSettlementEntry(settlementEntry);
        this.setInstallmentEntry(installmentEntry);
        this.setAmount(debtAmount);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getSettlementEntry() == null) {
            throw new TreasuryDomainException("error.InstallmentSettlementEntry.settlementEntry.required", new String[0]);
        }
        if (this.getAmount() == null || !TreasuryConstants.isPositive(this.getAmount())) {
            throw new TreasuryDomainException("error.InstallmentSettlementEntry.amount.must.be.positive", new String[0]);
        }
        if (this.getInstallmentEntry() == null) {
            throw new TreasuryDomainException("error.InstallmentSettlementEntry.installmentEntry.required", new String[0]);
        }
        if (InstallmentSettlementEntry.find(super.getInstallmentEntry(), super.getSettlementEntry()).count() > 1L) {
            throw new TreasuryDomainException("error.InstallmentSettlementEntry.entry.is.duplicated", new String[0]);
        }
        BigDecimal sumOfInstallmentSettlementEntries = this.getSettlementEntry().getInstallmentSettlementEntriesSet().stream().map(i -> i.getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (TreasuryConstants.isGreaterThan(sumOfInstallmentSettlementEntries, this.getSettlementEntry().getAmount())) {
            throw new TreasuryDomainException("error.InstallmentSettlementEntry.sum.of.installmentSettlementEntries.exceed.settlement.entry.amount", new String[0]);
        }
    }

    public static InstallmentSettlementEntry create(InstallmentEntry installmentEntry, SettlementEntry settlementEntry, BigDecimal debtAmount) {
        return new InstallmentSettlementEntry(installmentEntry, settlementEntry, debtAmount);
    }

    public static Set<InstallmentSettlementEntry> settleInstallmentEntriesOfDebitEntry(SettlementEntry settlementEntry) {
        if (!settlementEntry.getInvoiceEntry().isDebitNoteEntry()) {
            throw new TreasuryDomainException("error.InstallmentSettlementEntry.settleForDebitEntry.expecting.settlementEntry.forDebitEntry", new String[0]);
        }
        if (!settlementEntry.getInstallmentSettlementEntriesSet().isEmpty()) {
            throw new TreasuryDomainException("error.InstallmentSettlementEntry.settlementEntry.already.has.installmentSettlementEntries", new String[0]);
        }
        HashSet<InstallmentSettlementEntry> result = new HashSet<InstallmentSettlementEntry>();
        DebitEntry debitEntry = (DebitEntry)((Object)settlementEntry.getInvoiceEntry());
        BigDecimal rest = settlementEntry.getAmount();
        for (InstallmentEntry installmentEntry : debitEntry.getSortedOpenInstallmentEntries()) {
            if (!TreasuryConstants.isPositive(rest)) break;
            if (installmentEntry.isPaid()) continue;
            BigDecimal debtAmount = rest.compareTo(installmentEntry.getOpenAmount()) > 0 ? installmentEntry.getOpenAmount() : rest;
            rest = rest.subtract(debtAmount);
            result.add(InstallmentSettlementEntry.create(installmentEntry, settlementEntry, debtAmount));
            installmentEntry.getInstallment().getPaymentPlan().tryClosePaymentPlanByPaidOff();
        }
        return result;
    }

    public static Stream<InstallmentSettlementEntry> find(InstallmentEntry installmentEntry, SettlementEntry settlementEntry) {
        return installmentEntry.getInstallmentSettlementEntriesSet().stream().filter(i -> i.getSettlementEntry() == settlementEntry);
    }

    public static Optional<InstallmentSettlementEntry> findUnique(InstallmentEntry installmentEntry, SettlementEntry settlementEntry) {
        return InstallmentSettlementEntry.find(installmentEntry, settlementEntry).findFirst();
    }
}

