/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry_Base;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialEntryType;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.treasurydebtprocess.TreasuryDebtProcessMainService;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class CreditEntry
extends CreditEntry_Base {
    protected CreditEntry(FinantialDocument finantialDocument, Product product, Vat vat, BigDecimal unitAmount, String description, BigDecimal quantity, DateTime entryDateTime, DebitEntry debitEntry, TreasuryExemption treasuryExemption) {
        this.init(finantialDocument, product, vat, unitAmount, description, quantity, entryDateTime, debitEntry, treasuryExemption);
    }

    public boolean isCreditNoteEntry() {
        return true;
    }

    protected void init(FinantialDocument finantialDocument, DebtAccount debtAccount, Product product, FinantialEntryType finantialEntryType, Vat vat, BigDecimal amount, String description, BigDecimal quantity, DateTime entryDateTime) {
        throw new RuntimeException("error.CreditEntry.use.init.without.finantialEntryType");
    }

    protected void init(FinantialDocument finantialDocument, Product product, Vat vat, BigDecimal unitAmount, String description, BigDecimal quantity, DateTime entryDateTime, DebitEntry debitEntry, TreasuryExemption treasuryExemption) {
        super.init(finantialDocument, finantialDocument.getDebtAccount(), product, FinantialEntryType.CREDIT_ENTRY, vat, unitAmount, description, quantity, entryDateTime);
        this.setDebitEntry(debitEntry);
        this.setFromExemption(treasuryExemption != null);
        this.setTreasuryExemption(treasuryExemption);
        this.recalculateAmountValues();
        this.checkRules();
    }

    protected void checkRules() {
        super.checkRules();
        if (this.getFinantialDocument() != null && !(this.getFinantialDocument() instanceof CreditNote)) {
            throw new TreasuryDomainException("error.CreditEntry.finantialDocument.not.credit.entry.type", new String[0]);
        }
        if (this.getFromExemption() && this.getDebitEntry() == null) {
            throw new TreasuryDomainException("error.CreditEntry.from.exemption.requires.debit.entry", new String[0]);
        }
        if (this.getDebitEntry() != null && this.getDebitEntry().getProduct() != this.getProduct()) {
            throw new TreasuryDomainException("error.CreditEntry.product.must.be.the.same.as.debit.entry", new String[0]);
        }
        if (this.getFromExemption() && this.getTreasuryExemption() == null) {
            throw new TreasuryDomainException("error.CreditEntry.from.exemption.at.most.one.per.debit.entry", new String[0]);
        }
        if (this.getDebitEntry() != null && TreasuryConstants.isGreaterThan(this.getDebitEntry().getTotalCreditedAmount(), this.getDebitEntry().getTotalAmount())) {
            throw new TreasuryDomainException("error.CreditEntry.reated.debit.entry.invalid.total.credited.amount", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getDescription())) {
            throw new TreasuryDomainException("error.CreditEntry.description.required", new String[0]);
        }
    }

    public boolean isFromExemption() {
        return this.getFromExemption();
    }

    public void delete() {
        this.setDebitEntry(null);
        super.delete();
    }

    public void edit(String description) {
        if (this.isFromExemption()) {
            throw new TreasuryDomainException("error.CreditEntry.cannot.edit.due.to.exemption.origin", new String[0]);
        }
        this.setDescription(description);
        this.checkRules();
    }

    public static Stream<CreditEntry> findAll() {
        return FinantialDocumentEntry.findAll().filter(f -> f instanceof CreditEntry).map(CreditEntry.class::cast);
    }

    public LocalDate getDueDate() {
        return this.getEntryDateTime().toLocalDate();
    }

    public static Stream<? extends CreditEntry> find(CreditNote creditNote) {
        return creditNote.getFinantialDocumentEntriesSet().stream().filter(f -> f instanceof CreditEntry).map(CreditEntry.class::cast);
    }

    public static Stream<? extends CreditEntry> find(TreasuryEvent treasuryEvent) {
        return DebitEntry.find(treasuryEvent).map(d -> d.getCreditEntriesSet()).reduce((a, b) -> Sets.union((Set)a, (Set)b)).orElse(Sets.newHashSet()).stream();
    }

    public static Stream<? extends CreditEntry> findActive(TreasuryEvent treasuryEvent) {
        return DebitEntry.findActive(treasuryEvent).map(d -> d.getCreditEntriesSet()).reduce((a, b) -> Sets.union((Set)a, (Set)b)).orElse(Sets.newHashSet()).stream();
    }

    public static Stream<? extends CreditEntry> findActive(TreasuryEvent treasuryEvent, Product product) {
        return DebitEntry.findActive(treasuryEvent, product).map(d -> d.getCreditEntriesSet()).reduce((a, b) -> Sets.union((Set)a, (Set)b)).orElse(Sets.newHashSet()).stream();
    }

    public static CreditEntry create(FinantialDocument finantialDocument, String description, Product product, Vat vat, BigDecimal unitAmount, DateTime entryDateTime, DebitEntry debitEntry, BigDecimal quantity) {
        if (TreasuryDebtProcessMainService.isFinantialDocumentEntryAnnullmentActionBlocked((FinantialDocumentEntry)((Object)debitEntry))) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.annul.or.credit.due.to.existing.active.debt.process", new String[0]);
        }
        CreditEntry cr = new CreditEntry(finantialDocument, product, vat, unitAmount, description, quantity, entryDateTime, debitEntry, null);
        return cr;
    }

    static CreditEntry createFromExemption(TreasuryExemption treasuryExemption, FinantialDocument finantialDocument, String description, BigDecimal unitAmount, DateTime entryDateTime, DebitEntry debitEntry, BigDecimal quantity) {
        if (TreasuryDebtProcessMainService.isFinantialDocumentEntryAnnullmentActionBlocked((FinantialDocumentEntry)((Object)debitEntry))) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.annul.or.credit.due.to.existing.active.debt.process", new String[0]);
        }
        if (treasuryExemption == null) {
            throw new TreasuryDomainException("error.CreditEntry.createFromExemption.requires.treasuryExemption", new String[0]);
        }
        CreditEntry cr = new CreditEntry(finantialDocument, debitEntry.getProduct(), debitEntry.getVat(), unitAmount, description, quantity, entryDateTime, debitEntry, treasuryExemption);
        return cr;
    }

    public BigDecimal getOpenAmountWithInterests() {
        return this.getOpenAmount();
    }

    public CreditNote getCreditNote() {
        return (CreditNote)((Object)this.getFinantialDocument());
    }

    public CreditEntry splitCreditEntry(BigDecimal remainingAmountWithVat) {
        if (!TreasuryConstants.isLessThan(remainingAmountWithVat, this.getOpenAmount())) {
            throw new TreasuryDomainException("error.CreditEntry.splitCreditEntry.remainingAmount.less.than.open.amount", new String[0]);
        }
        if (!this.getFinantialDocument().isPreparing()) {
            throw new TreasuryDomainException("error.CreditEntry.splitCreditEntry.finantialDocument.not.preparing", new String[0]);
        }
        BigDecimal oldNetAmount = this.getNetAmount();
        BigDecimal oldAmountWithVat = this.getAmountWithVat();
        Currency currency = this.getDebtAccount().getFinantialInstitution().getCurrency();
        CreditNote newCreditNote = CreditNote.create(this.getDebtAccount(), this.getFinantialDocument().getDocumentNumberSeries(), this.getFinantialDocument().getDocumentDate(), ((CreditNote)((Object)this.getFinantialDocument())).getDebitNote(), this.getFinantialDocument().getOriginDocumentNumber());
        newCreditNote.setDocumentObservations(this.getFinantialDocument().getDocumentObservations());
        newCreditNote.setDocumentTermsAndConditions(this.getFinantialDocument().getDocumentTermsAndConditions());
        BigDecimal remainingAmountWithoutVatDividedByQuantity = Currency.getValueWithScale(TreasuryConstants.divide(TreasuryConstants.divide(remainingAmountWithVat, BigDecimal.ONE.add(TreasuryConstants.rationalVatRate((InvoiceEntry)((Object)this)))), this.getQuantity()));
        BigDecimal newOpenAmountWithoutVatDividedByQuantity = TreasuryConstants.divide(TreasuryConstants.divide(this.getOpenAmount(), BigDecimal.ONE.add(TreasuryConstants.rationalVatRate((InvoiceEntry)((Object)this)))), this.getQuantity());
        this.setAmount(newOpenAmountWithoutVatDividedByQuantity.subtract(remainingAmountWithoutVatDividedByQuantity));
        this.recalculateAmountValues();
        CreditEntry newCreditEntry = CreditEntry.create((FinantialDocument)((Object)newCreditNote), this.getDescription(), this.getProduct(), this.getVat(), remainingAmountWithoutVatDividedByQuantity, this.getEntryDateTime(), this.getDebitEntry(), this.getQuantity());
        newCreditEntry.setFromExemption(this.isFromExemption());
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && this.getFinantialDocument().isExportedInLegacyERP()) {
            newCreditEntry.getFinantialDocument().setExportedInLegacyERP(true);
            newCreditEntry.getFinantialDocument().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
        }
        if (oldNetAmount.compareTo(this.getNetAmount().add(newCreditEntry.getNetAmount())) != 0) {
            throw new IllegalStateException("error.CreditEntry.splitCreditEntry.netAmount.before.after.not.equal");
        }
        if (oldAmountWithVat.compareTo(this.getAmountWithVat().add(newCreditEntry.getAmountWithVat())) != 0) {
            throw new IllegalStateException("error.CreditEntry.splitCreditEntry.amountWithVat.before.after.not.equal");
        }
        return newCreditEntry;
    }
}

