/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.VatExemptionReason$callable$create;
import org.fenixedu.treasury.domain.VatExemptionReason$callable$delete;
import org.fenixedu.treasury.domain.VatExemptionReason$callable$edit;
import org.fenixedu.treasury.domain.VatExemptionReason_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class VatExemptionReason
extends VatExemptionReason_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected VatExemptionReason() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected VatExemptionReason(String code, LocalizedString name) {
        this();
        this.setCode(code);
        this.setName(name);
        this.checkRules();
    }

    private void checkRules() {
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.VatExemptionReason.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.VatExemptionReason.name.required", new String[0]);
        }
        VatExemptionReason.findByCode(this.getCode());
        this.getName().getLocales().stream().forEach(l -> VatExemptionReason.findByName(this.getName().getContent(l)));
    }

    public void edit(String string, LocalizedString localizedString) {
        Object object = advice$edit.perform((Callable)new VatExemptionReason$callable$edit(this, string, localizedString));
    }

    static /* synthetic */ void advised$edit(VatExemptionReason this_, String code, LocalizedString name) {
        this_.setCode(code);
        this_.setName(name);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getProductsSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new VatExemptionReason$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(VatExemptionReason this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.VatExemptionReason.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.deleteDomainObject();
    }

    public static Stream<VatExemptionReason> findAll() {
        return FenixFramework.getDomainRoot().getVatExemptionReasonsSet().stream();
    }

    public static VatExemptionReason findByCode(String code) {
        VatExemptionReason result = null;
        for (VatExemptionReason it : VatExemptionReason.findAll().collect(Collectors.toList())) {
            if (!it.getCode().equalsIgnoreCase(code)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.VatExemptionReason.duplicated.code", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static VatExemptionReason findByName(String name) {
        VatExemptionReason result = null;
        for (VatExemptionReason it : VatExemptionReason.findAll().collect(Collectors.toList())) {
            if (!LocalizedStringUtil.isEqualToAnyLocaleIgnoreCase(it.getName(), name)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.VatExemptionReason.duplicated.name", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static VatExemptionReason create(String string, LocalizedString localizedString) {
        return (VatExemptionReason)((Object)advice$create.perform((Callable)new VatExemptionReason$callable$create(string, localizedString)));
    }

    static /* synthetic */ VatExemptionReason advised$create(String code, LocalizedString name) {
        return new VatExemptionReason(code, name);
    }
}

