/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product$callable$create;
import org.fenixedu.treasury.domain.Product$callable$delete;
import org.fenixedu.treasury.domain.Product$callable$deleteOrphanProducts;
import org.fenixedu.treasury.domain.Product$callable$edit;
import org.fenixedu.treasury.domain.ProductGroup;
import org.fenixedu.treasury.domain.Product_Base;
import org.fenixedu.treasury.domain.VatExemptionReason;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.tariff.FixedTariff;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Product
extends Product_Base {
    public static final int MAX_CODE_LENGTH = 20;
    public static final Comparator<Product> COMPARE_BY_NAME;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;
    public static final Advice advice$deleteOrphanProducts;

    protected Product() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected Product(ProductGroup productGroup, String code, LocalizedString name, LocalizedString unitOfMeasure, boolean active, boolean legacy, int tuitionInstallmentOrder, VatType vatType, List<FinantialInstitution> finantialInstitutions, VatExemptionReason vatExemptionReason) {
        this();
        this.setProductGroup(productGroup);
        this.setCode(code);
        this.setName(name);
        this.setUnitOfMeasure(unitOfMeasure);
        this.setActive(active);
        this.setLegacy(legacy);
        this.setTuitionInstallmentOrder(tuitionInstallmentOrder);
        this.setVatType(vatType);
        this.setVatExemptionReason(vatExemptionReason);
        this.updateFinantialInstitutions(finantialInstitutions);
        this.checkRules();
    }

    public void checkRules() {
        if (this.getVatType() == null) {
            throw new TreasuryDomainException("error.Product.vatType.required", new String[0]);
        }
        if (this.getProductGroup() == null) {
            throw new TreasuryDomainException("error.Product.productGroup.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.Product.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.Product.name.required", new String[0]);
        }
        if (Product.findByCode(this.getCode()).count() > 1L) {
            throw new TreasuryDomainException("error.Product.code.duplicated", this.getCode());
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getUnitOfMeasure())) {
            throw new TreasuryDomainException("error.Product.unitOfMeasure.required", new String[0]);
        }
        if (this.getCode().length() > 20) {
            throw new TreasuryDomainException("error.Product.code.size.exceded", new String[0]);
        }
    }

    public boolean isActive() {
        return this.getActive();
    }

    public boolean isLegacy() {
        return this.getLegacy();
    }

    public void edit(LocalizedString localizedString, LocalizedString localizedString2, boolean bl, boolean bl2, int n, VatType vatType, ProductGroup productGroup, List<FinantialInstitution> list, VatExemptionReason vatExemptionReason) {
        Object object = advice$edit.perform((Callable)new Product$callable$edit(this, localizedString, localizedString2, bl, bl2, n, vatType, productGroup, list, vatExemptionReason));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$edit(Product this_, LocalizedString name, LocalizedString unitOfMeasure, boolean active, boolean legacy, int tuitionInstallmentOrder, VatType vatType, ProductGroup productGroup, List finantialInstitutions, VatExemptionReason vatExemptionReason) {
        if (!TreasuryPlataformDependentServicesFactory.implementation().isProductCertified(this_)) {
            this_.setName(name);
        }
        this_.setUnitOfMeasure(unitOfMeasure);
        this_.setActive(active);
        this_.setLegacy(legacy);
        this_.setTuitionInstallmentOrder(tuitionInstallmentOrder);
        this_.setVatType(vatType);
        this_.setProductGroup(productGroup);
        this_.setVatExemptionReason(vatExemptionReason);
        this_.updateFinantialInstitutions(finantialInstitutions);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getInvoiceEntriesSet().isEmpty() && this.getTreasuryExemptionSet().isEmpty() && this.getTreasuryEventsSet().isEmpty() && this.getAdvancePaymentTreasurySettings() == null && this.getTreasurySettings() == null;
    }

    public boolean isTransferBalanceProduct() {
        return this == TreasurySettings.getInstance().getTransferBalanceProduct();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new Product$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Product this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.Product.cannot.delete", new String[0]);
        }
        this_.setProductGroup(null);
        this_.setDomainRoot(null);
        this_.setVatType(null);
        for (FinantialInstitution inst : this_.getFinantialInstitutionsSet()) {
            for (Tariff t : this_.getTariffsSet(inst)) {
                t.delete();
            }
            this_.removeFinantialInstitutions(inst);
        }
        this_.setVatExemptionReason(null);
        this_.deleteDomainObject();
    }

    public static Stream<Product> findAll() {
        return FenixFramework.getDomainRoot().getProductsSet().stream();
    }

    public static Stream<Product> findAllActive() {
        return FenixFramework.getDomainRoot().getProductsSet().stream().filter(x -> x.getActive());
    }

    public static Stream<Product> findByCode(String code) {
        return Product.findAll().filter(p -> p.getCode().equalsIgnoreCase(code));
    }

    public static Optional<Product> findUniqueByCode(String code) {
        return Product.findByCode(code).findFirst();
    }

    public static Stream<Product> findByName(String name) {
        return Product.findAll().filter(p -> LocalizedStringUtil.isEqualToAnyLocaleIgnoreCase(p.getName(), name));
    }

    public static LocalizedString defaultUnitOfMeasure() {
        return TreasuryConstants.treasuryBundleI18N("label.unitOfMeasure.default", new String[0]);
    }

    public static Stream<Product> findAllLegacy() {
        return Product.findAll().filter(p -> p.isLegacy());
    }

    public static Product create(ProductGroup productGroup, String string, LocalizedString localizedString, LocalizedString localizedString2, boolean bl, boolean bl2, int n, VatType vatType, List<FinantialInstitution> list, VatExemptionReason vatExemptionReason) {
        return (Product)((Object)advice$create.perform((Callable)new Product$callable$create(productGroup, string, localizedString, localizedString2, bl, bl2, n, vatType, list, vatExemptionReason)));
    }

    static /* synthetic */ Product advised$create(ProductGroup productGroup, String code, LocalizedString name, LocalizedString unitOfMeasure, boolean active, boolean legacy, int tuitionInstallmentOrder, VatType vatType, List<FinantialInstitution> finantialInstitutions, VatExemptionReason vatExemptionReason) {
        return new Product(productGroup, code, name, unitOfMeasure, active, legacy, tuitionInstallmentOrder, vatType, finantialInstitutions, vatExemptionReason);
    }

    public Stream<Tariff> getTariffs(FinantialInstitution finantialInstitution) {
        return this.getTariffSet().stream().filter(x -> x.getFinantialEntity().getFinantialInstitution().equals((Object)finantialInstitution));
    }

    public Set<Tariff> getTariffsSet(FinantialInstitution finantialInstitution) {
        return this.getTariffs(finantialInstitution).collect(Collectors.toSet());
    }

    public Stream<FixedTariff> getFixedTariffs(FinantialInstitution finantialInstitution) {
        return this.getTariffSet().stream().filter(x -> x instanceof FixedTariff).filter(x -> x.getFinantialEntity().getFinantialInstitution().equals((Object)finantialInstitution)).map(FixedTariff.class::cast);
    }

    public Set<FixedTariff> getFixedTariffsSet(FinantialInstitution finantialInstitution) {
        return this.getFixedTariffs(finantialInstitution).collect(Collectors.toSet());
    }

    public Stream<Tariff> getActiveTariffs(FinantialInstitution finantialInstitution, DateTime when) {
        return this.getTariffSet().stream().filter(x -> x.getFinantialEntity().getFinantialInstitution().equals((Object)finantialInstitution)).filter(x -> x.getBeginDate() != null && x.getBeginDate().isBefore((ReadableInstant)when) && (x.getEndDate() == null || x.getEndDate().isAfter((ReadableInstant)when)));
    }

    public Set<Tariff> getActiveTariffsSet(FinantialInstitution finantialInstitution) {
        return this.getActiveTariffs(finantialInstitution, new DateTime()).collect(Collectors.toSet());
    }

    public void updateFinantialInstitutions(List<FinantialInstitution> finantialInstitutions) {
        if (finantialInstitutions == null) {
            finantialInstitutions = Collections.emptyList();
        }
        for (FinantialInstitution inst : this.getFinantialInstitutionsSet()) {
            if (finantialInstitutions.contains((Object)inst)) continue;
            if (this.canRemoveFinantialInstitution(inst)) {
                this.removeFinantialInstitutions(inst);
                inst.removeAvailableProducts(this);
                continue;
            }
            throw new TreasuryDomainException("error.product.cannot.remove.finantialentity", new String[0]);
        }
        for (FinantialInstitution inst2 : finantialInstitutions) {
            if (this.getFinantialInstitutionsSet().contains((Object)inst2)) continue;
            this.addFinantialInstitutions(inst2);
            inst2.addAvailableProducts(this);
        }
    }

    private boolean canRemoveFinantialInstitution(FinantialInstitution inst) {
        return true;
    }

    public static int deleteOrphanProducts() {
        return (Integer)advice$deleteOrphanProducts.perform((Callable)new Product$callable$deleteOrphanProducts());
    }

    static /* synthetic */ int advised$deleteOrphanProducts() {
        int count = 0;
        for (Product x : Product.findAll().collect(Collectors.toList())) {
            if (x.getActive() || !x.isDeletable()) continue;
            x.delete();
            ++count;
        }
        return count;
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$deleteOrphanProducts = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_NAME = new Comparator<Product>(){

            @Override
            public int compare(Product o1, Product o2) {
                int c = o1.getName().getContent().compareTo(o2.getName().getContent());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

