/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.paypal;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.paypal.PayPal;
import org.fenixedu.treasury.domain.paypal.PayPalLog;
import org.fenixedu.treasury.services.payments.paypal.PayPalWebhookBean;
import org.fenixedu.treasury.services.payments.paypal.PayPalWebhooksController$callable$createLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Path(value="/paypal_callback")
public class PayPalWebhooksController {
    private static final Logger logger;
    private static final String NOTIFICATION_URI = "/";
    public static final Advice advice$createLog;

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    public Response notification(String body, @Context HttpServletRequest httpRequest, @Context HttpServletResponse response) {
        PayPalLog log = this.createLog();
        FenixFramework.atomic(() -> log.saveRequest(body));
        PayPalWebhookBean bean = new PayPalWebhookBean(body);
        FenixFramework.atomic(() -> {
            log.logRequestReceiveDateAndData(bean.getTransactionId(), "Notification", bean.getEvent_type(), bean.getAmount(), bean.getResource_type(), bean.isOperationSuccess());
            log.setTransactionWithPayment(bean.isPaid());
        });
        try {
            Optional forwardPaymentRequesteOptional = Optional.ofNullable(null);
            if (bean.getOrder() != null) {
                forwardPaymentRequesteOptional = ForwardPaymentRequest.findUniqueBySibsGatewayTransactionId((String)bean.getOrder().id());
            }
            if (forwardPaymentRequesteOptional.isPresent()) {
                ForwardPaymentRequest forwardPaymentRequest = (ForwardPaymentRequest)((Object)forwardPaymentRequesteOptional.get());
                PayPal digitalPaymentPlatform = (PayPal)((Object)forwardPaymentRequest.getDigitalPaymentPlatform());
                FenixFramework.atomic(() -> log.setPaymentRequest((PaymentRequest)((Object)((Object)((Object)forwardPaymentRequest)))));
                digitalPaymentPlatform.processForwardPaymentFromWebhook((PaymentRequestLog)((Object)log), bean);
            } else {
                FenixFramework.atomic(() -> log.logRequestReceiveDateAndData(bean.getTransactionId(), "Notification", "forwardPayment", bean.getAmount(), bean.getOrder().status(), bean.isOperationSuccess()));
            }
            return Response.ok().build();
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            if (log != null) {
                FenixFramework.atomic(() -> log.logException(e));
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    OnlinePaymentsGatewayCommunicationException oe = (OnlinePaymentsGatewayCommunicationException)e;
                    FenixFramework.atomic(() -> {
                        log.saveRequest(oe.getRequestLog());
                        log.saveResponse(oe.getResponseLog());
                    });
                }
            }
            return Response.serverError().build();
        }
    }

    private PayPalLog createLog() {
        return (PayPalLog)((Object)advice$createLog.perform((Callable)new PayPalWebhooksController$callable$createLog(this)));
    }

    static /* synthetic */ PayPalLog advised$createLog(PayPalWebhooksController this_) {
        return PayPalLog.createLogForWebhookNotification();
    }

    static {
        advice$createLog = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        logger = LoggerFactory.getLogger(PayPalWebhooksController.class);
    }
}

