/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Optional;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class ReimbursementUtils {
    public static boolean isInReimbursementCreditsRestrictionModeOfSAP(CreditNote creditNote) {
        return !creditNote.getDebtAccount().getFinantialInstitution().isToCloseCreditNoteWhenCreated();
    }

    public static boolean isInReimbursementCreditsRestrictionModeOfSAP(CreditEntry creditEntry) {
        return !creditEntry.getDebtAccount().getFinantialInstitution().isToCloseCreditNoteWhenCreated();
    }

    public static boolean isCreditNoteSettledWithPayment(CreditNote creditNote) {
        return creditNote.getCreditEntries().flatMap(c -> c.getSettlementEntriesSet().stream()).filter(se -> !((SettlementNote)((Object)((Object)((Object)se.getFinantialDocument())))).isReimbursement()).count() > 0L;
    }

    public static boolean isCreditNoteForReimbursementMustBeClosedWithDebitNoteAndCreatedNew(CreditEntry creditEntry) {
        if (!ReimbursementUtils.isInReimbursementCreditsRestrictionModeOfSAP(creditEntry)) {
            return false;
        }
        CreditNote creditNote = (CreditNote)((Object)creditEntry.getFinantialDocument());
        if (creditNote.isAnnulled()) {
            throw new TreasuryDomainException("error.ReimbursementUtils.creditNote.annulled", new String[0]);
        }
        if (creditNote.isPreparing()) {
            if (creditNote.getCreditEntries().flatMap(c -> c.getSettlementEntriesSet().stream()).count() > 0L) {
                throw new TreasuryDomainException("error.ReimbursementUtils.creditNote.with.settlement.entries.already", new String[0]);
            }
            return false;
        }
        if (creditNote.isAdvancePayment()) {
            return false;
        }
        if (creditNote.isExportedInLegacyERP()) {
            return true;
        }
        if (creditNote.getDocumentNumberSeries().getSeries().isRegulationSeries() && creditNote.getCloseDate().isBefore((ReadableInstant)SAPExporter.ERP_INTEGRATION_START_DATE)) {
            return true;
        }
        if (creditNote.getCloseDate().isBefore((ReadableInstant)SAPExporter.ERP_INTEGRATION_START_DATE)) {
            throw new TreasuryDomainException("error.ReimbursementUtils.creditNote.marked.as.exportedInLegacyERP.but.close.date.not.conformant", new String[0]);
        }
        return ReimbursementUtils.isCreditNoteSettledWithPayment(creditNote);
    }

    public static CreditEntry closeWithDebitNoteAndCreateNewCreditNoteForReimbursement(CreditEntry originalCreditEntry, BigDecimal amountToReimburseWithVat) {
        DateTime now = new DateTime();
        DebtAccount debtAccount = originalCreditEntry.getDebtAccount();
        FinantialInstitution finantialInstitution = debtAccount.getFinantialInstitution();
        CreditNote originalCreditNote = (CreditNote)((Object)originalCreditEntry.getFinantialDocument());
        Series series = Series.findUniqueDefault(finantialInstitution).get();
        DebtAccount payorDebtAccount = originalCreditNote.getPayorDebtAccount();
        DocumentNumberSeries debitNumberSeries = DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), series);
        DocumentNumberSeries creditNumberSeries = DocumentNumberSeries.find(FinantialDocumentType.findForCreditNote(), series);
        DocumentNumberSeries settlementNumberSeries = DocumentNumberSeries.find(FinantialDocumentType.findForSettlementNote(), series);
        if (TreasuryConstants.isGreaterThan(amountToReimburseWithVat, originalCreditEntry.getOpenAmount())) {
            throw new TreasuryDomainException("error.ReimbursementUtils.amountToReimburse.greater.than.open.amount.of.credit", new String[0]);
        }
        if (originalCreditNote.isPreparing()) {
            originalCreditNote.closeDocument();
        }
        Vat vat = originalCreditEntry.getVat();
        BigDecimal amountToReimburseWithoutVat = TreasuryConstants.divide(amountToReimburseWithVat, BigDecimal.ONE.add(TreasuryConstants.rationalVatRate((InvoiceEntry)((Object)originalCreditEntry))));
        DebitNote compensationDebitNote = DebitNote.create(debtAccount, payorDebtAccount, debitNumberSeries, now, new LocalDate(), originalCreditNote.getUiDocumentNumber());
        DebitEntry compensationDebitEntry = DebitEntry.create(Optional.of(compensationDebitNote), debtAccount, null, vat, amountToReimburseWithoutVat, new LocalDate(), Maps.newHashMap(), originalCreditEntry.getProduct(), TreasuryConstants.treasuryBundle("label.ReimbursementUtils.compensation.debit.entry.description", originalCreditEntry.getDescription()), BigDecimal.ONE, null, now);
        compensationDebitNote.closeDocument();
        ReimbursementUtils.settlementCompensation(originalCreditEntry, amountToReimburseWithVat, now, debtAccount, settlementNumberSeries, compensationDebitEntry);
        CreditNote creditNoteToReimburse = CreditNote.create(debtAccount, creditNumberSeries, now, compensationDebitNote, originalCreditNote.getUiDocumentNumber());
        CreditEntry creditEntryToReimburse = compensationDebitEntry.createCreditEntry(now, originalCreditEntry.getDescription(), originalCreditNote.getDocumentObservations(), originalCreditNote.getDocumentTermsAndConditions(), amountToReimburseWithoutVat, null, creditNoteToReimburse);
        return creditEntryToReimburse;
    }

    private static void settlementCompensation(CreditEntry originalCreditEntry, BigDecimal amountToReimburseWithVat, DateTime now, DebtAccount debtAccount, DocumentNumberSeries settlementNumberSeries, DebitEntry compensationDebitEntry) {
        SettlementNote compensationSettlementNote = SettlementNote.create(debtAccount, settlementNumberSeries, now, now, null, null);
        SettlementEntry.create((InvoiceEntry)((Object)compensationDebitEntry), compensationSettlementNote, amountToReimburseWithVat, compensationDebitEntry.getDescription(), now, false);
        SettlementEntry.create((InvoiceEntry)((Object)originalCreditEntry), compensationSettlementNote, amountToReimburseWithVat, originalCreditEntry.getDescription(), now, false);
        compensationSettlementNote.closeDocument();
    }
}

