/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentStateType;
import org.fenixedu.treasury.domain.document.Invoice$callable$delete;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.Invoice_Base;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class Invoice
extends Invoice_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected Invoice() {
    }

    protected void checkRules() {
        if (this.getDebtAccount() == this.getPayorDebtAccount()) {
            throw new TreasuryDomainException("error.Invoice.payor.same.as.debt.account", new String[0]);
        }
        if (this.getPayorDebtAccount() != null && !this.getPayorDebtAccount().getCustomer().isAdhocCustomer()) {
            throw new TreasuryDomainException("error.Invoice.payor.debt.account.not.adhoc.customer", new String[0]);
        }
        for (FinantialDocumentEntry entry : this.getFinantialDocumentEntriesSet()) {
            InvoiceEntry invoiceEntry = (InvoiceEntry)((Object)entry);
            if (invoiceEntry.getDebtAccount().equals((Object)this.getDebtAccount())) continue;
            throw new TreasuryDomainException("error.Invoice.debtaccount.mismatch.invoiceentries.debtaccount", new String[0]);
        }
        super.checkRules();
    }

    protected void init(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate) {
        if (debtAccount.getClosed()) {
            throw new TreasuryDomainException("error.Invoice.debtAccount.closed", new String[0]);
        }
        super.init(debtAccount, documentNumberSeries, documentDate);
    }

    protected void init(DebtAccount debtAccount, DebtAccount payorDebtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate) {
        this.init(debtAccount, documentNumberSeries, documentDate);
        if (debtAccount == payorDebtAccount) {
            throw new TreasuryDomainException("error.Invoice.payor.same.as.debt.account", new String[0]);
        }
        this.setPayorDebtAccount(payorDebtAccount);
    }

    public boolean isInvoice() {
        return true;
    }

    public boolean isDeletable() {
        if (this.getState() != FinantialDocumentStateType.PREPARING) {
            return false;
        }
        return super.isDeletable();
    }

    public void delete(boolean bl) {
        Object object = advice$delete.perform((Callable)new Invoice$callable$delete(this, bl));
    }

    static /* synthetic */ void advised$delete(Invoice this_, boolean deleteEntries) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.Invoice.cannot.delete", new String[0]);
        }
        TreasuryDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        this_.setPayorDebtAccount(null);
        super.delete(deleteEntries);
    }

    public static Stream<? extends Invoice> findAll() {
        return FinantialDocument.findAll().filter(x -> x instanceof Invoice).map(Invoice.class::cast);
    }

    public static Stream<? extends Invoice> find(DebtAccount debtAccount) {
        return debtAccount.getFinantialDocumentsSet().stream().filter(x -> x instanceof Invoice).map(Invoice.class::cast);
    }

    public BigDecimal getTotalVatAmount() {
        BigDecimal vat = BigDecimal.ZERO;
        for (FinantialDocumentEntry entry : this.getFinantialDocumentEntriesSet()) {
            vat = vat.add(((InvoiceEntry)((Object)entry)).getVatAmount());
        }
        return vat;
    }

    public Set<SettlementEntry> getRelatedSettlementEntries() {
        HashSet<SettlementEntry> result = new HashSet<SettlementEntry>();
        for (FinantialDocumentEntry entry : this.getFinantialDocumentEntriesSet()) {
            InvoiceEntry invoiceEntry = (InvoiceEntry)((Object)entry);
            if (invoiceEntry.getSettlementEntriesSet().size() <= 0) continue;
            for (SettlementEntry settlementEntry : invoiceEntry.getSettlementEntriesSet()) {
                if (!settlementEntry.getFinantialDocument().isClosed()) continue;
                result.add(settlementEntry);
            }
        }
        return result;
    }

    public boolean hasValidSettlementEntries() {
        return this.getRelatedSettlementEntries().stream().anyMatch(y -> y.getFinantialDocument().isClosed() || y.getFinantialDocument().isPreparing());
    }

    public InvoiceEntry getEntryInOrder(Integer lineNumber) {
        FinantialDocumentEntry entry = this.getFinantialDocumentEntriesSet().stream().filter(x -> x.getEntryOrder().equals(lineNumber)).findFirst().orElse(null);
        if (entry != null) {
            return (InvoiceEntry)((Object)entry);
        }
        return null;
    }

    public boolean isTotalSettledWithoutPaymentEntries() {
        if (this.isAnnulled() || TreasuryConstants.isPositive(this.getOpenAmount())) {
            return false;
        }
        return this.getRelatedSettlementEntries().stream().map(e -> !((SettlementNote)((Object)((Object)((Object)e.getFinantialDocument())))).getPaymentEntriesSet().isEmpty()).reduce((a, c) -> a != false || c != false).orElse(false) == false;
    }

    public boolean isForPayorDebtAccount() {
        return this.getPayorDebtAccount() != null && this.getPayorDebtAccount() != this.getDebtAccount();
    }

    public SortedSet<? extends FinantialDocumentEntry> getFinantialDocumentEntriesOrderedByTuitionInstallmentOrderAndDescription() {
        TreeSet result = Sets.newTreeSet(InvoiceEntry.COMPARATOR_BY_TUITION_INSTALLMENT_ORDER_AND_DESCRIPTION);
        result.addAll(this.getFinantialDocumentEntriesSet().stream().map(InvoiceEntry.class::cast).collect(Collectors.toSet()));
        if (result.size() != this.getFinantialDocumentEntriesSet().size()) {
            throw new RuntimeException("error");
        }
        return result;
    }
}

