/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.AdvancedPaymentCreditNote;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.ReimbursementUtils;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.document.SettlementNote_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsBillingAddressBean;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.InstallmentPaymenPlanBean;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.dto.SettlementCreditEntryBean;
import org.fenixedu.treasury.dto.SettlementDebitEntryBean;
import org.fenixedu.treasury.dto.SettlementInterestEntryBean;
import org.fenixedu.treasury.dto.TreasuryTupleDataSourceBean;
import org.fenixedu.treasury.services.payments.virtualpaymententries.IVirtualPaymentEntryHandler;
import org.fenixedu.treasury.services.payments.virtualpaymententries.VirtualPaymentEntryFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class SettlementNoteBean
implements ITreasuryBean,
Serializable {
    public static final String CONTROLLER_URL = "/treasury/document/managepayments/settlementnote";
    public static final String CHOOSE_INVOICE_ENTRIES_URI = "/chooseInvoiceEntries/";
    public static final String CHOOSE_INVOICE_ENTRIES_URL = "/treasury/document/managepayments/settlementnote/chooseInvoiceEntries/";
    public static final String CALCULATE_INTEREST_URI = "/calculateInterest/";
    public static final String CALCULATE_INTEREST_URL = "/treasury/document/managepayments/settlementnote/calculateInterest/";
    public static final String CREATE_DEBIT_NOTE_URI = "/createDebitNote/";
    public static final String CREATE_DEBIT_NOTE_URL = "/treasury/document/managepayments/settlementnote/createDebitNote/";
    public static final String INSERT_PAYMENT_URI = "/insertpayment/";
    public static final String INSERT_PAYMENT_URL = "/treasury/document/managepayments/settlementnote/insertpayment/";
    public static final String SUMMARY_URI = "/summary/";
    public static final String SUMMARY_URL = "/treasury/document/managepayments/settlementnote/summary/";
    private static final long serialVersionUID = 1L;
    private boolean reimbursementNote;
    private DebtAccount debtAccount;
    private DateTime date;
    private DocumentNumberSeries docNumSeries;
    private String originDocumentNumber;
    private List<SettlementCreditEntryBean> creditEntries;
    private List<ISettlementInvoiceEntryBean> debitEntries;
    private List<ISettlementInvoiceEntryBean> virtualDebitEntries;
    private List<PaymentEntryBean> paymentEntries;
    private List<TreasuryTupleDataSourceBean> paymentMethods;
    private List<TreasuryTupleDataSourceBean> documentNumberSeries;
    private List<String> settlementNoteStateUrls;
    private Stack<Integer> previousStates;
    private String finantialTransactionReferenceYear;
    private String finantialTransactionReference;
    private boolean advancePayment;
    private DigitalPaymentPlatform digitalPaymentPlatform;
    private SibsBillingAddressBean addressBean;
    private boolean limitSibsPaymentRequestToCustomDueDate;
    private LocalDate customSibsPaymentRequestDueDate;
    private LocalDate uiAngularPaymentDate;

    public SettlementNoteBean() {
        this.init();
    }

    public SettlementNoteBean(DebtAccount debtAccount, boolean isReimbursementNote, boolean excludeDebtsForPayorAccount) {
        this();
        this.init(debtAccount, isReimbursementNote, excludeDebtsForPayorAccount);
    }

    public SettlementNoteBean(PaymentRequest paymentRequest, DateTime paymentDate, BigDecimal paidAmount, String originDocumentNumber) {
        if (!TreasuryConstants.isPositive(paidAmount)) {
            throw new IllegalArgumentException("Paid amount is not positive");
        }
        this.init();
        this.setDate(paymentDate);
        this.setOriginDocumentNumber(originDocumentNumber);
        this.setAdvancePayment(true);
        this.debtAccount = paymentRequest.getDebtAccount();
        this.reimbursementNote = false;
        this.docNumSeries = DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForSettlementNote(), this.getDebtAccount().getFinantialInstitution()).get();
        Comparator COMPARE_BY_DUE_DATE_AND_AMOUNT = (o1, o2) -> {
            int c = o1.getDueDate().compareTo((ReadablePartial)o2.getDueDate());
            if (c != 0) {
                return c;
            }
            c = -o1.getOpenAmount().compareTo(o2.getOpenAmount());
            if (c != 0) {
                return c;
            }
            return o1.getExternalId().compareTo(o2.getExternalId());
        };
        TreeSet sortedDebitEntriesToPay = Sets.newTreeSet((Comparator)COMPARE_BY_DUE_DATE_AND_AMOUNT);
        sortedDebitEntriesToPay.addAll(paymentRequest.getDebitEntriesSet());
        for (Object debitEntry : sortedDebitEntriesToPay) {
            SettlementDebitEntryBean debitEntryBean = new SettlementDebitEntryBean((DebitEntry)((Object)debitEntry));
            debitEntryBean.setIncluded(TreasuryConstants.isPositive(debitEntry.getOpenAmount()));
            this.debitEntries.add(debitEntryBean);
        }
        TreeSet sortedInstallments = Sets.newTreeSet(Installment.COMPARE_BY_DUEDATE);
        sortedInstallments.addAll(paymentRequest.getInstallmentsSet().stream().filter(i -> i.getPaymentPlan().getState().isOpen()).collect(Collectors.toSet()));
        for (Object installment : sortedInstallments) {
            InstallmentPaymenPlanBean installmentBean = new InstallmentPaymenPlanBean((Installment)((Object)installment));
            installmentBean.setIncluded(TreasuryConstants.isPositive(((Installment)((Object)installment)).getOpenAmount()));
            this.debitEntries.add(installmentBean);
        }
        if (this.getReferencedCustomers().size() > 1) {
            this.debitEntries.clear();
        }
        BigDecimal amountToDistribute = paidAmount;
        for (ISettlementInvoiceEntryBean entryBean : this.debitEntries) {
            if (!entryBean.isIncluded()) continue;
            if (TreasuryConstants.isPositive(amountToDistribute) && TreasuryConstants.isGreaterOrEqualThan(amountToDistribute, entryBean.getSettledAmount())) {
                amountToDistribute = amountToDistribute.subtract(entryBean.getSettledAmount());
                continue;
            }
            if (TreasuryConstants.isPositive(amountToDistribute) && TreasuryConstants.isGreaterThan(entryBean.getSettledAmount(), amountToDistribute)) {
                entryBean.setSettledAmount(amountToDistribute);
                amountToDistribute = BigDecimal.ZERO;
                continue;
            }
            entryBean.setSettledAmount(BigDecimal.ZERO);
            entryBean.setIncluded(false);
        }
        this.calculateVirtualDebitEntries();
        PaymentEntryBean paymentEntryBean = new PaymentEntryBean(paidAmount, paymentRequest.getPaymentMethod(), paymentRequest.fillPaymentEntryMethodId());
        this.paymentEntries.add(paymentEntryBean);
    }

    public SettlementNoteBean(SettlementNoteBean settlementNoteBean) {
        this.init();
        this.debtAccount = settlementNoteBean.getDebtAccount();
        this.reimbursementNote = settlementNoteBean.isReimbursementNote();
        this.advancePayment = settlementNoteBean.isAdvancePayment();
        this.date = settlementNoteBean.getDate();
        this.digitalPaymentPlatform = settlementNoteBean.getDigitalPaymentPlatform();
        this.docNumSeries = settlementNoteBean.getDocNumSeries();
        this.finantialTransactionReference = settlementNoteBean.getFinantialTransactionReference();
        this.finantialTransactionReferenceYear = settlementNoteBean.getFinantialTransactionReferenceYear();
        this.originDocumentNumber = settlementNoteBean.getOriginDocumentNumber();
        if (settlementNoteBean.getAddressBean() != null) {
            SibsBillingAddressBean sibsBillingAddressBean = new SibsBillingAddressBean();
            sibsBillingAddressBean.setAddress(settlementNoteBean.getAddressBean().getAddress());
            sibsBillingAddressBean.setAddressCountryCode(settlementNoteBean.getAddressBean().getAddressCountryCode());
            sibsBillingAddressBean.setAddressCountryName(settlementNoteBean.getAddressBean().getAddressCountryName());
            sibsBillingAddressBean.setCity(settlementNoteBean.getAddressBean().getCity());
            sibsBillingAddressBean.setZipCode(settlementNoteBean.getAddressBean().getZipCode());
            this.addressBean = sibsBillingAddressBean;
        }
        this.previousStates = (Stack)settlementNoteBean.getPreviousStates().clone();
        this.settlementNoteStateUrls = new ArrayList<String>(settlementNoteBean.getSettlementNoteStateUrls());
        this.documentNumberSeries = new ArrayList<TreasuryTupleDataSourceBean>();
        settlementNoteBean.getDocumentNumberSeries().forEach(bean -> this.documentNumberSeries.add(new TreasuryTupleDataSourceBean(bean.getId(), bean.getText())));
        settlementNoteBean.creditEntries.forEach(bean -> {
            SettlementCreditEntryBean creditBean = new SettlementCreditEntryBean(bean.getCreditEntry());
            creditBean.setIncluded(bean.isIncluded());
            creditBean.setNotValid(bean.isNotValid());
            creditBean.setSettledAmount(bean.getSettledAmount());
            this.creditEntries.add(creditBean);
        });
        settlementNoteBean.debitEntries.stream().filter(bean -> bean.isForDebitEntry()).forEach(bean -> {
            SettlementDebitEntryBean debitEntry = new SettlementDebitEntryBean((DebitEntry)((Object)((Object)((Object)bean.getInvoiceEntry()))));
            debitEntry.setIncluded(bean.isIncluded());
            debitEntry.setNotValid(bean.isNotValid());
            debitEntry.setSettledAmount(bean.getSettledAmount());
            this.debitEntries.add(debitEntry);
        });
        settlementNoteBean.debitEntries.stream().filter(bean -> bean.isForInstallment()).forEach(bean -> {
            InstallmentPaymenPlanBean installmentBean = new InstallmentPaymenPlanBean(((InstallmentPaymenPlanBean)bean).getInstallment());
            installmentBean.setIncluded(bean.isIncluded());
            installmentBean.setNotValid(bean.isNotValid());
            installmentBean.setSettledAmount(bean.getSettledAmount());
            this.debitEntries.add(installmentBean);
        });
        settlementNoteBean.paymentEntries.forEach(bean -> this.paymentEntries.add(new PaymentEntryBean(((PaymentEntryBean)bean).paymentAmount, ((PaymentEntryBean)bean).paymentMethod, ((PaymentEntryBean)bean).paymentMethodId)));
        settlementNoteBean.virtualDebitEntries.forEach(bean -> {
            String serialize = bean.serialize();
            this.virtualDebitEntries.add(ISettlementInvoiceEntryBean.deserialize(serialize));
        });
    }

    private void init() {
        this.creditEntries = new ArrayList<SettlementCreditEntryBean>();
        this.debitEntries = new ArrayList<ISettlementInvoiceEntryBean>();
        this.virtualDebitEntries = new ArrayList<ISettlementInvoiceEntryBean>();
        this.paymentEntries = new ArrayList<PaymentEntryBean>();
        this.date = new LocalDate().toDateTimeAtStartOfDay();
        this.settlementNoteStateUrls = new ArrayList<String>();
        this.previousStates = new Stack();
        this.setPaymentMethods(PaymentMethod.findAvailableForPaymentInApplication().collect(Collectors.toList()));
        this.advancePayment = false;
        this.finantialTransactionReferenceYear = String.valueOf(new LocalDate().getYear());
        this.documentNumberSeries = new ArrayList<TreasuryTupleDataSourceBean>();
        this.limitSibsPaymentRequestToCustomDueDate = false;
        this.customSibsPaymentRequestDueDate = null;
        this.uiAngularPaymentDate = new LocalDate();
    }

    public void init(DebtAccount debtAccount, boolean reimbursementNote, boolean excludeDebtsForPayorAccount) {
        this.init();
        this.debtAccount = debtAccount;
        this.reimbursementNote = reimbursementNote;
        for (InvoiceEntry invoiceEntry : debtAccount.getPendingInvoiceEntriesSet().stream().filter(ie -> !ie.hasPreparingSettlementEntries()).sorted((x, y) -> x.getDueDate().compareTo((ReadablePartial)y.getDueDate())).collect(Collectors.toList())) {
            if (invoiceEntry instanceof DebitEntry) {
                DebitEntry debitEntry = (DebitEntry)((Object)invoiceEntry);
                if (excludeDebtsForPayorAccount && debitEntry.getFinantialDocument() != null && ((Invoice)((Object)debitEntry.getFinantialDocument())).isForPayorDebtAccount()) continue;
                this.debitEntries.add(new SettlementDebitEntryBean(debitEntry));
                continue;
            }
            CreditEntry creditEntry = (CreditEntry)((Object)invoiceEntry);
            if (excludeDebtsForPayorAccount && creditEntry.getFinantialDocument() != null && ((Invoice)((Object)creditEntry.getFinantialDocument())).isForPayorDebtAccount()) continue;
            this.creditEntries.add(new SettlementCreditEntryBean((CreditEntry)((Object)invoiceEntry)));
        }
        Set installments = debtAccount.getActivePaymentPlansSet().stream().flatMap(plan -> plan.getSortedOpenInstallments().stream()).collect(Collectors.toSet());
        for (Installment installment : installments) {
            this.debitEntries.add(new InstallmentPaymenPlanBean(installment));
        }
        this.setDocumentNumberSeries(debtAccount, reimbursementNote);
        this.settlementNoteStateUrls = Arrays.asList(CHOOSE_INVOICE_ENTRIES_URL + debtAccount.getExternalId() + "/" + reimbursementNote, CHOOSE_INVOICE_ENTRIES_URL, CALCULATE_INTEREST_URL, CREATE_DEBIT_NOTE_URL, INSERT_PAYMENT_URL, SUMMARY_URL);
        this.advancePayment = false;
        this.finantialTransactionReferenceYear = String.valueOf(new LocalDate().getYear());
        Collections.sort(this.debitEntries, (o1, o2) -> o1.getDueDate().compareTo((ReadablePartial)o2.getDueDate()));
    }

    public SettlementNoteBean(DebtAccount debtAccount, DigitalPaymentPlatform digitalPaymentPlatform, boolean reimbursementNote, boolean excludeDebtsForPayorAccount) {
        this.init(debtAccount, reimbursementNote, excludeDebtsForPayorAccount);
        this.setDigitalPaymentPlatform(digitalPaymentPlatform);
    }

    public Set<Customer> getReferencedCustomers() {
        HashSet result = Sets.newHashSet();
        for (ISettlementInvoiceEntryBean iSettlementInvoiceEntryBean : this.getDebitEntries()) {
            if (!iSettlementInvoiceEntryBean.isIncluded()) continue;
            result.addAll(iSettlementInvoiceEntryBean.getPaymentCustomer());
        }
        for (SettlementCreditEntryBean creditEntryBean : this.creditEntries) {
            if (!creditEntryBean.isIncluded()) continue;
            result.addAll(creditEntryBean.getPaymentCustomer());
        }
        return result;
    }

    public boolean isReimbursementWithCompensation() {
        if (!this.isReimbursementNote()) {
            return false;
        }
        if (this.getCreditEntries().stream().filter(ce -> ce.isIncluded()).count() > 1L) {
            throw new TreasuryDomainException("error.SettlementNote.reimbursement.supports.only.one.settlement.entry", new String[0]);
        }
        CreditEntry creditEntry = this.getCreditEntries().stream().filter(ce -> ce.isIncluded()).findFirst().get().getCreditEntry();
        return ReimbursementUtils.isCreditNoteForReimbursementMustBeClosedWithDebitNoteAndCreatedNew(creditEntry);
    }

    public boolean checkAdvancePaymentCreditsWithPaymentDate() {
        Optional<SettlementNote> lastAdvancedCreditSettlementNote = this.getLastPaidAdvancedCreditSettlementNote();
        if (!lastAdvancedCreditSettlementNote.isPresent()) {
            return true;
        }
        return !this.getDate().toLocalDate().isBefore((ReadablePartial)lastAdvancedCreditSettlementNote.get().getPaymentDate().toLocalDate());
    }

    public Optional<SettlementNote> getLastPaidAdvancedCreditSettlementNote() {
        Optional<SettlementNote> lastAdvancedCreditSettlementNote = this.getCreditEntries().stream().filter(ce -> ce.isIncluded()).filter(ce -> ce.getCreditEntry().getFinantialDocument() != null && ((CreditNote)((Object)((Object)((Object)ce.getCreditEntry().getFinantialDocument())))).isAdvancePayment()).map(ce -> ce.getCreditEntry().getFinantialDocument()).map(AdvancedPaymentCreditNote.class::cast).filter(c -> c.getAdvancedPaymentSettlementNote() != null).map(c -> c.getAdvancedPaymentSettlementNote()).sorted(Comparator.comparing(SettlementNote_Base::getPaymentDate).reversed()).findFirst();
        return lastAdvancedCreditSettlementNote;
    }

    public void calculateVirtualDebitEntries() {
        this.setVirtualDebitEntries(new ArrayList<ISettlementInvoiceEntryBean>());
        List<IVirtualPaymentEntryHandler> handlers = VirtualPaymentEntryFactory.implementation().getHandlers();
        for (IVirtualPaymentEntryHandler handler : handlers) {
            this.addAllVirtualDebitEntries(handler.createISettlementInvoiceEntryBean(this));
        }
    }

    public void calculateInterestDebitEntries() {
        this.setVirtualDebitEntries(new ArrayList<ISettlementInvoiceEntryBean>());
        for (SettlementDebitEntryBean debitEntryBean : this.getDebitEntriesByType(SettlementDebitEntryBean.class)) {
            InterestRateBean debitInterest;
            if (!debitEntryBean.isIncluded() || !TreasuryConstants.isEqual(debitEntryBean.getDebitEntry().getOpenAmount(), debitEntryBean.getDebtAmount()) || !TreasuryConstants.isPositive((debitInterest = debitEntryBean.getDebitEntry().calculateUndebitedInterestValue(this.getDate().toLocalDate())).getInterestAmount())) continue;
            SettlementInterestEntryBean interestEntryBean = new SettlementInterestEntryBean(debitEntryBean.getDebitEntry(), debitInterest);
            this.virtualDebitEntries.add(interestEntryBean);
        }
    }

    public BigDecimal getTotalAmountToPay() {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (ISettlementInvoiceEntryBean debitEntryBean : this.getDebitEntries()) {
            if (!debitEntryBean.isIncluded()) continue;
            if (this.isReimbursementNote()) {
                totalAmount = totalAmount.subtract(debitEntryBean.getSettledAmount());
                continue;
            }
            totalAmount = totalAmount.add(debitEntryBean.getSettledAmount());
        }
        for (ISettlementInvoiceEntryBean interestEntryBean : this.getVirtualDebitEntries()) {
            if (!interestEntryBean.isIncluded()) continue;
            if (this.isReimbursementNote()) {
                totalAmount = totalAmount.subtract(interestEntryBean.getSettledAmount());
                continue;
            }
            totalAmount = totalAmount.add(interestEntryBean.getSettledAmount());
        }
        for (SettlementCreditEntryBean creditEntryBean : this.getCreditEntries()) {
            if (!creditEntryBean.isIncluded()) continue;
            if (this.isReimbursementNote()) {
                totalAmount = totalAmount.add(creditEntryBean.getCreditAmountWithVat());
                continue;
            }
            totalAmount = totalAmount.subtract(creditEntryBean.getCreditAmountWithVat());
        }
        return totalAmount;
    }

    public List<ISettlementInvoiceEntryBean> getIncludedInvoiceEntryBeans() {
        ArrayList invoiceEntriesList = Lists.newArrayList();
        for (ISettlementInvoiceEntryBean debitEntryBean : this.getDebitEntries()) {
            if (!debitEntryBean.isIncluded()) continue;
            invoiceEntriesList.add(debitEntryBean);
        }
        for (SettlementCreditEntryBean creditEntryBean : this.getCreditEntries()) {
            if (!creditEntryBean.isIncluded()) continue;
            invoiceEntriesList.add(creditEntryBean);
        }
        for (ISettlementInvoiceEntryBean interestEntryBean : this.getVirtualDebitEntries()) {
            if (!interestEntryBean.isIncluded()) continue;
            invoiceEntriesList.add(interestEntryBean);
        }
        return invoiceEntriesList;
    }

    public boolean isIncludedLegacyERPInvoiceEntryBeans() {
        for (ISettlementInvoiceEntryBean entryBean : this.getIncludedInvoiceEntryBeans()) {
            if (entryBean.getInvoiceEntry() == null || entryBean.getInvoiceEntry().getFinantialDocument() == null || !entryBean.getInvoiceEntry().getFinantialDocument().isExportedInLegacyERP()) continue;
            return true;
        }
        return false;
    }

    public void includeAllInterestOfSelectedDebitEntries() {
        ArrayList debitEntriesToIterate = Lists.newArrayList(this.getDebitEntriesByType(SettlementDebitEntryBean.class));
        for (SettlementDebitEntryBean debitEntryBean : debitEntriesToIterate) {
            InterestRateBean debitInterest;
            if (!debitEntryBean.isIncluded() || !TreasuryConstants.isEqual(debitEntryBean.getDebitEntry().getOpenAmount(), debitEntryBean.getDebtAmount()) || (debitInterest = debitEntryBean.getDebitEntry().calculateUndebitedInterestValue(this.getDate().toLocalDate())).getInterestAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            SettlementInterestEntryBean interestEntryBean = new SettlementInterestEntryBean(debitEntryBean.getDebitEntry(), debitInterest);
            this.virtualDebitEntries.add(interestEntryBean);
            interestEntryBean.setIncluded(true);
        }
        for (SettlementDebitEntryBean debitEntryBean : debitEntriesToIterate) {
            if (!debitEntryBean.isIncluded() || !TreasuryConstants.isEqual(debitEntryBean.getDebitEntry().getOpenAmount(), debitEntryBean.getDebtAmount())) continue;
            for (DebitEntry interestDebitEntry : debitEntryBean.getDebitEntry().getInterestDebitEntriesSet()) {
                if (this.getDebitEntriesByType(SettlementDebitEntryBean.class).stream().filter(e -> e.isIncluded()).filter(e -> e.getDebitEntry() == interestDebitEntry).findAny().isPresent() || !interestDebitEntry.isInDebt()) continue;
                this.getDebitEntries().stream().filter(e -> ((SettlementDebitEntryBean)e).getDebitEntry() == interestDebitEntry).findAny().get().setIncluded(true);
            }
        }
    }

    public List<Integer> getFinantialTransactionReferenceYears() {
        List<Integer> years = GlobalInterestRate.findAll().map(g -> g.getYear()).sorted().collect(Collectors.toList());
        Collections.reverse(years);
        return years;
    }

    private void setDocumentNumberSeries(DebtAccount debtAccount, boolean reimbursementNote) {
        FinantialDocumentType finantialDocumentType = reimbursementNote ? FinantialDocumentType.findForReimbursementNote() : FinantialDocumentType.findForSettlementNote();
        List availableSeries = DocumentNumberSeries.find(finantialDocumentType, debtAccount.getFinantialInstitution()).collect(Collectors.toList());
        this.setDocumentNumberSeries(DocumentNumberSeries.applyActiveSelectableAndDefaultSorting(availableSeries.stream()).collect(Collectors.toList()));
    }

    public DebtAccount getDebtAccount() {
        return this.debtAccount;
    }

    public void setDebtAccount(DebtAccount debtAccount) {
        this.debtAccount = debtAccount;
    }

    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime date) {
        this.date = date;
    }

    public List<SettlementCreditEntryBean> getCreditEntries() {
        return this.creditEntries;
    }

    public void setCreditEntries(List<SettlementCreditEntryBean> creditEntries) {
        this.creditEntries = creditEntries;
    }

    public <T> List<T> getDebitEntriesByType(Class<T> clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        return this.debitEntries.stream().filter(entry -> clazz.isAssignableFrom(entry.getClass())).map(obj -> clazz.cast(obj)).collect(Collectors.toList());
    }

    public List<ISettlementInvoiceEntryBean> getDebitEntries() {
        return this.debitEntries;
    }

    public void setDebitEntries(List<ISettlementInvoiceEntryBean> debitEntries) {
        this.debitEntries = debitEntries;
    }

    public boolean isAdvancePayment() {
        return this.advancePayment;
    }

    public void setAdvancePayment(boolean advancePayment) {
        this.advancePayment = advancePayment;
    }

    public LocalDate getDebitNoteDate() {
        LocalDate lowerDate = new LocalDate();
        for (SettlementDebitEntryBean debitEntryBean : this.getDebitEntriesByType(SettlementDebitEntryBean.class)) {
            if (!debitEntryBean.isIncluded() || !debitEntryBean.getDueDate().isBefore((ReadablePartial)lowerDate)) continue;
            lowerDate = debitEntryBean.getDueDate();
        }
        for (ISettlementInvoiceEntryBean interestEntryBean : this.getVirtualDebitEntries()) {
            if (!interestEntryBean.isIncluded() || !interestEntryBean.getDueDate().isBefore((ReadablePartial)lowerDate)) continue;
            lowerDate = interestEntryBean.getDueDate();
        }
        return lowerDate;
    }

    public BigDecimal getDebtAmount() {
        BigDecimal sum = BigDecimal.ZERO;
        for (ISettlementInvoiceEntryBean debitEntryBean : this.getDebitEntries()) {
            if (!debitEntryBean.isIncluded()) continue;
            sum = sum.add(debitEntryBean.getSettledAmount());
        }
        for (ISettlementInvoiceEntryBean interestEntryBean : this.getVirtualDebitEntries()) {
            if (!interestEntryBean.isIncluded()) continue;
            sum = sum.add(interestEntryBean.getSettledAmount());
        }
        for (SettlementCreditEntryBean creditEntryBean : this.getCreditEntries()) {
            if (!creditEntryBean.isIncluded()) continue;
            sum = sum.subtract(creditEntryBean.getCreditAmount());
        }
        return sum;
    }

    public BigDecimal getDebtAmountWithVat() {
        BigDecimal sum = BigDecimal.ZERO;
        for (ISettlementInvoiceEntryBean debitEntryBean : this.getDebitEntries()) {
            if (!debitEntryBean.isIncluded()) continue;
            sum = sum.add(debitEntryBean.getSettledAmount());
        }
        for (ISettlementInvoiceEntryBean interestEntryBean : this.getVirtualDebitEntries()) {
            if (!interestEntryBean.isIncluded()) continue;
            sum = sum.add(interestEntryBean.getSettledAmount());
        }
        for (SettlementCreditEntryBean creditEntryBean : this.getCreditEntries()) {
            if (!creditEntryBean.isIncluded()) continue;
            sum = sum.subtract(creditEntryBean.getCreditAmountWithVat());
        }
        return sum;
    }

    public BigDecimal getVatAmount() {
        return this.getDebtAmountWithVat().subtract(this.getDebtAmount());
    }

    public Map<String, VatAmountBean> getValuesByVat() {
        String vatType;
        HashMap<String, VatAmountBean> sumByVat = new HashMap<String, VatAmountBean>();
        for (VatType vatType2 : VatType.findAll().collect(Collectors.toList())) {
            sumByVat.put(vatType2.getName().getContent(), new VatAmountBean(BigDecimal.ZERO, BigDecimal.ZERO));
        }
        for (SettlementDebitEntryBean debitEntryBean : this.getDebitEntriesByType(SettlementDebitEntryBean.class)) {
            if (!debitEntryBean.isIncluded()) continue;
            vatType = debitEntryBean.getDebitEntry().getVat().getVatType().getName().getContent();
            ((VatAmountBean)sumByVat.get(vatType)).addAmount(debitEntryBean.getDebtAmount());
            ((VatAmountBean)sumByVat.get(vatType)).addAmountWithVat(debitEntryBean.getDebtAmountWithVat());
        }
        for (ISettlementInvoiceEntryBean interestEntryBean : this.getVirtualDebitEntries()) {
            if (!interestEntryBean.isIncluded()) continue;
            vatType = interestEntryBean.getVat().getVatType().getName().getContent();
            ((VatAmountBean)sumByVat.get(vatType)).addAmount(interestEntryBean.getSettledAmount());
            ((VatAmountBean)sumByVat.get(vatType)).addAmountWithVat(interestEntryBean.getSettledAmount());
        }
        for (SettlementCreditEntryBean creditEntryBean : this.getCreditEntries()) {
            if (!creditEntryBean.isIncluded()) continue;
            vatType = creditEntryBean.getCreditEntry().getVat().getVatType().getName().getContent();
            ((VatAmountBean)sumByVat.get(vatType)).subtractAmount(creditEntryBean.getCreditAmount());
            ((VatAmountBean)sumByVat.get(vatType)).subtractAmountWithVat(creditEntryBean.getCreditAmountWithVat());
        }
        return sumByVat;
    }

    public List<PaymentEntryBean> getPaymentEntries() {
        return this.paymentEntries;
    }

    public void setPaymentEntries(List<PaymentEntryBean> paymentEntries) {
        this.paymentEntries = paymentEntries;
    }

    public List<TreasuryTupleDataSourceBean> getPaymentMethods() {
        return this.paymentMethods;
    }

    public void setPaymentMethods(List<PaymentMethod> paymentMethods) {
        this.paymentMethods = paymentMethods.stream().map(paymentMethod -> {
            TreasuryTupleDataSourceBean tuple = new TreasuryTupleDataSourceBean();
            tuple.setText(paymentMethod.getName().getContent());
            tuple.setId(paymentMethod.getExternalId());
            return tuple;
        }).collect(Collectors.toList());
    }

    public BigDecimal getPaymentAmount() {
        BigDecimal paymentAmount = BigDecimal.ZERO;
        for (PaymentEntryBean paymentEntryBean : this.getPaymentEntries()) {
            paymentAmount = paymentAmount.add(paymentEntryBean.getPaymentAmount());
        }
        return paymentAmount;
    }

    public DocumentNumberSeries getDocNumSeries() {
        return this.docNumSeries;
    }

    public void setDocNumSeries(DocumentNumberSeries docNumSeries) {
        this.docNumSeries = docNumSeries;
    }

    public List<TreasuryTupleDataSourceBean> getDocumentNumberSeries() {
        return this.documentNumberSeries;
    }

    public void setDocumentNumberSeries(List<DocumentNumberSeries> documentNumberSeries) {
        this.documentNumberSeries = documentNumberSeries.stream().map(docNumSeries -> {
            TreasuryTupleDataSourceBean tuple = new TreasuryTupleDataSourceBean();
            tuple.setText(docNumSeries.getSeries().getCode() + " - " + docNumSeries.getSeries().getName().getContent());
            tuple.setId(docNumSeries.getExternalId());
            return tuple;
        }).collect(Collectors.toList());
    }

    public String getOriginDocumentNumber() {
        return this.originDocumentNumber;
    }

    public void setOriginDocumentNumber(String originDocumentNumber) {
        this.originDocumentNumber = originDocumentNumber;
    }

    public boolean isReimbursementNote() {
        return this.reimbursementNote;
    }

    public void setReimbursementNote(boolean reimbursementNote) {
        this.reimbursementNote = reimbursementNote;
    }

    public Stack<Integer> getPreviousStates() {
        return this.previousStates;
    }

    public void setPreviousStates(Stack<Integer> previousStates) {
        this.previousStates = previousStates;
    }

    public List<String> getSettlementNoteStateUrls() {
        return this.settlementNoteStateUrls;
    }

    public void setSettlementNoteStateUrls(List<String> settlementNoteStateUrls) {
        this.settlementNoteStateUrls = settlementNoteStateUrls;
    }

    public boolean hasEntriesWithoutDocument() {
        return this.getDebitEntriesByType(SettlementDebitEntryBean.class).stream().anyMatch(deb -> deb.isIncluded() && deb.getDebitEntry().getFinantialDocument() == null) || this.virtualDebitEntries.stream().anyMatch(deb -> deb.isIncluded());
    }

    public String getFinantialTransactionReference() {
        return this.finantialTransactionReference;
    }

    public void setFinantialTransactionReference(String finantialTransactionReference) {
        this.finantialTransactionReference = finantialTransactionReference;
    }

    public String getFinantialTransactionReferenceYear() {
        return this.finantialTransactionReferenceYear;
    }

    public void setFinantialTransactionReferenceYear(String finantialTransactionReferenceYear) {
        this.finantialTransactionReferenceYear = finantialTransactionReferenceYear;
    }

    public DigitalPaymentPlatform getDigitalPaymentPlatform() {
        return this.digitalPaymentPlatform;
    }

    public void setDigitalPaymentPlatform(DigitalPaymentPlatform digitalPaymentPlatform) {
        this.digitalPaymentPlatform = digitalPaymentPlatform;
    }

    public boolean isLimitSibsPaymentRequestToCustomDueDate() {
        return this.limitSibsPaymentRequestToCustomDueDate;
    }

    public void setLimitSibsPaymentRequestToCustomDueDate(boolean limitSibsPaymentRequestToCustomDueDate) {
        this.limitSibsPaymentRequestToCustomDueDate = limitSibsPaymentRequestToCustomDueDate;
    }

    public LocalDate getCustomSibsPaymentRequestDueDate() {
        return this.customSibsPaymentRequestDueDate;
    }

    public void setCustomSibsPaymentRequestDueDate(LocalDate customSibsPaymentRequestDueDate) {
        this.customSibsPaymentRequestDueDate = customSibsPaymentRequestDueDate;
    }

    @Deprecated
    public LocalDate getUiAngularPaymentDate() {
        return this.uiAngularPaymentDate;
    }

    @Deprecated
    public void setUiAngularPaymentDate(LocalDate uiAngularPaymentDate) {
        this.uiAngularPaymentDate = uiAngularPaymentDate;
    }

    public SibsBillingAddressBean getAddressBean() {
        return this.addressBean;
    }

    public void setAddressBean(SibsBillingAddressBean addressBean) {
        this.addressBean = addressBean;
    }

    public List<ISettlementInvoiceEntryBean> getVirtualDebitEntries() {
        return this.virtualDebitEntries;
    }

    public void setVirtualDebitEntries(List<ISettlementInvoiceEntryBean> virtualDebitEntries) {
        this.virtualDebitEntries = virtualDebitEntries;
    }

    private void addAllVirtualDebitEntries(List<ISettlementInvoiceEntryBean> iSettlementInvoiceEntryBeans) {
        this.virtualDebitEntries.addAll(iSettlementInvoiceEntryBeans);
    }

    public class VatAmountBean
    implements ITreasuryBean,
    Serializable {
        private static final long serialVersionUID = 1L;
        private BigDecimal amount;
        private BigDecimal amountWithVat;

        public VatAmountBean(BigDecimal amount, BigDecimal amountWithVat) {
            this.amount = amount;
            this.amountWithVat = amountWithVat;
        }

        public VatAmountBean() {
            this.amount = BigDecimal.ZERO;
            this.amountWithVat = BigDecimal.ZERO;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public void addAmount(BigDecimal partialAmount) {
            this.amount = this.amount.add(partialAmount);
        }

        public void subtractAmount(BigDecimal partialAmount) {
            this.amount = this.amount.subtract(partialAmount);
        }

        public BigDecimal getAmountWithVat() {
            return this.amountWithVat;
        }

        public void setAmountWithVat(BigDecimal amountWithVat) {
            this.amountWithVat = amountWithVat;
        }

        public void addAmountWithVat(BigDecimal partialAmountWithVat) {
            this.amountWithVat = this.amountWithVat.add(partialAmountWithVat);
        }

        public void subtractAmountWithVat(BigDecimal partialAmountWithVat) {
            this.amountWithVat = this.amountWithVat.subtract(partialAmountWithVat);
        }
    }

    public static class PaymentEntryBean
    implements ITreasuryBean,
    Serializable {
        private static final long serialVersionUID = 1L;
        private BigDecimal paymentAmount;
        private PaymentMethod paymentMethod;
        private String paymentMethodId;

        public PaymentEntryBean() {
            this.paymentAmount = BigDecimal.ZERO;
        }

        public PaymentEntryBean(BigDecimal paymentAmount, PaymentMethod paymentMethod, String paymentMethodId) {
            this.paymentAmount = paymentAmount;
            this.paymentMethod = paymentMethod;
            this.paymentMethodId = paymentMethodId;
        }

        public BigDecimal getPaymentAmount() {
            return this.paymentAmount;
        }

        public void setPaymentAmount(BigDecimal paymentAmount) {
            this.paymentAmount = paymentAmount;
        }

        public PaymentMethod getPaymentMethod() {
            return this.paymentMethod;
        }

        public void setPaymentMethod(PaymentMethod paymentMethod) {
            this.paymentMethod = paymentMethod;
        }

        public String getPaymentMethodId() {
            return this.paymentMethodId;
        }

        public void setPaymentMethodId(String paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
        }
    }
}

