/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.tariff;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate;
import org.fenixedu.treasury.domain.tariff.InterestRate$callable$createForDebitEntry;
import org.fenixedu.treasury.domain.tariff.InterestRate$callable$createForDebitEntry$1;
import org.fenixedu.treasury.domain.tariff.InterestRate$callable$createForTariff;
import org.fenixedu.treasury.domain.tariff.InterestRate$callable$delete;
import org.fenixedu.treasury.domain.tariff.InterestRate$callable$edit;
import org.fenixedu.treasury.domain.tariff.InterestRate_Base;
import org.fenixedu.treasury.domain.tariff.InterestType;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class InterestRate
extends InterestRate_Base {
    private static final int MAX_YEARS = 5;
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForTariff = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForDebitEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForDebitEntry$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected InterestRate() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected InterestRate(Tariff tariff, DebitEntry debitEntry, InterestType interestType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        this();
        this.setTariff(tariff);
        this.setDebitEntry(debitEntry);
        this.setInterestType(interestType);
        this.setNumberOfDaysAfterDueDate(1);
        this.setApplyInFirstWorkday(applyInFirstWorkday);
        this.setMaximumDaysToApplyPenalty(maximumDaysToApplyPenalty);
        this.setInterestFixedAmount(interestFixedAmount);
        this.setRate(rate);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getTariff() == null && this.getDebitEntry() == null) {
            throw new TreasuryDomainException("error.InterestRate.product.or.debit.entry.required", new String[0]);
        }
        if (this.getTariff() != null && this.getDebitEntry() != null) {
            throw new TreasuryDomainException("error.InterestRate.product.or.debit.entry.only.one", new String[0]);
        }
        if (this.getInterestType() == null) {
            throw new TreasuryDomainException("error.InterestRate.interestType.required", new String[0]);
        }
        if (this.getInterestType().isDaily() && this.getRate() == null) {
            throw new TreasuryDomainException("error.InterestRate.rate.required", new String[0]);
        }
        if (this.getInterestType().isFixedAmount() && this.getInterestFixedAmount() == null) {
            throw new TreasuryDomainException("error.InterestRate.interestFixedAmount.required", new String[0]);
        }
    }

    public boolean isMaximumDaysToApplyPenaltyApplied() {
        return this.getMaximumDaysToApplyPenalty() > 0;
    }

    public boolean isApplyInFirstWorkday() {
        return this.getApplyInFirstWorkday();
    }

    public void edit(InterestType interestType, int n, boolean bl, int n2, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Object object = advice$edit.perform((Callable)new InterestRate$callable$edit(this, interestType, n, bl, n2, bigDecimal, bigDecimal2));
    }

    static /* synthetic */ void advised$edit(InterestRate this_, InterestType interestType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        this_.setInterestType(interestType);
        this_.setNumberOfDaysAfterDueDate(1);
        this_.setApplyInFirstWorkday(applyInFirstWorkday);
        this_.setMaximumDaysToApplyPenalty(maximumDaysToApplyPenalty);
        this_.setInterestFixedAmount(interestFixedAmount);
        this_.setRate(rate);
        this_.checkRules();
    }

    public InterestRateBean calculateInterests(LocalDate paymentDate, boolean withAllInterestValues) {
        if (this.getInterestType().isFixedAmount()) {
            return this.calculateForFixedAmount(withAllInterestValues);
        }
        return this.calculateInterestAmount(withAllInterestValues, this.calculateEvents(paymentDate));
    }

    private InterestRateBean calculateInterestAmount(boolean withAllInterestValues, NavigableMap<LocalDate, InterestCalculationEvent> orderedEvents) {
        InterestRateBean result = new InterestRateBean();
        BigDecimal totalInterestAmount = BigDecimal.ZERO;
        int totalOfDays = 0;
        LocalDate key = (LocalDate)orderedEvents.firstKey();
        while (orderedEvents.higherKey(key) != null) {
            LocalDate eventDate = orderedEvents.higherKey(key);
            InterestCalculationEvent event = (InterestCalculationEvent)orderedEvents.get(key);
            BigDecimal daysInYear = new BigDecimal(TreasuryConstants.numberOfDaysInYear(key.getYear()));
            BigDecimal amountPerDay = TreasuryConstants.divide(event.amountToPay, daysInYear);
            BigDecimal numberOfDays = new BigDecimal(Days.daysBetween((ReadablePartial)key, (ReadablePartial)eventDate).getDays());
            BigDecimal partialInterestAmount = event.interestRate.multiply(amountPerDay).multiply(numberOfDays);
            result.addDetail(partialInterestAmount, key, eventDate.minusDays(1), amountPerDay, event.amountToPay, TreasuryConstants.defaultScale(event.interestRate).multiply(TreasuryConstants.HUNDRED_PERCENT).setScale(4, RoundingMode.HALF_EVEN));
            totalInterestAmount = totalInterestAmount.add(partialInterestAmount);
            totalOfDays += numberOfDays.intValue();
            key = eventDate;
        }
        if (!withAllInterestValues) {
            for (Map.Entry<LocalDate, BigDecimal> entry : this.createdInterestEntriesMap().entrySet()) {
                result.addCreatedInterestEntry(entry.getKey(), entry.getValue());
                totalInterestAmount = totalInterestAmount.subtract(entry.getValue());
            }
        }
        if (TreasuryConstants.isNegative(totalInterestAmount)) {
            totalInterestAmount = BigDecimal.ZERO;
        }
        this.getRelatedCurrency();
        result.setInterestAmount(Currency.getValueWithScale(totalInterestAmount));
        result.setNumberOfDays(totalOfDays);
        return result;
    }

    private TreeMap<LocalDate, BigDecimal> createdInterestEntriesMap() {
        TreeMap<LocalDate, BigDecimal> result = new TreeMap<LocalDate, BigDecimal>();
        for (DebitEntry interestDebitEntry : this.getDebitEntry().getInterestDebitEntriesSet()) {
            if (interestDebitEntry.isAnnulled() || !TreasuryConstants.isPositive(interestDebitEntry.getAvailableAmountForCredit())) continue;
            LocalDate interestEntryDateTime = interestDebitEntry.getEntryDateTime().toLocalDate();
            result.putIfAbsent(interestEntryDateTime, BigDecimal.ZERO);
            result.put(interestEntryDateTime, result.get(interestEntryDateTime).add(interestDebitEntry.getAvailableAmountForCredit()));
        }
        return result;
    }

    private NavigableMap<LocalDate, InterestCalculationEvent> calculateEvents(LocalDate paymentDate) {
        NavigableMap<LocalDate, BigDecimal> paymentsMap = this.createPaymentsMap(paymentDate);
        LocalDate lastPayment = (LocalDate)paymentsMap.lastKey();
        LocalDate firstDayToChargeInterests = this.calculateFirstDayToChargeInterests(lastPayment);
        LocalDate nextDayOfInterestsCharge = this.calculateLastDayToChargeInterests(lastPayment, firstDayToChargeInterests).plusDays(1);
        BigDecimal amountToPayAtFirstDay = this.amountInDebtAtDay(paymentsMap, firstDayToChargeInterests.minusDays(1));
        BigDecimal interestRateAtFirstDay = this.interestRateValue(firstDayToChargeInterests);
        TreeMap<LocalDate, InterestCalculationEvent> result = new TreeMap<LocalDate, InterestCalculationEvent>();
        result.put(firstDayToChargeInterests, new InterestCalculationEvent(amountToPayAtFirstDay, interestRateAtFirstDay));
        result.put(nextDayOfInterestsCharge, new InterestCalculationEvent(BigDecimal.ZERO, this.interestRateValue(nextDayOfInterestsCharge)));
        paymentsMap.forEach((settlementPaymentDate, paidAmount) -> {
            LocalDate eventDate = settlementPaymentDate.plusDays(1);
            if (eventDate.isBefore((ReadablePartial)firstDayToChargeInterests)) {
                return;
            }
            if (eventDate.isAfter((ReadablePartial)nextDayOfInterestsCharge)) {
                return;
            }
            result.putIfAbsent(eventDate, new InterestCalculationEvent(this.amountInDebtAtDay(paymentsMap, eventDate), this.interestRateValue(eventDate)));
        });
        GlobalInterestRate.findAll().filter(r -> !r.getFirstDay().isBefore((ReadablePartial)firstDayToChargeInterests)).filter(r -> !r.getFirstDay().isAfter((ReadablePartial)nextDayOfInterestsCharge)).forEach(r -> {
            LocalDate eventDate = r.getFirstDay();
            result.putIfAbsent(eventDate, new InterestCalculationEvent(this.amountInDebtAtDay(paymentsMap, eventDate), this.interestRateValue(eventDate)));
        });
        return result;
    }

    private LocalDate calculateFirstDayToChargeInterests(LocalDate lastPayment) {
        LocalDate firstDayToChargeInterests = this.applyOnFirstWorkdayIfNecessary(this.getDebitEntry().getDueDate().plusDays(this.numberOfDaysAfterDueDate()));
        if (firstDayToChargeInterests.isBefore((ReadablePartial)lastPayment.minusYears(5))) {
            firstDayToChargeInterests = lastPayment.minusYears(5).plusDays(1);
        }
        return firstDayToChargeInterests;
    }

    private LocalDate calculateLastDayToChargeInterests(LocalDate lastPayment, LocalDate firstDayToChargeInterests) {
        LocalDate nextDayOfPaymentDate = lastPayment;
        if (!this.isApplyPaymentMonth(lastPayment)) {
            nextDayOfPaymentDate = nextDayOfPaymentDate.withDayOfMonth(1).minusDays(1);
        }
        if (this.isMaximumDaysToApplyPenaltyApplied() && Days.daysBetween((ReadablePartial)firstDayToChargeInterests, (ReadablePartial)nextDayOfPaymentDate).getDays() > this.getMaximumDaysToApplyPenalty()) {
            nextDayOfPaymentDate = firstDayToChargeInterests.plusDays(this.getMaximumDaysToApplyPenalty() - 1);
        }
        return nextDayOfPaymentDate;
    }

    private BigDecimal amountInDebtAtDay(NavigableMap<LocalDate, BigDecimal> paymentsMap, LocalDate eventDate) {
        BigDecimal amountToPay = this.getDebitEntry().getAmountWithVat();
        for (Map.Entry entry : paymentsMap.entrySet()) {
            if (!((LocalDate)entry.getKey()).isBefore((ReadablePartial)eventDate)) break;
            amountToPay = amountToPay.subtract((BigDecimal)entry.getValue());
        }
        return amountToPay;
    }

    private NavigableMap<LocalDate, BigDecimal> createPaymentsMap(LocalDate paymentDate) {
        TreeMap<LocalDate, BigDecimal> result = new TreeMap<LocalDate, BigDecimal>();
        this.getDebitEntry().getSettlementEntriesSet().stream().filter(s -> !s.isAnnulled()).forEach(s -> {
            LocalDate settlementPaymentDate = s.getSettlementNote().getPaymentDate().toLocalDate();
            result.putIfAbsent(settlementPaymentDate, BigDecimal.ZERO);
            result.put(settlementPaymentDate, ((BigDecimal)result.get(settlementPaymentDate)).add(s.getAmount()));
        });
        result.putIfAbsent(paymentDate, BigDecimal.ZERO);
        result.put(paymentDate, ((BigDecimal)result.get(paymentDate)).add(this.getDebitEntry().getOpenAmount()));
        return result;
    }

    private boolean isApplyPaymentMonth(LocalDate date) {
        if (!this.getInterestType().isGlobalRate()) {
            return false;
        }
        Optional<GlobalInterestRate> globalRate = GlobalInterestRate.findUniqueAppliedForDate(date);
        if (!globalRate.isPresent()) {
            throw new TreasuryDomainException("error.InterestRate.rate.not.defined.for.date", date.toString("yyyy/MM/dd"));
        }
        return globalRate.get().isApplyPaymentMonth();
    }

    private BigDecimal interestRateValue(LocalDate date) {
        if (this.getInterestType().isGlobalRate()) {
            Optional<GlobalInterestRate> globalRate = GlobalInterestRate.findUniqueAppliedForDate(date);
            if (!globalRate.isPresent()) {
                throw new TreasuryDomainException("error.InterestRate.rate.not.defined.for.date", date.toString("yyyy/MM/dd"));
            }
            return TreasuryConstants.divide(globalRate.get().getRate(), TreasuryConstants.HUNDRED_PERCENT);
        }
        return TreasuryConstants.divide(this.getRate(), TreasuryConstants.HUNDRED_PERCENT);
    }

    private int numberOfDaysAfterDueDate() {
        if (this.getInterestType().isGlobalRate()) {
            return 1;
        }
        return this.getNumberOfDaysAfterDueDate();
    }

    private Currency getRelatedCurrency() {
        if (this.getTariff() != null) {
            return this.getTariff().getFinantialEntity().getFinantialInstitution().getCurrency();
        }
        if (this.getDebitEntry() != null) {
            return this.getDebitEntry().getCurrency();
        }
        return null;
    }

    private InterestRateBean calculateForFixedAmount(boolean withAllInterestValues) {
        InterestRateBean result = new InterestRateBean(this.getInterestType());
        this.getRelatedCurrency();
        BigDecimal totalInterestAmount = Currency.getValueWithScale(this.getInterestFixedAmount());
        if (!withAllInterestValues) {
            for (Map.Entry<LocalDate, BigDecimal> entry : this.createdInterestEntriesMap().entrySet()) {
                result.addCreatedInterestEntry(entry.getKey(), entry.getValue());
                totalInterestAmount = totalInterestAmount.subtract(entry.getValue());
            }
        }
        if (TreasuryConstants.isNegative(totalInterestAmount)) {
            totalInterestAmount = BigDecimal.ZERO;
        }
        this.getRelatedCurrency();
        result.setInterestAmount(Currency.getValueWithScale(totalInterestAmount));
        return result;
    }

    private LocalDate applyOnFirstWorkdayIfNecessary(LocalDate date) {
        boolean applyInFirstWorkday = this.isApplyInFirstWorkday();
        if (this.getInterestType().isGlobalRate()) {
            Optional<GlobalInterestRate> globalRate = GlobalInterestRate.findUniqueAppliedForDate(date);
            if (!globalRate.isPresent()) {
                throw new TreasuryDomainException("error.InterestRate.rate.not.defined.for.date", date.toString("yyyy/MM/dd"));
            }
            applyInFirstWorkday = globalRate.get().getApplyInFirstWorkday();
        }
        if (applyInFirstWorkday && this.isSaturday(date)) {
            return date.plusDays(2);
        }
        if (applyInFirstWorkday && this.isSunday(date)) {
            return date.plusDays(1);
        }
        return date;
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new InterestRate$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(InterestRate this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.InterestRate.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setTariff(null);
        this_.setDebitEntry(null);
        this_.deleteDomainObject();
    }

    private boolean isSaturday(LocalDate date) {
        return date.getDayOfWeek() == 6;
    }

    private boolean isSunday(LocalDate date) {
        return date.getDayOfWeek() == 7;
    }

    public static Stream<InterestRate> findAll() {
        return FenixFramework.getDomainRoot().getInterestRatesSet().stream();
    }

    public static InterestRate createForTariff(Tariff tariff, InterestType interestType, int n, boolean bl, int n2, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return (InterestRate)((Object)advice$createForTariff.perform((Callable)new InterestRate$callable$createForTariff(tariff, interestType, n, bl, n2, bigDecimal, bigDecimal2)));
    }

    static /* synthetic */ InterestRate advised$createForTariff(Tariff tariff, InterestType interestType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        return new InterestRate(tariff, null, interestType, numberOfDaysAfterDueDate, applyInFirstWorkday, maximumDaysToApplyPenalty, interestFixedAmount, rate);
    }

    public String getUiFullDescription() {
        switch (this.getInterestType()) {
            case DAILY: {
                return this.getInterestType().getDescriptionI18N().getContent() + "-" + this.getRate() + "% (Max. Dias=" + this.getMaximumDaysToApplyPenalty() + ", Aplica 1\u00ba Dia \u00datil=" + this.getApplyInFirstWorkday() + ", Dias ap\u00f3s Vencimento=" + this.getNumberOfDaysAfterDueDate() + ")";
            }
            case FIXED_AMOUNT: {
                return this.getInterestType().getDescriptionI18N().getContent() + "-" + this.getRelatedCurrency().getValueFor(this.getInterestFixedAmount());
            }
            case GLOBAL_RATE: {
                return this.getInterestType().getDescriptionI18N().getContent();
            }
        }
        return this.getInterestType().getDescriptionI18N().getContent();
    }

    public static InterestRate createForDebitEntry(DebitEntry debitEntry, InterestRate interestRate) {
        return (InterestRate)((Object)advice$createForDebitEntry.perform((Callable)new InterestRate$callable$createForDebitEntry(debitEntry, interestRate)));
    }

    static /* synthetic */ InterestRate advised$createForDebitEntry(DebitEntry debitEntry, InterestRate interestRate) {
        if (interestRate != null) {
            return new InterestRate(null, debitEntry, interestRate.getInterestType(), interestRate.getNumberOfDaysAfterDueDate(), interestRate.getApplyInFirstWorkday(), interestRate.getMaximumDaysToApplyPenalty(), interestRate.getInterestFixedAmount(), interestRate.getRate());
        }
        return null;
    }

    public static InterestRate createForDebitEntry(DebitEntry debitEntry, InterestType interestType, int n, boolean bl, int n2, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return (InterestRate)((Object)advice$createForDebitEntry$1.perform((Callable)new InterestRate$callable$createForDebitEntry$1(debitEntry, interestType, n, bl, n2, bigDecimal, bigDecimal2)));
    }

    static /* synthetic */ InterestRate advised$createForDebitEntry(DebitEntry debitEntry, InterestType interestType, int numberOfDaysAfterDueDate, boolean applyInFirstWorkday, int maximumDaysToApplyPenalty, BigDecimal interestFixedAmount, BigDecimal rate) {
        return new InterestRate(null, debitEntry, interestType, numberOfDaysAfterDueDate, applyInFirstWorkday, maximumDaysToApplyPenalty, interestFixedAmount, rate);
    }

    private class InterestCalculationEvent {
        private BigDecimal amountToPay;
        private BigDecimal interestRate;

        InterestCalculationEvent(BigDecimal amountToPay, BigDecimal interestRateAtEventDate) {
            this.amountToPay = amountToPay;
            this.interestRate = interestRateAtEventDate;
        }
    }
}

