/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator;

import java.util.List;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.PaymentPlanValidator;
import org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.WithoutConsecutiveInstallmentsOverdueValidator_Base;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class WithoutConsecutiveInstallmentsOverdueValidator
extends WithoutConsecutiveInstallmentsOverdueValidator_Base {
    public WithoutConsecutiveInstallmentsOverdueValidator() {
    }

    public WithoutConsecutiveInstallmentsOverdueValidator(Integer numberInstallments, Integer numberDaysToTakeEffect) {
        this();
        this.setNumberDaysToTakeEffect(numberDaysToTakeEffect);
        this.setNumberInstallments(numberInstallments);
    }

    public WithoutConsecutiveInstallmentsOverdueValidator create(Integer numberInstallments, Integer numberDaysToTakeEffect) {
        return new WithoutConsecutiveInstallmentsOverdueValidator(numberInstallments, numberDaysToTakeEffect);
    }

    public String getDescription() {
        return TreasuryConstants.treasuryBundle("org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.WithoutConsecutiveInstallmentsOverdueValidator.description", String.valueOf(this.getNumberInstallments()), String.valueOf(this.getNumberDaysToTakeEffect()));
    }

    public Boolean validate(LocalDate date, List<Installment> sortedInstallments) {
        int count = 0;
        for (Installment installment : sortedInstallments) {
            if (installment.isOverdue(date) && installment.getDueDate().isBefore((ReadablePartial)date.minusDays(this.getNumberDaysToTakeEffect().intValue()))) {
                if (++count != this.getNumberInstallments()) continue;
                return false;
            }
            count = 0;
        }
        return true;
    }

    protected PaymentPlanValidator clone() {
        return new WithoutConsecutiveInstallmentsOverdueValidator(this.getNumberInstallments(), this.getNumberDaysToTakeEffect());
    }
}

