/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto.PaymentPlans;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanConfigurator;
import org.fenixedu.treasury.domain.paymentPlan.paymentPlanValidator.PaymentPlanValidator;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.PaymentPlans.InstallmentBean;
import org.fenixedu.treasury.dto.SettlementDebitEntryBean;
import org.joda.time.LocalDate;

public class PaymentPlanBean {
    private DebtAccount debtAccount;
    private BigDecimal emolumentAmount;
    private int nbInstallments;
    private LocalDate startDate;
    private LocalDate endDate;
    private String reason;
    private String paymentPlanId;
    private List<InstallmentBean> installmentsBean;
    private LocalDate creationDate;
    private List<? extends ISettlementInvoiceEntryBean> allDebits;
    private PaymentPlanValidator paymentPlanValidator;
    private PaymentPlanConfigurator paymentPlanConfigurator;
    private boolean isChanged;
    private boolean withInitialValues;
    private Set<ISettlementInvoiceEntryBean> settlementInvoiceEntryBeans = new HashSet<ISettlementInvoiceEntryBean>();
    private Map<SettlementDebitEntryBean, BigDecimal> extraInterestWarning;

    public PaymentPlanBean(DebtAccount debtAccount, LocalDate creationDate) {
        this.emolumentAmount = BigDecimal.ZERO;
        this.debtAccount = debtAccount;
        this.creationDate = creationDate;
        this.isChanged = false;
        this.withInitialValues = true;
        this.allDebits = debtAccount.getPendingInvoiceEntriesSet().stream().filter(f -> f.isDebitNoteEntry() && !((DebitEntry)((Object)((Object)f))).isInOpenPaymentPlan()).map(debitEntry -> {
            SettlementDebitEntryBean debitEntryBean = new SettlementDebitEntryBean((DebitEntry)((Object)((Object)debitEntry)));
            debitEntryBean.setSettledAmount(debitEntry.getOpenAmountWithInterests());
            return debitEntryBean;
        }).collect(Collectors.toList());
    }

    public List<InstallmentBean> getInstallmentsBean() {
        if (this.installmentsBean == null || this.isChanged) {
            this.installmentsBean = this.paymentPlanConfigurator.getInstallmentsBeansFor(this);
            this.isChanged = false;
        }
        return this.installmentsBean;
    }

    public BigDecimal getEmolumentAmount() {
        return this.emolumentAmount;
    }

    public void setEmolumentAmount(BigDecimal emolumentAmount) {
        this.emolumentAmount = emolumentAmount;
        this.isChanged = true;
    }

    public int getNbInstallments() {
        return this.nbInstallments;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    public void setNbInstallments(int nbInstallments) {
        this.nbInstallments = nbInstallments;
        this.isChanged = true;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
        this.isChanged = true;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
        this.isChanged = true;
    }

    public String getPaymentPlanId() {
        return this.paymentPlanId;
    }

    public void setPaymentPlanId(String paymentPlanId) {
        this.paymentPlanId = paymentPlanId;
        this.isChanged = true;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
        this.isChanged = true;
    }

    public void setInstallmentsBean(List<InstallmentBean> installmentsBean) {
        this.installmentsBean = installmentsBean;
    }

    public boolean isChangedInstallmentPlan() {
        return this.isChanged;
    }

    public BigDecimal getTotalInstallments() {
        if (this.installmentsBean == null) {
            this.installmentsBean = this.paymentPlanConfigurator.getInstallmentsBeansFor(this);
        }
        return this.installmentsBean.stream().map(i -> i.getInstallmentAmount()).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
    }

    public DebtAccount getDebtAccount() {
        return this.debtAccount;
    }

    public void setDebtAccount(DebtAccount debtAccount) {
        this.debtAccount = debtAccount;
    }

    public LocalDate getCreationDate() {
        return this.creationDate;
    }

    public PaymentPlanValidator getPaymentPlanValidator() {
        return this.paymentPlanValidator;
    }

    public void setPaymentPlanValidator(PaymentPlanValidator paymentPlanValidator) {
        this.paymentPlanValidator = paymentPlanValidator;
        this.isChanged = true;
    }

    public boolean isWithInitialValues() {
        return this.withInitialValues;
    }

    public void setWithInitialValues(boolean withInitialValues) {
        this.withInitialValues = withInitialValues;
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
    }

    public PaymentPlanConfigurator getPaymentPlanConfigurator() {
        return this.paymentPlanConfigurator;
    }

    public void setPaymentPlanConfigurator(PaymentPlanConfigurator paymentPlanConfigurator) {
        this.paymentPlanConfigurator = paymentPlanConfigurator;
        this.paymentPlanId = paymentPlanConfigurator.getNumberGenerators().getNextNumberPreview();
    }

    public Set<ISettlementInvoiceEntryBean> getSettlementInvoiceEntryBeans() {
        return this.settlementInvoiceEntryBeans;
    }

    public void setSettlementInvoiceEntryBeans(Set<ISettlementInvoiceEntryBean> settlementInvoiceEntryBeans) {
        this.settlementInvoiceEntryBeans = settlementInvoiceEntryBeans;
    }

    public void addSettlementInvoiceEntryBean(ISettlementInvoiceEntryBean settlementInvoiceEntryBeans) {
        this.settlementInvoiceEntryBeans.add(settlementInvoiceEntryBeans);
    }

    public void removeSettlementInvoiceEntryBean(ISettlementInvoiceEntryBean settlementInvoiceEntryBeans) {
        this.settlementInvoiceEntryBeans.remove(settlementInvoiceEntryBeans);
    }

    public void createInstallmentsBean(List<LocalDate> fixedDates, List<BigDecimal> fixedAmounts) {
        this.installmentsBean = this.paymentPlanConfigurator.getInstallmentsBeansFor(this, fixedDates, fixedAmounts);
    }

    public List<? extends ISettlementInvoiceEntryBean> getAllDebits() {
        return this.allDebits;
    }

    public void setAllDebits(List<? extends ISettlementInvoiceEntryBean> allDebits) {
        this.allDebits = allDebits;
    }

    public void setExtraInterestWarning(Map<SettlementDebitEntryBean, BigDecimal> result) {
        this.extraInterestWarning = result;
    }

    public Map<SettlementDebitEntryBean, BigDecimal> getExtraInterestWarning() {
        return this.extraInterestWarning;
    }
}

