/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.payments;

import java.io.UnsupportedEncodingException;
import java.util.Comparator;
import java.util.stream.Stream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLogFile;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog_Base;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.fenixframework.FenixFramework;

public class PaymentRequestLog
extends PaymentRequestLog_Base {
    public static final Comparator<PaymentRequestLog> COMPARE_BY_CREATION_DATE = (o1, o2) -> o1.getCreationDate().compareTo((ReadableInstant)o2.getCreationDate()) * 10 + o1.getExternalId().compareTo(o2.getExternalId());

    public PaymentRequestLog() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
        this.setResponsibleUsername(TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername());
    }

    protected PaymentRequestLog(PaymentRequest request, String stateCode, LocalizedString stateDescription) {
        this();
        this.setPaymentRequest(request);
        this.setStateCode(stateCode);
        this.setStateDescription(stateDescription);
        this.checkRules();
    }

    private void checkRules() {
    }

    public void saveRequest(String requestBody) {
        if (requestBody == null) {
            return;
        }
        try {
            String filename = String.format("request_%s_%s.txt", new DateTime().toString("yyyyMMddHHmmss"), this.getExternalId());
            this.setRequestLogFile(PaymentRequestLogFile.create(filename, requestBody.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveResponse(String responseBody) {
        if (responseBody == null) {
            return;
        }
        try {
            String filename = String.format("response_%s_%s.txt", new DateTime().toString("yyyyMMddHHmmss"), this.getExternalId());
            this.setResponseLogFile(PaymentRequestLogFile.create(filename, responseBody.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void logException(Exception e) {
        String exceptionLog = String.format("%s\n%s", e.getLocalizedMessage(), ExceptionUtils.getFullStackTrace((Throwable)e));
        this.setExceptionOccured(true);
        try {
            String filename = String.format("exception_%s_%s.txt", new DateTime().toString("yyyyMMddHHmmss"), this.getExternalId());
            this.setExceptionLogFile(PaymentRequestLogFile.create(filename, exceptionLog.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void editAuthorizationData(String authorizationId, DateTime authorizationDate) {
        this.setAuthorizationId(authorizationId);
        this.setAuthorizationDate(authorizationDate);
    }

    public static Stream<? extends PaymentRequestLog> findAll() {
        return FenixFramework.getDomainRoot().getPaymentRequestLogsSet().stream();
    }

    public static PaymentRequestLog create(PaymentRequest request, String stateCode, LocalizedString stateDescription) {
        return new PaymentRequestLog(request, stateCode, stateDescription);
    }
}

