/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentPlan;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.text.StrSubstitutor;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanConfigurator$callable$delete;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanConfigurator$callable$setActive;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanConfigurator_Base;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanNumberGenerator;
import org.fenixedu.treasury.domain.paymentpenalty.PaymentPenaltyTaxTreasuryEvent;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.dto.PaymentPenaltyEntryBean;
import org.fenixedu.treasury.dto.PaymentPlans.AddictionsCalculeTypeEnum;
import org.fenixedu.treasury.dto.PaymentPlans.InstallmentBean;
import org.fenixedu.treasury.dto.PaymentPlans.InstallmentEntryBean;
import org.fenixedu.treasury.dto.PaymentPlans.PaymentPlanBean;
import org.fenixedu.treasury.dto.SettlementDebitEntryBean;
import org.fenixedu.treasury.dto.SettlementInterestEntryBean;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class PaymentPlanConfigurator
extends PaymentPlanConfigurator_Base {
    private static final int MAX_LOOP = 10;
    private static final Comparator<ISettlementInvoiceEntryBean> COMPARE_SETTLEMENT_INVOICE_ENTRY_BEAN_PENALTY_TAX_AFTER;
    private static final Comparator<ISettlementInvoiceEntryBean> COMPARE_SETTLEMENT_INVOICE_ENTRY_BEAN_PENALTY_TAX_BEFORE;
    public static final Advice advice$setActive;
    public static final Advice advice$delete;

    public PaymentPlanConfigurator() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        super.setActive(Boolean.FALSE);
        this.setTreasurySettings(TreasurySettings.getInstance());
    }

    public PaymentPlanConfigurator(LocalizedString name, LocalizedString installmentDescriptionFormat, Boolean usePaymentPenalty, AddictionsCalculeTypeEnum interestDistribuition, AddictionsCalculeTypeEnum paymentPenaltyDistribuition, Product emolumentProduct, PaymentPlanNumberGenerator numberGenerator) {
        this();
        this.setName(name);
        this.setInstallmentDescriptionFormat(installmentDescriptionFormat);
        this.setUsePaymentPenalty(usePaymentPenalty);
        this.setEmolumentProduct(emolumentProduct);
        this.setNumberGenerators(numberGenerator);
        this.setInterestDistribution(interestDistribuition);
        this.setPaymentPenaltyDistribution(paymentPenaltyDistribuition);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getTreasurySettings() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.treasurySettings.required", new String[0]);
        }
        if (this.getInstallmentDescriptionFormat() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.InstallmentDescriptionFormat.required", new String[0]);
        }
        if (this.getEmolumentProduct() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.EmolumentProduct.required", new String[0]);
        }
        if (this.getInstallmentDescriptionFormat().anyMatch(o -> !o.contains("${paymentPlanId}"))) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.installmentDescriptionFormat.payment.plan.id.required", new String[0]);
        }
        if (this.getInstallmentDescriptionFormat().anyMatch(o -> !o.contains("${installmentNumber}"))) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.installmentDescriptionFormat.installment.number.required", new String[0]);
        }
        if (this.getNumberGenerators() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.NumberGenerators.required", new String[0]);
        }
        if (this.getInterestDistribution() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.interestDistribution.required", new String[0]);
        }
        if (Boolean.TRUE.equals(this.getUsePaymentPenalty()) && this.getPaymentPenaltyDistribution() == null) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.paymentPenaltyDistribution.required", new String[0]);
        }
    }

    public abstract boolean isApplyInterest();

    public abstract boolean isInterestBlocked();

    public abstract boolean canChangeInstallmentsAmount();

    protected abstract LocalDate getDateToUseToPenaltyTaxCalculation(LocalDate var1, LocalDate var2);

    public void setActive(Boolean bl) {
        Object object = advice$setActive.perform((Callable)new PaymentPlanConfigurator$callable$setActive(this, bl));
    }

    static /* synthetic */ void advised$setActive(PaymentPlanConfigurator this_, Boolean active) {
        super.setActive(active);
    }

    public Boolean isActive() {
        return Boolean.TRUE.equals(this.getActive());
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PaymentPlanConfigurator$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PaymentPlanConfigurator this_) {
        if (this_.getActive().booleanValue()) {
            throw new TreasuryDomainException("error.PaymentPlanSettings.active.cannot.be.deleted", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setTreasurySettings(null);
        this_.setEmolumentProduct(null);
        this_.setNumberGenerators(null);
        super.deleteDomainObject();
    }

    public static Stream<PaymentPlanConfigurator> findAll() {
        return FenixFramework.getDomainRoot().getPaymentPlanConfiguratorsSet().stream();
    }

    public static Stream<PaymentPlanConfigurator> findActives() {
        return PaymentPlanConfigurator.findAll().filter(p -> Boolean.TRUE.equals(p.getActive()));
    }

    public Comparator<ISettlementInvoiceEntryBean> getComparator() {
        if (AddictionsCalculeTypeEnum.BEFORE_DEBIT_ENTRY == this.getPaymentPenaltyDistribution()) {
            return COMPARE_SETTLEMENT_INVOICE_ENTRY_BEAN_PENALTY_TAX_BEFORE;
        }
        return COMPARE_SETTLEMENT_INVOICE_ENTRY_BEAN_PENALTY_TAX_AFTER;
    }

    public List<InstallmentBean> getInstallmentsBeansFor(PaymentPlanBean paymentPlanBean) {
        return this.getInstallmentsBeansFor(paymentPlanBean, null, null);
    }

    public List<InstallmentBean> getInstallmentsBeansFor(PaymentPlanBean paymentPlanBean, List<LocalDate> fixedDates, List<BigDecimal> fixedAmountList) {
        this.resetSettlementInvoiceEntryBeansForChoosenDebitEntries(paymentPlanBean);
        int loopNumber = 0;
        PaymentPlanInstallmentCreationBean installmentsCreationBean = null;
        do {
            installmentsCreationBean = new PaymentPlanInstallmentCreationBean(paymentPlanBean, fixedDates, fixedAmountList);
            this.fillInstallmentsWithInvoiceEntries(installmentsCreationBean);
        } while ((fixedAmountList == null || fixedAmountList.isEmpty()) && ++loopNumber < 10 && installmentsCreationBean.diffFirstLastAmountGreaterOrEqualThanNbInstallmentsInCents());
        installmentsCreationBean.fillExtraInterestWarning();
        return installmentsCreationBean.getInstallments();
    }

    private void fillInstallmentsWithInvoiceEntries(PaymentPlanInstallmentCreationBean installmentsCreationBean) {
        ISettlementInvoiceEntryBean currentInvoiceEntryBean = installmentsCreationBean.getNextInvoiceEntryBean();
        for (int i = 0; i < installmentsCreationBean.getInstallments().size(); ++i) {
            BigDecimal installmentAmount;
            InstallmentBean currentInstallmentBean = installmentsCreationBean.getInstallmentBean(i);
            BigDecimal restInstallmentMaxAmount = installmentAmount = installmentsCreationBean.getInstallmentAmount(i);
            while (currentInvoiceEntryBean != null && TreasuryConstants.isPositive(restInstallmentMaxAmount)) {
                BigDecimal installmentEntryAmount;
                if (Boolean.TRUE.equals(this.getUsePaymentPenalty() != false && this.isDebitEntry(currentInvoiceEntryBean))) {
                    currentInvoiceEntryBean = this.processPaymentPenaltyEntryBean(installmentsCreationBean, currentInvoiceEntryBean);
                }
                if (!TreasuryConstants.isPositive(installmentEntryAmount = this.getRestAmountOfBeanInPaymentPlan(currentInvoiceEntryBean, installmentsCreationBean))) {
                    currentInvoiceEntryBean = installmentsCreationBean.getNextInvoiceEntryBean();
                    continue;
                }
                boolean isLastInstallmentOfCurrInvoiceEntryBean = true;
                if (TreasuryConstants.isGreaterThan(installmentEntryAmount, restInstallmentMaxAmount) && !installmentsCreationBean.isLastInstallmentOfPaymentPLan(currentInstallmentBean)) {
                    installmentEntryAmount = restInstallmentMaxAmount;
                    isLastInstallmentOfCurrInvoiceEntryBean = false;
                }
                if (this.isApplyInterest() && this.getInterestDistribution().isByInstallmentEntryAmount() && this.isDebitEntry(currentInvoiceEntryBean)) {
                    restInstallmentMaxAmount = this.processInterestInstallmentEntryByInstallmentEntryAmount(installmentsCreationBean, currentInstallmentBean, currentInvoiceEntryBean, installmentEntryAmount, restInstallmentMaxAmount, isLastInstallmentOfCurrInvoiceEntryBean);
                }
                this.createInstallmentEntryBean(currentInstallmentBean, currentInvoiceEntryBean, installmentEntryAmount);
                restInstallmentMaxAmount = restInstallmentMaxAmount.subtract(installmentEntryAmount);
                if (!this.isApplyInterest() || !this.getInterestDistribution().isAfterDebitEntry() || !this.isDebitEntry(currentInvoiceEntryBean) || TreasuryConstants.isPositive(this.getRestAmountOfBeanInPaymentPlan(currentInvoiceEntryBean, installmentsCreationBean))) continue;
                restInstallmentMaxAmount = this.createInterestInstallmentEntryAfterDebitEntry(installmentsCreationBean, currentInvoiceEntryBean, currentInstallmentBean, restInstallmentMaxAmount);
            }
        }
    }

    private BigDecimal createInterestInstallmentEntryAfterDebitEntry(PaymentPlanInstallmentCreationBean installmentsCreationBean, ISettlementInvoiceEntryBean currentInvoiceEntryBean, InstallmentBean currentInstallmentBean, BigDecimal restInstallmentAmount) {
        BigDecimal interestEntryAmout = this.getInterestAmountToPaymentPlan(installmentsCreationBean, currentInvoiceEntryBean);
        if (TreasuryConstants.isPositive(interestEntryAmout)) {
            this.processInterestInstallmentEntryBeanInInstallmentBean(installmentsCreationBean, currentInvoiceEntryBean, currentInstallmentBean, restInstallmentAmount, interestEntryAmout, null);
            restInstallmentAmount = restInstallmentAmount.subtract(Currency.getValueWithScale(interestEntryAmout));
        }
        return restInstallmentAmount;
    }

    private BigDecimal processInterestInstallmentEntryByInstallmentEntryAmount(PaymentPlanInstallmentCreationBean installmentsCreationBean, InstallmentBean currentInstallmentBean, ISettlementInvoiceEntryBean currentInvoiceEntryBean, BigDecimal installmentEntryAmount, BigDecimal restInstallmentAmount, boolean isLastInstallmentOfCurrInvoiceEntryBean) {
        BigDecimal interestAmout;
        if (!installmentsCreationBean.isLastInstallmentOfPaymentPLan(currentInstallmentBean)) {
            BigDecimal backupInstallmentEntryAmount = installmentEntryAmount;
            installmentEntryAmount = this.getDebtAmountToInstallmentEntryAmount(installmentsCreationBean, currentInstallmentBean, currentInvoiceEntryBean, installmentEntryAmount, restInstallmentAmount, isLastInstallmentOfCurrInvoiceEntryBean);
            boolean bl = isLastInstallmentOfCurrInvoiceEntryBean = isLastInstallmentOfCurrInvoiceEntryBean && TreasuryConstants.isEqual(installmentEntryAmount, backupInstallmentEntryAmount);
        }
        if (TreasuryConstants.isPositive(interestAmout = this.getInterestAmountOfCurrentInvoiceEntryBeanToInstallment(installmentsCreationBean, currentInvoiceEntryBean, installmentEntryAmount, currentInvoiceEntryBean.getDueDate(), currentInstallmentBean.getDueDate(), isLastInstallmentOfCurrInvoiceEntryBean))) {
            this.processInterestInstallmentEntryBeanInInstallmentBean(installmentsCreationBean, currentInvoiceEntryBean, currentInstallmentBean, restInstallmentAmount, interestAmout, installmentEntryAmount);
            return restInstallmentAmount.subtract(Currency.getValueWithScale(interestAmout));
        }
        return restInstallmentAmount;
    }

    private ISettlementInvoiceEntryBean processPaymentPenaltyEntryBean(PaymentPlanInstallmentCreationBean installmentsCreationBean, ISettlementInvoiceEntryBean currentInvoiceEntryBean) {
        PaymentPenaltyEntryBean paymentPenaltyEntryBean = this.createIfNotExistsPaymentPenaltyEntryBean((SettlementDebitEntryBean)currentInvoiceEntryBean, installmentsCreationBean);
        if (paymentPenaltyEntryBean != null) {
            installmentsCreationBean.addAmountToLastInstallmentMaxAmount(paymentPenaltyEntryBean.getSettledAmount());
            if (this.getPaymentPenaltyDistribution().isBeforeDebitEntry()) {
                installmentsCreationBean.addInvoiceEntryBeanToBeTreatedAndSort(currentInvoiceEntryBean);
                return paymentPenaltyEntryBean;
            }
            if (this.getPaymentPenaltyDistribution().isAfterDebitEntry()) {
                installmentsCreationBean.addInvoiceEntryBeanToBeTreatedAndSort(paymentPenaltyEntryBean);
                return currentInvoiceEntryBean;
            }
        }
        return currentInvoiceEntryBean;
    }

    private void processInterestInstallmentEntryBeanInInstallmentBean(PaymentPlanInstallmentCreationBean installmentsCreationBean, ISettlementInvoiceEntryBean currentInvoiceEntryBean, InstallmentBean currentInstallmentBean, BigDecimal restInstallmentAmount, BigDecimal interestAmout, BigDecimal invoiceInstallmentEntryAmount) {
        BigDecimal totalInstallmentAmount;
        BigDecimal interestInstallmentEntryAmount = Currency.getValueWithScale(interestAmout);
        BigDecimal bigDecimal = totalInstallmentAmount = invoiceInstallmentEntryAmount != null ? invoiceInstallmentEntryAmount.add(interestInstallmentEntryAmount) : interestInstallmentEntryAmount;
        if (TreasuryConstants.isGreaterThan(totalInstallmentAmount, restInstallmentAmount) && !installmentsCreationBean.isLastInstallmentOfPaymentPLan(currentInstallmentBean)) {
            interestInstallmentEntryAmount = invoiceInstallmentEntryAmount != null ? restInstallmentAmount.subtract(invoiceInstallmentEntryAmount) : restInstallmentAmount;
        }
        BigDecimal interestAmountToAddAtLastInstallment = this.createInterestInstallmentEntryBeanInInstallmentBean(installmentsCreationBean, currentInvoiceEntryBean, currentInstallmentBean, interestInstallmentEntryAmount, Currency.getValueWithScale(interestAmout));
        installmentsCreationBean.addAmountToLastInstallmentMaxAmount(interestAmountToAddAtLastInstallment);
    }

    private boolean isDebitEntry(ISettlementInvoiceEntryBean currentInvoiceEntryBean) {
        return currentInvoiceEntryBean.isForDebitEntry() && ((DebitEntry)((Object)currentInvoiceEntryBean.getInvoiceEntry())).getDebitEntry() == null && !(((DebitEntry)((Object)currentInvoiceEntryBean.getInvoiceEntry())).getTreasuryEvent() instanceof PaymentPenaltyTaxTreasuryEvent);
    }

    private InstallmentEntryBean createInstallmentEntryBean(InstallmentBean currentInstallmentBean, ISettlementInvoiceEntryBean currentInvoiceEntryBean, BigDecimal installmentEntryAmount) {
        Optional<InstallmentEntryBean> installmentEntryBeanOptional = currentInstallmentBean.getInstallmentEntries().stream().filter(bean -> bean.getInvoiceEntry() == currentInvoiceEntryBean).findFirst();
        InstallmentEntryBean installmentEntryBean = null;
        if (installmentEntryBeanOptional.isEmpty()) {
            installmentEntryBean = new InstallmentEntryBean(currentInvoiceEntryBean, installmentEntryAmount);
            currentInstallmentBean.addInstallmentEntries(installmentEntryBean);
        } else {
            installmentEntryBean = installmentEntryBeanOptional.get();
            installmentEntryBean.setAmount(installmentEntryBean.getAmount().add(installmentEntryAmount));
        }
        return installmentEntryBean;
    }

    private PaymentPenaltyEntryBean createIfNotExistsPaymentPenaltyEntryBean(SettlementDebitEntryBean currInvoiceEntryBean, PaymentPlanInstallmentCreationBean installmentsCreationBean) {
        Optional<ISettlementInvoiceEntryBean> paymentPenaltyEntryOptional = installmentsCreationBean.getPaymentPenaltyEntryFormPaymentPlan(currInvoiceEntryBean.getDebitEntry());
        if (paymentPenaltyEntryOptional.isPresent()) {
            return null;
        }
        PaymentPenaltyEntryBean paymentPenaltyEntryBean = PaymentPenaltyTaxTreasuryEvent.calculatePaymentPenaltyTax(currInvoiceEntryBean.getDebitEntry(), this.getDateToUseToPenaltyTaxCalculation(installmentsCreationBean.getRequestDate(), currInvoiceEntryBean.getDueDate()), installmentsCreationBean.getRequestDate());
        if (paymentPenaltyEntryBean != null) {
            installmentsCreationBean.addPaymentPlanSettlementInvoiceEntryBean(paymentPenaltyEntryBean);
        }
        return paymentPenaltyEntryBean;
    }

    private BigDecimal getRestAmountOfBeanInPaymentPlan(ISettlementInvoiceEntryBean currInvoiceEntryBean, PaymentPlanInstallmentCreationBean installmentsCreationBean) {
        BigDecimal total = currInvoiceEntryBean.isForDebitEntry() ? currInvoiceEntryBean.getEntryOpenAmount() : currInvoiceEntryBean.getSettledAmount();
        Stream<InstallmentEntryBean> installmentEntryBeansWithInvoiceEntryBean = installmentsCreationBean.getInstallmentEntryBeansWithInvoiceEntryBean(currInvoiceEntryBean);
        BigDecimal used = installmentEntryBeansWithInvoiceEntryBean.map(entry -> entry.getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        return total.subtract(used);
    }

    private BigDecimal getDebtAmountToInstallmentEntryAmount(PaymentPlanInstallmentCreationBean installmentsCreationBean, InstallmentBean currentInstallmentBean, ISettlementInvoiceEntryBean currentInvoiceEntryBean, BigDecimal installmentEntryAmount, BigDecimal currentInstallmentAmount, boolean isLastinstallment) {
        BigDecimal currentInvoiceEntryBeanAmount = installmentEntryAmount;
        BigDecimal calculatedInterestAmount = this.getInterestAmountOfCurrentInvoiceEntryBeanToInstallment(installmentsCreationBean, currentInvoiceEntryBean, currentInvoiceEntryBeanAmount, currentInvoiceEntryBean.getDueDate(), currentInstallmentBean.getDueDate(), isLastinstallment);
        BigDecimal subTotal = Currency.getValueWithScale(currentInvoiceEntryBeanAmount).add(Currency.getValueWithScale(calculatedInterestAmount));
        if (TreasuryConstants.isGreaterThan(subTotal, currentInstallmentAmount) && TreasuryConstants.isPositive(calculatedInterestAmount)) {
            ArrayList<BigDecimal> subTotalList = new ArrayList<BigDecimal>();
            do {
                currentInvoiceEntryBeanAmount = currentInvoiceEntryBeanAmount.subtract(subTotal.subtract(currentInstallmentAmount));
                calculatedInterestAmount = this.getInterestAmountOfCurrentInvoiceEntryBeanToInstallment(installmentsCreationBean, currentInvoiceEntryBean, currentInvoiceEntryBeanAmount, currentInvoiceEntryBean.getDueDate(), currentInstallmentBean.getDueDate(), false);
                subTotal = Currency.getValueWithScale(currentInvoiceEntryBeanAmount).add(Currency.getValueWithScale(calculatedInterestAmount));
                if (subTotalList.contains(subTotal) && TreasuryConstants.isGreaterOrEqualThan(subTotal, currentInstallmentAmount)) break;
                subTotalList.add(subTotal);
            } while (!TreasuryConstants.isEqual(subTotal, currentInstallmentAmount));
        }
        return Currency.getValueWithScale(currentInvoiceEntryBeanAmount);
    }

    protected BigDecimal getInterestAmountOfCurrentInvoiceEntryBeanToInstallment(PaymentPlanInstallmentCreationBean installmentsCreationBean, ISettlementInvoiceEntryBean currentInvoiceEntryBean, BigDecimal amount, LocalDate fromDate, LocalDate toDate, boolean isLastInstallmentOfCurrInvoiceEntryBean) {
        return this.getInterestAmountOfCurrentInvoiceEntryBeanToInstallmentBeforePlan(installmentsCreationBean, currentInvoiceEntryBean, amount, fromDate, toDate, isLastInstallmentOfCurrInvoiceEntryBean);
    }

    private BigDecimal getInterestAmountOfCurrentInvoiceEntryBeanToInstallmentBeforePlan(PaymentPlanInstallmentCreationBean installmentsCreationBean, ISettlementInvoiceEntryBean currentInvoiceEntryBean, BigDecimal amount, LocalDate fromDate, LocalDate toDate, boolean isLastInstallmentOfCurrInvoiceEntryBean) {
        if (!currentInvoiceEntryBean.isForDebitEntry() || !((DebitEntry)((Object)currentInvoiceEntryBean.getInvoiceEntry())).isApplyInterests()) {
            return BigDecimal.ZERO;
        }
        BigDecimal totalInterestAmountBeforePaymentPlan = this.getTotalInterestAmountOfInvoiceEntryBeforePaymentPlan(installmentsCreationBean, currentInvoiceEntryBean);
        if (isLastInstallmentOfCurrInvoiceEntryBean) {
            BigDecimal totalAmountOfCurrentInvoiceEntryInPreviousInstallments = BigDecimal.ZERO;
            List listOfInstallments = installmentsCreationBean.getInstallmentBeansWithInvoiceEntryBean(currentInvoiceEntryBean).collect(Collectors.toList());
            for (InstallmentBean installment : listOfInstallments) {
                if (installment.getDueDate().equals((Object)toDate)) continue;
                InstallmentEntryBean installmentEntryBean = installment.getInstallmentEntries().stream().filter(entryBean -> entryBean.getInvoiceEntry() == currentInvoiceEntryBean).findFirst().get();
                BigDecimal interestAmountOfCurrentInvoiceEntryBeanToInstallmentBeforePlan = this.getInterestAmountOfCurrentInvoiceEntryBeanToInstallmentBeforePlan(installmentsCreationBean, currentInvoiceEntryBean, installmentEntryBean.getAmount(), fromDate, installment.getDueDate(), false);
                totalAmountOfCurrentInvoiceEntryInPreviousInstallments = Currency.getValueWithScale(totalAmountOfCurrentInvoiceEntryInPreviousInstallments.add(interestAmountOfCurrentInvoiceEntryBeanToInstallmentBeforePlan));
            }
            return Currency.getValueWithScale(totalInterestAmountBeforePaymentPlan.subtract(totalAmountOfCurrentInvoiceEntryInPreviousInstallments), 20);
        }
        return Currency.getValueWithScale(TreasuryConstants.divide(amount, currentInvoiceEntryBean.getEntryOpenAmount()).multiply(totalInterestAmountBeforePaymentPlan), 20);
    }

    private BigDecimal getTotalInterestAmountOfInvoiceEntryBeforePaymentPlan(PaymentPlanInstallmentCreationBean installmentsCreationBean, ISettlementInvoiceEntryBean currentInvoiceEntryBean) {
        BigDecimal totalInterestPaid;
        BigDecimal allInterestAmountBeforePlan;
        BigDecimal expectedInterestBeforeInPlan;
        DebitEntry debitEntry = (DebitEntry)((Object)currentInvoiceEntryBean.getInvoiceEntry());
        BigDecimal interestAmountOfDebitEntryBean = currentInvoiceEntryBean.getSettledAmount().subtract(currentInvoiceEntryBean.getEntryOpenAmount());
        BigDecimal totalInterestDebitEntriesInPlan = installmentsCreationBean.getInterestInvoiceEntryBeanOfDebitEntry((DebitEntry)((Object)currentInvoiceEntryBean.getInvoiceEntry())).filter(bean -> bean.isForDebitEntry()).map(bean -> bean.getSettledAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalOfInterestInPlan = totalInterestDebitEntriesInPlan.add(interestAmountOfDebitEntryBean);
        if (TreasuryConstants.isGreaterThan(totalOfInterestInPlan, expectedInterestBeforeInPlan = (allInterestAmountBeforePlan = debitEntry.calculateAllInterestValue(installmentsCreationBean.getRequestDate()).getInterestAmount()).subtract(totalInterestPaid = debitEntry.getInterestDebitEntriesSet().stream().filter(interest -> !interest.isAnnulled() && !interest.isInDebt()).map(interest -> interest.getAvailableAmountForCredit()).reduce(BigDecimal.ZERO, BigDecimal::add)))) {
            return expectedInterestBeforeInPlan;
        }
        return totalOfInterestInPlan;
    }

    private BigDecimal createInterestInstallmentEntryBeanInInstallmentBean(PaymentPlanInstallmentCreationBean installmentsCreationBean, ISettlementInvoiceEntryBean currentInvoiceEntryBean, InstallmentBean currentInstallmentBean, BigDecimal interestEntryAmout, BigDecimal totalInterestEntryAmount) {
        List interestsBeansList = installmentsCreationBean.getInterestInvoiceEntryBeanOfDebitEntry((DebitEntry)((Object)currentInvoiceEntryBean.getInvoiceEntry())).collect(Collectors.toList());
        for (ISettlementInvoiceEntryBean settlementInvoiceEntryBean : interestsBeansList) {
            if (!TreasuryConstants.isPositive(interestEntryAmout)) break;
            if (settlementInvoiceEntryBean.isForDebitEntry()) {
                BigDecimal settlementRestAmout = this.getRestAmountOfBeanInPaymentPlan(settlementInvoiceEntryBean, installmentsCreationBean);
                if (!TreasuryConstants.isPositive(settlementRestAmout)) continue;
                if (TreasuryConstants.isGreaterThan(settlementRestAmout, interestEntryAmout)) {
                    totalInterestEntryAmount = totalInterestEntryAmount.subtract(settlementRestAmout.subtract(interestEntryAmout));
                    settlementRestAmout = interestEntryAmout;
                }
                this.createInstallmentEntryBean(currentInstallmentBean, settlementInvoiceEntryBean, settlementRestAmout);
                interestEntryAmout = interestEntryAmout.subtract(settlementRestAmout);
                totalInterestEntryAmount = totalInterestEntryAmount.subtract(settlementRestAmout);
                continue;
            }
            ((SettlementInterestEntryBean)settlementInvoiceEntryBean).getInterest().setInterestAmount(settlementInvoiceEntryBean.getSettledAmount().add(totalInterestEntryAmount));
            this.createInstallmentEntryBean(currentInstallmentBean, settlementInvoiceEntryBean, interestEntryAmout);
            return interestEntryAmout;
        }
        if (TreasuryConstants.isPositive(totalInterestEntryAmount)) {
            ISettlementInvoiceEntryBean createdInterestEntryBean = this.createInterestEntryBean(installmentsCreationBean, (DebitEntry)((Object)currentInvoiceEntryBean.getInvoiceEntry()), totalInterestEntryAmount);
            if (TreasuryConstants.isPositive(interestEntryAmout)) {
                this.createInstallmentEntryBean(currentInstallmentBean, createdInterestEntryBean, Currency.getValueWithScale(interestEntryAmout));
            }
        }
        return interestEntryAmout;
    }

    private ISettlementInvoiceEntryBean createInterestEntryBean(PaymentPlanInstallmentCreationBean installmentsCreationBean, DebitEntry debitEntry, BigDecimal interestEntryAmout) {
        if (TreasuryConstants.isPositive(interestEntryAmout)) {
            InterestRateBean interestRateBean = new InterestRateBean();
            interestRateBean.setDescription(TreasuryConstants.treasuryBundle(TreasuryConstants.DEFAULT_LANGUAGE, "label.InterestRateBean.interest.designation", debitEntry.getDescription()));
            interestRateBean.setInterestAmount(interestEntryAmout);
            SettlementInterestEntryBean interestEntryBean = new SettlementInterestEntryBean(debitEntry, interestRateBean);
            installmentsCreationBean.addPaymentPlanSettlementInvoiceEntryBean(interestEntryBean);
            installmentsCreationBean.addInvoiceEntryBeanToBeTreatedAndSort(interestEntryBean);
            return interestEntryBean;
        }
        return null;
    }

    protected BigDecimal getInterestAmountToPaymentPlan(PaymentPlanInstallmentCreationBean installmentsCreationBean, ISettlementInvoiceEntryBean currentInvoiceEntryBean) {
        return this.getTotalInterestAmountOfInvoiceEntryBeforePaymentPlan(installmentsCreationBean, currentInvoiceEntryBean);
    }

    protected void resetSettlementInvoiceEntryBeansForChoosenDebitEntries(PaymentPlanBean paymentPlanBean) {
        paymentPlanBean.setSettlementInvoiceEntryBeans(paymentPlanBean.getSettlementInvoiceEntryBeans().stream().filter(bean -> bean.isForDebitEntry() || bean.isForPendingDebitEntry()).collect(Collectors.toSet()));
    }

    private static DebitEntry getOriginDebitEntryFromInterestEntry(ISettlementInvoiceEntryBean bean) {
        DebitEntry debitEntry = null;
        if (bean.isForPendingInterest() || bean.isForDebitEntry() && ((DebitEntry)((Object)bean.getInvoiceEntry())).getDebitEntry() != null) {
            debitEntry = bean.isForPendingInterest() ? ((SettlementInterestEntryBean)bean).getDebitEntry() : ((DebitEntry)((Object)bean.getInvoiceEntry())).getDebitEntry();
        }
        return debitEntry;
    }

    private static DebitEntry getOriginDebitEntryFromPenaltyTaxEntry(ISettlementInvoiceEntryBean bean) {
        DebitEntry debitEntry = null;
        if (bean.isForPaymentPenalty() || bean.isForDebitEntry() && ((DebitEntry)((Object)bean.getInvoiceEntry())).getTreasuryEvent() != null && ((DebitEntry)((Object)bean.getInvoiceEntry())).getTreasuryEvent() instanceof PaymentPenaltyTaxTreasuryEvent) {
            debitEntry = bean.isForPaymentPenalty() ? ((PaymentPenaltyEntryBean)bean).getDebitEntry() : ((PaymentPenaltyTaxTreasuryEvent)((Object)((DebitEntry)((Object)bean.getInvoiceEntry())).getTreasuryEvent())).getOriginDebitEntry();
        }
        return debitEntry;
    }

    private static int compareDebitEntryDueDate(DebitEntry debitEntry1, DebitEntry debitEntry2) {
        return debitEntry1.getDueDate().compareTo((ReadablePartial)debitEntry2.getDueDate()) * 10 + debitEntry1.getExternalId().compareTo(debitEntry2.getExternalId());
    }

    static {
        advice$setActive = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_SETTLEMENT_INVOICE_ENTRY_BEAN_PENALTY_TAX_AFTER = (s1, s2) -> {
            DebitEntry debitEntryS2;
            if (s1.isForPendingDebitEntry() || s2.isForPendingDebitEntry()) {
                return s1.isForPendingDebitEntry() ? -1 : 1;
            }
            DebitEntry interestEntryS1 = PaymentPlanConfigurator.getOriginDebitEntryFromInterestEntry(s1);
            DebitEntry penaltyTaxEntryS1 = interestEntryS1 == null ? PaymentPlanConfigurator.getOriginDebitEntryFromPenaltyTaxEntry(s1) : null;
            DebitEntry debitEntryS1 = penaltyTaxEntryS1 == null && interestEntryS1 == null ? (DebitEntry)((Object)((Object)((Object)s1.getInvoiceEntry()))) : null;
            DebitEntry interestEntryS2 = PaymentPlanConfigurator.getOriginDebitEntryFromInterestEntry(s2);
            DebitEntry penaltyTaxEntryS2 = interestEntryS2 == null ? PaymentPlanConfigurator.getOriginDebitEntryFromPenaltyTaxEntry(s2) : null;
            DebitEntry debitEntry = debitEntryS2 = penaltyTaxEntryS2 == null && interestEntryS2 == null ? (DebitEntry)((Object)((Object)((Object)s2.getInvoiceEntry()))) : null;
            if (debitEntryS1 != null) {
                if (debitEntryS2 != null) {
                    return PaymentPlanConfigurator.compareDebitEntryDueDate(debitEntryS1, debitEntryS2);
                }
                if (interestEntryS2 != null) {
                    return debitEntryS1 == interestEntryS2 ? -1 : PaymentPlanConfigurator.compareDebitEntryDueDate(debitEntryS1, interestEntryS2);
                }
                if (penaltyTaxEntryS2 != null) {
                    return debitEntryS1 == penaltyTaxEntryS2 ? -1 : PaymentPlanConfigurator.compareDebitEntryDueDate(debitEntryS1, penaltyTaxEntryS2);
                }
            }
            if (interestEntryS1 != null) {
                if (debitEntryS2 != null) {
                    return interestEntryS1 == debitEntryS2 ? 1 : PaymentPlanConfigurator.compareDebitEntryDueDate(interestEntryS1, debitEntryS2);
                }
                if (interestEntryS2 != null) {
                    return interestEntryS1 == interestEntryS2 ? (s1.isForPendingInterest() ? 1 : -1) : PaymentPlanConfigurator.compareDebitEntryDueDate(interestEntryS1, interestEntryS2);
                }
                if (penaltyTaxEntryS2 != null) {
                    return interestEntryS1 == penaltyTaxEntryS2 ? -1 : PaymentPlanConfigurator.compareDebitEntryDueDate(interestEntryS1, penaltyTaxEntryS2);
                }
            }
            if (penaltyTaxEntryS1 != null) {
                if (debitEntryS2 != null) {
                    return penaltyTaxEntryS1 == debitEntryS2 ? 1 : PaymentPlanConfigurator.compareDebitEntryDueDate(penaltyTaxEntryS1, debitEntryS2);
                }
                if (interestEntryS2 != null) {
                    return penaltyTaxEntryS1 == interestEntryS2 ? 1 : PaymentPlanConfigurator.compareDebitEntryDueDate(penaltyTaxEntryS1, interestEntryS2);
                }
                if (penaltyTaxEntryS2 != null) {
                    return PaymentPlanConfigurator.compareDebitEntryDueDate(penaltyTaxEntryS1, penaltyTaxEntryS2);
                }
            }
            return s1.getDueDate().compareTo((ReadablePartial)s2.getDueDate());
        };
        COMPARE_SETTLEMENT_INVOICE_ENTRY_BEAN_PENALTY_TAX_BEFORE = (s1, s2) -> {
            DebitEntry debitEntryS2;
            if (s1.isForPendingDebitEntry() || s2.isForPendingDebitEntry()) {
                return s1.isForPendingDebitEntry() ? -1 : 1;
            }
            DebitEntry interestEntryS1 = PaymentPlanConfigurator.getOriginDebitEntryFromInterestEntry(s1);
            DebitEntry penaltyTaxEntryS1 = interestEntryS1 == null ? PaymentPlanConfigurator.getOriginDebitEntryFromPenaltyTaxEntry(s1) : null;
            DebitEntry debitEntryS1 = penaltyTaxEntryS1 == null && interestEntryS1 == null ? (DebitEntry)((Object)((Object)((Object)s1.getInvoiceEntry()))) : null;
            DebitEntry interestEntryS2 = PaymentPlanConfigurator.getOriginDebitEntryFromInterestEntry(s2);
            DebitEntry penaltyTaxEntryS2 = interestEntryS2 == null ? PaymentPlanConfigurator.getOriginDebitEntryFromPenaltyTaxEntry(s2) : null;
            DebitEntry debitEntry = debitEntryS2 = penaltyTaxEntryS2 == null && interestEntryS2 == null ? (DebitEntry)((Object)((Object)((Object)s2.getInvoiceEntry()))) : null;
            if (debitEntryS1 != null) {
                if (debitEntryS2 != null) {
                    return PaymentPlanConfigurator.compareDebitEntryDueDate(debitEntryS1, debitEntryS2);
                }
                if (interestEntryS2 != null) {
                    return debitEntryS1 == interestEntryS2 ? -1 : PaymentPlanConfigurator.compareDebitEntryDueDate(debitEntryS1, interestEntryS2);
                }
                if (penaltyTaxEntryS2 != null) {
                    return debitEntryS1 == penaltyTaxEntryS2 ? 1 : PaymentPlanConfigurator.compareDebitEntryDueDate(debitEntryS1, penaltyTaxEntryS2);
                }
            }
            if (interestEntryS1 != null) {
                if (debitEntryS2 != null) {
                    return interestEntryS1 == debitEntryS2 ? 1 : PaymentPlanConfigurator.compareDebitEntryDueDate(interestEntryS1, debitEntryS2);
                }
                if (interestEntryS2 != null) {
                    return interestEntryS1 == interestEntryS2 ? (s1.isForPendingInterest() ? 1 : -1) : PaymentPlanConfigurator.compareDebitEntryDueDate(interestEntryS1, interestEntryS2);
                }
                if (penaltyTaxEntryS2 != null) {
                    return interestEntryS1 == penaltyTaxEntryS2 ? 1 : PaymentPlanConfigurator.compareDebitEntryDueDate(interestEntryS1, penaltyTaxEntryS2);
                }
            }
            if (penaltyTaxEntryS1 != null) {
                if (debitEntryS2 != null) {
                    return penaltyTaxEntryS1 == debitEntryS2 ? -1 : PaymentPlanConfigurator.compareDebitEntryDueDate(penaltyTaxEntryS1, debitEntryS2);
                }
                if (interestEntryS2 != null) {
                    return penaltyTaxEntryS1 == interestEntryS2 ? -1 : PaymentPlanConfigurator.compareDebitEntryDueDate(penaltyTaxEntryS1, interestEntryS2);
                }
                if (penaltyTaxEntryS2 != null) {
                    return PaymentPlanConfigurator.compareDebitEntryDueDate(penaltyTaxEntryS1, penaltyTaxEntryS2);
                }
            }
            return s1.getDueDate().compareTo((ReadablePartial)s2.getDueDate());
        };
    }

    protected class PaymentPlanInstallmentCreationBean {
        private PaymentPlanBean paymentPlanBean;
        private List<InstallmentBean> installments;
        private List<BigDecimal> installmentsMaxAmount;
        private List<ISettlementInvoiceEntryBean> invoiceEntriesToBeTreated;

        public PaymentPlanInstallmentCreationBean(PaymentPlanBean paymentPlanBean, List<LocalDate> fixedDates, List<BigDecimal> fixedAmountList) {
            this.paymentPlanBean = paymentPlanBean;
            paymentPlanBean.setExtraInterestWarning(new LinkedHashMap<SettlementDebitEntryBean, BigDecimal>());
            this.installments = this.createInstallmentsList(paymentPlanBean, fixedDates);
            this.installmentsMaxAmount = this.createInstallmentMaxAmountList(paymentPlanBean, fixedAmountList);
            PaymentPlanConfigurator.this.resetSettlementInvoiceEntryBeansForChoosenDebitEntries(paymentPlanBean);
            this.invoiceEntriesToBeTreated = paymentPlanBean.getSettlementInvoiceEntryBeans().stream().sorted(PaymentPlanConfigurator.this.getComparator()).collect(Collectors.toList());
            if (this.invoiceEntriesToBeTreated.isEmpty()) {
                throw new TreasuryDomainException(TreasuryConstants.treasuryBundle("label.paymentPlanInstalllmentCreation.invoiceEntries.required", new String[0]), new String[0]);
            }
        }

        private List<BigDecimal> createInstallmentMaxAmountList(PaymentPlanBean paymentPlanBean, List<BigDecimal> fixedAmountList) {
            if (fixedAmountList != null) {
                return new ArrayList<BigDecimal>(fixedAmountList);
            }
            BigDecimal totalBeansAmount = paymentPlanBean.getSettlementInvoiceEntryBeans().stream().map(bean -> bean.isForDebitEntry() ? bean.getEntryOpenAmount() : bean.getSettledAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal installmentAmount = Currency.getValueWithScale(TreasuryConstants.divide(totalBeansAmount, new BigDecimal(paymentPlanBean.getNbInstallments())));
            ArrayList<BigDecimal> result = new ArrayList<BigDecimal>();
            for (int i = 0; i < paymentPlanBean.getNbInstallments() - 1; ++i) {
                result.add(installmentAmount);
                totalBeansAmount = totalBeansAmount.subtract(installmentAmount);
            }
            result.add(Currency.getValueWithScale(totalBeansAmount));
            return result;
        }

        private List<InstallmentBean> createInstallmentsList(PaymentPlanBean paymentPlanBean, List<LocalDate> dates) {
            if (dates == null) {
                dates = new ArrayList<LocalDate>();
                double daysBetweenInstallments = paymentPlanBean.getNbInstallments() == 1 ? 0.0 : (double)Days.daysBetween((ReadablePartial)paymentPlanBean.getStartDate(), (ReadablePartial)paymentPlanBean.getEndDate()).getDays() / ((double)paymentPlanBean.getNbInstallments() - 1.0);
                LocalDate installmentDueDate = paymentPlanBean.getStartDate();
                for (int i = 1; i <= paymentPlanBean.getNbInstallments(); ++i) {
                    if (i == paymentPlanBean.getNbInstallments()) {
                        installmentDueDate = paymentPlanBean.getEndDate();
                    }
                    dates.add(installmentDueDate);
                    installmentDueDate = paymentPlanBean.getStartDate().plusDays(Double.valueOf((double)i * daysBetweenInstallments).intValue());
                }
            }
            ArrayList<InstallmentBean> result = new ArrayList<InstallmentBean>();
            for (int installmentNumber = 1; installmentNumber <= paymentPlanBean.getNbInstallments(); ++installmentNumber) {
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("installmentNumber", "" + installmentNumber);
                values.put("paymentPlanId", paymentPlanBean.getPaymentPlanId());
                LocalizedString installmentDescription = new LocalizedString();
                for (Locale locale : TreasuryPlataformDependentServicesFactory.implementation().availableLocales()) {
                    installmentDescription = installmentDescription.with(locale, StrSubstitutor.replace((Object)PaymentPlanConfigurator.this.getInstallmentDescriptionFormat().getContent(locale), values));
                }
                result.add(new InstallmentBean(dates.get(installmentNumber - 1), installmentDescription));
            }
            return result;
        }

        public ISettlementInvoiceEntryBean getNextInvoiceEntryBean() {
            ISettlementInvoiceEntryBean iSettlementInvoiceEntryBean;
            ISettlementInvoiceEntryBean iSettlementInvoiceEntryBean2 = iSettlementInvoiceEntryBean = this.invoiceEntriesToBeTreated.isEmpty() ? null : this.invoiceEntriesToBeTreated.get(0);
            if (!this.invoiceEntriesToBeTreated.isEmpty()) {
                this.invoiceEntriesToBeTreated.remove(0);
            }
            return iSettlementInvoiceEntryBean;
        }

        public List<InstallmentBean> getInstallments() {
            return this.installments;
        }

        public BigDecimal getInstallmentAmount(int i) {
            return this.installmentsMaxAmount.get(i);
        }

        public InstallmentBean getInstallmentBean(int i) {
            return this.installments.get(i);
        }

        public boolean diffFirstLastAmountGreaterOrEqualThanNbInstallmentsInCents() {
            BigDecimal nbInstallmentsInCents = Currency.getValueWithScale(TreasuryConstants.divide(new BigDecimal(this.paymentPlanBean.getNbInstallments()), TreasuryConstants.HUNDRED_PERCENT));
            BigDecimal amountFirstInstallment = this.installments.get(0).getInstallmentAmount();
            BigDecimal amountLastInstallment = this.installments.get(this.paymentPlanBean.getNbInstallments() - 1).getInstallmentAmount();
            BigDecimal diffFirstLast = amountFirstInstallment.subtract(amountLastInstallment).abs();
            return TreasuryConstants.isGreaterOrEqualThan(diffFirstLast, nbInstallmentsInCents);
        }

        public void addAmountToLastInstallmentMaxAmount(BigDecimal amount) {
            BigDecimal installmentsAmount = this.installmentsMaxAmount.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal settlementInvoiceEntriesAmount = this.paymentPlanBean.getSettlementInvoiceEntryBeans().stream().map(entry -> entry.isForDebitEntry() ? entry.getEntryOpenAmount() : entry.getSettledAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (TreasuryConstants.isGreaterThan(settlementInvoiceEntriesAmount, installmentsAmount)) {
                this.installmentsMaxAmount.set(this.installmentsMaxAmount.size() - 1, this.installmentsMaxAmount.get(this.installmentsMaxAmount.size() - 1).add(amount));
            }
        }

        private boolean isInterestOf(ISettlementInvoiceEntryBean settlementInvoiceEntry, DebitEntry invoiceEntry) {
            boolean isInterestEntry = settlementInvoiceEntry.isForDebitEntry() && ((DebitEntry)((Object)settlementInvoiceEntry.getInvoiceEntry())).getDebitEntry() == invoiceEntry;
            boolean isPendingInterestEntry = settlementInvoiceEntry.isForPendingInterest() && ((SettlementInterestEntryBean)settlementInvoiceEntry).getDebitEntry() == invoiceEntry;
            return isPendingInterestEntry || isInterestEntry;
        }

        public Stream<ISettlementInvoiceEntryBean> getInterestInvoiceEntryBeanOfDebitEntry(DebitEntry debitEntry) {
            return this.paymentPlanBean.getSettlementInvoiceEntryBeans().stream().filter(settlementInvoiceEntry -> this.isInterestOf((ISettlementInvoiceEntryBean)settlementInvoiceEntry, debitEntry)).sorted(PaymentPlanConfigurator.this.getComparator());
        }

        public Stream<InstallmentEntryBean> getInstallmentEntryBeansWithInvoiceEntryBean(ISettlementInvoiceEntryBean currInvoiceEntryBean) {
            return this.installments.stream().flatMap(inst -> inst.getInstallmentEntries().stream()).filter(entry -> entry.getInvoiceEntry() == currInvoiceEntryBean);
        }

        public void addPaymentPlanSettlementInvoiceEntryBean(ISettlementInvoiceEntryBean settlementInvoiceEntryBean) {
            this.paymentPlanBean.addSettlementInvoiceEntryBean(settlementInvoiceEntryBean);
        }

        public LocalDate getRequestDate() {
            return this.paymentPlanBean.getCreationDate();
        }

        public Optional<ISettlementInvoiceEntryBean> getPaymentPenaltyEntryFormPaymentPlan(DebitEntry debitEntry) {
            return this.paymentPlanBean.getSettlementInvoiceEntryBeans().stream().filter(bean -> bean.isForPaymentPenalty() && ((PaymentPenaltyEntryBean)bean).getDebitEntry() == debitEntry).findFirst();
        }

        public void addInvoiceEntryBeanToBeTreatedAndSort(ISettlementInvoiceEntryBean invoiceEntryBean) {
            this.invoiceEntriesToBeTreated.add(invoiceEntryBean);
            this.invoiceEntriesToBeTreated.sort(PaymentPlanConfigurator.this.getComparator());
        }

        public LocalDate getPaymentPlanStartDate() {
            return this.paymentPlanBean.getStartDate();
        }

        public Stream<InstallmentBean> getInstallmentBeansWithInvoiceEntryBean(ISettlementInvoiceEntryBean currentInvoiceEntryBean) {
            return this.installments.stream().filter(installment -> installment.getInstallmentEntries().stream().anyMatch(installmentEntryBean -> installmentEntryBean.getInvoiceEntry() == currentInvoiceEntryBean));
        }

        public void fillExtraInterestWarning() {
            LinkedHashMap<SettlementDebitEntryBean, BigDecimal> result = new LinkedHashMap<SettlementDebitEntryBean, BigDecimal>();
            List debitEntryList = this.paymentPlanBean.getSettlementInvoiceEntryBeans().stream().filter(bean -> PaymentPlanConfigurator.this.isDebitEntry(bean)).sorted(PaymentPlanConfigurator.this.getComparator()).collect(Collectors.toList());
            for (ISettlementInvoiceEntryBean iSettlementInvoiceEntryBean : debitEntryList) {
                BigDecimal totalInterests;
                SettlementDebitEntryBean debitEntry = (SettlementDebitEntryBean)iSettlementInvoiceEntryBean;
                BigDecimal totalInterestsBeans = this.getInterestInvoiceEntryBeanOfDebitEntry(debitEntry.getDebitEntry()).map(bean -> bean.getSettledAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal diffInterest = totalInterestsBeans.subtract(totalInterests = Currency.getValueWithScale(PaymentPlanConfigurator.this.getInterestAmountToPaymentPlan(this, iSettlementInvoiceEntryBean)));
                if (!TreasuryConstants.isPositive(diffInterest)) continue;
                result.put(debitEntry, diffInterest);
            }
            this.paymentPlanBean.setExtraInterestWarning(result);
        }

        public boolean isLastInstallmentOfPaymentPLan(InstallmentBean currentInstallmentBean) {
            return this.installments.get(this.installments.size() - 1) == currentInstallmentBean;
        }
    }
}

