/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentPlan;

import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanCalculateInstallmentsInterestsConfigurator_Base;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlanConfigurator;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.PaymentPlans.InstallmentBean;
import org.fenixedu.treasury.dto.PaymentPlans.InstallmentEntryBean;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class PaymentPlanCalculateInstallmentsInterestsConfigurator
extends PaymentPlanCalculateInstallmentsInterestsConfigurator_Base {
    public boolean isInterestBlocked() {
        return true;
    }

    public boolean canChangeInstallmentsAmount() {
        return false;
    }

    protected BigDecimal getInterestAmountOfCurrentInvoiceEntryBeanToInstallment(PaymentPlanConfigurator.PaymentPlanInstallmentCreationBean installmentsCreationBean, ISettlementInvoiceEntryBean currentInvoiceEntryBean, BigDecimal amount, LocalDate fromDate, LocalDate toDate, boolean isLastInstallmentOfCurrInvoiceEntryBean) {
        BigDecimal interestAmountBeforePaymentPlan = BigDecimal.ZERO;
        if (fromDate.isBefore((ReadablePartial)installmentsCreationBean.getRequestDate())) {
            interestAmountBeforePaymentPlan = super.getInterestAmountOfCurrentInvoiceEntryBeanToInstallment(installmentsCreationBean, currentInvoiceEntryBean, amount, fromDate, toDate, isLastInstallmentOfCurrInvoiceEntryBean);
        }
        LocalDate startDate = currentInvoiceEntryBean.getDueDate().isAfter((ReadablePartial)installmentsCreationBean.getPaymentPlanStartDate()) ? currentInvoiceEntryBean.getDueDate() : installmentsCreationBean.getPaymentPlanStartDate();
        BigDecimal interestAmountAfterPaymentPlan = this.calculateInterestValue(installmentsCreationBean, amount, startDate, toDate);
        return interestAmountBeforePaymentPlan.add(interestAmountAfterPaymentPlan);
    }

    protected BigDecimal getInterestAmountToPaymentPlan(PaymentPlanConfigurator.PaymentPlanInstallmentCreationBean installmentsCreationBean, ISettlementInvoiceEntryBean currentInvoiceEntryBean) {
        BigDecimal totalInterestAmount = BigDecimal.ZERO;
        List collect = installmentsCreationBean.getInstallmentBeansWithInvoiceEntryBean(currentInvoiceEntryBean).collect(Collectors.toList());
        boolean isLastinstallment = false;
        for (int i = 0; i < collect.size(); ++i) {
            if (i == collect.size() - 1) {
                isLastinstallment = true;
            }
            InstallmentBean installment = (InstallmentBean)collect.get(i);
            InstallmentEntryBean installmentEntryBean = installment.getInstallmentEntries().stream().filter(entryBean -> entryBean.getInvoiceEntry() == currentInvoiceEntryBean).findFirst().get();
            BigDecimal installmentInterestAmount = this.getInterestAmountOfCurrentInvoiceEntryBeanToInstallment(installmentsCreationBean, currentInvoiceEntryBean, installmentEntryBean.getAmount(), installmentEntryBean.getInvoiceEntry().getDueDate(), installment.getDueDate(), isLastinstallment);
            totalInterestAmount = totalInterestAmount.add(installmentInterestAmount);
        }
        return totalInterestAmount;
    }

    protected LocalDate getDateToUseToPenaltyTaxCalculation(LocalDate creationDate, LocalDate installmentDate) {
        return installmentDate;
    }

    private BigDecimal calculateInterestValue(PaymentPlanConfigurator.PaymentPlanInstallmentCreationBean installmentsCreationBean, BigDecimal amount, LocalDate fromDate, LocalDate toDate) {
        BigDecimal daysBetween = new BigDecimal(Days.daysBetween((ReadablePartial)fromDate, (ReadablePartial)toDate).getDays());
        BigDecimal daysInYear = new BigDecimal(TreasuryConstants.numberOfDaysInYear(installmentsCreationBean.getRequestDate().getYear()));
        BigDecimal amountPerDay = TreasuryConstants.divide(amount, daysInYear);
        Optional<GlobalInterestRate> findUniqueAppliedForDate = GlobalInterestRate.findUniqueAppliedForDate(installmentsCreationBean.getRequestDate());
        if (findUniqueAppliedForDate.isEmpty() || !TreasuryConstants.isPositive(daysBetween)) {
            return BigDecimal.ZERO;
        }
        BigDecimal interestRate = TreasuryConstants.divide(findUniqueAppliedForDate.get().getRate(), TreasuryConstants.HUNDRED_PERCENT);
        return interestRate.multiply(amountPerDay).multiply(daysBetween);
    }

    public boolean isApplyInterest() {
        return true;
    }
}

