/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments.payline;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentController;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentPlatformService;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PostProcessPaymentStatusBean;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineConfiguration$callable$doWebPayment;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineConfiguration$callable$postProcessPayment;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineConfiguration$callable$processPayment;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineConfiguration_Base;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineWebServiceResponse;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatformPaymentMode;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.InstallmentPaymenPlanBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentStatusBean;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PaylineConfiguration
extends PaylineConfiguration_Base
implements IForwardPaymentPlatformService {
    private static final String TRANSACTION_APPROVED_CODE = "00000";
    private static final String TRANSACTION_PENDING_FORM_FILL = "02306";
    public static final String ACTION_RETURN_URL = "return";
    public static final String ACTION_CANCEL_URL = "cancel";
    public static final String LANG_PT = "pt";
    public static final String LANG_EN = "en";
    public static final Advice advice$postProcessPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$doWebPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$processPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public PaylineConfiguration() {
    }

    protected PaylineConfiguration(FinantialInstitution finantialInstitution, String name, boolean active, String paymentURL, String paylineMerchantId, String paylineMerchantAccessKey, String paylineContractNumber) {
        this();
        this.init(finantialInstitution, name, active);
        this.setPaymentURL(paymentURL);
        this.setPaylineMerchantId(paylineMerchantId);
        this.setPaylineMerchantAccessKey(paylineMerchantAccessKey);
        this.setPaylineContractNumber(paylineContractNumber);
        DigitalPaymentPlatformPaymentMode.create((DigitalPaymentPlatform)((Object)this), TreasurySettings.getInstance().getCreditCardPaymentMethod());
        this.checkRules();
    }

    private void checkRules() {
    }

    @Override
    public IForwardPaymentController getForwardPaymentController(ForwardPaymentRequest forwardPayment) {
        return IForwardPaymentController.getForwardPaymentController((PaymentRequest)((Object)forwardPayment));
    }

    @Override
    public String getPaymentURL(ForwardPaymentRequest request) {
        throw new RuntimeException("not applied");
    }

    @Override
    public String getLogosJspPage() {
        return "implementations/payline/logos.jsp";
    }

    @Override
    public String getWarningBeforeRedirectionJspPage() {
        return "implementations/payline/warning.jsp";
    }

    @Override
    public ForwardPaymentStatusBean paymentStatus(ForwardPaymentRequest forwardPayment) {
        if (!forwardPayment.getDigitalPaymentPlatform().isActive()) {
            throw new TreasuryDomainException("error.ForwardPaymentConfiguration.not.active", new String[0]);
        }
        ITreasuryPlatformDependentServices implementation = TreasuryPlataformDependentServicesFactory.implementation();
        PaylineWebServiceResponse response = implementation.paylineGetWebPaymentDetails(forwardPayment);
        ForwardPaymentStateType type = null;
        String authorizationNumber = null;
        DateTime authorizationDate = null;
        String transactionId = null;
        DateTime transactionDate = null;
        BigDecimal payedAmount = null;
        boolean success = TRANSACTION_APPROVED_CODE.equals(response.getResultCode());
        if (!success) {
            type = TRANSACTION_PENDING_FORM_FILL.equals(response.getResultCode()) ? ForwardPaymentStateType.REQUESTED : ForwardPaymentStateType.REJECTED;
        } else {
            authorizationNumber = response.getAuthorizationNumber();
            authorizationDate = response.getAuthorizationDate();
            transactionId = response.getTransactionId();
            payedAmount = response.getPaymentAmount();
            transactionDate = response.getTransactionDate();
            type = ForwardPaymentStateType.PAYED;
        }
        ForwardPaymentStatusBean bean = new ForwardPaymentStatusBean(true, type, response.getResultCode(), response.getResultLongMessage(), response.getJsonRequest(), response.getJsonResponse());
        bean.editAuthorizationDetails(authorizationNumber, authorizationDate);
        bean.editTransactionDetails(transactionId, transactionDate, payedAmount);
        return bean;
    }

    @Override
    public PostProcessPaymentStatusBean postProcessPayment(ForwardPaymentRequest forwardPaymentRequest, String string, Optional<String> optional) {
        return (PostProcessPaymentStatusBean)advice$postProcessPayment.perform((Callable)new PaylineConfiguration$callable$postProcessPayment(this, forwardPaymentRequest, string, optional));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ PostProcessPaymentStatusBean advised$postProcessPayment(PaylineConfiguration this_, ForwardPaymentRequest forwardPayment, String justification, Optional specificTransactionId) {
        ForwardPaymentStateType previousState = forwardPayment.getCurrentState();
        ForwardPaymentStatusBean paymentStatusBean = forwardPayment.getDigitalPaymentPlatform().castToForwardPaymentPlatformService().paymentStatus(forwardPayment);
        if (!forwardPayment.getState().isInStateToPostProcessPayment()) {
            throw new TreasuryDomainException("error.ManageForwardPayments.forwardPayment.not.created.nor.requested", String.valueOf(forwardPayment.getOrderNumber()));
        }
        if (Lists.newArrayList((Object[])new ForwardPaymentStateType[]{ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED}).contains(paymentStatusBean.getStateType())) {
            return new PostProcessPaymentStatusBean(paymentStatusBean, previousState, false);
        }
        boolean success = TRANSACTION_APPROVED_CODE.equals(paymentStatusBean.getStatusCode());
        if (!paymentStatusBean.isInvocationSuccess()) {
            throw new TreasuryDomainException("error.ManageForwardPayments.postProcessPayment.invocation.unsucessful", String.valueOf(forwardPayment.getOrderNumber()));
        }
        if (!success) {
            forwardPayment.reject("postProcessPayment", paymentStatusBean.getStatusCode(), paymentStatusBean.getStatusMessage(), paymentStatusBean.getRequestBody(), paymentStatusBean.getResponseBody());
            return new PostProcessPaymentStatusBean(paymentStatusBean, previousState, false);
        }
        forwardPayment.advanceToPaidState(paymentStatusBean.getStatusCode(), paymentStatusBean.getStatusMessage(), paymentStatusBean.getPayedAmount(), paymentStatusBean.getTransactionDate(), paymentStatusBean.getTransactionId(), paymentStatusBean.getAuthorizationNumber(), paymentStatusBean.getRequestBody(), paymentStatusBean.getResponseBody(), justification);
        return new PostProcessPaymentStatusBean(paymentStatusBean, previousState, true);
    }

    public void edit(String name, boolean active, String paymentURL, String paylineMerchantId, String paylineMerchantAccessKey, String paylineContractNumber) {
        this.setName(name);
        this.setActive(active);
        this.setPaymentURL(paymentURL);
        this.setPaylineMerchantId(paylineMerchantId);
        this.setPaylineMerchantAccessKey(paylineMerchantAccessKey);
        this.setPaylineContractNumber(paylineContractNumber);
        this.checkRules();
    }

    public void delete() {
        super.delete();
        super.deleteDomainObject();
    }

    public static String getReturnURL(ForwardPaymentRequest forwardPayment, String returnControllerURL) {
        return String.format("%s%s/%s/%s/%s", TreasurySettings.getInstance().getForwardPaymentReturnDefaultURL(), returnControllerURL, forwardPayment.getExternalId(), ACTION_RETURN_URL, forwardPayment.getReturnForwardPaymentUrlChecksum());
    }

    private void saveReturnUrlChecksum(ForwardPaymentRequest forwardPayment, String returnControllerURL, HttpSession session) {
        String returnUrlToChecksum = String.format("%s%s/%s", TreasurySettings.getInstance().getForwardPaymentReturnDefaultURL(), returnControllerURL, forwardPayment.getExternalId());
        String urlChecksum = TreasuryPlataformDependentServicesFactory.implementation().calculateURLChecksum(returnUrlToChecksum, session);
        forwardPayment.setReturnForwardPaymentUrlChecksum(urlChecksum);
    }

    public static String getCancelURL(ForwardPaymentRequest forwardPayment, String returnControllerURL) {
        return String.format("%s%s/%s/%s/%s", TreasurySettings.getInstance().getForwardPaymentReturnDefaultURL(), returnControllerURL, forwardPayment.getExternalId(), ACTION_CANCEL_URL, forwardPayment.getReturnForwardPaymentUrlChecksum());
    }

    public boolean isActionReturn(String action) {
        return ACTION_RETURN_URL.equals(action);
    }

    public boolean isActionCancel(String action) {
        return ACTION_CANCEL_URL.equals(action);
    }

    public boolean doWebPayment(ForwardPaymentRequest forwardPaymentRequest, String string, HttpSession httpSession) {
        return (Boolean)advice$doWebPayment.perform((Callable)new PaylineConfiguration$callable$doWebPayment(this, forwardPaymentRequest, string, httpSession));
    }

    static /* synthetic */ boolean advised$doWebPayment(PaylineConfiguration this_, ForwardPaymentRequest forwardPayment, String returnControllerURL, HttpSession session) {
        String cancelUrl;
        String returnUrl;
        if (!forwardPayment.getDigitalPaymentPlatform().isActive()) {
            throw new TreasuryDomainException("error.ForwardPaymentConfiguration.not.active", new String[0]);
        }
        if (session != null) {
            this_.saveReturnUrlChecksum(forwardPayment, returnControllerURL, session);
            returnUrl = PaylineConfiguration.getReturnURL(forwardPayment, returnControllerURL);
            cancelUrl = PaylineConfiguration.getCancelURL(forwardPayment, returnControllerURL);
        } else {
            returnUrl = forwardPayment.getForwardPaymentSuccessUrl();
            cancelUrl = forwardPayment.getForwardPaymentInsuccessUrl();
        }
        ITreasuryPlatformDependentServices implementation = TreasuryPlataformDependentServicesFactory.implementation();
        PaylineWebServiceResponse response = implementation.paylineDoWebPayment(forwardPayment, returnUrl, cancelUrl);
        boolean success = TRANSACTION_APPROVED_CODE.equals(response.getResultCode());
        if (!success) {
            forwardPayment.reject("requestPayment", response.getResultCode(), response.getResultLongMessage(), response.getJsonRequest(), response.getJsonResponse());
            return false;
        }
        String code = response.getResultCode();
        String longMessage = response.getResultLongMessage();
        forwardPayment.advanceToRequestState("doWebPayment", code, longMessage, response.getJsonRequest(), response.getJsonResponse());
        forwardPayment.setCheckoutId(response.getToken());
        forwardPayment.setRedirectUrl(response.getRedirectURL());
        return true;
    }

    public boolean processPayment(ForwardPaymentRequest forwardPaymentRequest, String string) {
        return (Boolean)advice$processPayment.perform((Callable)new PaylineConfiguration$callable$processPayment(this, forwardPaymentRequest, string));
    }

    static /* synthetic */ boolean advised$processPayment(PaylineConfiguration this_, ForwardPaymentRequest forwardPayment, String action) {
        if (!this_.isActionReturn(action)) {
            ITreasuryPlatformDependentServices implementation = TreasuryPlataformDependentServicesFactory.implementation();
            PaylineWebServiceResponse response = implementation.paylineGetWebPaymentDetails(forwardPayment);
            String statusCode = response.getResultCode();
            String statusMessage = TreasuryConstants.treasuryBundle("label.PaylineImplementation.cancelled", new String[0]) + ": " + response.getResultLongMessage();
            forwardPayment.reject(action, statusCode, statusMessage, response.getJsonRequest(), response.getJsonResponse());
            return false;
        }
        ITreasuryPlatformDependentServices implementation = TreasuryPlataformDependentServicesFactory.implementation();
        PaylineWebServiceResponse response = implementation.paylineGetWebPaymentDetails(forwardPayment);
        String statusCode = response.getResultCode();
        String statusMessage = response.getResultLongMessage();
        boolean success = TRANSACTION_APPROVED_CODE.equals(statusCode);
        if (!success) {
            forwardPayment.reject(action, statusCode, statusMessage, response.getJsonRequest(), response.getJsonResponse());
            return false;
        }
        String transactionId = response.getTransactionId();
        String authorizationNumber = response.getAuthorizationNumber();
        DateTime transactionDate = response.getTransactionDate();
        BigDecimal paidAmount = response.getPaymentAmount();
        forwardPayment.advanceToPaidState(statusCode, statusMessage, paidAmount, transactionDate, transactionId, authorizationNumber, response.getJsonRequest(), response.getJsonResponse(), null);
        return true;
    }

    public static PaylineConfiguration create(FinantialInstitution finantialInstitution, String name, boolean active, String paymentURL, String paylineMerchantId, String paylineMerchantAccessKey, String paylineContractNumber) {
        return new PaylineConfiguration(finantialInstitution, name, active, paymentURL, paylineMerchantId, paylineMerchantAccessKey, paylineContractNumber);
    }

    public static String getPresentationName() {
        return TreasuryConstants.treasuryBundle("label.PaylineConfiguration.presentationName", new String[0]);
    }

    @Override
    public ForwardPaymentRequest createForwardPaymentRequest(SettlementNoteBean bean, Function<ForwardPaymentRequest, String> successUrlFunction, Function<ForwardPaymentRequest, String> insuccessUrlFunction) {
        Set<DebitEntry> debitEntries = bean.getIncludedInvoiceEntryBeans().stream().map(ISettlementInvoiceEntryBean::getInvoiceEntry).filter(i -> i != null).map(DebitEntry.class::cast).collect(Collectors.toSet());
        Set<Installment> installments = bean.getIncludedInvoiceEntryBeans().stream().filter(i -> i instanceof InstallmentPaymenPlanBean && i.isIncluded()).map(InstallmentPaymenPlanBean.class::cast).map(ib -> ib.getInstallment()).collect(Collectors.toSet());
        ForwardPaymentRequest forwardPaymentRequest = ForwardPaymentRequest.create(bean.getDigitalPaymentPlatform(), bean.getDebtAccount(), debitEntries, installments, bean.getTotalAmountToPay(), successUrlFunction, insuccessUrlFunction);
        this.doWebPayment(forwardPaymentRequest, null, null);
        return forwardPaymentRequest;
    }

    @Override
    public List<? extends DigitalPlatformResultBean> getPaymentTransactionsReportListByMerchantId(String merchantTransationId) {
        return Collections.emptyList();
    }

    @Override
    public PostProcessPaymentStatusBean processForwardPayment(ForwardPaymentRequest forwardPayment) {
        return this.postProcessPayment(forwardPayment, "", null);
    }
}

