/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.exemption;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption$callable$create;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption$callable$delete;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption_Base;
import org.fenixedu.treasury.util.TreasuryConstants;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TreasuryExemption
extends TreasuryExemption_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public TreasuryExemption() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected TreasuryExemption(TreasuryExemptionType treasuryExemptionType, TreasuryEvent treasuryEvent, String reason, BigDecimal valueToExempt, DebitEntry debitEntry) {
        this();
        if (debitEntry.getTreasuryExemption() != null) {
            throw new TreasuryDomainException("error.TreasuryExemption.debitEntry.already.exempted", new String[0]);
        }
        for (CreditEntry creditEntry : debitEntry.getCreditEntriesSet()) {
            if (creditEntry.getFinantialDocument().isAnnulled() || creditEntry.isFromExemption()) continue;
            throw new TreasuryDomainException("error.TreasuryExemption.debitEntry.with.credit.not.from.exemption", new String[0]);
        }
        this.setTreasuryExemptionType(treasuryExemptionType);
        this.setTreasuryEvent(treasuryEvent);
        this.setReason(reason);
        this.setExemptByPercentage(false);
        this.setValueToExempt(valueToExempt);
        this.setDebitEntry(debitEntry);
        this.setProduct(debitEntry.getProduct());
        this.checkRules();
        this.exemptEventIfWithDebtEntries();
    }

    private void checkRules() {
        if (this.getTreasuryExemptionType() == null) {
            throw new TreasuryDomainException("error.TreasuryExemption.treasuryExemptionType.required", new String[0]);
        }
        if (this.getTreasuryEvent() == null) {
            throw new TreasuryDomainException("error.TreasuryExemption.treasuryEvent.required", new String[0]);
        }
        if (this.getValueToExempt() == null) {
            throw new TreasuryDomainException("error.TreasuryExemption.valueToExempt.required", new String[0]);
        }
        if (!TreasuryConstants.isPositive(this.getValueToExempt())) {
            throw new TreasuryDomainException("error.TreasuryExemption.valueToExempt.positive.required", new String[0]);
        }
        if (this.getDebitEntry() == null) {
            throw new TreasuryDomainException("error.TreasuryExemption.debitEntry.required", new String[0]);
        }
        if (this.getProduct() == null) {
            throw new TreasuryDomainException("error.TreasuryExemption.product.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getReason())) {
            throw new TreasuryDomainException("error.TreasuryExemption.reason.empty", new String[0]);
        }
        if (this.getDebitEntry().isEventAnnuled()) {
            throw new TreasuryDomainException("error.TreasuryExemption.debit.entry.annuled.in.event", new String[0]);
        }
        if (TreasuryConstants.isGreaterThan(this.getValueToExempt(), this.getDebitEntry().getAmountWithVat().add(this.getDebitEntry().getExemptedAmount()))) {
            throw new TreasuryDomainException("error.TreasuryExemption.valueToExempt.higher.than.debitEntry", new String[0]);
        }
    }

    public boolean isExemptByPercentage() {
        return super.getExemptByPercentage();
    }

    public BigDecimal getExemptedAmount() {
        if (this.isExemptByPercentage()) {
            throw new TreasuryDomainException("error.TreasuryExemption.exempted.by.percentage.not.supported", new String[0]);
        }
        return this.getValueToExempt();
    }

    private void exemptEventIfWithDebtEntries() {
        BigDecimal amountToExempt = this.getValueToExempt().subtract(this.exemptedAmount(this.getDebitEntry()));
        if (!TreasuryConstants.isPositive(amountToExempt)) {
            return;
        }
        BigDecimal amountWithVat = this.getDebitEntry().getAmountWithVat();
        BigDecimal amountToUse = TreasuryConstants.isGreaterThan(amountWithVat, amountToExempt) ? amountToExempt : amountWithVat;
        this.getDebitEntry().exempt(this, amountToUse);
    }

    private BigDecimal exemptedAmount(DebitEntry debitEntry) {
        BigDecimal result = debitEntry.getExemptedAmount();
        result = result.add(debitEntry.getCreditEntriesSet().stream().map(l -> l.getAmountWithVat()).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO));
        return result;
    }

    private void revertExemptionIfPossible() {
        if (this.getDebitEntry().isAnnulled()) {
            return;
        }
        if (this.getDebitEntry().isProcessedInClosedDebitNote()) {
            throw new TreasuryDomainException("error.TreasuryExemption.delete.impossible.due.to.processed.debit.or.credit.entry", new String[0]);
        }
        if (!this.getDebitEntry().revertExemptionIfPossible(this)) {
            throw new TreasuryDomainException("error.TreasuryExemption.delete.impossible.due.to.processed.debit.or.credit.entry", new String[0]);
        }
    }

    private boolean isDeletable() {
        return this.getDebitEntry().isAnnulled() || this.getDebitEntry().getFinantialDocument() == null || this.getDebitEntry().getFinantialDocument().isPreparing();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new TreasuryExemption$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(TreasuryExemption this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.TreasuryExemption.delete.impossible", new String[0]);
        }
        this_.revertExemptionIfPossible();
        super.setDomainRoot(null);
        super.setTreasuryExemptionType(null);
        super.setTreasuryEvent(null);
        super.setProduct(null);
        super.setDebitEntry(null);
        super.deleteDomainObject();
    }

    public static Stream<TreasuryExemption> findAll() {
        return FenixFramework.getDomainRoot().getTreasuryExemptionsSet().stream();
    }

    public static Stream<TreasuryExemption> find(TreasuryExemptionType treasuryExemptionType) {
        return FenixFramework.getDomainRoot().getTreasuryExemptionsSet().stream().filter(t -> t.getTreasuryExemptionType() == treasuryExemptionType);
    }

    public static Stream<TreasuryExemption> find(TreasuryEvent treasuryEvent) {
        return FenixFramework.getDomainRoot().getTreasuryExemptionsSet().stream().filter(t -> t.getTreasuryEvent() == treasuryEvent);
    }

    protected static Stream<TreasuryExemption> find(TreasuryEvent treasuryEvent, Product product) {
        return TreasuryExemption.find(treasuryEvent).filter(t -> t.getProduct() == product);
    }

    public static Optional<TreasuryExemption> findUnique(TreasuryEvent treasuryEvent, Product product) {
        return TreasuryExemption.find(treasuryEvent, product).findFirst();
    }

    public static Stream<TreasuryExemption> findByDebtAccount(DebtAccount debtAccount) {
        return FenixFramework.getDomainRoot().getTreasuryExemptionsSet().stream().filter(t -> t.getDebitEntry().getDebtAccount() == debtAccount);
    }

    public static TreasuryExemption create(TreasuryExemptionType treasuryExemptionType, TreasuryEvent treasuryEvent, String string, BigDecimal bigDecimal, DebitEntry debitEntry) {
        return (TreasuryExemption)((Object)advice$create.perform((Callable)new TreasuryExemption$callable$create(treasuryExemptionType, treasuryEvent, string, bigDecimal, debitEntry)));
    }

    static /* synthetic */ TreasuryExemption advised$create(TreasuryExemptionType treasuryExemptionType, TreasuryEvent treasuryEvent, String reason, BigDecimal valueToExempt, DebitEntry debitEntry) {
        if (TreasuryConstants.isGreaterThan(debitEntry.getQuantity(), BigDecimal.ONE)) {
            throw new TreasuryDomainException("error.TreasuryExemption.not.possible.to.exempt.debit.entry.with.more.than.one.in.quantity", new String[0]);
        }
        return new TreasuryExemption(treasuryExemptionType, treasuryEvent, reason, valueToExempt, debitEntry);
    }
}

