/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document.reimbursement;

import com.google.common.base.Strings;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.document.reimbursement.ReimbursementProcessStatusType_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import pt.ist.fenixframework.FenixFramework;

public class ReimbursementProcessStatusType
extends ReimbursementProcessStatusType_Base {
    public static final Comparator<ReimbursementProcessStatusType> COMPARE_BY_ORDER_NUMBER = new Comparator<ReimbursementProcessStatusType>(){

        @Override
        public int compare(ReimbursementProcessStatusType o1, ReimbursementProcessStatusType o2) {
            int c = Integer.compare(o1.getOrderNumber(), o2.getOrderNumber());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        }
    };

    public ReimbursementProcessStatusType() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected ReimbursementProcessStatusType(String code, String description, int orderNumber, boolean initialStatus, boolean finalStatus, boolean rejectedStatus) {
        this();
        super.setCode(code);
        super.setDescription(description);
        super.setOrderNumber(orderNumber);
        super.setInitialStatus(initialStatus);
        super.setFinalStatus(finalStatus);
        super.setRejectedStatus(rejectedStatus);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.ReimbursementProcessStatusType.bennu.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getCode())) {
            throw new TreasuryDomainException("error.ReimbursementProcessStatusType.code.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getDescription())) {
            throw new TreasuryDomainException("error.ReimbursementProcessStatusType.description.required", new String[0]);
        }
        if (ReimbursementProcessStatusType.findByCode(this.getCode()).count() > 1L) {
            throw new TreasuryDomainException("error.ReimbursementProcessStatusType.code.already.defined", this.getCode());
        }
        if (ReimbursementProcessStatusType.findByOrderNumber(this.getOrderNumber()).count() > 1L) {
            throw new TreasuryDomainException("error.ReimbursementProcessStatusType.order.number.unique", this.getCode());
        }
        if (ReimbursementProcessStatusType.findByInitialStatus().count() > 1L) {
            throw new TreasuryDomainException("error.ReimbursementProcessStatusType.initial.unique", new String[0]);
        }
    }

    public boolean isInitialStatus() {
        return this.getInitialStatus();
    }

    public boolean isFinalStatus() {
        return this.getFinalStatus();
    }

    public boolean isRejectedStatus() {
        return this.getRejectedStatus();
    }

    public boolean isAfter(ReimbursementProcessStatusType currentReimbursementProcessStatus) {
        return COMPARE_BY_ORDER_NUMBER.compare(this, currentReimbursementProcessStatus) > 0;
    }

    public static Stream<ReimbursementProcessStatusType> findAll() {
        return FenixFramework.getDomainRoot().getReimbursementProcessStatusTypesSet().stream();
    }

    public static Stream<ReimbursementProcessStatusType> findByCode(String code) {
        return ReimbursementProcessStatusType.findAll().filter(r -> code.equals(r.getCode()));
    }

    public static Stream<ReimbursementProcessStatusType> findByOrderNumber(int orderNumber) {
        return ReimbursementProcessStatusType.findAll().filter(r -> r.getOrderNumber() == orderNumber);
    }

    public static Stream<ReimbursementProcessStatusType> findByInitialStatus() {
        return ReimbursementProcessStatusType.findAll().filter(r -> r.isInitialStatus());
    }

    public static Optional<ReimbursementProcessStatusType> findUniqueByCode(String code) {
        return ReimbursementProcessStatusType.findByCode(code).findFirst();
    }

    public static Optional<ReimbursementProcessStatusType> findUniqueByInitialStatus() {
        return ReimbursementProcessStatusType.findByInitialStatus().findFirst();
    }

    public static ReimbursementProcessStatusType create(String code, String description, int orderNumber, boolean initialStatus, boolean finalStatus, boolean annuledStatus) {
        return new ReimbursementProcessStatusType(code, description, orderNumber, initialStatus, finalStatus, annuledStatus);
    }
}

