/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.accesscontrol;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.services.accesscontrol.spi.ITreasuryAccessControlExtension;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;

public class TreasuryAccessControl {
    private static TreasuryAccessControl _instance = null;
    private List<ITreasuryAccessControlExtension> extensions = Collections.synchronizedList(Lists.newArrayList());

    private TreasuryAccessControl() {
    }

    public boolean isFrontOfficeMember() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        return this.isFrontOfficeMember(services.getLoggedUsername());
    }

    public boolean isBackOfficeMember() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        return this.isBackOfficeMember(services.getLoggedUsername());
    }

    public boolean isFrontOfficeMember(FinantialInstitution finantialInstitution) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        return this.isFrontOfficeMember(services.getLoggedUsername(), finantialInstitution);
    }

    public boolean isBackOfficeMember(FinantialInstitution finantialInstitution) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        return this.isBackOfficeMember(services.getLoggedUsername(), finantialInstitution);
    }

    public boolean isManager() {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        return this.isManager(services.getLoggedUsername());
    }

    public boolean isFrontOfficeMember(String username) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isFrontOfficeMember(username)) continue;
            return true;
        }
        return false;
    }

    public boolean isFrontOfficeMember(String username, FinantialInstitution finantialInstitution) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isFrontOfficeMember(username, finantialInstitution)) continue;
            return true;
        }
        return false;
    }

    public <T> boolean isFrontOfficeMemberWithinContext(String username, T context) {
        for (ITreasuryAccessControlExtension ext : this.extensions) {
            if (!ext.isContextObjectApplied(context) || !ext.isFrontOfficeMemberWithinContext(username, context)) continue;
            return true;
        }
        return false;
    }

    public boolean isBackOfficeMember(String username) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isBackOfficeMember(username)) continue;
            return true;
        }
        return false;
    }

    public boolean isBackOfficeMember(String username, FinantialInstitution finantialInstitution) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isBackOfficeMember(username, finantialInstitution)) continue;
            return true;
        }
        return false;
    }

    public boolean isBackOfficeMember(String username, FinantialEntity finantialEntity) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isBackOfficeMember(username, finantialEntity)) continue;
            return true;
        }
        return false;
    }

    public <T> boolean isBackOfficeMemberWithinContext(String username, T context) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isContextObjectApplied(context) || !iTreasuryAccessControlExtension.isBackOfficeMemberWithinContext(username, context)) continue;
            return true;
        }
        return false;
    }

    public boolean isManager(String username) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isManager(username)) continue;
            return true;
        }
        return false;
    }

    public void registerExtension(ITreasuryAccessControlExtension extension) {
        this.extensions.add(extension);
    }

    public void unregisterExtension(ITreasuryAccessControlExtension extension) {
        this.extensions.add(extension);
    }

    public boolean isAllowToModifyInvoices(String username, FinantialInstitution finantialInstitution) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isAllowToModifyInvoices(username, finantialInstitution)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowToModifySettlements(String username, FinantialInstitution finantialInstitution) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isAllowToModifySettlements(username, finantialInstitution)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowToConditionallyAnnulSettlementNote(String username, SettlementNote settlementNote) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isAllowToConditionallyAnnulSettlementNote(username, settlementNote)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowToAnnulSettlementNoteWithoutAnyRestriction(String username, SettlementNote settlementNote) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isAllowToAnnulSettlementNoteWithoutAnyRestriction(username, settlementNote)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getFrontOfficeMemberUsernames() {
        HashSet result = Sets.newHashSet();
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            result.addAll(iTreasuryAccessControlExtension.getFrontOfficeMemberUsernames());
        }
        return result;
    }

    public Set<String> getBackOfficeMemberUsernames() {
        HashSet result = Sets.newHashSet();
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            result.addAll(iTreasuryAccessControlExtension.getBackOfficeMemberUsernames());
        }
        return result;
    }

    public Set<String> getTreasuryManagerMemberUsernames() {
        HashSet result = Sets.newHashSet();
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            result.addAll(iTreasuryAccessControlExtension.getTreasuryManagerMemberUsernames());
        }
        return result;
    }

    public static synchronized TreasuryAccessControl getInstance() {
        if (_instance == null) {
            _instance = new TreasuryAccessControl();
        }
        return _instance;
    }
}

