/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.PaymentMethodReference$callable$delete;
import org.fenixedu.treasury.domain.PaymentMethodReference_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PaymentMethodReference
extends PaymentMethodReference_Base {
    public static Comparator<PaymentMethodReference> COMPARE_BY_NAME;
    public static final Advice advice$delete;

    public PaymentMethodReference() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected PaymentMethodReference(PaymentMethod paymentMethod, FinantialInstitution finantialInstitution, String name, String paymentReferenceId) {
        this();
        this.setPaymentMethod(paymentMethod);
        this.setFinantialInstitution(finantialInstitution);
        this.setName(name);
        this.setPaymentReferenceId(paymentReferenceId);
        this.setDefaultReference(false);
        this.setPaymentMethodReferenceActive(true);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.PaymentMethodReference.domainRoot.required", new String[0]);
        }
        if (this.getPaymentMethod() == null) {
            throw new TreasuryDomainException("error.PaymentMethodReference.paymentMethod.required", new String[0]);
        }
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.PaymentMethodReference.finantialInstitution.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getName())) {
            throw new TreasuryDomainException("error.PaymentMethodReference.name.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getPaymentReferenceId())) {
            throw new TreasuryDomainException("error.PaymentMethodReference.paymentReferenceId.required", new String[0]);
        }
        if (PaymentMethodReference.findByPaymentReferenceId(this.getPaymentMethod(), this.getFinantialInstitution(), this.getPaymentReferenceId()).count() > 1L) {
            throw new TreasuryDomainException("error.PaymentMethodReference.paymentReferenceId.duplicated", new String[0]);
        }
        if (PaymentMethodReference.findDefaultPaymentMethodReference(this.getPaymentMethod(), this.getFinantialInstitution()).count() > 1L) {
            throw new TreasuryDomainException("error.PaymentMethodReference.defaultPaymentMethodReference.not.unique", new String[0]);
        }
        if (this.isDefault() && !this.isActive()) {
            throw new TreasuryDomainException("error.PaymentMethodReference.default.must.be.active", new String[0]);
        }
    }

    public boolean isDefault() {
        return Boolean.TRUE.equals(this.getDefaultReference());
    }

    public boolean isActive() {
        return Boolean.TRUE.equals(this.getPaymentMethodReferenceActive());
    }

    public void markAsDefault() {
        PaymentMethodReference.find(this.getPaymentMethod(), this.getFinantialInstitution()).forEach(p -> p.setDefaultReference(false));
        this.setDefaultReference(true);
        this.checkRules();
    }

    public void markAsNotDefault() {
        this.setDefaultReference(false);
        this.checkRules();
    }

    public void activate() {
        this.setPaymentMethodReferenceActive(true);
        this.checkRules();
    }

    public void deactivate() {
        this.setDefaultReference(false);
        this.setPaymentMethodReferenceActive(false);
        this.checkRules();
    }

    public void edit(String name, String paymentReferenceId) {
        this.setName(name);
        this.setPaymentReferenceId(paymentReferenceId);
        this.checkRules();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PaymentMethodReference$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PaymentMethodReference this_) {
        this_.setDomainRoot(null);
        this_.setPaymentMethod(null);
        this_.setFinantialInstitution(null);
        super.deleteDomainObject();
    }

    public static boolean isPaymentMethodReferencesApplied() {
        return PaymentMethodReference.findAll().count() > 0L;
    }

    public static Stream<PaymentMethodReference> findAll() {
        return FenixFramework.getDomainRoot().getPaymentMethodReferencesSet().stream();
    }

    public static Stream<PaymentMethodReference> find(PaymentMethod paymentMethod, FinantialInstitution finantialInstitution) {
        return paymentMethod.getPaymentMethodReferencesSet().stream().filter(p -> p.getFinantialInstitution() == finantialInstitution);
    }

    public static Stream<PaymentMethodReference> findActive(PaymentMethod paymentMethod, FinantialInstitution finantialInstitution) {
        return PaymentMethodReference.find(paymentMethod, finantialInstitution).filter(p -> p.isActive());
    }

    public static Stream<PaymentMethodReference> findByPaymentReferenceId(PaymentMethod paymentMethod, FinantialInstitution finantialInstitution, String paymentReferenceId) {
        return PaymentMethodReference.find(paymentMethod, finantialInstitution).filter(p -> paymentReferenceId.equals(p.getPaymentReferenceId()));
    }

    public static Stream<PaymentMethodReference> findDefaultPaymentMethodReference(PaymentMethod paymentMethod, FinantialInstitution finantialInstitution) {
        return PaymentMethodReference.find(paymentMethod, finantialInstitution).filter(p -> p.isDefault());
    }

    public static Optional<PaymentMethodReference> findUniqueDefaultPaymentMethodReference(PaymentMethod paymentMethod, FinantialInstitution finantialInstitution) {
        return PaymentMethodReference.find(paymentMethod, finantialInstitution).filter(p -> p.isDefault()).findFirst();
    }

    public static PaymentMethodReference create(PaymentMethod paymentMethod, FinantialInstitution finantialInstitution, String name, String paymentReferenceId) {
        return new PaymentMethodReference(paymentMethod, finantialInstitution, name, paymentReferenceId);
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_NAME = (o1, o2) -> o1.getName().compareTo(o2.getName()) * 10 + o1.getExternalId().compareTo(o2.getExternalId());
    }
}

