/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentEntry;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentSettlementEntry;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGateway;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;

@Deprecated
public interface IPaymentProcessorForInvoiceEntries {
    public DebtAccount getDebtAccount();

    public DocumentNumberSeries getDocumentSeriesForPayments();

    public DocumentNumberSeries getDocumentSeriesInterestDebits();

    public Set<Customer> getReferencedCustomers();

    public BigDecimal getPayableAmount();

    public DateTime getPaymentRequestDate();

    public String getPaymentRequestStateDescription();

    public String getPaymentTypeDescription();

    public PaymentMethod getPaymentMethod();

    public Set<InvoiceEntry> getInvoiceEntriesSet();

    public Set<Installment> getInstallmentsSet();

    public String fillPaymentEntryMethodId();

    public SibsOnlinePaymentsGateway getSibsOnlinePaymentsGateway();

    public String getSibsOppwaMerchantTransactionId();

    public String getSibsOppwaTransactionId();

    default public boolean isMbwayRequest() {
        return false;
    }

    default public boolean isPaymentCodeTarget() {
        return false;
    }

    default public boolean isForwardPayment() {
        return false;
    }

    default public boolean payAllDebitEntriesInterests() {
        return false;
    }

    default public Set<SettlementNote> internalProcessPaymentInNormalPaymentMixingLegacyInvoices(String username, BigDecimal amount, DateTime paymentDate, String originDocumentNumber, String comments, Set<InvoiceEntry> invoiceEntriesToPay, Set<Installment> installmentsToPay, Function<IPaymentProcessorForInvoiceEntries, Map<String, String>> additionalPropertiesMapFunction) {
        TreeSet sortedInvoiceEntriesToPay = Sets.newTreeSet(InvoiceEntry.COMPARE_BY_AMOUNT_AND_DUE_DATE);
        sortedInvoiceEntriesToPay.addAll(invoiceEntriesToPay);
        TreeSet sortedInstallmentEntryToPay = Sets.newTreeSet(InstallmentEntry.COMPARE_BY_DEBIT_ENTRY_COMPARATOR);
        sortedInstallmentEntryToPay.addAll(installmentsToPay.stream().flatMap(i -> i.getInstallmentEntriesSet().stream()).collect(Collectors.toSet()));
        BigDecimal availableAmount = amount;
        ArrayList<DebitEntry> interestRateEntries = new ArrayList<DebitEntry>();
        DebtAccount referenceDebtAccount = this.getDebtAccount();
        DocumentNumberSeries docNumberSeries = this.getDocumentSeriesForPayments();
        SettlementNote settlementNote = SettlementNote.create(referenceDebtAccount, docNumberSeries, new DateTime(), paymentDate, comments, null);
        if (this.getReferencedCustomers().size() == 1) {
            SettlementEntry settlementEntry;
            DebitNote debitNote;
            Object documentNumberSeries;
            DebitEntry debitEntry;
            for (Object entry : sortedInvoiceEntriesToPay) {
                if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal amountToPay = ((InvoiceEntry)((Object)entry)).getOpenAmount();
                if (amountToPay.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (((InvoiceEntry)((Object)entry)).isDebitNoteEntry()) {
                    debitEntry = (DebitEntry)((Object)entry);
                    if (debitEntry.getFinantialDocument() == null) {
                        documentNumberSeries = DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForDebitNote(), this.getDebtAccount().getFinantialInstitution()).get();
                        debitNote = DebitNote.create(debitEntry.getDebtAccount(), (DocumentNumberSeries)((Object)documentNumberSeries), new DateTime());
                        debitNote.addDebitNoteEntries(Lists.newArrayList((Object[])new DebitEntry[]{debitEntry}));
                    }
                    if (debitEntry.getFinantialDocument().isPreparing()) {
                        debitEntry.getFinantialDocument().closeDocument();
                    }
                    if (amountToPay.compareTo(availableAmount) > 0) {
                        amountToPay = availableAmount;
                    }
                    if (debitEntry.getOpenAmount().equals(amountToPay)) {
                        InterestRateBean calculateUndebitedInterestValue;
                        if (this.payAllDebitEntriesInterests()) {
                            for (DebitEntry interestDebitEntry : debitEntry.getInterestDebitEntriesSet()) {
                                if (interestDebitEntry.isAnnulled() || !interestDebitEntry.isInDebt() || sortedInvoiceEntriesToPay.contains((Object)interestDebitEntry)) continue;
                                interestRateEntries.add(interestDebitEntry);
                            }
                        }
                        if (TreasuryConstants.isPositive((calculateUndebitedInterestValue = debitEntry.calculateUndebitedInterestValue(paymentDate.toLocalDate())).getInterestAmount())) {
                            DebitEntry interestDebitEntry;
                            interestDebitEntry = debitEntry.createInterestRateDebitEntry(calculateUndebitedInterestValue, paymentDate, Optional.empty());
                            interestRateEntries.add(interestDebitEntry);
                        }
                    }
                    settlementEntry = SettlementEntry.create((InvoiceEntry)((Object)entry), settlementNote, amountToPay, entry.getDescription(), paymentDate, true);
                    InstallmentSettlementEntry.settleInstallmentEntriesOfDebitEntry(settlementEntry);
                    availableAmount = availableAmount.subtract(amountToPay);
                    continue;
                }
                if (!((InvoiceEntry)((Object)entry)).isCreditNoteEntry()) continue;
                SettlementEntry.create((InvoiceEntry)((Object)entry), settlementNote, ((InvoiceEntry)((Object)entry)).getOpenAmount(), entry.getDescription(), paymentDate, true);
                availableAmount = availableAmount.add(amountToPay);
            }
            for (Object entry : sortedInstallmentEntryToPay) {
                if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal installmentAmountToPay = ((InstallmentEntry)((Object)entry)).getOpenAmount();
                if (installmentAmountToPay.compareTo(BigDecimal.ZERO) <= 0) continue;
                debitEntry = entry.getDebitEntry();
                if (debitEntry.getFinantialDocument() == null) {
                    documentNumberSeries = DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForDebitNote(), this.getDebtAccount().getFinantialInstitution()).get();
                    debitNote = DebitNote.create(debitEntry.getDebtAccount(), (DocumentNumberSeries)((Object)documentNumberSeries), new DateTime());
                    debitNote.addDebitNoteEntries(Lists.newArrayList((Object[])new DebitEntry[]{debitEntry}));
                }
                if (debitEntry.getFinantialDocument().isPreparing()) {
                    debitEntry.getFinantialDocument().closeDocument();
                }
                if (installmentAmountToPay.compareTo(availableAmount) > 0) {
                    installmentAmountToPay = availableAmount;
                }
                if ((settlementEntry = settlementNote.getSettlementEntryByDebitEntry(debitEntry)) == null) {
                    settlementEntry = SettlementEntry.create((InvoiceEntry)((Object)debitEntry), settlementNote, installmentAmountToPay, debitEntry.getDescription(), paymentDate, false);
                } else {
                    settlementEntry.setAmount(settlementEntry.getAmount().add(installmentAmountToPay));
                }
                InstallmentSettlementEntry.create((InstallmentEntry)((Object)entry), settlementEntry, installmentAmountToPay);
                entry.getInstallment().getPaymentPlan().tryClosePaymentPlanByPaidOff();
                availableAmount = availableAmount.subtract(installmentAmountToPay);
            }
            if (interestRateEntries.size() > 0) {
                DebitNote interestNote = DebitNote.create(referenceDebtAccount, this.getDocumentSeriesInterestDebits(), paymentDate);
                for (DebitEntry interestEntry : interestRateEntries) {
                    if (interestEntry.getFinantialDocument() != null) {
                        if (!interestEntry.getFinantialDocument().isPreparing()) continue;
                        interestEntry.getFinantialDocument().closeDocument();
                        continue;
                    }
                    interestEntry.setFinantialDocument((FinantialDocument)((Object)interestNote));
                }
                interestNote.closeDocument();
                if (availableAmount.compareTo(BigDecimal.ZERO) > 0) {
                    for (DebitEntry interestEntry : interestRateEntries) {
                        if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                        BigDecimal amountToPay = interestEntry.getOpenAmount();
                        if (amountToPay.compareTo(availableAmount) > 0) {
                            amountToPay = availableAmount;
                        }
                        SettlementEntry newSettlementEntry = SettlementEntry.create((InvoiceEntry)((Object)interestEntry), settlementNote, amountToPay, interestEntry.getDescription(), paymentDate, true);
                        availableAmount = availableAmount.subtract(amountToPay);
                    }
                }
                interestRateEntries.clear();
            }
        }
        if (availableAmount.compareTo(BigDecimal.ZERO) > 0) {
            settlementNote.createAdvancedPaymentCreditNote(availableAmount, TreasuryConstants.treasuryBundle("label.PaymentCodeTarget.advancedpayment", new String[0]) + comments + "-" + originDocumentNumber, originDocumentNumber);
        }
        Map<String, String> paymentEntryPropertiesMap = additionalPropertiesMapFunction.apply(this);
        PaymentEntry.create(this.getPaymentMethod(), settlementNote, amount, this.fillPaymentEntryMethodId(), paymentEntryPropertiesMap);
        settlementNote.closeDocument();
        return Sets.newHashSet((Object[])new SettlementNote[]{settlementNote});
    }

    default public Set<SettlementNote> internalProcessPaymentInRestrictedPaymentMixingLegacyInvoices(String username, BigDecimal amount, DateTime paymentDate, String sibsTransactionId, String comments, Set<InvoiceEntry> invoiceEntriesToPay, Set<Installment> installmentsToPay, Function<IPaymentProcessorForInvoiceEntries, Map<String, String>> additionalPropertiesMapFunction) {
        SettlementEntry settlementEntry;
        DebitEntry debitEntry;
        if (!TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices()) {
            throw new RuntimeException("invalid call");
        }
        SettlementNote.checkMixingOfInvoiceEntriesExportedInLegacyERP(invoiceEntriesToPay);
        if (invoiceEntriesToPay.stream().allMatch(e -> e.getFinantialDocument() == null || !e.getFinantialDocument().isExportedInLegacyERP())) {
            return this.internalProcessPaymentInNormalPaymentMixingLegacyInvoices(username, amount, paymentDate, sibsTransactionId, comments, invoiceEntriesToPay, installmentsToPay, additionalPropertiesMapFunction);
        }
        TreeSet sortedInvoiceEntriesToPay = Sets.newTreeSet(InvoiceEntry.COMPARE_BY_AMOUNT_AND_DUE_DATE);
        sortedInvoiceEntriesToPay.addAll(invoiceEntriesToPay);
        TreeSet sortedInstallmentEntryToPay = Sets.newTreeSet(InstallmentEntry.COMPARE_BY_DEBIT_ENTRY_COMPARATOR);
        sortedInstallmentEntryToPay.addAll(installmentsToPay.stream().flatMap(i -> i.getInstallmentEntriesSet().stream()).collect(Collectors.toSet()));
        BigDecimal availableAmount = amount;
        DebtAccount referenceDebtAccount = this.getDebtAccount();
        DocumentNumberSeries docNumberSeries = this.getDocumentSeriesForPayments();
        SettlementNote settlementNote = SettlementNote.create(referenceDebtAccount, docNumberSeries, new DateTime(), paymentDate, comments, null);
        if (this.getReferencedCustomers().size() == 1) {
            for (Object entry : sortedInvoiceEntriesToPay) {
                if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) break;
                BigDecimal amountToPay = ((InvoiceEntry)((Object)entry)).getOpenAmount();
                if (amountToPay.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (((InvoiceEntry)((Object)entry)).isDebitNoteEntry()) {
                    InterestRateBean calculateUndebitedInterestValue;
                    debitEntry = (DebitEntry)((Object)entry);
                    if (debitEntry.getFinantialDocument().isPreparing()) {
                        debitEntry.getFinantialDocument().closeDocument();
                    }
                    if (amountToPay.compareTo(availableAmount) > 0) {
                        amountToPay = availableAmount;
                    }
                    if (debitEntry.getOpenAmount().equals(amountToPay) && TreasuryConstants.isPositive((calculateUndebitedInterestValue = debitEntry.calculateUndebitedInterestValue(paymentDate.toLocalDate())).getInterestAmount())) {
                        debitEntry.createInterestRateDebitEntry(calculateUndebitedInterestValue, paymentDate, Optional.empty());
                    }
                    settlementEntry = SettlementEntry.create((InvoiceEntry)((Object)entry), settlementNote, amountToPay, entry.getDescription(), paymentDate, true);
                    InstallmentSettlementEntry.settleInstallmentEntriesOfDebitEntry(settlementEntry);
                    availableAmount = availableAmount.subtract(amountToPay);
                    continue;
                }
                if (!((InvoiceEntry)((Object)entry)).isCreditNoteEntry()) continue;
                SettlementEntry.create((InvoiceEntry)((Object)entry), settlementNote, ((InvoiceEntry)((Object)entry)).getOpenAmount(), entry.getDescription(), paymentDate, true);
                availableAmount = availableAmount.add(amountToPay);
            }
        }
        for (Object entry : sortedInstallmentEntryToPay) {
            if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) break;
            BigDecimal installmentAmountToPay = ((InstallmentEntry)((Object)entry)).getOpenAmount();
            if (installmentAmountToPay.compareTo(BigDecimal.ZERO) <= 0) continue;
            debitEntry = entry.getDebitEntry();
            if (debitEntry.getFinantialDocument().isPreparing()) {
                debitEntry.getFinantialDocument().closeDocument();
            }
            if (installmentAmountToPay.compareTo(availableAmount) > 0) {
                installmentAmountToPay = availableAmount;
            }
            if ((settlementEntry = settlementNote.getSettlementEntryByDebitEntry(debitEntry)) == null) {
                settlementEntry = SettlementEntry.create((InvoiceEntry)((Object)debitEntry), settlementNote, installmentAmountToPay, debitEntry.getDescription(), paymentDate, false);
            } else {
                settlementEntry.setAmount(settlementEntry.getAmount().add(installmentAmountToPay));
            }
            InstallmentSettlementEntry.create((InstallmentEntry)((Object)entry), settlementEntry, installmentAmountToPay);
            entry.getInstallment().getPaymentPlan().tryClosePaymentPlanByPaidOff();
            availableAmount = availableAmount.subtract(installmentAmountToPay);
        }
        if (availableAmount.compareTo(BigDecimal.ZERO) <= 0) {
            availableAmount = BigDecimal.ZERO;
        }
        Map<String, String> paymentEntryPropertiesMap = additionalPropertiesMapFunction.apply(this);
        PaymentEntry.create(this.getPaymentMethod(), settlementNote, amount.subtract(availableAmount), this.fillPaymentEntryMethodId(), paymentEntryPropertiesMap);
        settlementNote.closeDocument();
        HashSet result = Sets.newHashSet((Object[])new SettlementNote[]{settlementNote});
        if (availableAmount.compareTo(BigDecimal.ZERO) > 0) {
            SettlementNote advancedPaymentSettlementNote = SettlementNote.create(referenceDebtAccount, docNumberSeries, new DateTime(), paymentDate, comments, null);
            advancedPaymentSettlementNote.createAdvancedPaymentCreditNote(availableAmount, TreasuryConstants.treasuryBundle("label.PaymentCodeTarget.advancedpayment", new String[0]) + comments + "-" + sibsTransactionId, sibsTransactionId);
            PaymentEntry.create(this.getPaymentMethod(), advancedPaymentSettlementNote, availableAmount, this.fillPaymentEntryMethodId(), paymentEntryPropertiesMap);
            advancedPaymentSettlementNote.closeDocument();
            advancedPaymentSettlementNote.setExportedInLegacyERP(true);
            advancedPaymentSettlementNote.setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
            advancedPaymentSettlementNote.getAdvancedPaymentCreditNote().setExportedInLegacyERP(true);
            advancedPaymentSettlementNote.getAdvancedPaymentCreditNote().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
            result.add(advancedPaymentSettlementNote);
        }
        return result;
    }

    public static Set<Customer> getReferencedCustomers(Set<InvoiceEntry> invoiceEntrySet, Set<Installment> installments) {
        HashSet result = Sets.newHashSet();
        for (InvoiceEntry invoiceEntry : invoiceEntrySet) {
            if (invoiceEntry.getFinantialDocument() != null && ((Invoice)((Object)invoiceEntry.getFinantialDocument())).isForPayorDebtAccount()) {
                result.add(((Invoice)((Object)invoiceEntry.getFinantialDocument())).getPayorDebtAccount().getCustomer());
                continue;
            }
            result.add(invoiceEntry.getDebtAccount().getCustomer());
        }
        for (Installment installment : installments) {
            result.addAll(installment.getInstallmentEntriesSet().stream().map(e -> e.getDebitEntry()).map(deb -> deb.getFinantialDocument() != null && ((Invoice)((Object)((Object)((Object)((Object)deb.getFinantialDocument()))))).isForPayorDebtAccount() ? ((Invoice)((Object)((Object)((Object)((Object)deb.getFinantialDocument()))))).getPayorDebtAccount().getCustomer() : deb.getDebtAccount().getCustomer()).collect(Collectors.toSet()));
        }
        return result;
    }
}

