/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FiscalCountryRegion$callable$create;
import org.fenixedu.treasury.domain.FiscalCountryRegion$callable$delete;
import org.fenixedu.treasury.domain.FiscalCountryRegion$callable$edit;
import org.fenixedu.treasury.domain.FiscalCountryRegion$callable$initializeFiscalRegion;
import org.fenixedu.treasury.domain.FiscalCountryRegion_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import org.fenixedu.treasury.util.TreasuryConstants;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class FiscalCountryRegion
extends FiscalCountryRegion_Base {
    public static final Advice advice$initializeFiscalRegion = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected FiscalCountryRegion() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected FiscalCountryRegion(String fiscalCode, LocalizedString name) {
        this();
        this.setFiscalCode(fiscalCode);
        this.setName(name);
        this.checkRules();
    }

    public static void initializeFiscalRegion() {
        Object object = advice$initializeFiscalRegion.perform((Callable)new FiscalCountryRegion$callable$initializeFiscalRegion());
    }

    static /* synthetic */ void advised$initializeFiscalRegion() {
        if (FiscalCountryRegion.findAll().count() == 0L) {
            FiscalCountryRegion.create("PT", TreasuryConstants.treasuryBundleI18N("label.FiscalCountryRegion.PT", new String[0]));
            FiscalCountryRegion.create("PT_MA", TreasuryConstants.treasuryBundleI18N("label.FiscalCountryRegion.PT_MA", new String[0]));
            FiscalCountryRegion.create("PT_AZ", TreasuryConstants.treasuryBundleI18N("label.FiscalCountryRegion.PT_AZ", new String[0]));
        }
    }

    private void checkRules() {
        if (LocalizedStringUtil.isTrimmedEmpty(this.getFiscalCode())) {
            throw new TreasuryDomainException("error.FiscalCountryRegion.fiscalCode.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.FiscalCountryRegion.name.required", new String[0]);
        }
        FiscalCountryRegion.findByRegionCode(this.getFiscalCode());
        this.getName().getLocales().stream().forEach(l -> FiscalCountryRegion.findByName(this.getName().getContent(l)));
    }

    public void edit(String string, LocalizedString localizedString) {
        Object object = advice$edit.perform((Callable)new FiscalCountryRegion$callable$edit(this, string, localizedString));
    }

    static /* synthetic */ void advised$edit(FiscalCountryRegion this_, String fiscalCode, LocalizedString name) {
        this_.setFiscalCode(fiscalCode);
        this_.setName(name);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getFinantialInstitutionsSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new FiscalCountryRegion$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(FiscalCountryRegion this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.FiscalCountryRegion.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.deleteDomainObject();
    }

    public static Stream<FiscalCountryRegion> findAll() {
        return FenixFramework.getDomainRoot().getFiscalCountryRegionsSet().stream();
    }

    public static FiscalCountryRegion findByRegionCode(String fiscalCode) {
        FiscalCountryRegion result = null;
        for (FiscalCountryRegion it : FiscalCountryRegion.findAll().collect(Collectors.toList())) {
            if (!it.getFiscalCode().equalsIgnoreCase(fiscalCode)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.FiscalCountryRegion.duplicated.fiscalCode", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static FiscalCountryRegion findByName(String name) {
        FiscalCountryRegion result = null;
        for (FiscalCountryRegion it : FiscalCountryRegion.findAll().collect(Collectors.toList())) {
            if (!LocalizedStringUtil.isEqualToAnyLocaleIgnoreCase(it.getName(), name)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.FiscalCountryRegion.duplicated.name", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static FiscalCountryRegion create(String string, LocalizedString localizedString) {
        return (FiscalCountryRegion)((Object)advice$create.perform((Callable)new FiscalCountryRegion$callable$create(string, localizedString)));
    }

    static /* synthetic */ FiscalCountryRegion advised$create(String fiscalCode, LocalizedString name) {
        return new FiscalCountryRegion(fiscalCode, name);
    }
}

