/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.AdhocCustomer$callable$changeFiscalNumber;
import org.fenixedu.treasury.domain.AdhocCustomer$callable$create;
import org.fenixedu.treasury.domain.AdhocCustomer$callable$delete;
import org.fenixedu.treasury.domain.AdhocCustomer$callable$edit;
import org.fenixedu.treasury.domain.AdhocCustomer_Base;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.CustomerType;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.FiscalDataUpdateLog;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.dto.AdhocCustomerBean;
import org.fenixedu.treasury.util.FiscalCodeValidation;
import org.fenixedu.treasury.util.TreasuryConstants;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AdhocCustomer
extends AdhocCustomer_Base {
    private static final int SAFT_CUSTOMER_COMPANY_NAME_MAX_LENGTH = 100;
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$changeFiscalNumber = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected AdhocCustomer() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public boolean isAdhocCustomer() {
        return true;
    }

    public boolean isActive() {
        return this.getDebtAccountsSet().stream().filter(d -> !d.getClosed()).count() > 0L;
    }

    public Customer getActiveCustomer() {
        return this;
    }

    protected AdhocCustomer(CustomerType customerType, String fiscalNumber, String name, String address, String districtSubdivision, String region, String zipCode, String addressCountryCode, String identificationNumber, List<FinantialInstitution> finantialInstitutions) {
        this();
        this.setCustomerType(customerType);
        this.setCode(this.getExternalId());
        this.setFiscalNumber(fiscalNumber);
        this.setName(name);
        this.setAddress(address);
        this.setRegion(region);
        this.setDistrictSubdivision(districtSubdivision);
        this.setZipCode(zipCode);
        this.setAddressCountryCode(addressCountryCode.toUpperCase());
        this.setIdentificationNumber(identificationNumber);
        if (TreasuryConstants.isDefaultCountry(this.getAddressCountryCode()) && !FiscalCodeValidation.isValidFiscalNumber(this.getAddressCountryCode(), this.getFiscalNumber())) {
            throw new TreasuryDomainException("error.Customer.fiscal.information.invalid", new String[0]);
        }
        this.registerFinantialInstitutions(finantialInstitutions);
        this.checkRules();
    }

    public void checkRules() {
        super.checkRules();
        if (this.getName().length() > 100) {
            throw new TreasuryDomainException("error.AdhocCustomer.name.exceeds.max.length", String.valueOf(100));
        }
    }

    public String getPaymentReferenceBaseCode() {
        return this.getCode();
    }

    public void edit(CustomerType customerType, String string, String string2, String string3, String string4, String string5, String string6, List<FinantialInstitution> list) {
        Object object = advice$edit.perform((Callable)new AdhocCustomer$callable$edit(this, customerType, string, string2, string3, string4, string5, string6, list));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$edit(AdhocCustomer this_, CustomerType customerType, String name, String address, String districtSubdivision, String region, String zipCode, String identificationNumber, List newFinantialInstitutions) {
        this_.registerFinantialInstitutions(newFinantialInstitutions);
        this_.setCustomerType(customerType);
        this_.setName(name);
        this_.setAddress(address);
        this_.setDistrictSubdivision(districtSubdivision);
        this_.setRegion(region);
        this_.setZipCode(zipCode);
        this_.setIdentificationNumber(identificationNumber);
        this_.checkRules();
    }

    public void changeFiscalNumber(AdhocCustomerBean adhocCustomerBean) {
        Object object = advice$changeFiscalNumber.perform((Callable)new AdhocCustomer$callable$changeFiscalNumber(this, adhocCustomerBean));
    }

    static /* synthetic */ void advised$changeFiscalNumber(AdhocCustomer this_, AdhocCustomerBean bean) {
        if (!Strings.isNullOrEmpty((String)this_.getErpCustomerId())) {
            throw new TreasuryDomainException("warning.Customer.changeFiscalNumber.maybe.integrated.in.erp", new String[0]);
        }
        String oldFiscalCountry = this_.getAddressCountryCode();
        String oldFiscalNumber = this_.getFiscalNumber();
        boolean changeFiscalNumberConfirmed = bean.isChangeFiscalNumberConfirmed();
        boolean withFinantialDocumentsIntegratedInERP = this_.isWithFinantialDocumentsIntegratedInERP();
        boolean customerInformationMaybeIntegratedWithSuccess = this_.isCustomerInformationMaybeIntegratedWithSuccess();
        boolean customerWithFinantialDocumentsIntegratedInPreviousERP = this_.isCustomerWithFinantialDocumentsIntegratedInPreviousERP();
        if (!bean.isChangeFiscalNumberConfirmed()) {
            throw new TreasuryDomainException("message.Customer.changeFiscalNumber.confirmation", new String[0]);
        }
        String addressCountryCode = bean.getAddressCountryCode();
        String fiscalNumber = bean.getFiscalNumber();
        if (Strings.isNullOrEmpty((String)addressCountryCode)) {
            throw new TreasuryDomainException("error.Customer.countryCode.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)fiscalNumber)) {
            throw new TreasuryDomainException("error.Customer.fiscalNumber.required", new String[0]);
        }
        if (AdhocCustomer.lowerCase((String)addressCountryCode).equals(AdhocCustomer.lowerCase((String)this_.getAddressCountryCode())) && fiscalNumber.equals(this_.getFiscalNumber())) {
            throw new TreasuryDomainException("error.Customer.already.with.fiscal.information", new String[0]);
        }
        if (this_.isFiscalValidated() && this_.isFiscalCodeValid()) {
            throw new TreasuryDomainException("error.Customer.changeFiscalNumber.already.valid", new String[0]);
        }
        if (customerInformationMaybeIntegratedWithSuccess) {
            throw new TreasuryDomainException("warning.Customer.changeFiscalNumber.maybe.integrated.in.erp", new String[0]);
        }
        if (withFinantialDocumentsIntegratedInERP) {
            throw new TreasuryDomainException("error.Customer.changeFiscalNumber.documents.integrated.erp", new String[0]);
        }
        if (!FiscalCodeValidation.isValidFiscalNumber(addressCountryCode, fiscalNumber)) {
            throw new TreasuryDomainException("error.Customer.fiscal.information.invalid", new String[0]);
        }
        this_.setAddressCountryCode(addressCountryCode);
        this_.setFiscalNumber(fiscalNumber);
        this_.setAddress(bean.getAddress());
        this_.setDistrictSubdivision(bean.getDistrictSubdivision());
        this_.setRegion(bean.getRegion());
        this_.setZipCode(bean.getZipCode());
        this_.setIdentificationNumber(bean.getIdentificationNumber());
        this_.checkRules();
        FiscalDataUpdateLog.create((Customer)((Object)this_), oldFiscalCountry, oldFiscalNumber, changeFiscalNumberConfirmed, withFinantialDocumentsIntegratedInERP, customerInformationMaybeIntegratedWithSuccess, customerWithFinantialDocumentsIntegratedInPreviousERP);
    }

    public boolean isFiscalCodeValid() {
        return !TreasuryConstants.isDefaultCountry(this.getAddressCountryCode()) || FiscalCodeValidation.isValidFiscalNumber(this.getAddressCountryCode(), this.getFiscalNumber());
    }

    public boolean isFiscalValidated() {
        return TreasuryConstants.isDefaultCountry(this.getAddressCountryCode());
    }

    public boolean isAbleToChangeFiscalNumber() {
        boolean result = super.isAbleToChangeFiscalNumber();
        if (!result) {
            return result;
        }
        return !FiscalCodeValidation.isValidationAppliedToFiscalCountry(this.getAddressCountryCode()) || !FiscalCodeValidation.isValidFiscalNumber(this.getAddressCountryCode(), this.getFiscalNumber());
    }

    public Set<? extends TreasuryEvent> getTreasuryEventsSet() {
        return Sets.newHashSet();
    }

    public boolean isUiOtherRelatedCustomerActive() {
        return false;
    }

    public String uiRedirectToActiveCustomer(String url) {
        return url + "/" + this.getExternalId();
    }

    public boolean isDeletable() {
        return this.getDebtAccountsSet().stream().allMatch(da -> da.isDeletable());
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new AdhocCustomer$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(AdhocCustomer this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.AdhocCustomer.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setCustomerType(null);
        for (DebtAccount deb : this_.getDebtAccountsSet()) {
            deb.delete();
        }
        this_.deleteDomainObject();
    }

    public String getFirstNames() {
        throw new RuntimeException("not supported");
    }

    public String getLastNames() {
        throw new RuntimeException("not supported");
    }

    public String getBusinessIdentification() {
        return this.getIdentificationNumber();
    }

    public String getNationalityCountryCode() {
        return null;
    }

    public String getFiscalCountry() {
        return this.getAddressCountryCode();
    }

    public String getEmail() {
        throw new RuntimeException("not supported");
    }

    public String getPhoneNumber() {
        throw new RuntimeException("not supported");
    }

    public BigDecimal getGlobalBalance() {
        BigDecimal globalBalance = BigDecimal.ZERO;
        for (DebtAccount debtAccount : this.getDebtAccountsSet()) {
            globalBalance = globalBalance.add(debtAccount.getTotalInDebt());
        }
        return globalBalance;
    }

    public String getUsername() {
        return null;
    }

    public Set<Customer> getAllCustomers() {
        return Sets.newHashSet((Object[])new Customer[]{this});
    }

    public LocalizedString getIdentificationTypeDesignation() {
        return null;
    }

    public String getIdentificationTypeCode() {
        return null;
    }

    public String getIban() {
        return null;
    }

    public boolean isAddressValid() {
        boolean valid = true;
        valid &= !Strings.isNullOrEmpty((String)this.getAddressCountryCode());
        valid &= !Strings.isNullOrEmpty((String)this.getAddress());
        valid &= !Strings.isNullOrEmpty((String)this.getDistrictSubdivision());
        if (TreasuryConstants.isDefaultCountry(this.getAddressCountryCode())) {
            valid &= !Strings.isNullOrEmpty((String)this.getZipCode());
            valid &= !Strings.isNullOrEmpty((String)this.getRegion());
        }
        if (TreasuryConstants.isDefaultCountry(this.getAddressCountryCode()) && !Strings.isNullOrEmpty((String)this.getZipCode())) {
            valid &= this.getZipCode().matches("\\d{4}-\\d{3}");
        }
        return valid;
    }

    public static CustomerType getDefaultCustomerType() {
        return CustomerType.findByCode("ADHOC").findFirst().orElse(null);
    }

    public static AdhocCustomer create(CustomerType customerType, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, List<FinantialInstitution> list) {
        return (AdhocCustomer)((Object)advice$create.perform((Callable)new AdhocCustomer$callable$create(customerType, string, string2, string3, string4, string5, string6, string7, string8, list)));
    }

    static /* synthetic */ AdhocCustomer advised$create(CustomerType customerType, String fiscalNumber, String name, String address, String districtSubdivision, String region, String zipCode, String addressCountryCode, String identificationNumber, List<FinantialInstitution> finantialInstitutions) {
        return new AdhocCustomer(customerType, fiscalNumber, name, address, districtSubdivision, region, zipCode, addressCountryCode, identificationNumber, finantialInstitutions);
    }

    public static Stream<AdhocCustomer> findAll() {
        return FenixFramework.getDomainRoot().getCustomersSet().stream().filter(x -> x instanceof AdhocCustomer).map(AdhocCustomer.class::cast);
    }

    public static Stream<AdhocCustomer> findByFiscalNumber(String fiscalNumber) {
        return AdhocCustomer.findAll().filter(i -> fiscalNumber.equalsIgnoreCase(i.getFiscalNumber()));
    }

    public static Stream<AdhocCustomer> findByName(String name) {
        return AdhocCustomer.findAll().filter(i -> name.equalsIgnoreCase(i.getName()));
    }

    public static Stream<AdhocCustomer> findByAddress(String address) {
        return AdhocCustomer.findAll().filter(i -> address.equalsIgnoreCase(i.getAddress()));
    }

    public static Stream<AdhocCustomer> findByDistrictSubdivision(String districtSubdivision) {
        return AdhocCustomer.findAll().filter(i -> districtSubdivision.equalsIgnoreCase(i.getDistrictSubdivision()));
    }

    public static Stream<AdhocCustomer> findByZipCode(String zipCode) {
        return AdhocCustomer.findAll().filter(i -> zipCode.equalsIgnoreCase(i.getZipCode()));
    }

    public static Stream<AdhocCustomer> findByCountryCode(String countryCode) {
        return AdhocCustomer.findAll().filter(i -> countryCode.equalsIgnoreCase(i.getAddressCountryCode()));
    }

    public static Stream<AdhocCustomer> findByCode(String code) {
        return AdhocCustomer.findAll().filter(i -> code.equalsIgnoreCase(i.getCode()));
    }
}

