/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.virtualpaymententries;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.dto.SettlementDebitEntryBean;
import org.fenixedu.treasury.dto.SettlementInterestEntryBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.services.payments.virtualpaymententries.IVirtualPaymentEntryHandler;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;

public class VirtualInterestHandler
implements IVirtualPaymentEntryHandler {
    @Override
    public List<ISettlementInvoiceEntryBean> createISettlementInvoiceEntryBean(SettlementNoteBean settlementNoteBean) {
        ArrayList<ISettlementInvoiceEntryBean> result = new ArrayList<ISettlementInvoiceEntryBean>();
        for (SettlementDebitEntryBean debitEntryBean : settlementNoteBean.getDebitEntriesByType(SettlementDebitEntryBean.class)) {
            InterestRateBean debitInterest;
            if (!debitEntryBean.isIncluded() || !TreasuryConstants.isEqual(debitEntryBean.getDebitEntry().getOpenAmount(), debitEntryBean.getSettledAmount()) || !TreasuryConstants.isPositive((debitInterest = debitEntryBean.getDebitEntry().calculateUndebitedInterestValue(settlementNoteBean.getDate())).getInterestAmount())) continue;
            SettlementInterestEntryBean interestEntryBean = new SettlementInterestEntryBean(debitEntryBean.getDebitEntry(), debitInterest);
            interestEntryBean.setVirtualPaymentEntryHandler(this);
            interestEntryBean.setIncluded(!debitEntryBean.getDebitEntry().isExportedInERPAndInRestrictedPaymentMixingLegacyInvoices());
            interestEntryBean.setCalculationDescription(this.getCalculationDescription(settlementNoteBean, interestEntryBean));
            result.add(interestEntryBean);
        }
        return result;
    }

    private Map<String, List<String>> getCalculationDescription(SettlementNoteBean settlementNoteBean, SettlementInterestEntryBean interestEntryBean) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        Currency currency = settlementNoteBean.getDebtAccount().getFinantialInstitution().getCurrency();
        String title = TreasuryConstants.treasuryBundle("label.VirtualInterestHandler.Calculated_interests", new String[0]);
        ArrayList<String> lines = new ArrayList<String>();
        for (InterestRateBean.InterestInformationDetail detail : interestEntryBean.getInterest().getInterestInformationList()) {
            lines.add(String.format("[%s - %s]: %s", detail.getBegin().toString("yyyy/MM/dd"), detail.getEnd().toString("yyyy/MM/dd"), currency.getValueFor(detail.getAmount())));
            lines.add(TreasuryConstants.treasuryBundle("label.InterestEntry.affectedAmount.description", currency.getValueFor(detail.getAffectedAmount()), "" + detail.getNumberOfDays(), detail.getInterestRate().toString()));
        }
        map.put(title, lines);
        if (!interestEntryBean.getInterest().getCreatedInterestEntriesList().isEmpty()) {
            title = TreasuryConstants.treasuryBundle("label.VirtualInterestHandler.Created_interests", new String[0]);
            lines = new ArrayList();
            for (InterestRateBean.CreatedInterestEntry entry : interestEntryBean.getInterest().getCreatedInterestEntriesList()) {
                lines.add(String.format("[%s]: %s", entry.getEntryDate().toString("yyyy/MM/dd"), currency.getValueFor(entry.getAmount())));
            }
            map.put(title, lines);
        }
        return map;
    }

    @Override
    public void execute(SettlementNoteBean settlementNoteBean, ISettlementInvoiceEntryBean invoiceEntryBean) {
        DocumentNumberSeries debitNoteSeries = DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), settlementNoteBean.getDebtAccount().getFinantialInstitution()).filter(x -> Boolean.TRUE.equals(x.getSeries().getDefaultSeries())).findFirst().orElse(null);
        if (!(invoiceEntryBean instanceof SettlementInterestEntryBean)) {
            return;
        }
        SettlementInterestEntryBean interestEntryBean = (SettlementInterestEntryBean)invoiceEntryBean;
        DebitNote interestDebitNote = DebitNote.create(settlementNoteBean.getDebtAccount(), debitNoteSeries, new DateTime());
        if (settlementNoteBean.getReferencedCustomers().size() == 1 && settlementNoteBean.getReferencedCustomers().iterator().next() != settlementNoteBean.getDebtAccount().getCustomer()) {
            Customer payorCustomer = settlementNoteBean.getReferencedCustomers().iterator().next();
            DebtAccount payorDebtAccount = payorCustomer.getDebtAccountFor(settlementNoteBean.getDebtAccount().getFinantialInstitution());
            interestDebitNote.setPayorDebtAccount(payorDebtAccount);
        }
        DebitEntry interestDebitEntry = interestEntryBean.getDebitEntry().createInterestRateDebitEntry(interestEntryBean.getInterest(), new DateTime(), Optional.ofNullable(interestDebitNote));
        SettlementDebitEntryBean settlementDebitEntryBean = new SettlementDebitEntryBean(interestDebitEntry);
        settlementDebitEntryBean.setIncluded(true);
        settlementNoteBean.getDebitEntries().add(settlementDebitEntryBean);
        interestEntryBean.setIncluded(false);
    }
}

