/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.sibspaymentsgateway;

import java.math.BigDecimal;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.sibspaymentsgateway.SibsPaymentsGatewayLog_Base;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;

public class SibsPaymentsGatewayLog
extends SibsPaymentsGatewayLog_Base {
    public static final String REQUEST_PAYMENT_CODE = "sibsMbPaymentRequest";
    public static final String MBWAY_REQUEST_PAYMENT = "mbwayPaymentRequest";
    public static final String WEBHOOK_NOTIFICATION = "WEBHOOK_NOTIFICATION";
    public static final String OCTECT_STREAM_CONTENT_TYPE = "application/octet-stream";

    public SibsPaymentsGatewayLog() {
    }

    protected SibsPaymentsGatewayLog(String operationCode) {
        this();
        this.setOperationCode(operationCode);
        this.checkRules();
    }

    protected SibsPaymentsGatewayLog(String operationCode, String sibsGatewayMerchantTransactionId) {
        this();
        this.setOperationCode(operationCode);
        this.setSibsGatewayMerchantTransactionId(sibsGatewayMerchantTransactionId);
        this.checkRules();
    }

    public SibsPaymentsGatewayLog(PaymentRequest paymentRequest, String statusCode, LocalizedString statusDescription) {
        this();
        this.setPaymentRequest(paymentRequest);
        this.setStateCode(statusCode);
        this.setStateDescription(statusDescription);
    }

    private void checkRules() {
    }

    public boolean isExceptionOccured() {
        return super.getExceptionOccured();
    }

    public boolean isOperationSuccess() {
        return super.getOperationSuccess();
    }

    public void savePaymentInfo(BigDecimal amount, DateTime paymentDate) {
        this.setAmount(amount);
        this.setPaymentDate(paymentDate);
    }

    public void savePaymentTypeAndBrand(String paymentType, String paymentBrand) {
        this.setPaymentType(paymentType);
        this.setPaymentBrand(paymentBrand);
    }

    public void markAsDuplicatedTransaction() {
        this.setSibsTransactionDuplicated(true);
    }

    public void logRequestSendDate() {
        this.setRequestSendDate(new DateTime());
    }

    public void logRequestReceiveDateAndData(String transactionId, boolean operationSuccess, boolean transactionPaid, String operationResultCode, String operationResultDescription) {
        this.setRequestReceiveDate(new DateTime());
        this.setSibsGatewayTransactionId(transactionId);
        this.setOperationSuccess(operationSuccess);
        this.setTransactionWithPayment(transactionPaid);
        this.setStatusCode(operationResultCode);
        this.setStatusMessage(operationResultDescription);
    }

    public void saveWebhookNotificationData(String notificationInitializationVector, String notificationAuthenticationTag, String notificationEncryptedPayload) {
        ITreasuryPlatformDependentServices implementation = TreasuryPlataformDependentServicesFactory.implementation();
        this.setNotificationInitializationVector(notificationInitializationVector);
        this.setNotificationAuthTag(notificationAuthenticationTag);
        if (notificationEncryptedPayload != null) {
            String notificationEncryptedPayloadFileId = implementation.createFile(String.format("sibsOnlinePaymentsGatewayLog-notificationEncryptedPayload-%s.txt", this.getExternalId()), OCTECT_STREAM_CONTENT_TYPE, notificationEncryptedPayload.getBytes());
            this.setNotificationEncryptedPayloadFileId(notificationEncryptedPayloadFileId);
        }
    }

    public void saveMerchantTransactionId(String merchantTransactionId) {
        this.setSibsGatewayMerchantTransactionId(merchantTransactionId);
    }

    public void saveTransactionId(String transactionId) {
        this.setSibsGatewayTransactionId(transactionId);
    }

    public void saveReferenceId(String referenceId) {
        this.setSibsGatewayReferenceId(referenceId);
    }

    public static Stream<SibsPaymentsGatewayLog> findAll() {
        return PaymentRequestLog.findAll().filter(p -> p instanceof SibsPaymentsGatewayLog).map(SibsPaymentsGatewayLog.class::cast);
    }

    public static SibsPaymentsGatewayLog createForSibsPaymentRequest(String sibsGatewayMerchantTransactionId) {
        SibsPaymentsGatewayLog log = new SibsPaymentsGatewayLog(REQUEST_PAYMENT_CODE, sibsGatewayMerchantTransactionId);
        log.setStateCode(PaymentReferenceCodeStateType.UNUSED.getCode());
        log.setStateDescription(PaymentReferenceCodeStateType.UNUSED.getDescriptionI18N());
        return log;
    }

    public static SibsPaymentsGatewayLog createForMbwayPaymentRequest(String sibsGatewayMerchantTransactionId) {
        SibsPaymentsGatewayLog log = new SibsPaymentsGatewayLog(MBWAY_REQUEST_PAYMENT, sibsGatewayMerchantTransactionId);
        log.setStateCode(PaymentReferenceCodeStateType.UNUSED.getCode());
        log.setStateDescription(PaymentReferenceCodeStateType.UNUSED.getDescriptionI18N());
        return log;
    }

    public static SibsPaymentsGatewayLog createLogForWebhookNotification() {
        return new SibsPaymentsGatewayLog(WEBHOOK_NOTIFICATION);
    }

    public static SibsPaymentsGatewayLog create(PaymentRequest paymentRequest, String sibsGatewayMerchantTransactionId) {
        SibsPaymentsGatewayLog log = new SibsPaymentsGatewayLog();
        log.setPaymentRequest(paymentRequest);
        log.setSibsGatewayMerchantTransactionId(sibsGatewayMerchantTransactionId);
        return log;
    }

    public static SibsPaymentsGatewayLog createPaymentRequestLog(PaymentRequest paymentRequest, String statusCode, LocalizedString statusDescription) {
        return new SibsPaymentsGatewayLog(paymentRequest, statusCode, statusDescription);
    }
}

