/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry_Base;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentCodeTransaction;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest$callable$processPayment;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest_Base;
import org.fenixedu.treasury.domain.paymentcodes.SibsReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile;
import org.fenixedu.treasury.domain.paymentcodes.integration.SibsPaymentCodePool;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentTransaction;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsPaymentRequest
extends SibsPaymentRequest_Base {
    public static final Advice advice$processPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public SibsPaymentRequest() {
    }

    protected SibsPaymentRequest(SibsReferenceCode sibsReferenceCode, DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, BigDecimal payableAmount) {
        this();
        if (sibsReferenceCode.getSibsPaymentRequest() != null) {
            throw new TreasuryDomainException("error.SibsPaymentRequest.sibsReferenceCode.not.free", new String[0]);
        }
        this.init((DigitalPaymentPlatform)((Object)sibsReferenceCode.getDigitalPaymentPlatform()), debtAccount, debitEntries, installments, payableAmount, TreasurySettings.getInstance().getMbPaymentMethod());
        this.setEntityReferenceCode(sibsReferenceCode.getEntityReferenceCode());
        this.setReferenceCode(sibsReferenceCode.getReferenceCode());
        this.setSibsReferenceCode(sibsReferenceCode);
        this.setState(PaymentReferenceCodeStateType.USED);
        this.checkRules();
    }

    public SibsPaymentRequest(DigitalPaymentPlatform platform, DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, String entityCode, String referenceCode, BigDecimal payableAmount, String merchantTransactionId, String sibsReferenceId) {
        this();
        this.init(platform, debtAccount, debitEntries, installments, payableAmount, TreasurySettings.getInstance().getMbPaymentMethod());
        this.setEntityReferenceCode(entityCode);
        this.setReferenceCode(referenceCode);
        this.setMerchantTransactionId(merchantTransactionId);
        this.setTransactionId(sibsReferenceId);
        this.setState(PaymentReferenceCodeStateType.USED);
        if (StringUtils.isEmpty((String)this.getMerchantTransactionId())) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.sibsMerchantTransaction.required", new String[0]);
        }
        this.checkRules();
    }

    public void checkRules() {
        super.checkRules();
        if (!this.getDigitalPaymentPlatform().isSibsPaymentCodeServiceSupported()) {
            throw new TreasuryDomainException("error.SibsPaymentRequest.digitalPaymentPlatform.not.supports.sibs.service", new String[0]);
        }
        if (this.getDigitalPaymentPlatform() instanceof SibsPaymentCodePool && this.getSibsReferenceCode() == null) {
            throw new TreasuryDomainException("error.SibsPaymentRequest.sibsReferenceCode.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getEntityReferenceCode())) {
            throw new TreasuryDomainException("error.SibsPaymentRequest.entityReferenceCode.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getReferenceCode())) {
            throw new TreasuryDomainException("error.SibsPaymentRequest.referenceCode.required", new String[0]);
        }
        if (SibsPaymentRequest.find(this.getEntityReferenceCode(), this.getReferenceCode()).count() > 1L) {
            throw new TreasuryDomainException("error.SibsPaymentRequest.request.already.exists.for.entityCode.and.referenceCode", new String[0]);
        }
    }

    public void setSibsReferenceCode(SibsReferenceCode sibsReferenceCode) {
        if (sibsReferenceCode.getSibsPaymentRequest() != null && sibsReferenceCode.getSibsPaymentRequest() != this) {
            throw new TreasuryDomainException("error.SibsPaymentRequest.sibsReferenceCode.associated.to.other.sibsPaymentRequest", new String[0]);
        }
        super.setSibsReferenceCode(sibsReferenceCode);
    }

    public PaymentReferenceCodeStateType getCurrentState() {
        return super.getState();
    }

    public boolean isInCreatedState() {
        return false;
    }

    public boolean isInRequestedState() {
        return this.getState() == PaymentReferenceCodeStateType.USED;
    }

    public boolean isInPaidState() {
        return this.getState() == PaymentReferenceCodeStateType.PROCESSED;
    }

    public boolean isInAnnuledState() {
        return this.getState() == PaymentReferenceCodeStateType.ANNULLED;
    }

    public void anull() {
        this.setState(PaymentReferenceCodeStateType.ANNULLED);
    }

    public String getDescription() {
        List descriptions = this.getOrderedDebitEntries().stream().map(FinantialDocumentEntry_Base::getDescription).collect(Collectors.toList());
        descriptions.addAll(this.getOrderedInstallments().stream().map(i -> i.getDescription().getContent()).collect(Collectors.toList()));
        return String.join((CharSequence)"\n", descriptions);
    }

    public String getFormattedCode() {
        StringBuilder result = new StringBuilder();
        int i = 1;
        for (char character : this.getReferenceCode().toCharArray()) {
            result.append(character);
            if (i % 3 == 0) {
                result.append(" ");
            }
            ++i;
        }
        return result.charAt(result.length() - 1) == ' ' ? result.deleteCharAt(result.length() - 1).toString() : result.toString();
    }

    public PaymentTransaction processPayment(BigDecimal bigDecimal, DateTime dateTime, String string, String string2, String string3, DateTime dateTime2, SibsReportFile sibsReportFile, boolean bl) {
        return (PaymentTransaction)((Object)advice$processPayment.perform((Callable)new SibsPaymentRequest$callable$processPayment(this, bigDecimal, dateTime, string, string2, string3, dateTime2, sibsReportFile, bl)));
    }

    static /* synthetic */ PaymentTransaction advised$processPayment(SibsPaymentRequest this_, BigDecimal paidAmount, DateTime paymentDate, String sibsTransactionId, String sibsImportationFilename, String sibsMerchantTransactionId, DateTime whenProcessedBySibs, SibsReportFile sibsReportFile, boolean checkSibsTransactionIdDuplication) {
        if (SibsPaymentCodeTransaction.isReferenceProcessingDuplicate(this_.getEntityReferenceCode(), this_.getReferenceCode(), paymentDate)) {
            return null;
        }
        if (checkSibsTransactionIdDuplication && SibsPaymentCodeTransaction.isSibsGatewayReferenceProcessingDuplicate(sibsTransactionId)) {
            throw new RuntimeException("Duplicate transaction id: " + sibsTransactionId);
        }
        if (this_.getState() == PaymentReferenceCodeStateType.UNUSED || this_.getState() == PaymentReferenceCodeStateType.USED) {
            this_.setState(PaymentReferenceCodeStateType.PROCESSED);
        }
        HashSet<SettlementNote> noteSet = new HashSet<SettlementNote>();
        SibsPaymentCodeTransaction transaction = SibsPaymentCodeTransaction.create(sibsReportFile, this_, paymentDate, paidAmount, sibsTransactionId, whenProcessedBySibs, noteSet);
        Function<PaymentRequest, Map> additionalPropertiesMapFunction = o -> this.fillPaymentEntryPropertiesMap(sibsTransactionId);
        if (!TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices()) {
            noteSet.addAll(this_.internalProcessPaymentInNormalPaymentMixingLegacyInvoices(paidAmount, paymentDate, sibsTransactionId, sibsImportationFilename, additionalPropertiesMapFunction));
        } else {
            noteSet.addAll(this_.internalProcessPaymentInRestrictedPaymentMixingLegacyInvoices(paidAmount, paymentDate, sibsTransactionId, sibsImportationFilename, additionalPropertiesMapFunction));
        }
        for (SettlementNote settlementNote : noteSet) {
            String observations = "";
            if (!StringUtils.isEmpty((String)sibsMerchantTransactionId)) {
                observations = sibsMerchantTransactionId;
            } else if (!StringUtils.isEmpty((String)sibsImportationFilename)) {
                observations = String.format("%s [%s]", sibsImportationFilename, this_.getReferenceCode());
            }
            settlementNote.setDocumentObservations(observations);
            if (settlementNote.getAdvancedPaymentCreditNote() == null) continue;
            settlementNote.getAdvancedPaymentCreditNote().setDocumentObservations(observations);
        }
        transaction.getSettlementNotesSet().addAll(noteSet);
        return transaction;
    }

    public String fillPaymentEntryMethodId() {
        return String.format("COB PAG SERV %s", this.getEntityReferenceCode());
    }

    private Map<String, String> fillPaymentEntryPropertiesMap(String sibsTransactionId) {
        HashMap<String, String> paymentEntryPropertiesMap = new HashMap<String, String>();
        paymentEntryPropertiesMap.put("ReferenceCode", this.getReferenceCode());
        paymentEntryPropertiesMap.put("EntityReferenceCode", this.getEntityReferenceCode());
        if (!Strings.isNullOrEmpty((String)sibsTransactionId)) {
            paymentEntryPropertiesMap.put("SibsTransactionId", sibsTransactionId);
        }
        return paymentEntryPropertiesMap;
    }

    public static Stream<SibsPaymentRequest> findAll() {
        return PaymentRequest.findAll().filter(p -> p instanceof SibsPaymentRequest).map(SibsPaymentRequest.class::cast);
    }

    public static Stream<SibsPaymentRequest> find(String entityReferenceCode, String referenceCode) {
        return SibsPaymentRequest.findAll().filter(p -> entityReferenceCode.equals(p.getEntityReferenceCode())).filter(p -> referenceCode.equals(p.getReferenceCode()));
    }

    public static Stream<SibsPaymentRequest> findBySibsGatewayMerchantTransactionId(String sibsGatewayMerchantTransactionId) {
        return PaymentRequest.findBySibsGatewayMerchantTransactionId(sibsGatewayMerchantTransactionId).filter(p -> p instanceof SibsPaymentRequest).map(SibsPaymentRequest.class::cast);
    }

    public static Stream<SibsPaymentRequest> findBySibsGatewayTransactionId(String sibsGatewayTransactionId) {
        return PaymentRequest.findBySibsGatewayTransactionId(sibsGatewayTransactionId).filter(p -> p instanceof SibsPaymentRequest).map(SibsPaymentRequest.class::cast);
    }

    public static Optional<SibsPaymentRequest> findUniqueBySibsGatewayTransactionId(String sibsGatewayTransactionId) {
        return SibsPaymentRequest.findBySibsGatewayTransactionId(sibsGatewayTransactionId).findAny();
    }

    public static Stream<SibsPaymentRequest> find(DebitEntry debitEntry) {
        return debitEntry.getPaymentRequestsSet().stream().filter(r -> r instanceof SibsPaymentRequest).map(SibsPaymentRequest.class::cast);
    }

    public static Stream<SibsPaymentRequest> find(Installment installment) {
        return installment.getPaymentRequestsSet().stream().filter(r -> r instanceof SibsPaymentRequest).map(SibsPaymentRequest.class::cast);
    }

    public static Stream<SibsPaymentRequest> findWithDebitEntries(Set<DebitEntry> debitEntries) {
        Set paymentCodes = debitEntries.stream().flatMap(d -> SibsPaymentRequest.find(d)).collect(Collectors.toSet());
        HashSet result = Sets.newHashSet();
        for (SibsPaymentRequest code : paymentCodes) {
            if (!Sets.symmetricDifference((Set)code.getDebitEntriesSet(), debitEntries).isEmpty()) continue;
            result.add(code);
        }
        return result.stream();
    }

    public static Stream<SibsPaymentRequest> findCreatedByDebitEntry(DebitEntry debitEntry) {
        return SibsPaymentRequest.find(debitEntry).filter(p -> p.isInCreatedState());
    }

    public static Stream<SibsPaymentRequest> findRequestedByDebitEntry(DebitEntry debitEntry) {
        return SibsPaymentRequest.find(debitEntry).filter(p -> p.isInRequestedState());
    }

    public static Stream<SibsPaymentRequest> findCreatedByInstallment(Installment installment) {
        return SibsPaymentRequest.find(installment).filter(p -> p.isInCreatedState());
    }

    public static Stream<SibsPaymentRequest> findRequestedByInstallment(Installment installment) {
        return SibsPaymentRequest.find(installment).filter(p -> p.isInRequestedState());
    }

    public static Stream<SibsPaymentRequest> findCreatedByDebitEntriesSet(Set<DebitEntry> debitEntries) {
        return SibsPaymentRequest.findWithDebitEntries(debitEntries).filter(p -> p.isInCreatedState());
    }

    public static Stream<SibsPaymentRequest> findRequestedByDebitEntriesSet(Set<DebitEntry> debitEntries) {
        return SibsPaymentRequest.findWithDebitEntries(debitEntries).filter(p -> p.isInRequestedState());
    }

    public static SibsPaymentRequest create(SibsReferenceCode sibsReferenceCode, DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, BigDecimal payableAmount) {
        return new SibsPaymentRequest(sibsReferenceCode, debtAccount, debitEntries, installments, payableAmount);
    }

    public static SibsPaymentRequest create(DigitalPaymentPlatform platform, DebtAccount debtAccount, Set<DebitEntry> debitEntries, Set<Installment> installments, BigDecimal payableAmount, String entityCode, String referenceCode, String merchantTransactionId, String sibsReferenceId) {
        return new SibsPaymentRequest(platform, debtAccount, debitEntries, installments, entityCode, referenceCode, payableAmount, merchantTransactionId, sibsReferenceId);
    }
}

