/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.IPaymentProcessorForInvoiceEntries;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentEntry;
import org.fenixedu.treasury.domain.paymentPlan.Installment_Base;
import org.fenixedu.treasury.domain.paymentcodes.FinantialDocumentPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode$callable$create;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode_Base;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Deprecated
public class MultipleEntriesPaymentCode
extends MultipleEntriesPaymentCode_Base {
    public static final int MAX_PAYMENT_CODES_FOR_DEBIT_ENTRY = 2;
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public MultipleEntriesPaymentCode() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected MultipleEntriesPaymentCode(Set<DebitEntry> debitNoteEntries, Set<Installment> installments, PaymentReferenceCode paymentReferenceCode, boolean valid) {
        this();
        this.init(debitNoteEntries, installments, paymentReferenceCode, valid);
    }

    protected void init(Set<DebitEntry> debitNoteEntries, Set<Installment> installments, PaymentReferenceCode paymentReferenceCode, boolean valid) {
        this.getInvoiceEntriesSet().addAll(debitNoteEntries);
        this.getInstallmentsSet().addAll(installments);
        DebtAccount debtAccount = null;
        if (!debitNoteEntries.isEmpty()) {
            debtAccount = debitNoteEntries.iterator().next().getDebtAccount();
        }
        if (!installments.isEmpty() && debtAccount == null) {
            debtAccount = installments.iterator().next().getPaymentPlan().getDebtAccount();
        }
        this.setDebtAccount(debtAccount);
        this.setPaymentReferenceCode(paymentReferenceCode);
        this.setValid(valid);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getPaymentReferenceCode() == null) {
            throw new TreasuryDomainException("error.MultipleEntriesPaymentCode.paymentReferenceCode.required", new String[0]);
        }
        if (this.getInvoiceEntriesSet().isEmpty() && this.getInstallmentsSet().isEmpty()) {
            throw new TreasuryDomainException("error.MultipleEntriesPaymentCode.debitEntries.and.installments.empty", new String[0]);
        }
        DebtAccount debtAccount = this.getDebtAccount();
        for (InvoiceEntry invoiceEntry : this.getInvoiceEntriesSet()) {
            DebitEntry debitEntry = (DebitEntry)((Object)invoiceEntry);
            if (debitEntry.getDebtAccount() != debtAccount) {
                throw new TreasuryDomainException("error.MultipleEntriesPaymentCode.debit.entry.not.same.debt.account", new String[0]);
            }
            if (!TreasuryConstants.isGreaterThan(debitEntry.getOpenAmount(), BigDecimal.ZERO)) {
                throw new TreasuryDomainException("error.MultipleEntriesPaymentCode.debit.entry.open.amount.must.be.greater.than.zero", new String[0]);
            }
            boolean hasFinantialDocumentPaymentCode = debitEntry.getFinantialDocument() != null && FinantialDocumentPaymentCode.findNewByFinantialDocument(debitEntry.getFinantialDocument()).count() > 0L;
            if (hasFinantialDocumentPaymentCode |= debitEntry.getFinantialDocument() != null && FinantialDocumentPaymentCode.findUsedByFinantialDocument(debitEntry.getFinantialDocument()).count() > 0L) {
                throw new TreasuryDomainException("error.MultipleEntriesPaymentCode.debit.entry.finantial.with.active.payment.code", debitEntry.getFinantialDocument().getUiDocumentNumber());
            }
            long activePaymentCodesOnDebitEntryCount = MultipleEntriesPaymentCode.findNewByDebitEntry(debitEntry).count() + MultipleEntriesPaymentCode.findUsedByDebitEntry(debitEntry).count();
            if (activePaymentCodesOnDebitEntryCount <= 2L) continue;
            throw new TreasuryDomainException("error.MultipleEntriesPaymentCode.debit.entry.with.active.payment.code", debitEntry.getDescription());
        }
        if (this.getReferencedCustomers().size() > 1) {
            throw new TreasuryDomainException("error.MultipleEntriesPaymentCode.referencedCustomers.only.one.allowed", new String[0]);
        }
        SettlementNote.checkMixingOfInvoiceEntriesExportedInLegacyERP(this.getInvoiceEntriesSet());
    }

    public boolean isMultipleEntriesPaymentCode() {
        return true;
    }

    public DocumentNumberSeries getDocumentSeriesForPayments() {
        return this.getPaymentReferenceCode().getPaymentCodePool().getDocumentSeriesForPayments();
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        for (FinantialDocumentEntry finantialDocumentEntry : this.getOrderedInvoiceEntries()) {
            builder.append(finantialDocumentEntry.getDescription()).append("\n");
        }
        for (Installment installment : this.getInstallmentsSet().stream().sorted(Installment.COMPARE_BY_DUEDATE).collect(Collectors.toList())) {
            builder.append(installment.getDescription().getContent()).append(":\n");
            for (InstallmentEntry installmentEntry : installment.getInstallmentEntriesSet()) {
                builder.append("-" + installmentEntry.getDebitEntry().getDescription()).append("\n");
            }
        }
        return builder.toString().trim();
    }

    public Set<SettlementNote> processPayment(String username, BigDecimal amountToPay, DateTime whenRegistered, String sibsTransactionId, String comments) {
        return this.internalProcessPayment(username, amountToPay, whenRegistered, sibsTransactionId, comments, this.getInvoiceEntriesSet(), this.getInstallmentsSet());
    }

    public Set<Customer> getReferencedCustomers() {
        return IPaymentProcessorForInvoiceEntries.getReferencedCustomers(this.getInvoiceEntriesSet(), this.getInstallmentsSet());
    }

    public TreeSet<DebitEntry> getOrderedInvoiceEntries() {
        TreeSet<DebitEntry> result = new TreeSet<DebitEntry>(DebitEntry.COMPARE_BY_EXTERNAL_ID);
        result.addAll(this.getInvoiceEntriesSet().stream().map(DebitEntry.class::cast).collect(Collectors.toSet()));
        return result;
    }

    public DocumentNumberSeries getDocumentSeriesInterestDebits() {
        return DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), this.getPaymentReferenceCode().getPaymentCodePool().getDocumentSeriesForPayments().getSeries());
    }

    public boolean isPaymentCodeFor(TreasuryEvent event) {
        Set invoiceEntriesSet = this.getInvoiceEntriesSet();
        invoiceEntriesSet.addAll(this.getInstallmentsSet().stream().flatMap(i -> i.getInstallmentEntriesSet().stream().map(e -> e.getDebitEntry())).collect(Collectors.toSet()));
        return invoiceEntriesSet.stream().map(DebitEntry.class::cast).anyMatch(x -> x.getTreasuryEvent() != null && x.getTreasuryEvent().equals((Object)event));
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new MultipleEntriesPaymentCode$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(MultipleEntriesPaymentCode this_) {
        TreasuryDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.MultipleEntriesPaymentCode.cannot.delete", new String[0]);
        }
        this_.deleteDomainObject();
    }

    private boolean isDeletable() {
        return false;
    }

    public LocalDate getDueDate() {
        Set map = this.getInvoiceEntriesSet().stream().map(InvoiceEntry::getDueDate).collect(Collectors.toSet());
        map.addAll(this.getInstallmentsSet().stream().map(Installment_Base::getDueDate).collect(Collectors.toSet()));
        return map.stream().sorted().findFirst().orElse(null);
    }

    public static MultipleEntriesPaymentCode create(Set<DebitEntry> set, Set<Installment> set2, PaymentReferenceCode paymentReferenceCode, boolean bl) {
        return (MultipleEntriesPaymentCode)((Object)advice$create.perform((Callable)new MultipleEntriesPaymentCode$callable$create(set, set2, paymentReferenceCode, bl)));
    }

    static /* synthetic */ MultipleEntriesPaymentCode advised$create(Set<DebitEntry> debitNoteEntries, Set<Installment> installments, PaymentReferenceCode paymentReferenceCode, boolean valid) {
        return new MultipleEntriesPaymentCode(debitNoteEntries, installments, paymentReferenceCode, valid);
    }

    public Set<Product> getReferencedProducts() {
        Set invoiceEntriesSet = this.getInvoiceEntriesSet();
        invoiceEntriesSet.addAll(this.getInstallmentsSet().stream().flatMap(i -> i.getInstallmentEntriesSet().stream().map(e -> e.getDebitEntry())).collect(Collectors.toSet()));
        return invoiceEntriesSet.stream().map(d -> d.getProduct()).collect(Collectors.toSet());
    }

    public static Stream<MultipleEntriesPaymentCode> findAll() {
        HashSet entries = new HashSet();
        for (FinantialInstitution finantialInstitution : FinantialInstitution.findAll().collect(Collectors.toSet())) {
            MultipleEntriesPaymentCode.findAll(finantialInstitution).collect(Collectors.toCollection(() -> entries));
        }
        return entries.stream();
    }

    public static Stream<MultipleEntriesPaymentCode> findAll(FinantialInstitution finantialInstitution) {
        HashSet<MultipleEntriesPaymentCode> entries = new HashSet<MultipleEntriesPaymentCode>();
        for (PaymentCodePool pool : finantialInstitution.getPaymentCodePoolsSet()) {
            for (PaymentReferenceCode code : pool.getPaymentReferenceCodesSet()) {
                if (code.getTargetPayment() == null || !(code.getTargetPayment() instanceof MultipleEntriesPaymentCode)) continue;
                entries.add((MultipleEntriesPaymentCode)((Object)code.getTargetPayment()));
            }
        }
        return entries.stream();
    }

    public static Stream<MultipleEntriesPaymentCode> find(DebitEntry debitEntry) {
        return debitEntry.getPaymentCodesSet().stream();
    }

    public static Stream<MultipleEntriesPaymentCode> findWithDebitEntries(Set<DebitEntry> debitEntries) {
        Set paymentCodes = debitEntries.stream().map(d -> d.getPaymentCodesSet()).flatMap(p -> p.stream()).collect(Collectors.toSet());
        HashSet result = Sets.newHashSet();
        for (MultipleEntriesPaymentCode code : paymentCodes) {
            if (!Sets.symmetricDifference((Set)code.getInvoiceEntriesSet(), debitEntries).isEmpty()) continue;
            result.add(code);
        }
        return result.stream();
    }

    public static Stream<MultipleEntriesPaymentCode> findByValid(FinantialInstitution finantialInstitution, boolean valid) {
        return MultipleEntriesPaymentCode.findAll(finantialInstitution).filter(i -> valid == i.getValid());
    }

    public static Stream<MultipleEntriesPaymentCode> findNewByDebitEntry(DebitEntry debitEntry) {
        return MultipleEntriesPaymentCode.find(debitEntry).filter(p -> p.getPaymentReferenceCode().isNew());
    }

    public static Stream<MultipleEntriesPaymentCode> findUsedByDebitEntry(DebitEntry debitEntry) {
        return MultipleEntriesPaymentCode.find(debitEntry).filter(p -> p.getPaymentReferenceCode().isUsed());
    }

    public static Stream<MultipleEntriesPaymentCode> findNewByDebitEntriesSet(Set<DebitEntry> debitEntries) {
        return MultipleEntriesPaymentCode.findWithDebitEntries(debitEntries).filter(p -> p.getPaymentReferenceCode().isNew());
    }

    public static Stream<MultipleEntriesPaymentCode> findUsedByDebitEntriesSet(Set<DebitEntry> debitEntries) {
        return MultipleEntriesPaymentCode.findWithDebitEntries(debitEntries).filter(p -> p.getPaymentReferenceCode().isUsed());
    }

    public static Stream<MultipleEntriesPaymentCode> findNewByInstallment(Installment installment) {
        return MultipleEntriesPaymentCode.findByInstallment(installment).filter(p -> p.getPaymentReferenceCode().isNew());
    }

    public static Stream<MultipleEntriesPaymentCode> findUsedByInstallment(Installment installment) {
        return MultipleEntriesPaymentCode.findByInstallment(installment).filter(p -> p.getPaymentReferenceCode().isUsed());
    }

    public static Stream<MultipleEntriesPaymentCode> findByInstallment(Installment installment) {
        return installment.getPaymentCodesSet().stream();
    }

    public static Stream<MultipleEntriesPaymentCode> findNewByInstallmentsSet(Set<Installment> installments) {
        return MultipleEntriesPaymentCode.findWithInstallment(installments).filter(p -> p.getPaymentReferenceCode().isNew());
    }

    public static Stream<MultipleEntriesPaymentCode> findUsedByInstallmentsSet(Set<Installment> installments) {
        return MultipleEntriesPaymentCode.findWithInstallment(installments).filter(p -> p.getPaymentReferenceCode().isUsed());
    }

    public static Stream<MultipleEntriesPaymentCode> findWithInstallment(Set<Installment> installments) {
        Set paymentCodes = installments.stream().map(d -> d.getPaymentCodesSet()).flatMap(p -> p.stream()).collect(Collectors.toSet());
        HashSet result = Sets.newHashSet();
        for (MultipleEntriesPaymentCode code : paymentCodes) {
            if (!Sets.symmetricDifference((Set)code.getInstallmentsSet(), installments).isEmpty()) continue;
            result.add(code);
        }
        return result.stream();
    }
}

