/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentPlan;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.concurrent.Callable;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentPlan.Installment;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentEntry$callable$create;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentEntry$callable$delete;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentEntry_Base;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class InstallmentEntry
extends InstallmentEntry_Base {
    public static final Comparator<? super InstallmentEntry> COMPARE_BY_DEBIT_ENTRY_COMPARATOR;
    public static final Advice advice$create;
    public static final Advice advice$delete;

    public InstallmentEntry() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    private InstallmentEntry(DebitEntry debitEntry, BigDecimal debitAmount, Installment installment) {
        this();
        this.setDebitEntry(debitEntry);
        this.setAmount(debitAmount);
        this.setInstallment(installment);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDebitEntry() == null) {
            throw new TreasuryDomainException("error.InstallmentEntry.debitEntry.required", new String[0]);
        }
        if (this.getAmount() == null || !TreasuryConstants.isPositive(this.getAmount())) {
            throw new TreasuryDomainException("error.InstallmentEntry.getAmount.must.be.positive", new String[0]);
        }
        if (this.getInstallment() == null) {
            throw new TreasuryDomainException("error.InstallmentEntry.installment.required", new String[0]);
        }
    }

    public static InstallmentEntry create(DebitEntry debitEntry, BigDecimal bigDecimal, Installment installment) {
        return (InstallmentEntry)((Object)advice$create.perform((Callable)new InstallmentEntry$callable$create(debitEntry, bigDecimal, installment)));
    }

    static /* synthetic */ InstallmentEntry advised$create(DebitEntry debitEntry, BigDecimal debitAmount, Installment installment) {
        return new InstallmentEntry(debitEntry, debitAmount, installment);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new InstallmentEntry$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(InstallmentEntry this_) {
        this_.setDomainRoot(null);
        this_.setDebitEntry(null);
        this_.deleteDomainObject();
    }

    public BigDecimal getPaidAmount() {
        return this.getInstallmentSettlementEntriesSet().stream().filter(i -> !i.getSettlementEntry().getSettlementNote().isAnnulled()).map(i -> i.getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getOpenAmount() {
        this.getCurrency();
        return Currency.getValueWithScale(this.getAmount().subtract(this.getPaidAmount()));
    }

    private Currency getCurrency() {
        return this.getDebitEntry().getCurrency();
    }

    public boolean isPaid() {
        return TreasuryConstants.isZero(this.getOpenAmount());
    }

    static {
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_DEBIT_ENTRY_COMPARATOR = (m1, m2) -> m1.getInstallment().getDueDate().compareTo((ReadablePartial)m2.getInstallment().getDueDate()) * 100 + DebitEntry.COMPARE_DEBIT_ENTRY_IN_SAME_PAYMENT_PLAN.compare(m1.getDebitEntry(), m2.getDebitEntry()) * 10 + m1.getExternalId().compareTo(m2.getExternalId());
    }
}

