/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.meowallet;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.concurrent.Callable;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.meowallet.MeoWalletLog$callable$createForTransationReport;
import org.fenixedu.treasury.domain.meowallet.MeoWalletLog$callable$delete;
import org.fenixedu.treasury.domain.meowallet.MeoWalletLog_Base;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MeoWalletLog
extends MeoWalletLog_Base {
    public static final String REQUEST_PAYMENT_CODE = "mbPaymentRequest";
    public static final String MBWAY_REQUEST_PAYMENT = "mbwayPaymentRequest";
    public static final String WEBHOOK_NOTIFICATION = "WEBHOOK_NOTIFICATION";
    public static final String REQUEST_TRANSACTION_REPORT = "paymentStatus";
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createForTransationReport = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public MeoWalletLog() {
    }

    protected MeoWalletLog(String operationCode, String extInvoiceId, String extCustomerId) {
        this();
        this.setOperationCode(operationCode);
        this.setExtInvoiceId(extInvoiceId);
        this.setExtCustomerId(extCustomerId);
        this.checkRules();
    }

    public MeoWalletLog(PaymentRequest paymentRequest, String statusCode, LocalizedString stateDescription) {
        this();
        this.setPaymentRequest(paymentRequest);
        this.setStatusCode(statusCode);
        this.setStateDescription(stateDescription);
    }

    private void checkRules() {
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new MeoWalletLog$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(MeoWalletLog this_) {
        super.deleteDomainObject();
    }

    public static MeoWalletLog createForMbwayPaymentRequest(String extInvoiceId, String extCustomerId) {
        MeoWalletLog log = new MeoWalletLog(MBWAY_REQUEST_PAYMENT, extInvoiceId, extCustomerId);
        log.setStateCode(PaymentReferenceCodeStateType.UNUSED.getCode());
        log.setStateDescription(PaymentReferenceCodeStateType.UNUSED.getDescriptionI18N());
        return log;
    }

    public static MeoWalletLog createForSibsPaymentRequest(String extInvoiceId, String extCustomerId) {
        MeoWalletLog log = new MeoWalletLog(REQUEST_PAYMENT_CODE, extInvoiceId, extCustomerId);
        log.setStateCode(PaymentReferenceCodeStateType.UNUSED.getCode());
        log.setStateDescription(PaymentReferenceCodeStateType.UNUSED.getDescriptionI18N());
        return log;
    }

    public static MeoWalletLog createLogForWebhookNotification() {
        MeoWalletLog log = new MeoWalletLog(WEBHOOK_NOTIFICATION, "", "");
        log.setResponsibleUsername(WEBHOOK_NOTIFICATION);
        return log;
    }

    public void logRequestSendDate() {
        this.setRequestSendDate(new DateTime());
    }

    public void logRequestReceiveDateAndData(String id, String type, String method, BigDecimal amount, String status, boolean operationSucess) {
        this.setRequestReceiveDate(new DateTime());
        this.setMeoWalletId(id);
        this.setPaymentType(type);
        this.setPaymentMethod(method);
        this.setAmount(amount);
        this.setStatusCode(status);
        this.setOperationSuccess(operationSucess);
    }

    public void savePaymentInfo(BigDecimal paidAmount, DateTime paymentDate) {
        this.setPaymentDate(paymentDate);
        this.setAmount(paidAmount);
    }

    public void markAsDuplicatedTransaction() {
        this.setTransactionDuplicated(true);
    }

    public static MeoWalletLog createPaymentRequestLog(PaymentRequest paymentRequest, String code, LocalizedString localizedName) {
        return new MeoWalletLog(paymentRequest, code, localizedName);
    }

    public static MeoWalletLog createForTransationReport(String string) {
        return (MeoWalletLog)((Object)advice$createForTransationReport.perform((Callable)new MeoWalletLog$callable$createForTransationReport(string)));
    }

    static /* synthetic */ MeoWalletLog advised$createForTransationReport(String merchantTransationId) {
        return new MeoWalletLog(REQUEST_TRANSACTION_REPORT, merchantTransationId, null);
    }
}

