/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.integration;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPConfiguration$callable$create;
import org.fenixedu.treasury.domain.integration.ERPConfiguration$callable$delete;
import org.fenixedu.treasury.domain.integration.ERPConfiguration$callable$edit;
import org.fenixedu.treasury.domain.integration.ERPConfiguration_Base;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.integration.erp.IERPExternalService;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ERPConfiguration
extends ERPConfiguration_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected ERPConfiguration() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected void init(Series paymentsIntegrationSeries, FinantialInstitution finantialInstitution, String code, String externalURL, String username, String password, String implementationClassName, Long maxSizeBytesToExportOnline) {
        this.setActive(false);
        this.setPaymentsIntegrationSeries(paymentsIntegrationSeries);
        this.setFinantialInstitution(finantialInstitution);
        this.setCode(code);
        this.setExternalURL(externalURL);
        this.setUsername(username);
        this.setPassword(password);
        this.setExportAnnulledRelatedDocuments(false);
        this.setExportOnlyRelatedDocumentsPerExport(false);
        this.setImplementationClassName(implementationClassName);
        this.setMaxSizeBytesToExportOnline(maxSizeBytesToExportOnline);
        this.setCreditsOfLegacyDebitWithoutLegacyInvoiceExportEnabled(false);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.ERPConfiguration.domainRoot.required", new String[0]);
        }
        if (Boolean.TRUE.equals(this.getActive()) && this.getPaymentsIntegrationSeries() == null) {
            throw new TreasuryDomainException("error.ERPConfiguration.paymentsIntegrationSeries.required", new String[0]);
        }
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.ERPConfiguration.finantialInstitution.required", new String[0]);
        }
    }

    public void edit(boolean bl, Series series, String string, String string2, String string3, boolean bl2, boolean bl3, String string4, Long l, String string5) {
        Object object = advice$edit.perform((Callable)new ERPConfiguration$callable$edit(this, bl, series, string, string2, string3, bl2, bl3, string4, l, string5));
    }

    static /* synthetic */ void advised$edit(ERPConfiguration this_, boolean active, Series paymentsIntegrationSeries, String externalURL, String username, String password, boolean exportAnnulledRelatedDocuments, boolean exportOnlyRelatedDocumentsPerExport, String implementationClassName, Long maxSizeBytesToExportOnline, String erpIdProcess) {
        this_.setActive(active);
        this_.setPaymentsIntegrationSeries(paymentsIntegrationSeries);
        this_.setExternalURL(externalURL);
        this_.setUsername(username);
        this_.setPassword(password);
        this_.setExportAnnulledRelatedDocuments(exportAnnulledRelatedDocuments);
        this_.setExportOnlyRelatedDocumentsPerExport(exportOnlyRelatedDocumentsPerExport);
        this_.setImplementationClassName(implementationClassName);
        this_.setMaxSizeBytesToExportOnline(maxSizeBytesToExportOnline);
        this_.setErpIdProcess(erpIdProcess);
        this_.checkRules();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public boolean isDeletable() {
        return true;
    }

    public boolean isIntegratedDocumentsExportationEnabled() {
        return this.getIntegratedDocumentsExportationEnabled();
    }

    public boolean isCreditsOfLegacyDebitWithoutLegacyInvoiceExportEnabled() {
        return this.getCreditsOfLegacyDebitWithoutLegacyInvoiceExportEnabled();
    }

    public boolean isAllowFiscalFixWithLegacyDocsExportedLegacyERP() {
        return this.getAllowFiscalFixWithLegacyDocsExportedLegacyERP();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new ERPConfiguration$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(ERPConfiguration this_) {
        TreasuryDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.ERPConfiguration.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setFinantialInstitution(null);
        this_.setPaymentsIntegrationSeries(null);
        this_.deleteDomainObject();
    }

    public static ERPConfiguration createEmpty(FinantialInstitution finantialInstitution) {
        ERPConfiguration eRPConfiguration = new ERPConfiguration();
        eRPConfiguration.init(null, finantialInstitution, null, null, null, null, null, 1024L);
        return eRPConfiguration;
    }

    public static ERPConfiguration create(Series series, FinantialInstitution finantialInstitution, String string, String string2, String string3, String string4, String string5, Long l) {
        return (ERPConfiguration)((Object)advice$create.perform((Callable)new ERPConfiguration$callable$create(series, finantialInstitution, string, string2, string3, string4, string5, l)));
    }

    static /* synthetic */ ERPConfiguration advised$create(Series paymentsIntegrationSeries, FinantialInstitution finantialInstitution, String code, String externalURL, String username, String password, String implementationClassName, Long maxSizeBytesToExportOnline) {
        ERPConfiguration eRPConfiguration = new ERPConfiguration();
        eRPConfiguration.init(paymentsIntegrationSeries, finantialInstitution, code, externalURL, username, password, implementationClassName, maxSizeBytesToExportOnline);
        return eRPConfiguration;
    }

    public IERPExternalService getERPExternalServiceImplementation() {
        return TreasuryPlataformDependentServicesFactory.implementation().getERPExternalServiceImplementation(this);
    }
}

