/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.exemption;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType$callable$create;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType$callable$delete;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType$callable$edit;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType_Base;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class TreasuryExemptionType
extends TreasuryExemptionType_Base {
    public static final Comparator<? super TreasuryExemptionType> COMPARE_BY_NAME;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;

    protected TreasuryExemptionType() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected TreasuryExemptionType(String code, LocalizedString name, BigDecimal defaultExemptionPercentage, boolean active) {
        this();
        this.setCode(code);
        this.setName(name);
        this.setDefaultExemptionPercentage(defaultExemptionPercentage);
        this.setActive(active);
        this.checkRules();
    }

    private void checkRules() {
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.Currency.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.Currency.name.required", new String[0]);
        }
        if (TreasuryExemptionType.findByCode(this.getCode()).count() > 1L) {
            throw new TreasuryDomainException("error.TreasuryExemptionType.code.duplicated", new String[0]);
        }
    }

    public void edit(String string, LocalizedString localizedString, BigDecimal bigDecimal, boolean bl) {
        Object object = advice$edit.perform((Callable)new TreasuryExemptionType$callable$edit(this, string, localizedString, bigDecimal, bl));
    }

    static /* synthetic */ void advised$edit(TreasuryExemptionType this_, String code, LocalizedString name, BigDecimal discountRate, boolean active) {
        this_.setCode(code);
        this_.setName(name);
        this_.setDefaultExemptionPercentage(discountRate);
        this_.setActive(active);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getTreasuryExemptionsSet().isEmpty();
    }

    public boolean isActive() {
        return super.getActive();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new TreasuryExemptionType$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(TreasuryExemptionType this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.TreasuryExemptionType.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.deleteDomainObject();
    }

    public static TreasuryExemptionType create(String string, LocalizedString localizedString, BigDecimal bigDecimal, boolean bl) {
        return (TreasuryExemptionType)((Object)advice$create.perform((Callable)new TreasuryExemptionType$callable$create(string, localizedString, bigDecimal, bl)));
    }

    static /* synthetic */ TreasuryExemptionType advised$create(String code, LocalizedString name, BigDecimal defaultExemptionPercentage, boolean active) {
        return new TreasuryExemptionType(code, name, defaultExemptionPercentage, active);
    }

    public static Stream<TreasuryExemptionType> findAll() {
        return FenixFramework.getDomainRoot().getTreasuryExemptionTypesSet().stream();
    }

    public static Stream<TreasuryExemptionType> findByCode(String code) {
        return TreasuryExemptionType.findAll().filter(i -> code.equalsIgnoreCase(i.getCode()));
    }

    public static Stream<TreasuryExemptionType> findByDebtAccount(DebtAccount debtAccount) {
        return Stream.empty();
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_NAME = new Comparator<TreasuryExemptionType>(){

            @Override
            public int compare(TreasuryExemptionType o1, TreasuryExemptionType o2) {
                int c = o1.getName().getContent().compareTo(o2.getName().getContent());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

