/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.PaymentMethodReference;
import org.fenixedu.treasury.domain.document.PaymentEntry$callable$create;
import org.fenixedu.treasury.domain.document.PaymentEntry$callable$delete;
import org.fenixedu.treasury.domain.document.PaymentEntry$callable$edit;
import org.fenixedu.treasury.domain.document.PaymentEntry_Base;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.TreasuryConstants;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PaymentEntry
extends PaymentEntry_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected PaymentEntry() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected PaymentEntry(PaymentMethod paymentMethod, SettlementNote settlementNote, BigDecimal payedAmount, String paymentMethodId, Map<String, String> propertiesMap) {
        this();
        this.init(paymentMethod, settlementNote, payedAmount, paymentMethodId, propertiesMap);
    }

    protected void init(PaymentMethod paymentMethod, SettlementNote settlementNote, BigDecimal payedAmount, String paymentMethodId, Map<String, String> propertiesMap) {
        Optional<PaymentMethodReference> defaultMethodReference;
        this.setPaymentMethod(paymentMethod);
        this.setSettlementNote(settlementNote);
        this.setPayedAmount(payedAmount);
        this.setPaymentMethodId(paymentMethodId);
        this.setPropertiesJsonMap(TreasuryConstants.propertiesMapToJson(propertiesMap));
        if (StringUtils.isEmpty((String)this.getPaymentMethodId()) && PaymentMethodReference.isPaymentMethodReferencesApplied() && (defaultMethodReference = PaymentMethodReference.findUniqueDefaultPaymentMethodReference(this.getPaymentMethod(), this.getSettlementNote().getDebtAccount().getFinantialInstitution())).isPresent()) {
            this.setPaymentMethodId(defaultMethodReference.get().getPaymentReferenceId());
        }
        this.checkRules();
    }

    private void checkRules() {
        if (this.getPaymentMethod() == null) {
            throw new TreasuryDomainException("error.PaymentEntry.paymentMethod.required", new String[0]);
        }
        if (this.getSettlementNote() == null) {
            throw new TreasuryDomainException("error.PaymentEntry.settlementNote.required", new String[0]);
        }
    }

    public void edit(PaymentMethod paymentMethod, SettlementNote settlementNote, BigDecimal bigDecimal, String string) {
        Object object = advice$edit.perform((Callable)new PaymentEntry$callable$edit(this, paymentMethod, settlementNote, bigDecimal, string));
    }

    static /* synthetic */ void advised$edit(PaymentEntry this_, PaymentMethod paymentMethod, SettlementNote settlementNote, BigDecimal payedAmount, String paymentMethodId) {
        this_.setPaymentMethod(paymentMethod);
        this_.setSettlementNote(settlementNote);
        this_.setPayedAmount(payedAmount);
        this_.setPaymentMethodId(paymentMethodId);
        this_.checkRules();
    }

    public Map<String, String> getPropertiesMap() {
        return TreasuryConstants.propertiesJsonToMap(this.getPropertiesJsonMap());
    }

    public void editPropertiesMap(Map<String, String> propertiesMap) {
        this.setPropertiesJsonMap(TreasuryConstants.propertiesMapToJson(propertiesMap));
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PaymentEntry$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PaymentEntry this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.PaymentEntry.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setPaymentMethod(null);
        this_.deleteDomainObject();
    }

    public static PaymentEntry create(PaymentMethod paymentMethod, SettlementNote settlementNote, BigDecimal bigDecimal, String string, Map<String, String> map) {
        return (PaymentEntry)((Object)advice$create.perform((Callable)new PaymentEntry$callable$create(paymentMethod, settlementNote, bigDecimal, string, map)));
    }

    static /* synthetic */ PaymentEntry advised$create(PaymentMethod paymentMethod, SettlementNote settlementNote, BigDecimal payedAmount, String paymentMethodId, Map<String, String> propertiesMap) {
        return new PaymentEntry(paymentMethod, settlementNote, payedAmount, paymentMethodId, propertiesMap);
    }

    public static Stream<PaymentEntry> findAll() {
        return FenixFramework.getDomainRoot().getPaymentEntriesSet().stream();
    }

    public static Stream<PaymentEntry> findByPaymentMethod(PaymentMethod paymentMethod) {
        return paymentMethod.getPaymentEntriesSet().stream();
    }

    public static Stream<PaymentEntry> findBySettlementNote(SettlementNote settlementNote) {
        return settlementNote.getPaymentEntriesSet().stream();
    }

    public static Stream<PaymentEntry> findByPayedAmount(BigDecimal payedAmount) {
        return PaymentEntry.findAll().filter(i -> payedAmount.equals(i.getPayedAmount()));
    }
}

