/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibs;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.services.payments.sibs.SIBSImportationLineDTO;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFile;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFileDetailLine;
import org.joda.time.DateTime;

public class SIBSImportationFileDTO {
    protected DateTime whenProcessedBySibs;
    protected String filename;
    protected BigDecimal transactionsTotalAmount;
    protected BigDecimal totalCost;
    protected Integer fileVersion;
    private String sibsEntityCode;
    private FinantialInstitution finantialInstitution;
    protected List<SIBSImportationLineDTO> lines;

    public SIBSImportationFileDTO(SibsIncommingPaymentFile sibsIncomingPaymentFile, FinantialInstitution finantialInstitution) {
        this.setWhenProcessedBySibs(sibsIncomingPaymentFile.getHeader().getWhenProcessedBySibs().toDateTimeAtMidnight());
        this.setFilename(sibsIncomingPaymentFile.getFilename());
        this.setTransactionsTotalAmount(sibsIncomingPaymentFile.getFooter().getTransactionsTotalAmount());
        this.setTotalCost(sibsIncomingPaymentFile.getFooter().getTotalCost());
        this.setFileVersion(sibsIncomingPaymentFile.getHeader().getVersion());
        this.setSibsEntityCode(sibsIncomingPaymentFile.getHeader().getEntityCode());
        this.setFinantialInstitution(finantialInstitution);
        this.setLines(this.generateLines(sibsIncomingPaymentFile));
    }

    protected List<SIBSImportationLineDTO> generateLines(SibsIncommingPaymentFile sibsIncomingPaymentFile) {
        ArrayList<SIBSImportationLineDTO> result = new ArrayList<SIBSImportationLineDTO>();
        for (SibsIncommingPaymentFileDetailLine dto : sibsIncomingPaymentFile.getDetailLines()) {
            result.add(new SIBSImportationLineDTO(this, dto));
        }
        return result;
    }

    public List<SIBSImportationLineDTO> getLines() {
        return this.lines;
    }

    public void setLines(List<SIBSImportationLineDTO> lines) {
        this.lines = lines;
    }

    public DateTime getWhenProcessedBySibs() {
        return this.whenProcessedBySibs;
    }

    public void setWhenProcessedBySibs(DateTime whenProcessedBySibs) {
        this.whenProcessedBySibs = whenProcessedBySibs;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public BigDecimal getTransactionsTotalAmount() {
        return this.transactionsTotalAmount;
    }

    public void setTransactionsTotalAmount(BigDecimal transactionsTotalAmount) {
        this.transactionsTotalAmount = transactionsTotalAmount;
    }

    public BigDecimal getTotalCost() {
        return this.totalCost;
    }

    public void setTotalCost(BigDecimal totalCost) {
        this.totalCost = totalCost;
    }

    public Integer getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(Integer fileVersion) {
        this.fileVersion = fileVersion;
    }

    public String getSibsEntityCode() {
        return this.sibsEntityCode;
    }

    public void setSibsEntityCode(String sibsEntityId) {
        this.sibsEntityCode = sibsEntityId;
    }

    public FinantialInstitution getFinantialInstitution() {
        return this.finantialInstitution;
    }

    public void setFinantialInstitution(FinantialInstitution finantialInstitution) {
        this.finantialInstitution = finantialInstitution;
    }
}

