/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation;

import com.qubit.solution.fenixedu.bennu.webservices.services.client.BennuWebServiceClient;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.UnaryOperator;
import javax.xml.ws.BindingProvider;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.IntegrationOperationLogBean;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.AuditFile;
import org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation.ReimbursementStateBean;
import org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation.SIAGExternalService$callable$createStaticInitializer;
import org.fenixedu.treasury.services.integration.erp.IERPExporter;
import org.fenixedu.treasury.services.integration.erp.IERPExternalService;
import org.fenixedu.treasury.services.integration.erp.IERPImporter;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentStatusWS;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationOutput;
import org.fenixedu.treasury.services.integration.erp.siag.DocumentsInformationInput;
import org.fenixedu.treasury.services.integration.erp.siag.GestaoAcademicaService;
import org.fenixedu.treasury.services.integration.erp.siag.GestaoAcademicaServiceService;
import org.fenixedu.treasury.services.integration.erp.siag.IntegrationStatusOutput;
import org.fenixedu.treasury.services.integration.erp.siag.StatusType;
import org.fenixedu.treasury.services.integration.erp.singap.siag.SingapSiagExporter;
import org.fenixedu.treasury.services.integration.erp.singap.siag.SingapSiagImporter;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SIAGExternalService
extends BennuWebServiceClient<GestaoAcademicaService>
implements IERPExternalService {
    private static final String SIAG_ERROR_PREFIX = "ERRO(S):";
    public static final Advice advice$createStaticInitializer = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    private static void createStaticInitializer() {
        Object object = advice$createStaticInitializer.perform((Callable)new SIAGExternalService$callable$createStaticInitializer());
    }

    static /* synthetic */ void advised$createStaticInitializer() {
        new SIAGExternalService();
    }

    @Override
    public DocumentsInformationOutput sendInfoOnline(FinantialInstitution finantialInstitution, org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationInput documentsInformation) {
        DocumentsInformationOutput output = new DocumentsInformationOutput();
        DocumentsInformationInput siagInput = new DocumentsInformationInput();
        siagInput.setDataURI(documentsInformation.getDataURI());
        siagInput.setFinantialInstitution(documentsInformation.getFinantialInstitution());
        siagInput.setData(documentsInformation.getData());
        org.fenixedu.treasury.services.integration.erp.siag.DocumentsInformationOutput siagOutput = ((GestaoAcademicaService)this.getClient()).sendInfoOnline(siagInput);
        output.setRequestId(siagOutput.getRequestId());
        StringBuilder errorLog = new StringBuilder();
        for (org.fenixedu.treasury.services.integration.erp.siag.DocumentStatusWS siagStatus : siagOutput.getDocumentStatus()) {
            if (siagStatus.getIntegrationStatus().equals((Object)StatusType.ERROR)) {
                errorLog.append(siagStatus.getErrorDescription());
            }
            DocumentStatusWS docStatus = new DocumentStatusWS();
            docStatus.setDocumentNumber(siagStatus.getDocumentNumber());
            docStatus.setErrorDescription(String.format("[STATUS: %s] - %s", new Object[]{siagStatus.getIntegrationStatus(), siagStatus.getErrorDescription()}));
            docStatus.setIntegrationStatus(DocumentStatusWS.StatusType.valueOf(siagStatus.getIntegrationStatus().toString()));
            output.getDocumentStatus().add(docStatus);
        }
        return output;
    }

    @Override
    public String sendInfoOffline(org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationInput documentsInformation) {
        DocumentsInformationInput siagInput = new DocumentsInformationInput();
        siagInput.setDataURI(documentsInformation.getDataURI());
        siagInput.setFinantialInstitution(documentsInformation.getFinantialInstitution());
        String result = ((GestaoAcademicaService)this.getClient()).sendInfoOffline(siagInput);
        if (result.contains(SIAG_ERROR_PREFIX)) {
            throw new TreasuryDomainException(result, new String[0]);
        }
        return result;
    }

    @Override
    public List<DocumentStatusWS> getIntegrationStatusFor(String finantialInstitution, List<String> documentsInformation) {
        IntegrationStatusOutput integrationStatusFor = ((GestaoAcademicaService)this.getClient()).getIntegrationStatusFor(finantialInstitution, documentsInformation);
        ArrayList<DocumentStatusWS> statusList = new ArrayList<DocumentStatusWS>();
        for (org.fenixedu.treasury.services.integration.erp.siag.DocumentStatusWS siagDocStatus : integrationStatusFor.getDocumentStatus()) {
            DocumentStatusWS docStatus = new DocumentStatusWS();
            docStatus.setDocumentNumber(siagDocStatus.getDocumentNumber());
            docStatus.setErrorDescription(siagDocStatus.getErrorDescription());
            docStatus.setIntegrationStatus(DocumentStatusWS.StatusType.valueOf(siagDocStatus.getIntegrationStatus().toString()));
            statusList.add(docStatus);
        }
        return statusList;
    }

    protected BindingProvider getService() {
        BindingProvider prov = (BindingProvider)new GestaoAcademicaServiceService().getSIAGGestaoAcademicaService();
        return prov;
    }

    public UnaryOperator<AuditFile> getAuditFilePreProcessOperator() {
        return x -> {
            x.getHeader().setBusinessName(this.getWebServiceClientConfiguration().getClientPassword());
            x.getHeader().getCompanyAddress().setStreetName(this.getWebServiceClientConfiguration().getClientUsername());
            return x;
        };
    }

    @Override
    public IERPExporter getERPExporter() {
        return new SingapSiagExporter();
    }

    @Override
    public IERPImporter getERPImporter(InputStream inputStream) {
        return new SingapSiagImporter(inputStream);
    }

    @Override
    public byte[] downloadCertifiedDocumentPrint(String finantialInstitution, String finantialDocumentNumber, String erpIdProcess) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ReimbursementStateBean checkReimbursementState(SettlementNote reimbursementNote, IntegrationOperationLogBean logBean) {
        throw new RuntimeException("not implemented");
    }

    static {
        SIAGExternalService.createStaticInitializer();
    }
}

