/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.sibsonlinepaymentsgateway;

import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.MbwayPaymentRequest;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.MbwayTransaction_Base;
import org.joda.time.DateTime;
import pt.ist.fenixframework.FenixFramework;

public class MbwayTransaction
extends MbwayTransaction_Base {
    public MbwayTransaction() {
        this.setCreationDate(new DateTime());
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public MbwayTransaction(MbwayPaymentRequest mbwayPaymentRequest, String sibsTransactionId, BigDecimal amount, DateTime paymentDate, Set<SettlementNote> settlementNotes) {
        this();
        this.setMbwayPaymentRequest(mbwayPaymentRequest);
        this.setAmount(amount);
        this.setSibsTransactionId(sibsTransactionId);
        this.setPaymentDate(paymentDate);
        this.getSettlementNotesSet().addAll(settlementNotes);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.MbwayTransaction.domainRoot.required", new String[0]);
        }
        if (this.getMbwayPaymentRequest() == null) {
            throw new TreasuryDomainException("error.MbwayTransaction.mbwayPaymentRequest.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getSibsTransactionId())) {
            throw new TreasuryDomainException("error.MbwayTransaction.sibsTransactionId.required", new String[0]);
        }
        if (this.getPaymentDate() == null) {
            throw new TreasuryDomainException("error.MbwayTransaction.paymentDate.required", new String[0]);
        }
        if (this.getSettlementNotesSet().isEmpty()) {
            throw new TreasuryDomainException("error.MbwayTransaction.paymentDate.required", new String[0]);
        }
        if (this.getAmount() == null) {
            throw new TreasuryDomainException("error.MbwayTransaction.amount.required", new String[0]);
        }
        if (MbwayTransaction.findBySibsTransactionId(this.getSibsTransactionId()).count() >= 2L) {
            throw new TreasuryDomainException("error.MbwayTransaction.sibsTransactionId.already.registered", new String[0]);
        }
    }

    public static MbwayTransaction create(MbwayPaymentRequest mbwayPaymentRequest, String sibsTransactionId, BigDecimal amount, DateTime paymentDate, Set<SettlementNote> settlementNotes) {
        MbwayTransaction mbwayTransaction = new MbwayTransaction(mbwayPaymentRequest, sibsTransactionId, amount, paymentDate, settlementNotes);
        return mbwayTransaction;
    }

    public static Stream<MbwayTransaction> findAll() {
        return FenixFramework.getDomainRoot().getMbwayPaymentTransactionsSet().stream();
    }

    public static Stream<MbwayTransaction> find(MbwayPaymentRequest mbwayPaymentRequest) {
        return mbwayPaymentRequest.getMbwayTransactionsSet().stream();
    }

    public static Stream<MbwayTransaction> findBySibsTransactionId(String sibsTransactionId) {
        return MbwayTransaction.findAll().filter(t -> t.getSibsTransactionId().equals(sibsTransactionId));
    }

    public static boolean isTransactionProcessingDuplicate(String sibsTransactionId) {
        return MbwayTransaction.findBySibsTransactionId(sibsTransactionId).count() > 0L;
    }
}

