/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution$callable$create;
import org.fenixedu.treasury.domain.FinantialInstitution$callable$delete;
import org.fenixedu.treasury.domain.FinantialInstitution$callable$edit;
import org.fenixedu.treasury.domain.FinantialInstitution$callable$editContacts;
import org.fenixedu.treasury.domain.FinantialInstitution$callable$markSeriesAsDefault;
import org.fenixedu.treasury.domain.FinantialInstitution_Base;
import org.fenixedu.treasury.domain.FiscalCountryRegion;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsConfiguration;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.standards.geographic.Country;
import pt.ist.standards.geographic.District;
import pt.ist.standards.geographic.Municipality;

public class FinantialInstitution
extends FinantialInstitution_Base {
    public static final Comparator<FinantialInstitution> COMPARATOR_BY_NAME;
    public static final Advice advice$editContacts;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$markSeriesAsDefault;
    public static final Advice advice$create;

    protected FinantialInstitution() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected FinantialInstitution(FiscalCountryRegion fiscalCountryRegion, Currency currency, String code, String fiscalNumber, String companyId, String name, String companyName, String address, Country country, District district, Municipality municipality, String locality, String zipCode) {
        this();
        this.setFiscalCountryRegion(fiscalCountryRegion);
        this.setCode(code);
        this.setFiscalNumber(fiscalNumber);
        this.setCompanyId(companyId);
        this.setName(name);
        this.setCompanyName(companyName);
        this.setAddress(address);
        this.setCountry(country);
        this.setDistrict(district);
        this.setMunicipality(municipality);
        this.setLocality(locality);
        this.setZipCode(zipCode);
        this.setCurrency(currency);
        SibsConfiguration.create(this, null, null, null);
        this.checkRules();
    }

    private void checkRules() {
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.FinantialInstitution.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getFiscalNumber())) {
            throw new TreasuryDomainException("error.FinantialInstitution.fiscalNumber.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.FinantialInstitution.name.required", new String[0]);
        }
        if (FinantialInstitution.findByCode(this.getCode()).count() > 1L) {
            throw new TreasuryDomainException("error.FinantialInstitution.code.duplicated", new String[0]);
        }
        if (FinantialInstitution.findByName(this.getName()).count() > 1L) {
            throw new TreasuryDomainException("error.FinantialInstitution.name.duplicated", new String[0]);
        }
    }

    public void editContacts(String string, String string2, String string3) {
        Object object = advice$editContacts.perform((Callable)new FinantialInstitution$callable$editContacts(this, string, string2, string3));
    }

    static /* synthetic */ void advised$editContacts(FinantialInstitution this_, String email, String telephoneContact, String webAddress) {
        this_.setEmail(email);
        this_.setTelephoneContact(telephoneContact);
        this_.setWebAddress(webAddress);
    }

    public String getComercialRegistrationCode() {
        return this.getFiscalNumber() + " " + this.getAddress();
    }

    public void edit(FiscalCountryRegion fiscalCountryRegion, Currency currency, String string, String string2, String string3, String string4, String string5, String string6, Country country, District district, Municipality municipality, String string7, String string8) {
        Object object = advice$edit.perform((Callable)new FinantialInstitution$callable$edit(this, fiscalCountryRegion, currency, string, string2, string3, string4, string5, string6, country, district, municipality, string7, string8));
    }

    static /* synthetic */ void advised$edit(FinantialInstitution this_, FiscalCountryRegion fiscalCountryRegion, Currency currency, String code, String fiscalNumber, String companyId, String name, String companyName, String address, Country country, District district, Municipality municipality, String locality, String zipCode) {
        this_.setFiscalCountryRegion(fiscalCountryRegion);
        this_.setCurrency(currency);
        this_.setCode(code);
        this_.setFiscalNumber(fiscalNumber);
        this_.setCompanyId(companyId);
        this_.setName(name);
        this_.setCompanyName(companyName);
        this_.setAddress(address);
        this_.setCountry(country);
        this_.setDistrict(district);
        this_.setMunicipality(municipality);
        this_.setLocality(locality);
        this_.setZipCode(zipCode);
        this_.checkRules();
    }

    public boolean isDeletable() {
        if (this.getFinantialEntitiesSet().stream().anyMatch(x -> !x.isDeletable())) {
            return false;
        }
        if (this.getDebtAccountsSet().stream().anyMatch(x -> !x.isDeletable())) {
            return false;
        }
        return !this.getSeriesSet().stream().anyMatch(x -> !x.isDeletable());
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new FinantialInstitution$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(FinantialInstitution this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.FinantialInstitution.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setCurrency(null);
        this_.setCountry(null);
        this_.setDistrict(null);
        this_.setMunicipality(null);
        this_.setFiscalCountryRegion(null);
        for (DebtAccount debt : this_.getDebtAccountsSet()) {
            this_.removeDebtAccounts(debt);
            debt.delete();
        }
        for (FinantialEntity entity : this_.getFinantialEntitiesSet()) {
            this_.removeFinantialEntities(entity);
            entity.delete();
        }
        for (Product p : this_.getAvailableProductsSet()) {
            this_.removeAvailableProducts(p);
        }
        for (Series s : this_.getSeriesSet()) {
            this_.removeSeries(s);
            s.delete();
        }
        for (Vat vat : this_.getVatsSet()) {
            vat.delete();
        }
        this_.deleteDomainObject();
    }

    public void markSeriesAsDefault(Series series) {
        Object object = advice$markSeriesAsDefault.perform((Callable)new FinantialInstitution$callable$markSeriesAsDefault(this, series));
    }

    static /* synthetic */ void advised$markSeriesAsDefault(FinantialInstitution this_, Series series) {
        for (Series s : this_.getSeriesSet()) {
            s.setDefaultSeries(false);
        }
        series.setDefaultSeries(true);
    }

    public static Stream<FinantialInstitution> findAll() {
        return FenixFramework.getDomainRoot().getFinantialInstitutionsSet().stream();
    }

    public static Optional<FinantialInstitution> findUnique() {
        Set all = FenixFramework.getDomainRoot().getFinantialInstitutionsSet();
        return all.size() != 1 ? Optional.empty() : Optional.of((FinantialInstitution)((Object)all.iterator().next()));
    }

    public static Stream<FinantialInstitution> findByCode(String code) {
        return FinantialInstitution.findAll().filter(fi -> fi.getCode().equalsIgnoreCase(code));
    }

    public static Stream<FinantialInstitution> findByName(String name) {
        return FinantialInstitution.findAll().filter(fi -> fi.getName().equalsIgnoreCase(name));
    }

    public static FinantialInstitution create(FiscalCountryRegion fiscalCountryRegion, Currency currency, String string, String string2, String string3, String string4, String string5, String string6, Country country, District district, Municipality municipality, String string7, String string8) {
        return (FinantialInstitution)((Object)advice$create.perform((Callable)new FinantialInstitution$callable$create(fiscalCountryRegion, currency, string, string2, string3, string4, string5, string6, country, district, municipality, string7, string8)));
    }

    static /* synthetic */ FinantialInstitution advised$create(FiscalCountryRegion fiscalCountryRegion, Currency currency, String code, String fiscalNumber, String companyId, String name, String companyName, String address, Country country, District district, Municipality municipality, String locality, String zipCode) {
        return new FinantialInstitution(fiscalCountryRegion, currency, code, fiscalNumber, companyId, name, companyName, address, country, district, municipality, locality, zipCode);
    }

    public Set<FinantialDocument> getExportableDocuments(DateTime fromDate, DateTime toDate) {
        HashSet<FinantialDocument> result = new HashSet<FinantialDocument>();
        for (Series series : this.getSeriesSet()) {
            for (DocumentNumberSeries documentNumberSeries : series.getDocumentNumberSeriesSet()) {
                result.addAll(documentNumberSeries.getFinantialDocumentsSet().stream().filter(x -> x.getDocumentDate().isAfter((ReadableInstant)fromDate) && x.getDocumentDate().isBefore((ReadableInstant)toDate)).collect(Collectors.toSet()));
            }
        }
        return result;
    }

    public Vat getActiveVat(VatType vatType, DateTime when) {
        return this.getVatsSet().stream().filter(x -> x.isActive(when) && x.getVatType().equals((Object)vatType)).findFirst().orElse(null);
    }

    public String getUiCompleteAddress() {
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)this.getAddress())) {
            sb.append(this.getAddress()).append(", ");
        }
        if (!Strings.isNullOrEmpty((String)this.getZipCode())) {
            sb.append(this.getZipCode()).append(", ");
        }
        if (!Strings.isNullOrEmpty((String)this.getLocality())) {
            sb.append(this.getLocality()).append(", ");
        }
        if (this.getMunicipality() != null) {
            sb.append(this.getMunicipality().name).append(", ");
        }
        if (this.getCountry() != null) {
            sb.append(this.getCountry().alpha2).append(", ");
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    public static Optional<FinantialInstitution> findUniqueByFiscalCode(String fiscalNumber) {
        return FinantialInstitution.findAll().filter(x -> fiscalNumber.equals(x.getFiscalNumber())).findFirst();
    }

    static {
        advice$editContacts = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$markSeriesAsDefault = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_NAME = (o1, o2) -> {
            int c = o1.getName().compareTo(o2.getName());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
    }
}

