/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.sibs.incomming;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.joda.time.DateTime;

public class SibsIncommingPaymentFileDetailLine {
    private static final String DATE_TIME_FORMAT = "yyyyMMddHHmm";
    private DateTime whenOccuredTransaction;
    private BigDecimal amount;
    private String sibsTransactionId;
    private String code;
    private static final int[] FIELD_SIZES = new int[]{1, 2, 4, 8, 12, 10, 5, 2, 10, 5, 15, 9, 1, 1, 12, 3};

    public static SibsIncommingPaymentFileDetailLine buildFrom(String rawLine) {
        String[] fields = SibsIncommingPaymentFileDetailLine.splitLine(rawLine);
        return new SibsIncommingPaymentFileDetailLine(SibsIncommingPaymentFileDetailLine.getWhenOccuredTransactionFrom(fields), SibsIncommingPaymentFileDetailLine.getAmountFrom(fields), SibsIncommingPaymentFileDetailLine.getSibsTransactionIdFrom(fields), SibsIncommingPaymentFileDetailLine.getCodeFrom(fields));
    }

    public SibsIncommingPaymentFileDetailLine(DateTime whenOccuredTransactionFrom, BigDecimal amountFrom, String sibsTransactionIdFrom, String codeFrom) {
        this.whenOccuredTransaction = whenOccuredTransactionFrom;
        this.amount = amountFrom;
        this.sibsTransactionId = sibsTransactionIdFrom;
        this.code = codeFrom;
    }

    private static String getCodeFrom(String[] fields) {
        return fields[11];
    }

    private static String getSibsTransactionIdFrom(String[] fields) {
        return fields[9];
    }

    private static BigDecimal getAmountFrom(String[] fields) {
        return BigDecimal.valueOf(Double.parseDouble(fields[5].substring(0, 8) + "." + fields[5].substring(8)));
    }

    private static DateTime getWhenOccuredTransactionFrom(String[] fields) {
        try {
            return new DateTime((Object)new SimpleDateFormat(DATE_TIME_FORMAT).parse(fields[4]));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private static final String[] splitLine(String line) {
        int lastIndex = 0;
        String[] result = new String[FIELD_SIZES.length];
        for (int i = 0; i < FIELD_SIZES.length; ++i) {
            result[i] = line.substring(lastIndex, lastIndex + FIELD_SIZES[i]);
            lastIndex += FIELD_SIZES[i];
        }
        return result;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getSibsTransactionId() {
        return this.sibsTransactionId;
    }

    public void setSibsTransactionId(String sibsTransactionId) {
        this.sibsTransactionId = sibsTransactionId;
    }

    public DateTime getWhenOccuredTransaction() {
        return this.whenOccuredTransaction;
    }

    public void setWhenOccuredTransaction(DateTime whenOccuredTransaction) {
        this.whenOccuredTransaction = whenOccuredTransaction;
    }
}

