/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.AdvancedPaymentCreditNote;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentStateType;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.FinantialDocumentTypeEnum;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.ReimbursementEntry;
import org.fenixedu.treasury.domain.document.ReimbursementUtils;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$anullDocument;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$create;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$createAdvancedPaymentCreditNote;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$createSettlementNote;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$delete;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$edit;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$processReimbursementStateChange;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$processSettlementNoteCreation;
import org.fenixedu.treasury.domain.document.SettlementNote$callable$updateSettlementNote;
import org.fenixedu.treasury.domain.document.SettlementNote_Base;
import org.fenixedu.treasury.domain.document.reimbursement.ReimbursementProcessStatusType;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SettlementNote
extends SettlementNote_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateSettlementNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$processSettlementNoteCreation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$anullDocument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$processReimbursementStateChange = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createAdvancedPaymentCreditNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createSettlementNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected SettlementNote() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected SettlementNote(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate, DateTime paymentDate, String originDocumentNumber, String finantialTransactionReference) {
        this();
        this.init(debtAccount, documentNumberSeries, documentDate, paymentDate, originDocumentNumber, finantialTransactionReference);
    }

    protected void init(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate, DateTime paymentDate, String originDocumentNumber, String finantialTransactionReference) {
        this.setFinantialTransactionReference(finantialTransactionReference);
        this.setOriginDocumentNumber(originDocumentNumber);
        if (paymentDate == null) {
            this.setPaymentDate(documentDate);
        } else {
            this.setPaymentDate(paymentDate);
        }
        super.init(debtAccount, documentNumberSeries, documentDate);
        this.checkRules();
    }

    public boolean isSettlementNote() {
        return true;
    }

    public boolean isReimbursement() {
        return this.getDocumentNumberSeries().getFinantialDocumentType() == FinantialDocumentType.findForReimbursementNote();
    }

    protected BigDecimal checkDiferenceInAmount() {
        BigDecimal result = this.getTotalDebitAmount().subtract(this.getTotalCreditAmount());
        if (this.getAdvancedPaymentCreditNote() != null) {
            result = result.add(this.getAdvancedPaymentCreditNote().getTotalAmount());
        }
        if (TreasuryConstants.isZero(this.getTotalReimbursementAmount())) {
            return this.getTotalPayedAmount().subtract(result);
        }
        return this.getTotalReimbursementAmount().add(result);
    }

    protected void checkRules() {
        super.checkRules();
        if (this.getPaymentDate().isAfter((ReadableInstant)this.getDocumentDate())) {
            throw new TreasuryDomainException("error.SettlementNote.invalid.payment.date.after.document.date", new String[0]);
        }
        if (!this.getDocumentNumberSeries().getFinantialDocumentType().getType().equals((Object)FinantialDocumentTypeEnum.SETTLEMENT_NOTE) && !this.getDocumentNumberSeries().getFinantialDocumentType().getType().equals((Object)FinantialDocumentTypeEnum.REIMBURSEMENT_NOTE)) {
            throw new TreasuryDomainException("error.FinantialDocument.finantialDocumentType.invalid", new String[0]);
        }
        if (this.isClosed() && this.isReimbursement() && this.getCurrentReimbursementProcessStatus() == null) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementNote.current.status.invalid", new String[0]);
        }
        if (this.isClosed()) {
            for (SettlementEntry settlementEntry : this.getSettlemetEntriesSet()) {
                if (!settlementEntry.getInvoiceEntry().isCreditNoteEntry() || settlementEntry.getInvoiceEntry().getFinantialDocument().isClosed()) continue;
                throw new TreasuryDomainException("error.SettlementNote.settlement.entry.for.credit.entry.not.closed", new String[0]);
            }
        }
        HashMap map = new HashMap();
        this.getSettlemetEntriesSet().forEach(se -> {
            map.putIfAbsent(se.getInvoiceEntry(), new LongAdder());
            ((LongAdder)map.get((Object)se.getInvoiceEntry())).increment();
        });
        for (Map.Entry entry : map.entrySet()) {
            if (((LongAdder)entry.getValue()).intValue() <= 1) continue;
            throw new TreasuryDomainException("error.SettlementNote.checkRules.invoiceEntries.not.unique", new String[0]);
        }
    }

    public void markAsUsedInBalanceTransfer() {
        this.setUsedInBalanceTransfer(true);
    }

    public void edit(FinantialDocumentType finantialDocumentType, DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, Currency currency, String string, DateTime dateTime, DateTime dateTime2, String string2, FinantialDocumentStateType finantialDocumentStateType) {
        Object object = advice$edit.perform((Callable)new SettlementNote$callable$edit(this, finantialDocumentType, debtAccount, documentNumberSeries, currency, string, dateTime, dateTime2, string2, finantialDocumentStateType));
    }

    static /* synthetic */ void advised$edit(SettlementNote this_, FinantialDocumentType finantialDocumentType, DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, Currency currency, String documentNumber, DateTime documentDate, DateTime paymentDate, String originDocumentNumber, FinantialDocumentStateType state) {
        this_.setFinantialDocumentType(finantialDocumentType);
        this_.setDebtAccount(debtAccount);
        this_.setDocumentNumberSeries(documentNumberSeries);
        this_.setCurrency(currency);
        this_.setDocumentNumber(documentNumber);
        this_.setDocumentDate(documentDate);
        this_.setDocumentDueDate(documentDate.toLocalDate());
        this_.setOriginDocumentNumber(originDocumentNumber);
        this_.setState(state);
        this_.setPaymentDate(paymentDate);
        this_.checkRules();
    }

    public void updateSettlementNote(String string, String string2) {
        Object object = advice$updateSettlementNote.perform((Callable)new SettlementNote$callable$updateSettlementNote(this, string, string2));
    }

    static /* synthetic */ void advised$updateSettlementNote(SettlementNote this_, String originDocumentNumber, String documentObservations) {
        this_.setOriginDocumentNumber(originDocumentNumber);
        this_.setDocumentObservations(documentObservations);
        this_.checkRules();
    }

    public boolean isDeletable() {
        if (this.isPreparing()) {
            if (this.getAdvancedPaymentCreditNote() != null) {
                return this.getAdvancedPaymentCreditNote().isDeletable();
            }
            return true;
        }
        return false;
    }

    public boolean isAdvancePaymentSetByUser() {
        return this.getAdvancePaymentSetByUser();
    }

    public boolean isReimbursementPending() {
        if (!this.isReimbursement()) {
            return false;
        }
        if (this.getCurrentReimbursementProcessStatus() == null) {
            return false;
        }
        return this.getCurrentReimbursementProcessStatus().isInitialStatus();
    }

    public boolean isReimbursementConcluded() {
        if (!this.isReimbursement()) {
            return false;
        }
        ReimbursementProcessStatusType currentStatus = this.getCurrentReimbursementProcessStatus();
        if (currentStatus == null) {
            return false;
        }
        return currentStatus.isFinalStatus() && !currentStatus.isRejectedStatus();
    }

    public boolean isReimbursementRejected() {
        if (!this.isReimbursement()) {
            return false;
        }
        ReimbursementProcessStatusType currentStatus = this.getCurrentReimbursementProcessStatus();
        if (currentStatus == null) {
            return false;
        }
        return currentStatus.isFinalStatus() && currentStatus.isRejectedStatus();
    }

    public boolean isUsedInBalanceTransfer() {
        return this.getUsedInBalanceTransfer();
    }

    public void delete(boolean bl) {
        Object object = advice$delete.perform((Callable)new SettlementNote$callable$delete(this, bl));
    }

    static /* synthetic */ void advised$delete(SettlementNote this_, boolean deleteEntries) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.SettlementNote.cannot.delete", new String[0]);
        }
        for (PaymentEntry paymentEntry : this_.getPaymentEntriesSet()) {
            this_.removePaymentEntries(paymentEntry);
            if (deleteEntries) {
                paymentEntry.delete();
                continue;
            }
            paymentEntry.setSettlementNote(null);
        }
        for (ReimbursementEntry entry : this_.getReimbursementEntriesSet()) {
            this_.removeReimbursementEntries(entry);
            if (deleteEntries) {
                entry.delete();
                continue;
            }
            entry.setSettlementNote(null);
        }
        if (this_.getAdvancedPaymentCreditNote() != null) {
            this_.getAdvancedPaymentCreditNote().delete(true);
        }
        super.delete(deleteEntries);
    }

    public void processSettlementNoteCreation(SettlementNoteBean settlementNoteBean) {
        Object object = advice$processSettlementNoteCreation.perform((Callable)new SettlementNote$callable$processSettlementNoteCreation(this, settlementNoteBean));
    }

    static /* synthetic */ void advised$processSettlementNoteCreation(SettlementNote this_, SettlementNoteBean bean) {
        this_.processInterestEntries(bean);
        this_.closeDebitNotes(bean);
        this_.closeCreditNotes(bean);
        if (bean.isReimbursementNote()) {
            this_.processReimbursementEntries(bean);
        } else {
            this_.processPaymentEntries(bean);
        }
        this_.processAdvancePayments(bean);
        this_.setAdvancePaymentSetByUser(bean.isAdvancePayment());
        if (this_.isReimbursement()) {
            if (this_.getSettlemetEntries().count() != 1L) {
                throw new TreasuryDomainException("error.SettlementNote.reimbursement.supports.only.one.settlement.entry", new String[0]);
            }
            CreditNote creditNote = (CreditNote)((Object)this_.getSettlemetEntries().findFirst().get().getInvoiceEntry().getFinantialDocument());
            if (!creditNote.isCreditNote()) {
                throw new TreasuryDomainException("error.SettlementNote.reimbursement.invoice.entry.not.from.credit.note.", new String[0]);
            }
            if (!creditNote.isAdvancePayment() && ReimbursementUtils.isCreditNoteSettledWithPayment(creditNote)) {
                throw new TreasuryDomainException("error.CreditNote.reimbursement.over.credit.with.payments.not.possible", new String[0]);
            }
        }
    }

    private void processAdvancePayments(SettlementNoteBean bean) {
        if (bean.isReimbursementNote()) {
            return;
        }
        if (!bean.isAdvancePayment()) {
            return;
        }
        BigDecimal debitSum = bean.isReimbursementNote() ? bean.getDebtAmountWithVat().negate() : bean.getDebtAmountWithVat();
        BigDecimal paymentSum = bean.getPaymentAmount();
        BigDecimal availableAmount = paymentSum.subtract(debitSum);
        if (!TreasuryConstants.isPositive(availableAmount)) {
            return;
        }
        String comments = String.format("%s [%s]", TreasuryConstants.treasuryBundleI18N("label.SettlementNote.advancedpayment", new String[0]).getContent(TreasuryConstants.DEFAULT_LANGUAGE), this.getPaymentDate().toString("dd/MM/yyyy"));
        this.createAdvancedPaymentCreditNote(availableAmount, comments, this.getExternalId());
    }

    private void processReimbursementEntries(SettlementNoteBean bean) {
        for (SettlementNoteBean.PaymentEntryBean paymentEntryBean : bean.getPaymentEntries()) {
            ReimbursementEntry.create(this, paymentEntryBean.getPaymentMethod(), paymentEntryBean.getPaymentAmount(), paymentEntryBean.getPaymentMethodId());
        }
    }

    private void processPaymentEntries(SettlementNoteBean bean) {
        for (SettlementNoteBean.PaymentEntryBean paymentEntryBean : bean.getPaymentEntries()) {
            PaymentEntry.create(paymentEntryBean.getPaymentMethod(), this, paymentEntryBean.getPaymentAmount(), paymentEntryBean.getPaymentMethodId(), Maps.newHashMap());
        }
    }

    private void processInterestEntries(SettlementNoteBean bean) {
        DocumentNumberSeries debitNoteSeries = DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), bean.getDebtAccount().getFinantialInstitution()).filter(x -> Boolean.TRUE.equals(x.getSeries().getDefaultSeries())).findFirst().orElse(null);
        if (bean.getInterestEntries().size() == 0) {
            return;
        }
        for (SettlementNoteBean.InterestEntryBean interestEntryBean : bean.getInterestEntries()) {
            DebitNote interestDebitNote = DebitNote.create(bean.getDebtAccount(), debitNoteSeries, new DateTime());
            DebitEntry interestDebitEntry = interestEntryBean.getDebitEntry().createInterestRateDebitEntry(interestEntryBean.getInterest(), new DateTime(), Optional.ofNullable(interestDebitNote));
            if (!interestEntryBean.isIncluded()) continue;
            interestDebitNote.closeDocument();
            SettlementEntry.create((InvoiceEntry)((Object)interestDebitEntry), this, interestEntryBean.getInterest().getInterestAmount(), interestDebitEntry.getDescription(), bean.getDate().toDateTimeAtStartOfDay(), false);
        }
    }

    private void closeCreditNotes(SettlementNoteBean bean) {
        for (SettlementNoteBean.CreditEntryBean creditEntryBean : bean.getCreditEntries()) {
            if (!creditEntryBean.isIncluded()) continue;
            CreditEntry creditEntry = creditEntryBean.getCreditEntry();
            BigDecimal creditAmountWithVat = creditEntryBean.getCreditAmountWithVat();
            if (bean.isReimbursementNote() && ReimbursementUtils.isCreditNoteForReimbursementMustBeClosedWithDebitNoteAndCreatedNew(creditEntry)) {
                creditEntry = ReimbursementUtils.closeWithDebitNoteAndCreateNewCreditNoteForReimbursement(creditEntry, creditAmountWithVat);
            }
            if (!creditEntry.getFinantialDocument().isClosed()) {
                if (TreasuryConstants.isLessThan(creditAmountWithVat, creditEntry.getOpenAmount())) {
                    creditEntry.splitCreditEntry(creditEntry.getOpenAmount().subtract(creditAmountWithVat));
                }
                creditEntry.getFinantialDocument().closeDocument();
            }
            String creditDescription = creditEntryBean.getCreditEntry().getDescription();
            SettlementEntry.create(creditEntry, creditAmountWithVat, creditDescription, this, bean.getDate().toDateTimeAtStartOfDay());
        }
    }

    private void closeDebitNotes(SettlementNoteBean bean) {
        DocumentNumberSeries debitNoteSeries = DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), bean.getDebtAccount().getFinantialInstitution()).filter(x -> Boolean.TRUE.equals(x.getSeries().getDefaultSeries())).findFirst().orElse(null);
        ArrayList<DebitEntry> untiedDebitEntries = new ArrayList<DebitEntry>();
        for (SettlementNoteBean.DebitEntryBean debitEntryBean : bean.getDebitEntries()) {
            if (!debitEntryBean.isIncluded()) continue;
            if (debitEntryBean.getDebitEntry().getFinantialDocument() == null) {
                untiedDebitEntries.add(debitEntryBean.getDebitEntry());
            } else if (!debitEntryBean.getDebitEntry().getFinantialDocument().isClosed()) {
                debitEntryBean.getDebitEntry().getFinantialDocument().closeDocument();
            }
            SettlementEntry.create(debitEntryBean, this, bean.getDate().toDateTimeAtStartOfDay());
        }
        if (untiedDebitEntries.size() != 0) {
            DebitNote debitNote = DebitNote.create(bean.getDebtAccount(), debitNoteSeries, bean.getDate().toDateTimeAtStartOfDay());
            debitNote.addDebitNoteEntries(untiedDebitEntries);
            debitNote.closeDocument();
        }
    }

    public Stream<SettlementEntry> getSettlemetEntries() {
        return this.getFinantialDocumentEntriesSet().stream().map(SettlementEntry.class::cast);
    }

    public Set<SettlementEntry> getSettlemetEntriesSet() {
        return this.getSettlemetEntries().collect(Collectors.toSet());
    }

    public Set<FinantialDocument> findRelatedDocuments(Set<FinantialDocument> documentsBaseList, Boolean includeAnulledDocuments) {
        documentsBaseList.add((FinantialDocument)((Object)this));
        for (SettlementEntry entry : this.getSettlemetEntriesSet()) {
            if (entry.getInvoiceEntry() == null || entry.getInvoiceEntry().getFinantialDocument() == null || !includeAnulledDocuments.booleanValue() && this.isAnnulled() || documentsBaseList.contains((Object)entry.getInvoiceEntry().getFinantialDocument())) continue;
            documentsBaseList.addAll(entry.getInvoiceEntry().getFinantialDocument().findRelatedDocuments(documentsBaseList, includeAnulledDocuments));
        }
        return documentsBaseList;
    }

    public void anullDocument(String string, boolean bl) {
        Object object = advice$anullDocument.perform((Callable)new SettlementNote$callable$anullDocument(this, string, bl));
    }

    static /* synthetic */ void advised$anullDocument(SettlementNote this_, String anulledReason, boolean markDocumentToExport2) {
        if (this_.isPreparing()) {
            this_.delete(true);
        } else if (this_.isClosed()) {
            if (this_.isExportedInLegacyERP()) {
                throw new TreasuryDomainException("error.SettlementNote.cannot.anull.settlement.exported.in.legacy.erp", new String[0]);
            }
            if (this_.getAdvancedPaymentCreditNote() != null && this_.getAdvancedPaymentCreditNote().hasValidSettlementEntries()) {
                throw new TreasuryDomainException("error.SettlementNote.cannot.anull.settlement.due.to.advanced.payment.settled", new String[0]);
            }
            if (this_.isUsedInBalanceTransfer()) {
                throw new TreasuryDomainException("error.SettlementNote.cannot.anull.settlement.due.to.balance.transfer", new String[0]);
            }
            this_.setState(FinantialDocumentStateType.ANNULED);
            this_.setAnnulledReason(anulledReason);
            if (markDocumentToExport2) {
                this_.markDocumentToExport();
            }
            if (this_.getAdvancedPaymentCreditNote() != null) {
                this_.getAdvancedPaymentCreditNote().anullDocument(anulledReason);
            }
            this_.checkRules();
        } else {
            throw new TreasuryDomainException(TreasuryConstants.treasuryBundle("error.FinantialDocumentState.invalid.state.change.request", new String[0]), new String[0]);
        }
    }

    public BigDecimal getTotalDebitAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (SettlementEntry entry : this.getSettlemetEntriesSet()) {
            if (!entry.getInvoiceEntry().isDebitNoteEntry()) continue;
            total = total.add(entry.getTotalAmount());
        }
        return total;
    }

    public void closeDocument(boolean markDocumentToExport2) {
        for (SettlementEntry settlementEntry : this.getSettlemetEntriesSet()) {
            if (!TreasuryConstants.isGreaterThan(settlementEntry.getAmount(), settlementEntry.getInvoiceEntry().getOpenAmount())) continue;
            throw new TreasuryDomainException("error.SettlementNote.invalid.settlement.entry.amount.for.invoice.entry", new String[0]);
        }
        if (!TreasuryConstants.isZero(this.checkDiferenceInAmount())) {
            throw new TreasuryDomainException("error.SettlementNote.invalid.amounts.in.settlement.note", new String[0]);
        }
        if (this.getReferencedCustomers().size() > 1) {
            throw new TreasuryDomainException("error.SettlementNote.referencedCustomers.only.one.allowed", new String[0]);
        }
        if (this.getAdvancedPaymentCreditNote() != null) {
            this.getAdvancedPaymentCreditNote().closeDocument();
        }
        if (this.isReimbursement()) {
            this.processReimbursementStateChange(ReimbursementProcessStatusType.findUniqueByInitialStatus().get(), String.valueOf(this.getDocumentDate().getYear()), new DateTime());
        }
        super.closeDocument(markDocumentToExport2);
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices()) {
            boolean atLeastOneInvoiceEntryExportedInLegacyERP;
            boolean bl = atLeastOneInvoiceEntryExportedInLegacyERP = this.getSettlemetEntries().filter(s -> s.getInvoiceEntry().getFinantialDocument().isExportedInLegacyERP()).count() > 0L;
            if (atLeastOneInvoiceEntryExportedInLegacyERP) {
                if (!this.isExportedInLegacyERP()) {
                    this.setExportedInLegacyERP(true);
                    this.setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
                }
                this.getSettlemetEntries().forEach(s -> {
                    if (s.getCloseDate() == null || !s.getCloseDate().isBefore((ReadableInstant)SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1))) {
                        s.setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
                    }
                });
                if (this.getAdvancedPaymentCreditNote() != null && !this.getAdvancedPaymentCreditNote().isExportedInLegacyERP()) {
                    this.getAdvancedPaymentCreditNote().setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
                    this.getAdvancedPaymentCreditNote().setExportedInLegacyERP(true);
                }
            }
        }
        this.checkRules();
    }

    public void processReimbursementStateChange(ReimbursementProcessStatusType reimbursementProcessStatusType, String string, DateTime dateTime) {
        Object object = advice$processReimbursementStateChange.perform((Callable)new SettlementNote$callable$processReimbursementStateChange(this, reimbursementProcessStatusType, string, dateTime));
    }

    static /* synthetic */ void advised$processReimbursementStateChange(SettlementNote this_, ReimbursementProcessStatusType reimbursementStatus, String exerciseYear, DateTime reimbursementStatusDate) {
        if (reimbursementStatus == null) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementStatus", new String[0]);
        }
        if (!this_.isReimbursement()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.settlementNote", new String[0]);
        }
        if (!this_.isClosed() && !reimbursementStatus.isInitialStatus()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementNote.state", new String[0]);
        }
        if (!reimbursementStatus.isInitialStatus() && this_.getCurrentReimbursementProcessStatus() == null) {
            throw new TreasuryDomainException("error.SettlementNote.currentReimbursementProcessStatus.invalid", new String[0]);
        }
        if (this_.getCurrentReimbursementProcessStatus() != null && !reimbursementStatus.isAfter(this_.getCurrentReimbursementProcessStatus())) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementNote.next.status.invalid", new String[0]);
        }
        if (this_.getCurrentReimbursementProcessStatus() != null && this_.getCurrentReimbursementProcessStatus().isFinalStatus()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementNote.current.status.is.final", new String[0]);
        }
        this_.setCurrentReimbursementProcessStatus(reimbursementStatus);
        if (this_.getCurrentReimbursementProcessStatus() == null) {
            throw new TreasuryDomainException("error.SettlementNote.currentReimbursementProcessStatus.invalid", new String[0]);
        }
        if (this_.getCurrentReimbursementProcessStatus().isRejectedStatus() && this_.isClosed()) {
            CreditNote creditNote = (CreditNote)((Object)this_.getSettlemetEntries().findFirst().get().getInvoiceEntry().getFinantialDocument());
            if (!creditNote.isAdvancePayment()) {
                creditNote.anullReimbursementCreditNoteAndCopy(TreasuryConstants.treasuryBundle("error.SettlementNote.reimbursement.rejected.reason", new String[0]));
            }
            this_.anullDocument(TreasuryConstants.treasuryBundle("label.ReimbursementProcessStatusType.annuled.reimbursement.by.annuled.process", new String[0]), false);
            this_.markDocumentToExport();
        }
    }

    public BigDecimal getTotalCreditAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (SettlementEntry entry : this.getSettlemetEntriesSet()) {
            if (!entry.getInvoiceEntry().isCreditNoteEntry()) continue;
            total = total.add(entry.getTotalAmount());
        }
        return total;
    }

    public BigDecimal getTotalPayedAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (PaymentEntry entry : this.getPaymentEntriesSet()) {
            total = total.add(entry.getPayedAmount());
        }
        return total;
    }

    public BigDecimal getTotalReimbursementAmount() {
        BigDecimal total = BigDecimal.ZERO;
        for (ReimbursementEntry reimbursementEntry : this.getReimbursementEntriesSet()) {
            total = total.add(reimbursementEntry.getReimbursedAmount());
        }
        return total;
    }

    public BigDecimal getTotalAmount() {
        return this.getTotalDebitAmount().subtract(this.getTotalDebitAmount());
    }

    public BigDecimal getTotalNetAmount() {
        throw new TreasuryDomainException("error.SettlementNote.totalNetAmount.not.available", new String[0]);
    }

    public void createAdvancedPaymentCreditNote(BigDecimal bigDecimal, String string, String string2) {
        Object object = advice$createAdvancedPaymentCreditNote.perform((Callable)new SettlementNote$callable$createAdvancedPaymentCreditNote(this, bigDecimal, string, string2));
    }

    static /* synthetic */ void advised$createAdvancedPaymentCreditNote(SettlementNote this_, BigDecimal availableAmount, String comments, String originDocumentNumber) {
        if (FinantialDocumentType.findForCreditNote() == null) {
            throw new TreasuryDomainException("error.SettlementNote.non-existing.credit.note.document.type", new String[0]);
        }
        DocumentNumberSeries documentNumberSeries = DocumentNumberSeries.find(FinantialDocumentType.findForCreditNote(), this_.getDocumentNumberSeries().getSeries());
        if (this_.getReferencedCustomers().size() > 1) {
            throw new TreasuryDomainException("error.SettlementNote.referencedCustomers.only.one.allowed", new String[0]);
        }
        DebtAccount payorDebtAccount = null;
        if (!this_.getReferencedCustomers().isEmpty()) {
            Customer payorCustomer = this_.getReferencedCustomers().iterator().next();
            if (DebtAccount.findUnique(this_.getDebtAccount().getFinantialInstitution(), payorCustomer).isPresent() && DebtAccount.findUnique(this_.getDebtAccount().getFinantialInstitution(), payorCustomer).get() != this_.getDebtAccount()) {
                payorDebtAccount = DebtAccount.findUnique(this_.getDebtAccount().getFinantialInstitution(), payorCustomer).get();
            }
        }
        AdvancedPaymentCreditNote creditNote = AdvancedPaymentCreditNote.createCreditNoteForAdvancedPayment(documentNumberSeries, this_.getDebtAccount(), availableAmount, this_.getDocumentDate(), comments, originDocumentNumber, payorDebtAccount);
        this_.setAdvancedPaymentCreditNote(creditNote);
    }

    public boolean hasAdvancedPayment() {
        return this.getAdvancedPaymentCreditNote() != null;
    }

    protected boolean isDocumentEmpty() {
        if (this.getAdvancedPaymentCreditNote() != null) {
            return this.getAdvancedPaymentCreditNote().isDocumentEmpty() && this.getFinantialDocumentEntriesSet().isEmpty();
        }
        return this.getFinantialDocumentEntriesSet().isEmpty();
    }

    public Set<Customer> getReferencedCustomers() {
        HashSet result = Sets.newHashSet();
        for (SettlementEntry settlementEntry : this.getSettlemetEntriesSet()) {
            Invoice invoice = (Invoice)((Object)settlementEntry.getInvoiceEntry().getFinantialDocument());
            if (invoice.isForPayorDebtAccount()) {
                result.add(invoice.getPayorDebtAccount().getCustomer());
                continue;
            }
            result.add(invoice.getDebtAccount().getCustomer());
        }
        if (this.getAdvancedPaymentCreditNote() != null) {
            if (this.getAdvancedPaymentCreditNote().isForPayorDebtAccount()) {
                result.add(this.getAdvancedPaymentCreditNote().getPayorDebtAccount().getCustomer());
            } else {
                result.add(this.getAdvancedPaymentCreditNote().getDebtAccount().getCustomer());
            }
        }
        return result;
    }

    protected SortedSet<? extends FinantialDocumentEntry> getFinantialDocumentEntriesOrderedByTuitionInstallmentOrderAndDescription() {
        TreeSet result = Sets.newTreeSet(SettlementEntry.COMPARATOR_BY_TUITION_INSTALLMENT_ORDER_AND_DESCRIPTION);
        result.addAll(this.getFinantialDocumentEntriesSet().stream().map(SettlementEntry.class::cast).collect(Collectors.toSet()));
        if (result.size() != this.getFinantialDocumentEntriesSet().size()) {
            throw new RuntimeException("error");
        }
        return result;
    }

    public static SettlementNote create(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime dateTime, DateTime dateTime2, String string, String string2) {
        return (SettlementNote)((Object)advice$create.perform((Callable)new SettlementNote$callable$create(debtAccount, documentNumberSeries, dateTime, dateTime2, string, string2)));
    }

    static /* synthetic */ SettlementNote advised$create(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate, DateTime paymentDate, String originDocumentNumber, String finantialTransactionReference) {
        SettlementNote settlementNote = new SettlementNote(debtAccount, documentNumberSeries, documentDate, paymentDate, originDocumentNumber, finantialTransactionReference);
        return settlementNote;
    }

    public static SettlementNote createSettlementNote(SettlementNoteBean settlementNoteBean) {
        return (SettlementNote)((Object)advice$createSettlementNote.perform((Callable)new SettlementNote$callable$createSettlementNote(settlementNoteBean)));
    }

    static /* synthetic */ SettlementNote advised$createSettlementNote(SettlementNoteBean bean) {
        DateTime documentDate = new DateTime();
        SettlementNote settlementNote = SettlementNote.create(bean.getDebtAccount(), bean.getDocNumSeries(), documentDate, bean.getDate().toDateTimeAtStartOfDay(), bean.getOriginDocumentNumber(), !Strings.isNullOrEmpty((String)bean.getFinantialTransactionReference()) ? bean.getFinantialTransactionReferenceYear() + "/" + bean.getFinantialTransactionReference() : "");
        settlementNote.processSettlementNoteCreation(bean);
        settlementNote.closeDocument();
        return settlementNote;
    }

    public static Stream<SettlementNote> findAll() {
        return FenixFramework.getDomainRoot().getFinantialDocumentsSet().stream().filter(x -> x instanceof SettlementNote).map(SettlementNote.class::cast);
    }

    public static Stream<SettlementNote> findByFinantialDocumentType(FinantialDocumentType finantialDocumentType) {
        return finantialDocumentType.getFinantialDocumentsSet().stream().filter(x -> x instanceof SettlementNote).map(SettlementNote.class::cast);
    }

    public static Stream<SettlementNote> findByDebtAccount(DebtAccount debtAccount) {
        return debtAccount.getFinantialDocumentsSet().stream().filter(x -> x instanceof SettlementNote).map(SettlementNote.class::cast);
    }

    public static Stream<SettlementNote> findByDocumentNumberSeries(DocumentNumberSeries documentNumberSeries) {
        return documentNumberSeries.getFinantialDocumentsSet().stream().filter(x -> x instanceof SettlementNote).map(SettlementNote.class::cast);
    }

    public static Stream<SettlementNote> findByCurrency(Currency currency) {
        return currency.getFinantialDocumentsSet().stream().filter(x -> x instanceof SettlementNote).map(SettlementNote.class::cast);
    }

    public static Stream<SettlementNote> findByDocumentNumber(String documentNumber) {
        return SettlementNote.findAll().filter(i -> documentNumber.equalsIgnoreCase(i.getDocumentNumber()));
    }

    public static Stream<SettlementNote> findByDocumentDate(DateTime documentDate) {
        return SettlementNote.findAll().filter(i -> documentDate.equals((Object)i.getDocumentDate()));
    }

    public static Stream<SettlementNote> findByDocumentDueDate(DateTime documentDueDate) {
        return SettlementNote.findAll().filter(i -> documentDueDate.equals((Object)i.getDocumentDueDate()));
    }

    public static Stream<SettlementNote> findByOriginDocumentNumber(String originDocumentNumber) {
        return SettlementNote.findAll().filter(i -> originDocumentNumber.equalsIgnoreCase(i.getOriginDocumentNumber()));
    }

    public static Stream<SettlementNote> findByState(FinantialDocumentStateType state) {
        return SettlementNote.findAll().filter(i -> state.equals((Object)i.getState()));
    }

    public static void checkMixingOfInvoiceEntriesExportedInLegacyERP(Set<InvoiceEntry> invoiceEntries) {
        boolean notExportedInLegacyERP;
        boolean atLeastOneExportedInLegacyERP;
        if (!TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices()) {
            return;
        }
        boolean bl = atLeastOneExportedInLegacyERP = invoiceEntries.stream().filter(i -> i.getFinantialDocument() != null).filter(i -> i.getFinantialDocument().isExportedInLegacyERP()).count() > 0L;
        if (atLeastOneExportedInLegacyERP && (notExportedInLegacyERP = invoiceEntries.stream().anyMatch(i -> i.getFinantialDocument() == null || !i.getFinantialDocument().isExportedInLegacyERP()))) {
            throw new TreasuryDomainException("error.SettlementNote.debit.entry.mixed.exported.in.legacy.erp.not.allowed", new String[0]);
        }
    }

    public static void checkMixingOfInvoiceEntriesExportedInLegacyERP(List<ISettlementInvoiceEntryBean> invoiceEntryBeans) {
        boolean notExportedInLegacyERP;
        boolean atLeastOneExportedInLegacyERP;
        if (!TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices()) {
            return;
        }
        boolean bl = atLeastOneExportedInLegacyERP = invoiceEntryBeans.stream().filter(i -> i.getInvoiceEntry() != null).filter(i -> i.getInvoiceEntry().getFinantialDocument() != null).filter(i -> i.getInvoiceEntry().getFinantialDocument().isExportedInLegacyERP()).count() > 0L;
        if (atLeastOneExportedInLegacyERP && (notExportedInLegacyERP = invoiceEntryBeans.stream().anyMatch(i -> i.getInvoiceEntry() == null || i.getInvoiceEntry().getFinantialDocument() == null || !i.getInvoiceEntry().getFinantialDocument().isExportedInLegacyERP()))) {
            throw new TreasuryDomainException("error.SettlementNote.debit.entry.mixed.exported.in.legacy.erp.not.allowed", new String[0]);
        }
    }
}

