/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote$callable$anullDocument;
import org.fenixedu.treasury.domain.document.CreditNote$callable$create;
import org.fenixedu.treasury.domain.document.CreditNote$callable$delete;
import org.fenixedu.treasury.domain.document.CreditNote$callable$deprecatedEdit;
import org.fenixedu.treasury.domain.document.CreditNote$callable$updateCreditNote;
import org.fenixedu.treasury.domain.document.CreditNote_Base;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentStateType;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.FinantialDocumentTypeEnum;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.ReimbursementUtils;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class CreditNote
extends CreditNote_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$deprecatedEdit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateCreditNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$anullDocument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public CreditNote() {
    }

    protected CreditNote(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate, DebitNote debitNote) {
        this.init(debtAccount, documentNumberSeries, documentDate, debitNote);
        this.checkRules();
    }

    protected void init(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate, DebitNote debitNote) {
        super.init(debtAccount, documentNumberSeries, documentDate);
        this.setDebitNote(debitNote);
        if (debitNote != null) {
            this.setPayorDebtAccount(debitNote.getPayorDebtAccount());
        }
    }

    protected void checkRules() {
        if (!this.getDocumentNumberSeries().getFinantialDocumentType().getType().equals((Object)FinantialDocumentTypeEnum.CREDIT_NOTE)) {
            throw new TreasuryDomainException("error.CreditNote.finantialDocumentType.invalid", new String[0]);
        }
        if (this.getDebitNote() != null && !this.getDebitNote().getDebtAccount().equals((Object)this.getDebtAccount())) {
            throw new TreasuryDomainException("error.CreditNote.invalid.debtaccount.with.debitnote", new String[0]);
        }
        if (this.getDebitNote() != null && !this.getDebitNote().isClosed()) {
            throw new TreasuryDomainException("error.CreditNote.debitnote.not.closed", new String[0]);
        }
        if (this.getDebitNote() != null && this.getPayorDebtAccount() != this.getDebitNote().getPayorDebtAccount()) {
            throw new TreasuryDomainException("error.CreditNote.with.payorDebtAccount.different.from.debit.note", new String[0]);
        }
        if (this.getDebitNote() != null && this.getDebitNote().getDocumentNumberSeries().getSeries().isRegulationSeries()) {
            throw new TreasuryDomainException("error.CreditNote.debit.note.cannot.be.from.regulation.series", new String[0]);
        }
        super.checkRules();
    }

    public boolean isCreditNote() {
        return true;
    }

    public boolean isDeletable() {
        return true;
    }

    public boolean isAdvancePayment() {
        return false;
    }

    public boolean isRelatedToReimbursement() {
        if (!this.isClosed()) {
            return false;
        }
        HashSet<SettlementEntry> settlementEntries = new HashSet<SettlementEntry>();
        for (FinantialDocumentEntry entry : this.getFinantialDocumentEntriesSet()) {
            for (SettlementEntry settlementEntry : ((InvoiceEntry)((Object)entry)).getSettlementEntriesSet()) {
                settlementEntries.add(settlementEntry);
            }
        }
        if (settlementEntries.isEmpty()) {
            return false;
        }
        if (settlementEntries.size() != 1) {
            throw new TreasuryDomainException("error.CreditNote.isRelatedToReimbursement.settlement.entries.not.one.check", new String[0]);
        }
        SettlementNote settlementNote = (SettlementNote)((Object)((SettlementEntry)((Object)this.getRelatedSettlementEntries().iterator().next())).getFinantialDocument());
        return settlementNote.isReimbursement();
    }

    public void delete(boolean bl) {
        Object object = advice$delete.perform((Callable)new CreditNote$callable$delete(this, bl));
    }

    static /* synthetic */ void advised$delete(CreditNote this_, boolean deleteEntries) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.CreditNote.cannot.delete", new String[0]);
        }
        this_.setDebitNote(null);
        super.delete(deleteEntries);
    }

    public Stream<? extends CreditEntry> getCreditEntries() {
        return CreditEntry.find(this);
    }

    public Set<? extends CreditEntry> getCreditEntriesSet() {
        return this.getCreditEntries().collect(Collectors.toSet());
    }

    public BigDecimal getDebitAmount() {
        return BigDecimal.ZERO;
    }

    public BigDecimal getCreditAmount() {
        return this.getTotalAmount();
    }

    public DebtAccount getPayorDebtAccount() {
        if (super.getPayorDebtAccount() == null && this.getDebitNote() != null) {
            return this.getDebitNote().getPayorDebtAccount();
        }
        return super.getPayorDebtAccount();
    }

    public void editPayorDebtAccount(DebtAccount payorDebtAccount) {
        if (!this.isPreparing()) {
            throw new TreasuryDomainException("error.CreditNote.edit.not.possible.on.closed.document", new String[0]);
        }
        this.setPayorDebtAccount(payorDebtAccount);
        this.checkRules();
    }

    private void deprecatedEdit(DebitNote debitNote, DebtAccount debtAccount, FinantialDocumentType finantialDocumentType, DebtAccount debtAccount2, DocumentNumberSeries documentNumberSeries, Currency currency, String string, DateTime dateTime, LocalDate localDate, String string2, FinantialDocumentStateType finantialDocumentStateType) {
        Object object = advice$deprecatedEdit.perform((Callable)new CreditNote$callable$deprecatedEdit(this, debitNote, debtAccount, finantialDocumentType, debtAccount2, documentNumberSeries, currency, string, dateTime, localDate, string2, finantialDocumentStateType));
    }

    static /* synthetic */ void advised$deprecatedEdit(CreditNote this_, DebitNote debitNote, DebtAccount payorDebtAccount, FinantialDocumentType finantialDocumentType, DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, Currency currency, String documentNumber, DateTime documentDate, LocalDate documentDueDate, String originDocumentNumber, FinantialDocumentStateType state) {
        if (!this_.isPreparing()) {
            throw new TreasuryDomainException("error.CreditNote.edit.not.possible.on.closed.document", new String[0]);
        }
        this_.setDebitNote(debitNote);
        this_.setFinantialDocumentType(finantialDocumentType);
        this_.setDebtAccount(debtAccount);
        this_.editPayorDebtAccount(payorDebtAccount);
        this_.setDocumentNumberSeries(documentNumberSeries);
        this_.setCurrency(currency);
        this_.setDocumentNumber(documentNumber);
        this_.setDocumentDate(documentDate);
        this_.setDocumentDueDate(documentDueDate);
        this_.setOriginDocumentNumber(originDocumentNumber);
        this_.setState(state);
        this_.checkRules();
    }

    public void updateCreditNote(String string, String string2) {
        Object object = advice$updateCreditNote.perform((Callable)new CreditNote$callable$updateCreditNote(this, string, string2));
    }

    static /* synthetic */ void advised$updateCreditNote(CreditNote this_, String originDocumentNumber, String documentObservations) {
        this_.setOriginDocumentNumber(originDocumentNumber);
        this_.setDocumentObservations(documentObservations);
        this_.checkRules();
    }

    public BigDecimal getOpenAmount() {
        if (this.isAnnulled()) {
            return BigDecimal.ZERO;
        }
        BigDecimal amount = BigDecimal.ZERO;
        for (CreditEntry creditEntry : this.getCreditEntriesSet()) {
            amount = amount.add(creditEntry.getOpenAmount());
        }
        return this.getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(amount);
    }

    public BigDecimal getOpenAmountWithInterests() {
        if (this.getState().isPreparing() || this.getState().isClosed()) {
            return this.getOpenAmount();
        }
        return BigDecimal.ZERO;
    }

    public Set<FinantialDocument> findRelatedDocuments(Set<FinantialDocument> documentsBaseList, Boolean includeAnulledDocuments) {
        documentsBaseList.add((FinantialDocument)((Object)this));
        for (CreditEntry creditEntry : this.getCreditEntriesSet()) {
            if (creditEntry.getDebitEntry() == null || creditEntry.getDebitEntry().getFinantialDocument() == null || creditEntry.getDebitEntry().getFinantialDocument().isPreparing() || !includeAnulledDocuments.booleanValue() && this.isAnnulled() || documentsBaseList.contains((Object)creditEntry.getDebitEntry().getFinantialDocument())) continue;
            documentsBaseList.addAll(creditEntry.getDebitEntry().getFinantialDocument().findRelatedDocuments(documentsBaseList, includeAnulledDocuments));
        }
        for (CreditEntry creditEntry : this.getCreditEntriesSet()) {
            for (SettlementEntry settlementEntry : creditEntry.getSettlementEntriesSet()) {
                if (settlementEntry.getFinantialDocument() == null || settlementEntry.getFinantialDocument().isPreparing() || !includeAnulledDocuments.booleanValue() && settlementEntry.getFinantialDocument().isAnnulled() || documentsBaseList.contains((Object)settlementEntry.getFinantialDocument())) continue;
                documentsBaseList.addAll(settlementEntry.getFinantialDocument().findRelatedDocuments(documentsBaseList, includeAnulledDocuments));
            }
        }
        return documentsBaseList;
    }

    public void anullDocument(String string) {
        Object object = advice$anullDocument.perform((Callable)new CreditNote$callable$anullDocument(this, string));
    }

    static /* synthetic */ void advised$anullDocument(CreditNote this_, String reason) {
        if (Strings.isNullOrEmpty((String)reason)) {
            throw new TreasuryDomainException("error.CreditNote.anullDocument.reason.required", new String[0]);
        }
        if (this_.isPreparing()) {
            if (this_.getCreditEntries().anyMatch(ce -> ce.isFromExemption())) {
                throw new TreasuryDomainException("error.CreditNote.entry.from.exemption.cannot.be.annuled", new String[0]);
            }
            if (this_.getCreditEntries().anyMatch(ce -> !ce.getSettlementEntriesSet().isEmpty())) {
                throw new TreasuryDomainException("error.CreditNote.cannot.delete.has.settlemententries", new String[0]);
            }
            this_.setState(FinantialDocumentStateType.ANNULED);
            String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
            if (!Strings.isNullOrEmpty((String)loggedUsername)) {
                this_.setAnnulledReason(reason + " - [" + loggedUsername + "] " + new DateTime().toString("YYYY-MM-dd HH:mm:ss"));
            } else {
                this_.setAnnulledReason(reason + " - " + new DateTime().toString("YYYY-MM-dd HH:mm:ss"));
            }
        } else {
            throw new TreasuryDomainException(TreasuryConstants.treasuryBundle("error.FinantialDocumentState.invalid.state.change.request", new String[0]), new String[0]);
        }
        this_.checkRules();
    }

    public CreditNote anullReimbursementCreditNoteAndCopy(String annuledReason) {
        if (!this.isClosed()) {
            throw new TreasuryDomainException("error.CreditNote.anullReimbursementCreditNoteAndCopy.copy.only.on.closed.credit.note", new String[0]);
        }
        if (!this.isRelatedToReimbursement()) {
            throw new TreasuryDomainException("error.CreditNote.creditNote.not.from.reimbursement", new String[0]);
        }
        if (this.isAdvancePayment()) {
            throw new TreasuryDomainException("error.CreditNote.annulment.over.advance.payment.not.possible", new String[0]);
        }
        if (ReimbursementUtils.isCreditNoteSettledWithPayment(this)) {
            throw new TreasuryDomainException("error.CreditNote.annulment.over.credit.with.payments.not.possible", new String[0]);
        }
        this.setState(FinantialDocumentStateType.ANNULED);
        this.setAnnulledReason(annuledReason);
        CreditNote creditNote = CreditNote.create(this.getDebtAccount(), this.getDocumentNumberSeries(), new DateTime(), this.getDebitNote(), this.getOriginDocumentNumber());
        for (CreditEntry creditEntry : this.getCreditEntriesSet()) {
            CreditEntry.create((FinantialDocument)((Object)creditNote), creditEntry.getDescription(), creditEntry.getProduct(), creditEntry.getVat(), creditEntry.getAmount(), new DateTime(), creditEntry.getDebitEntry(), creditEntry.getQuantity());
        }
        return creditNote;
    }

    public static Stream<CreditNote> findAll() {
        return Invoice.findAll().filter(i -> i instanceof CreditNote).map(CreditNote.class::cast);
    }

    public static Stream<CreditNote> find(DebtAccount debtAccount) {
        return debtAccount.getFinantialDocumentsSet().stream().filter(x -> x instanceof CreditNote).map(CreditNote.class::cast);
    }

    public static CreditNote create(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime dateTime, DebitNote debitNote, String string) {
        return (CreditNote)((Object)advice$create.perform((Callable)new CreditNote$callable$create(debtAccount, documentNumberSeries, dateTime, debitNote, string)));
    }

    static /* synthetic */ CreditNote advised$create(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate, DebitNote debitNote, String originNumber) {
        CreditNote note = new CreditNote(debtAccount, documentNumberSeries, documentDate, debitNote);
        note.setOriginDocumentNumber(originNumber);
        note.checkRules();
        return note;
    }

    public static CreditEntry createBalanceTransferCredit(DebtAccount debtAccount, DateTime documentDate, String originNumber, Product product, BigDecimal amountWithVat, DebtAccount payorDebtAccount, String entryDescription) {
        FinantialInstitution finantialInstitution = debtAccount.getFinantialInstitution();
        Series regulationSeries = finantialInstitution.getRegulationSeries();
        DocumentNumberSeries numberSeries = DocumentNumberSeries.find(FinantialDocumentType.findForCreditNote(), regulationSeries);
        Vat transferVat = Vat.findActiveUnique(product.getVatType(), finantialInstitution, documentDate).get();
        if (Strings.isNullOrEmpty((String)entryDescription)) {
            entryDescription = product.getName().getContent();
        }
        CreditNote creditNote = CreditNote.create(debtAccount, numberSeries, documentDate, null, originNumber);
        BigDecimal amountWithoutVat = TreasuryConstants.divide(amountWithVat, BigDecimal.ONE.add(transferVat.getTaxRate()));
        CreditEntry entry = CreditEntry.create((FinantialDocument)((Object)creditNote), entryDescription, product, transferVat, amountWithoutVat, documentDate, null, BigDecimal.ONE);
        creditNote.editPayorDebtAccount(payorDebtAccount);
        return entry;
    }
}

