/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.concurrent.Callable;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.AdvancedPaymentCreditNote$callable$createCreditNoteForAdvancedPayment;
import org.fenixedu.treasury.domain.document.AdvancedPaymentCreditNote$callable$delete;
import org.fenixedu.treasury.domain.document.AdvancedPaymentCreditNote_Base;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentStateType;
import org.fenixedu.treasury.domain.document.FinantialDocumentTypeEnum;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AdvancedPaymentCreditNote
extends AdvancedPaymentCreditNote_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createCreditNoteForAdvancedPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected AdvancedPaymentCreditNote(DebtAccount debtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate) {
        super.init(debtAccount, documentNumberSeries, documentDate);
        this.checkRules();
    }

    protected AdvancedPaymentCreditNote(DebtAccount debtAccount, DebtAccount payorDebtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate) {
        super.init(debtAccount, payorDebtAccount, documentNumberSeries, documentDate);
        this.checkRules();
    }

    public boolean isCreditNote() {
        return true;
    }

    protected void checkRules() {
        if (!this.getDocumentNumberSeries().getFinantialDocumentType().getType().equals((Object)FinantialDocumentTypeEnum.CREDIT_NOTE)) {
            throw new TreasuryDomainException("error.AdvancedPaymentCreditNote.finantialDocumentType.invalid", new String[0]);
        }
        if (this.getAdvancedPaymentSettlementNote() != null && !this.getAdvancedPaymentSettlementNote().getDebtAccount().equals((Object)this.getDebtAccount())) {
            throw new TreasuryDomainException("error.AdvancedPaymentCreditNote.invalid.debtaccount.with.settlementnote", new String[0]);
        }
        super.checkRules();
    }

    public boolean isDeletable() {
        return true;
    }

    public boolean isAdvancePayment() {
        return true;
    }

    public void anullDocument(String reason) {
        if (this.isClosed()) {
            if (this.getCreditEntries().anyMatch(ce -> !ce.getSettlementEntriesSet().isEmpty())) {
                throw new TreasuryDomainException("error.CreditNote.cannot.delete.has.settlemententries", new String[0]);
            }
            this.setState(FinantialDocumentStateType.ANNULED);
            String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
            if (!Strings.isNullOrEmpty((String)loggedUsername)) {
                this.setAnnulledReason(reason + " - [" + loggedUsername + "]" + new DateTime().toString("YYYY-MM-dd HH:mm:ss"));
            } else {
                this.setAnnulledReason(reason + " - " + new DateTime().toString("YYYY-MM-dd HH:mm:ss"));
            }
        } else {
            throw new TreasuryDomainException(TreasuryConstants.treasuryBundle("error.FinantialDocumentState.invalid.state.change.request", new String[0]), new String[0]);
        }
        this.checkRules();
    }

    public void delete(boolean bl) {
        Object object = advice$delete.perform((Callable)new AdvancedPaymentCreditNote$callable$delete(this, bl));
    }

    static /* synthetic */ void advised$delete(AdvancedPaymentCreditNote this_, boolean deleteEntries) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.CreditNote.cannot.delete", new String[0]);
        }
        this_.setDebitNote(null);
        super.delete(deleteEntries);
    }

    private static AdvancedPaymentCreditNote create(DebtAccount debtAccount, DebtAccount payorDebtAccount, DocumentNumberSeries documentNumberSeries, DateTime documentDate) {
        AdvancedPaymentCreditNote note = new AdvancedPaymentCreditNote(debtAccount, payorDebtAccount, documentNumberSeries, documentDate);
        note.checkRules();
        return note;
    }

    public static AdvancedPaymentCreditNote createCreditNoteForAdvancedPayment(DocumentNumberSeries documentNumberSeries, DebtAccount debtAccount, BigDecimal bigDecimal, DateTime dateTime, String string, String string2, DebtAccount debtAccount2) {
        return (AdvancedPaymentCreditNote)((Object)advice$createCreditNoteForAdvancedPayment.perform((Callable)new AdvancedPaymentCreditNote$callable$createCreditNoteForAdvancedPayment(documentNumberSeries, debtAccount, bigDecimal, dateTime, string, string2, debtAccount2)));
    }

    static /* synthetic */ AdvancedPaymentCreditNote advised$createCreditNoteForAdvancedPayment(DocumentNumberSeries documentNumberSeries, DebtAccount debtAccount, BigDecimal availableAmount, DateTime documentDate, String description, String originDocumentNumber, DebtAccount payorDebtAccount) {
        AdvancedPaymentCreditNote note = AdvancedPaymentCreditNote.create(debtAccount, payorDebtAccount != debtAccount ? payorDebtAccount : null, documentNumberSeries, documentDate);
        note.setOriginDocumentNumber(originDocumentNumber);
        Product advancedPaymentProduct = TreasurySettings.getInstance().getAdvancePaymentProduct();
        if (advancedPaymentProduct == null) {
            throw new TreasuryDomainException("error.AdvancedPaymentCreditNote.invalid.product.for.advanced.payment", new String[0]);
        }
        Vat vat = Vat.findActiveUnique(advancedPaymentProduct.getVatType(), debtAccount.getFinantialInstitution(), new DateTime()).orElse(null);
        if (vat == null) {
            throw new TreasuryDomainException("error.AdvancedPaymentCreditNote.invalid.vat.type.for.advanced.payment", new String[0]);
        }
        String lineDescription = TreasuryConstants.treasuryBundleI18N("label.AdvancedPaymentCreditNote.advanced.payment.description", new String[0]).getContent(TreasuryConstants.DEFAULT_LANGUAGE) + description;
        CreditEntry entry = CreditEntry.create((FinantialDocument)((Object)note), lineDescription, advancedPaymentProduct, vat, availableAmount, documentDate, null, BigDecimal.ONE);
        return note;
    }
}

