/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.FiscalYear$callable$create;
import org.fenixedu.treasury.domain.FiscalYear$callable$editSettlementAnnulmentLimitDate;
import org.fenixedu.treasury.domain.FiscalYear_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class FiscalYear
extends FiscalYear_Base {
    public static final Comparator<FiscalYear> COMPARE_BY_YEAR;
    public static final Advice advice$editSettlementAnnulmentLimitDate;
    public static final Advice advice$create;

    public FiscalYear() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    public FiscalYear(FinantialInstitution finantialInstitution, int year, LocalDate settlementAnnulmentLimitDate) {
        this();
        this.setFinantialInstitution(finantialInstitution);
        this.setYear(year);
        this.setSettlementAnnulmentLimitDate(settlementAnnulmentLimitDate);
        this.checkRules();
    }

    public void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.FiscalYear.domainRoot.required", new String[0]);
        }
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.FiscalYear.finantialInstitution.required", new String[0]);
        }
        if (this.getSettlementAnnulmentLimitDate() == null) {
            throw new TreasuryDomainException("error.FiscalYear.settlementAnnulmentLimitDate.required", new String[0]);
        }
        if (FiscalYear.find(this.getFinantialInstitution(), this.getYear()).count() > 1L) {
            throw new TreasuryDomainException("error.FiscalYear.already.defined.for.finantial.institution.and.year", new String[0]);
        }
    }

    public void editSettlementAnnulmentLimitDate(LocalDate localDate) {
        Object object = advice$editSettlementAnnulmentLimitDate.perform((Callable)new FiscalYear$callable$editSettlementAnnulmentLimitDate(this, localDate));
    }

    static /* synthetic */ void advised$editSettlementAnnulmentLimitDate(FiscalYear this_, LocalDate limitDate) {
        this_.setSettlementAnnulmentLimitDate(limitDate);
        this_.checkRules();
    }

    public static Stream<FiscalYear> findAll() {
        return FenixFramework.getDomainRoot().getFiscalYearsSet().stream();
    }

    public static Stream<FiscalYear> find(FinantialInstitution finantialInstitution, int year) {
        return finantialInstitution.getFiscalYearsSet().stream().filter(fy -> fy.getYear() == year);
    }

    public static Optional<FiscalYear> findUnique(FinantialInstitution finantialInstitution, int year) {
        return FiscalYear.find(finantialInstitution, year).findFirst();
    }

    public static FiscalYear create(FinantialInstitution finantialInstitution, int n, LocalDate localDate) {
        return (FiscalYear)((Object)advice$create.perform((Callable)new FiscalYear$callable$create(finantialInstitution, n, localDate)));
    }

    static /* synthetic */ FiscalYear advised$create(FinantialInstitution finantialInstitution, int year, LocalDate settlementAnnulmentLimitDate) {
        return new FiscalYear(finantialInstitution, year, settlementAnnulmentLimitDate);
    }

    static {
        advice$editSettlementAnnulmentLimitDate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_YEAR = (o1, o2) -> {
            int c = Integer.compare(o1.getYear(), o2.getYear());
            if (c != 0) {
                return c;
            }
            return o1.getExternalId().compareTo(o2.getExternalId());
        };
    }
}

