/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.reports.dataproviders;

import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.math.BigDecimal;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.services.reports.dataproviders.AbstractDataProvider;
import org.joda.time.LocalDate;

public class PaymentReferenceCodeDataProvider
extends AbstractDataProvider
implements IReportDataProvider {
    protected static final String PAYMENT_CODE_KEY = "paymentCode";
    private PaymentReferenceCode paymentCode;

    public PaymentReferenceCodeDataProvider(PaymentReferenceCode paymentCode) {
        this.setPaymentCode(paymentCode);
        this.registerKey(PAYMENT_CODE_KEY, PaymentReferenceCodeDataProvider::handlePaymentCodeKey);
    }

    private static Object handlePaymentCodeKey(IReportDataProvider provider) {
        PaymentReferenceCodeDataProvider regisProvider = (PaymentReferenceCodeDataProvider)provider;
        return regisProvider.getPaymentCode();
    }

    @Override
    public void registerFieldsAndImages(IDocumentFieldsData arg0) {
    }

    public PaymentReferenceCode getPaymentCode() {
        return this.paymentCode;
    }

    public void setPaymentCode(PaymentReferenceCode paymentCode) {
        this.paymentCode = paymentCode;
    }

    public String getDescription() {
        MultipleEntriesPaymentCode targetPayment = (MultipleEntriesPaymentCode)((Object)this.paymentCode.getTargetPayment());
        StringBuilder builder = new StringBuilder();
        for (FinantialDocumentEntry finantialDocumentEntry : targetPayment.getOrderedInvoiceEntries()) {
            builder.append(((DebitEntry)((Object)finantialDocumentEntry)).getProduct().getName().getContent()).append("\n");
        }
        return builder.toString();
    }

    public BigDecimal getAmount() {
        return this.paymentCode.getPayableAmount();
    }

    public LocalDate getDueDate() {
        return ((MultipleEntriesPaymentCode)((Object)this.paymentCode.getTargetPayment())).getDueDate();
    }
}

