/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.reports.dataproviders;

import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.services.reports.dataproviders.AbstractDataProvider;
import org.fenixedu.treasury.services.reports.dataproviders.PaymentReferenceCodeDataProvider;
import org.joda.time.ReadablePartial;

public class DebtAccountDataProvider
extends AbstractDataProvider
implements IReportDataProvider {
    protected static final String DEBT_ACCOUNT_KEY = "debtAccount";
    protected static final String PAYMENT_LINES_KEY = "paymentLines";
    private DebtAccount debtAccount;
    private List<DebitNote> debitNotesForPaymentLines;

    public DebtAccountDataProvider(DebtAccount debtAccount) {
        this(debtAccount, null);
    }

    public DebtAccountDataProvider(DebtAccount debtAccount, List<DebitNote> debitNotesForPaymentLines) {
        this.debtAccount = debtAccount;
        this.registerKey(DEBT_ACCOUNT_KEY, DebtAccountDataProvider::handleDebtAccountKey);
        this.registerKey(PAYMENT_LINES_KEY, DebtAccountDataProvider::handlePaymentsLinesKey);
    }

    private static Object handlePaymentsLinesKey(IReportDataProvider provider) {
        DebtAccountDataProvider debtProvider = (DebtAccountDataProvider)provider;
        HashSet referencesCodes = new HashSet();
        if (debtProvider.debitNotesForPaymentLines == null) {
            List pendingDebitEntriesSet = debtProvider.debtAccount.getPendingInvoiceEntriesSet().stream().filter(x -> x.isDebitNoteEntry()).collect(Collectors.toList());
            for (InvoiceEntry entry : pendingDebitEntriesSet) {
                DebitEntry debitEntry = (DebitEntry)((Object)entry);
                referencesCodes.addAll(MultipleEntriesPaymentCode.find(debitEntry).filter(m -> m.getPaymentReferenceCode().isUsed()).map(m -> m.getPaymentReferenceCode()).collect(Collectors.toSet()));
            }
        }
        ArrayList<PaymentReferenceCodeDataProvider> codesProviders = new ArrayList<PaymentReferenceCodeDataProvider>();
        for (PaymentReferenceCode code : referencesCodes) {
            codesProviders.add(new PaymentReferenceCodeDataProvider(code));
        }
        return codesProviders.stream().sorted((x, y) -> x.getDueDate().compareTo((ReadablePartial)y.getDueDate())).collect(Collectors.toList());
    }

    private static Object handleDebtAccountKey(IReportDataProvider provider) {
        DebtAccountDataProvider invoiceProvider = (DebtAccountDataProvider)provider;
        return invoiceProvider.debtAccount;
    }

    @Override
    public void registerFieldsAndImages(IDocumentFieldsData arg0) {
        arg0.registerCollectionAsField(PAYMENT_LINES_KEY);
    }
}

