/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp.singap.siag;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.ReimbursementEntry;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPConfiguration;
import org.fenixedu.treasury.domain.integration.ERPImportOperation;
import org.fenixedu.treasury.domain.integration.IntegrationOperationLogBean;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.AuditFile;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.PaymentMethod;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.SAFTPTSettlementType;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.SourceDocuments;
import org.fenixedu.treasury.services.integration.erp.IERPImporter;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentStatusWS;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationOutput;
import org.fenixedu.treasury.services.integration.erp.singap.siag.SingapSiagImporter$callable$processAuditFile;
import org.fenixedu.treasury.services.integration.erp.singap.siag.SingapSiagImporter$callable$processErpPayment;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SingapSiagImporter
implements IERPImporter {
    private static JAXBContext jaxbContext;
    private static Logger logger;
    private InputStream fileStream;
    public static final Advice advice$processAuditFile;
    public static final Advice advice$processErpPayment;

    public SingapSiagImporter(InputStream fileStream) {
        this.fileStream = fileStream;
    }

    public AuditFile readAuditFileFromXML() {
        try {
            if (jaxbContext == null) {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AuditFile.class});
            }
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            StringWriter writer = new StringWriter();
            AuditFile auditFile = (AuditFile)jaxbUnmarshaller.unmarshal(this.fileStream);
            return auditFile;
        }
        catch (JAXBException e) {
            return null;
        }
    }

    @Override
    public DocumentsInformationOutput processAuditFile(ERPImportOperation eRPImportOperation) {
        return (DocumentsInformationOutput)advice$processAuditFile.perform((Callable)new SingapSiagImporter$callable$processAuditFile(this, eRPImportOperation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ DocumentsInformationOutput advised$processAuditFile(SingapSiagImporter this_, ERPImportOperation eRPImportOperation) {
        IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
        DocumentsInformationOutput result = new DocumentsInformationOutput();
        result.setDocumentStatus(new ArrayList<DocumentStatusWS>());
        result.setRequestId(eRPImportOperation.getExternalId());
        try {
            AuditFile auditFile = this_.readAuditFileFromXML();
            BigDecimal totalCredit = BigDecimal.ZERO;
            BigDecimal totalDebit = BigDecimal.ZERO;
            BigInteger totalPayments = BigInteger.ZERO;
            for (SourceDocuments.Payments.Payment payment : auditFile.getSourceDocuments().getPayments().getPayment()) {
                DocumentStatusWS docStatus = new DocumentStatusWS();
                logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("info.ERPImporter.processing.payment", payment.getPaymentRefNo()));
                SettlementNote note = null;
                try {
                    note = this_.processErpPayment(payment, eRPImportOperation, logBean);
                    if (note != null) {
                        if (Strings.isNullOrEmpty((String)note.getOriginDocumentNumber())) {
                            docStatus.setDocumentNumber(note.getUiDocumentNumber());
                        } else {
                            docStatus.setDocumentNumber(note.getOriginDocumentNumber());
                        }
                        docStatus.setIntegrationStatus(DocumentStatusWS.StatusType.SUCCESS);
                        totalPayments = totalPayments.add(BigInteger.ONE);
                        totalCredit = totalCredit.add(note.getTotalCreditAmount());
                        totalDebit = totalDebit.add(note.getTotalDebitAmount());
                        if (note.isPreparing()) {
                            note.closeDocument(false);
                        }
                    } else {
                        throw new TreasuryDomainException("error.ERPImporter.processing.payment", payment.getPaymentRefNo());
                    }
                    eRPImportOperation.addFinantialDocuments((FinantialDocument)((Object)note));
                }
                catch (Exception ex) {
                    logBean.appendIntegrationLog(ex.getLocalizedMessage());
                    logBean.appendErrorLog(ex.getLocalizedMessage());
                    int count = 0;
                    for (StackTraceElement el : ex.getStackTrace()) {
                        logBean.appendErrorLog(el.toString());
                        if (count++ >= 10) break;
                    }
                    logBean.appendIntegrationLog(TreasuryConstants.treasuryBundle("error.ERPImporter.processing.payment", payment.getPaymentRefNo()));
                    logBean.appendErrorLog(TreasuryConstants.treasuryBundle("error.ERPImporter.processing.payment", payment.getPaymentRefNo()));
                    docStatus.setDocumentNumber(payment.getPaymentRefNo());
                    docStatus.setErrorDescription("Error: " + ex.getLocalizedMessage());
                    docStatus.setIntegrationStatus(DocumentStatusWS.StatusType.ERROR);
                }
                result.getDocumentStatus().add(docStatus);
            }
            if (eRPImportOperation.getProcessed()) {
                eRPImportOperation.setCorrected(true);
            }
            eRPImportOperation.setProcessed(true);
            eRPImportOperation.setExecutionDate(new DateTime());
            if (eRPImportOperation.getErrorLog() == null || eRPImportOperation.getErrorLog().isEmpty()) {
                eRPImportOperation.setSuccess(true);
            }
        }
        catch (Exception ex) {
            logBean.appendErrorLog(ex.getLocalizedMessage());
            int count = 0;
            for (StackTraceElement el : ex.getStackTrace()) {
                logBean.appendErrorLog(el.toString());
                if (count++ >= 10) break;
            }
            logBean.appendErrorLog(ex.getLocalizedMessage());
            eRPImportOperation.setProcessed(true);
            eRPImportOperation.setCorrected(false);
            eRPImportOperation.setExecutionDate(new DateTime());
            eRPImportOperation.setSuccess(false);
        }
        finally {
            eRPImportOperation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
        }
        return result;
    }

    private SettlementNote processErpPayment(SourceDocuments.Payments.Payment payment, ERPImportOperation eRPImportOperation, IntegrationOperationLogBean integrationOperationLogBean) {
        return (SettlementNote)((Object)advice$processErpPayment.perform((Callable)new SingapSiagImporter$callable$processErpPayment(this, payment, eRPImportOperation, integrationOperationLogBean)));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static /* synthetic */ SettlementNote advised$processErpPayment(SingapSiagImporter this_, SourceDocuments.Payments.Payment payment, ERPImportOperation eRPImportOperation, IntegrationOperationLogBean logBean) {
        void var13_21;
        DateTime documentDate;
        void var11_13;
        SettlementNote settlementNote;
        boolean newSettlementNoteCreated = false;
        ERPConfiguration integrationConfig = eRPImportOperation.getFinantialInstitution().getErpIntegrationConfiguration();
        DocumentNumberSeries seriesToIntegratePayments = DocumentNumberSeries.find(FinantialDocumentType.findForSettlementNote(), integrationConfig.getPaymentsIntegrationSeries());
        if (payment.getSettlementType() != null && payment.getSettlementType().equals((Object)SAFTPTSettlementType.NR)) {
            seriesToIntegratePayments = DocumentNumberSeries.find(FinantialDocumentType.findForReimbursementNote(), integrationConfig.getPaymentsIntegrationSeries());
        }
        if (seriesToIntegratePayments == null || !seriesToIntegratePayments.getSeries().getExternSeries()) {
            throw new TreasuryDomainException("label.error.integration.erpimporter.invalid.series.to.integrate.payments", new String[0]);
        }
        String externalNumber = payment.getPaymentRefNo();
        Customer customer = Customer.findByCode(payment.getCustomerID()).findFirst().orElse(null);
        SettlementNote settlementNote2 = null;
        DebtAccount customerDebtAccount = null;
        if (customer == null) throw new TreasuryDomainException("label.error.integration.erpimporter.invalid.customer.to.integrate.payments", new String[0]);
        customerDebtAccount = DebtAccount.findUnique(eRPImportOperation.getFinantialInstitution(), customer).orElse(null);
        if (customerDebtAccount == null) throw new TreasuryDomainException("label.error.integration.erpimporter.invalid.debtaccount.to.integrate.payments", new String[0]);
        SettlementNote settlementNote3 = SettlementNote.findByDocumentNumberSeries(seriesToIntegratePayments).filter(x -> x.getOriginDocumentNumber() != null && x.getOriginDocumentNumber().equals(externalNumber)).findFirst().orElse(null);
        if (settlementNote3 == null && !Strings.isNullOrEmpty((String)payment.getSourceID()) && (settlementNote = (SettlementNote)SettlementNote.findAll().filter(x -> x.getUiDocumentNumber().equals(payment.getSourceID())).findFirst().orElse(null)) != null) {
            settlementNote.setOriginDocumentNumber(payment.getPaymentRefNo());
        }
        if (var11_13 != null) {
            settlementNote2 = var11_13;
            if (!settlementNote2.getDebtAccount().equals((Object)customerDebtAccount)) {
                throw new TreasuryDomainException("label.error.integration.erpimporter.invalid.debtaccount.existing.payment", new String[0]);
            }
            if (payment.getDocumentStatus().getPaymentStatus().equals("A")) {
                if (settlementNote2.isAnnulled()) return settlementNote2;
                settlementNote2.anullDocument(TreasuryConstants.treasuryBundle("label.info.integration.erpimporter.annulled.by.integration", new String[0]) + " - [" + new DateTime().toString("YYYY-MM-dd HH:mm:ss") + "]", false);
                return settlementNote2;
            }
            logBean.appendIntegrationLog("label.error.integration.erpimporter.invalid.already.existing.payment.ignored");
            return settlementNote2;
        }
        if (payment.getDocumentStatus().getPaymentStatus().equals("A")) {
            throw new TreasuryDomainException("label.error.integration.erpimporter.invalid.payment.received.document.annulled.not.exists", new String[0]);
        }
        DateTime dateTime = documentDate = new DateTime((Object)payment.getTransactionDate().toGregorianCalendar());
        if (payment.getPaymentMethod().size() > 0 && payment.getPaymentMethod().get(0).getPaymentDate() != null) {
            try {
                DateTime dateTime2 = new DateTime((Object)payment.getPaymentMethod().get(0).getPaymentDate().toGregorianCalendar());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        settlementNote2 = SettlementNote.create(customerDebtAccount, seriesToIntegratePayments, documentDate, (DateTime)var13_21, externalNumber, null);
        newSettlementNoteCreated = true;
        try {
            for (SourceDocuments.Payments.Payment.Line paymentLine : payment.getLine()) {
                if (paymentLine.getSourceDocumentID().size() != 1) {
                    throw new TreasuryDomainException("label.error.integration.erpimporter.invalid.line.source.in.payment", new String[0]);
                }
                String string = paymentLine.getSourceDocumentID().get(0).getOriginatingON();
                FinantialDocument referenceDocument = FinantialDocument.findByUiDocumentNumber(eRPImportOperation.getFinantialInstitution(), string);
                if (referenceDocument == null || !(referenceDocument instanceof Invoice)) {
                    throw new TreasuryDomainException("label.error.integration.erpimporter.invalid.line.source.in.payment", new String[0]);
                }
                Invoice referenceInvoice = (Invoice)((Object)referenceDocument);
                if (!referenceInvoice.getDebtAccount().equals((Object)customerDebtAccount)) {
                    throw new TreasuryDomainException("label.error.integration.erpimporter.invalid.line.debtaccount.in.payment", new String[0]);
                }
                InvoiceEntry invoiceEntry = referenceInvoice.getEntryInOrder(paymentLine.getSourceDocumentID().get(0).getLineNumber().intValue());
                if (invoiceEntry == null) {
                    throw new TreasuryDomainException("label.error.integration.erpimporter.invalid.line.source.in.payment", new String[0]);
                }
                BigDecimal paymentAmount = paymentLine.getDebitAmount();
                if (invoiceEntry.isCreditNoteEntry()) {
                    paymentAmount = paymentLine.getCreditAmount();
                }
                if (invoiceEntry.getOpenAmount().compareTo(paymentAmount) < 0) {
                    throw new TreasuryDomainException("label.error.integration.erpimporter.invalid.line.amount.in.payment", new String[0]);
                }
                XMLGregorianCalendar paymentStatusDate = payment.getDocumentStatus().getPaymentStatusDate();
                DateTime paymentDate = new DateTime((Object)paymentStatusDate.toGregorianCalendar());
                SettlementEntry settlementEntry = SettlementEntry.create(invoiceEntry, settlementNote2, paymentAmount, invoiceEntry.getDescription(), paymentDate, false);
                if (!paymentDate.isBefore((ReadableInstant)settlementNote2.getPaymentDate())) continue;
                settlementNote2.setPaymentDate(paymentDate);
            }
            if (payment.getSettlementType() != null && payment.getSettlementType().equals((Object)SAFTPTSettlementType.NR)) {
                for (PaymentMethod paymentMethod : payment.getPaymentMethod()) {
                    ReimbursementEntry reimbursementEntry = ReimbursementEntry.create(settlementNote2, this_.convertFromSAFTPaymentMethod(paymentMethod.getPaymentMechanism()), paymentMethod.getPaymentAmount(), null);
                }
            } else {
                for (PaymentMethod paymentMethod : payment.getPaymentMethod()) {
                    PaymentEntry paymentEntry = PaymentEntry.create(this_.convertFromSAFTPaymentMethod(paymentMethod.getPaymentMechanism()), settlementNote2, paymentMethod.getPaymentAmount(), null, Maps.newHashMap());
                }
            }
            if (payment.getAdvancedPaymentCredit() == null) return settlementNote2;
            throw new TreasuryDomainException("label.error.integration.erpimporter.advanced.payment.credit.cannot.integrate", new String[0]);
        }
        catch (Exception exception) {
            if (!newSettlementNoteCreated || settlementNote2 == null || !settlementNote2.isDeletable()) throw exception;
            settlementNote2.delete(true);
            throw exception;
        }
    }

    private org.fenixedu.treasury.domain.PaymentMethod convertFromSAFTPaymentMethod(String paymentMechanism) {
        org.fenixedu.treasury.domain.PaymentMethod paymentMethod = org.fenixedu.treasury.domain.PaymentMethod.findByCode(paymentMechanism);
        if (paymentMethod == null) {
            throw new TreasuryDomainException("error.ERPImporter.unkown.payment.method", paymentMechanism);
        }
        return paymentMethod;
    }

    public Set<String> getRelatedDocumentsNumber() {
        HashSet<String> result = new HashSet<String>();
        AuditFile file = this.readAuditFileFromXML();
        for (SourceDocuments.WorkingDocuments.WorkDocument w : file.getSourceDocuments().getWorkingDocuments().getWorkDocument()) {
            result.add(w.getDocumentNumber());
        }
        for (SourceDocuments.SalesInvoices.Invoice i : file.getSourceDocuments().getSalesInvoices().getInvoice()) {
            result.add(i.getInvoiceNo());
        }
        for (SourceDocuments.Payments.Payment p : file.getSourceDocuments().getPayments().getPayment()) {
            result.add(p.getPaymentRefNo());
        }
        return result;
    }

    @Override
    public String readTaxRegistrationNumberFromAuditFile() {
        AuditFile auditFile = this.readAuditFileFromXML();
        return auditFile.getHeader().getTaxRegistrationNumber() + "";
    }

    static {
        advice$processAuditFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$processErpPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        jaxbContext = null;
        logger = LoggerFactory.getLogger(SingapSiagImporter.class);
    }
}

