/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.accesscontrol;

import java.util.Set;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.accesscontrol.TreasuryAccessControl;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.services.accesscontrol.spi.ITreasuryAccessControlExtension;

public class TreasuryAccessControlAPI {
    public static void registerExtension(ITreasuryAccessControlExtension extension) {
        TreasuryAccessControl.getInstance().registerExtension(extension);
    }

    public static void unregisterExtension(ITreasuryAccessControlExtension extension) {
        TreasuryAccessControl.getInstance().unregisterExtension(extension);
    }

    public static boolean isAllowToModifyInvoices(String username, FinantialInstitution finantialInstitution) {
        return TreasuryAccessControl.getInstance().isAllowToModifyInvoices(username, finantialInstitution);
    }

    public static boolean isAllowToModifySettlements(String username, FinantialInstitution finantialInstitution) {
        return TreasuryAccessControl.getInstance().isAllowToModifySettlements(username, finantialInstitution);
    }

    public static boolean isAllowToConditionallyAnnulSettlementNote(String username, SettlementNote settlementNote) {
        return TreasuryAccessControl.getInstance().isAllowToConditionallyAnnulSettlementNote(username, settlementNote);
    }

    public static boolean isAllowToAnnulSettlementNoteWithoutAnyRestriction(String username, SettlementNote settlementNote) {
        return TreasuryAccessControl.getInstance().isAllowToAnnulSettlementNoteWithoutAnyRestriction(username, settlementNote);
    }

    public static boolean isFrontOfficeMember(String username) {
        return TreasuryAccessControl.getInstance().isFrontOfficeMember(username);
    }

    public static boolean isFrontOfficeMember(String username, FinantialInstitution finantialInstitution) {
        return TreasuryAccessControl.getInstance().isFrontOfficeMember(username, finantialInstitution);
    }

    public static <T> boolean isFrontOfficeMemberWithinContext(String username, T context) {
        return TreasuryAccessControl.getInstance().isFrontOfficeMemberWithinContext(username, context);
    }

    public static boolean isBackOfficeMember(String username) {
        return TreasuryAccessControl.getInstance().isBackOfficeMember(username);
    }

    public static boolean isBackOfficeMember(String username, FinantialInstitution finantialInstitution) {
        return TreasuryAccessControl.getInstance().isBackOfficeMember(username, finantialInstitution);
    }

    public static boolean isBackOfficeMember(String username, FinantialEntity finantialEntity) {
        return TreasuryAccessControl.getInstance().isBackOfficeMember(username, finantialEntity);
    }

    public static <T> boolean isBackOfficeMemberWithinContext(String username, T context) {
        return TreasuryAccessControl.getInstance().isBackOfficeMemberWithinContext(username, context);
    }

    public static boolean isManager(String username) {
        return TreasuryAccessControl.getInstance().isManager(username);
    }

    public static Set<String> getFrontOfficeMemberUsernames() {
        return TreasuryAccessControl.getInstance().getFrontOfficeMemberUsernames();
    }

    public static Set<String> getBackOfficeMemberUsernames() {
        return TreasuryAccessControl.getInstance().getBackOfficeMemberUsernames();
    }

    public static Set<String> getTreasuryManagerMemberUsernames() {
        return TreasuryAccessControl.getInstance().getTreasuryManagerMemberUsernames();
    }
}

