/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.sibsonlinepaymentsgateway;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.onlinepaymentsgateway.api.CheckoutResultBean;
import org.fenixedu.onlinepaymentsgateway.api.CustomerDataInputBean;
import org.fenixedu.onlinepaymentsgateway.api.MbCheckoutResultBean;
import org.fenixedu.onlinepaymentsgateway.api.MbPrepareCheckoutInputBean;
import org.fenixedu.onlinepaymentsgateway.api.MbWayCheckoutResultBean;
import org.fenixedu.onlinepaymentsgateway.api.MbWayPrepareCheckoutInputBean;
import org.fenixedu.onlinepaymentsgateway.api.OnlinePaymentServiceFactory;
import org.fenixedu.onlinepaymentsgateway.api.PaymentStateBean;
import org.fenixedu.onlinepaymentsgateway.api.PrepareCheckoutInputBean;
import org.fenixedu.onlinepaymentsgateway.api.SIBSInitializeServiceBean;
import org.fenixedu.onlinepaymentsgateway.api.SIBSOnlinePaymentsGatewayService;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.SibsEnvironmentMode;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfiguration;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsBillingAddressBean;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGateway$callable$edit;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGateway$callable$generateMBPaymentReference;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGateway$callable$getPaymentStatusBySibsCheckoutId;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGateway$callable$getPaymentStatusBySibsTransactionId;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGateway$callable$getPaymentTransactionsReportListByMerchantId;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGateway$callable$prepareCheckout;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGatewayEnviromentMode;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGateway_Base;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsOnlinePaymentsGateway
extends SibsOnlinePaymentsGateway_Base {
    private static final int DEFAULT_NUM_MONTHS_PAYMENT_REFERENCE_CODE_EXPIRATION = 12;
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$getPaymentStatusBySibsCheckoutId = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$getPaymentStatusBySibsTransactionId = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$getPaymentTransactionsReportListByMerchantId = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$prepareCheckout = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$generateMBPaymentReference = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));

    public SibsOnlinePaymentsGateway() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected SibsOnlinePaymentsGateway(PaymentCodePool paymentCodePool, ForwardPaymentConfiguration forwardPaymentConfiguration, String sibsEntityId, String sibsEndpointUrl, String merchantTransactionIdPrefix, String bearerToken, String aesKey, PaymentMethod mbwayPaymentMethod, DocumentNumberSeries mbwayDocumentSeries, boolean mbwayActive) {
        this();
        this.setPaymentCodePool(paymentCodePool);
        this.setForwardPaymentConfiguration(forwardPaymentConfiguration);
        this.setSibsEntityId(sibsEntityId);
        this.setSibsEndpointUrl(sibsEndpointUrl);
        this.setMerchantTransactionIdPrefix(merchantTransactionIdPrefix);
        this.setBearerToken(bearerToken);
        this.setAesKey(aesKey);
        this.setMbwayPaymentMethod(mbwayPaymentMethod);
        this.setMbwayDocumentSeries(mbwayDocumentSeries);
        this.setMbwayActive(mbwayActive);
        this.setNumberOfMonthsToExpirePaymentReferenceCode(12);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGateway.domainRoot.required", new String[0]);
        }
        if (this.getPaymentCodePool() == null) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGateway.paymentCodePool.required", new String[0]);
        }
        if (this.getForwardPaymentConfiguration() == null) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGateway.forwardPaymentConfiguration.required", new String[0]);
        }
        if (this.getPaymentCodePool().getFinantialInstitution() != this.getForwardPaymentConfiguration().getFinantialInstitution()) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGateway.pool.and.forward.configuration.not.from.same.finantial.institution", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getSibsEntityId())) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGateway.sibsEntityId.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getSibsEndpointUrl())) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGateway.sibsEndpointUrl.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getMerchantTransactionIdPrefix())) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGateway.merchantTransactionIdPrefix.required", new String[0]);
        }
        if (this.getMbwayPaymentMethod() == null) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGateway.mbwayPaymentMethod.required", new String[0]);
        }
        if (this.getMbwayDocumentSeries() == null) {
            throw new TreasuryDomainException("error.SibsOnlinePaymentsGateway.mbwayDocumentSeries.required", new String[0]);
        }
    }

    public void edit(String string, String string2, String string3, PaymentMethod paymentMethod, DocumentNumberSeries documentNumberSeries, boolean bl, int n) {
        Object object = advice$edit.perform((Callable)new SibsOnlinePaymentsGateway$callable$edit(this, string, string2, string3, paymentMethod, documentNumberSeries, bl, n));
    }

    static /* synthetic */ void advised$edit(SibsOnlinePaymentsGateway this_, String sibsEndpointUrl, String bearerToken, String aesKey, PaymentMethod mbwayPaymentMethod, DocumentNumberSeries mbwayDocumentSeries, boolean mbwayActive, int numberOfMonthsToExpirePaymentReferenceCode) {
        this_.setSibsEndpointUrl(sibsEndpointUrl);
        this_.setBearerToken(bearerToken);
        this_.setAesKey(aesKey);
        this_.setMbwayPaymentMethod(mbwayPaymentMethod);
        this_.setMbwayDocumentSeries(mbwayDocumentSeries);
        this_.setMbwayActive(mbwayActive);
        this_.setNumberOfMonthsToExpirePaymentReferenceCode(numberOfMonthsToExpirePaymentReferenceCode);
    }

    public boolean isSendBillingDataInOnlinePayment() {
        return this.getSendBillingDataInOnlinePayment();
    }

    public String generateNewMerchantTransactionId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public PaymentStateBean getPaymentStatusBySibsCheckoutId(String string) throws OnlinePaymentsGatewayCommunicationException {
        return (PaymentStateBean)advice$getPaymentStatusBySibsCheckoutId.perform((Callable)new SibsOnlinePaymentsGateway$callable$getPaymentStatusBySibsCheckoutId(this, string));
    }

    static /* synthetic */ PaymentStateBean advised$getPaymentStatusBySibsCheckoutId(SibsOnlinePaymentsGateway this_, String checkoutId) throws OnlinePaymentsGatewayCommunicationException {
        SIBSOnlinePaymentsGatewayService gatewayService = this_.gatewayService();
        try {
            return gatewayService.getPaymentStatusByCheckoutId(checkoutId);
        }
        catch (OnlinePaymentsGatewayCommunicationException e) {
            throw new TreasuryDomainException((Throwable)e, "error.SibsOnlinePaymentsGateway.getPaymentStatusBySibsTransactionId.communication.error", new String[0]);
        }
    }

    public PaymentStateBean getPaymentStatusBySibsTransactionId(String string) throws OnlinePaymentsGatewayCommunicationException {
        return (PaymentStateBean)advice$getPaymentStatusBySibsTransactionId.perform((Callable)new SibsOnlinePaymentsGateway$callable$getPaymentStatusBySibsTransactionId(this, string));
    }

    static /* synthetic */ PaymentStateBean advised$getPaymentStatusBySibsTransactionId(SibsOnlinePaymentsGateway this_, String transactionId) throws OnlinePaymentsGatewayCommunicationException {
        SIBSOnlinePaymentsGatewayService gatewayService = this_.gatewayService();
        return gatewayService.getPaymentTransactionReportByTransactionId(transactionId);
    }

    public List<PaymentStateBean> getPaymentTransactionsReportListByMerchantId(String string) throws OnlinePaymentsGatewayCommunicationException {
        return (List)advice$getPaymentTransactionsReportListByMerchantId.perform((Callable)new SibsOnlinePaymentsGateway$callable$getPaymentTransactionsReportListByMerchantId(this, string));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ List advised$getPaymentTransactionsReportListByMerchantId(SibsOnlinePaymentsGateway this_, String merchantId) throws OnlinePaymentsGatewayCommunicationException {
        SIBSOnlinePaymentsGatewayService gatewayService = this_.gatewayService();
        return gatewayService.getPaymentTransactionsReportListByMerchantId(merchantId);
    }

    public CheckoutResultBean prepareCheckout(DebtAccount debtAccount, String string, BigDecimal bigDecimal, String string2, SibsBillingAddressBean sibsBillingAddressBean) throws OnlinePaymentsGatewayCommunicationException {
        return (CheckoutResultBean)advice$prepareCheckout.perform((Callable)new SibsOnlinePaymentsGateway$callable$prepareCheckout(this, debtAccount, string, bigDecimal, string2, sibsBillingAddressBean));
    }

    static /* synthetic */ CheckoutResultBean advised$prepareCheckout(SibsOnlinePaymentsGateway this_, DebtAccount debtAccount, String merchantTransactionId, BigDecimal amount, String returnUrl, SibsBillingAddressBean billingAddressBean) throws OnlinePaymentsGatewayCommunicationException {
        SIBSOnlinePaymentsGatewayService gatewayService = this_.gatewayService();
        PrepareCheckoutInputBean bean = new PrepareCheckoutInputBean(amount, merchantTransactionId, returnUrl, new DateTime(), new DateTime().plusDays(7));
        if (this_.isSendBillingDataInOnlinePayment()) {
            String customerEmail = debtAccount.getCustomer().getEmail();
            bean.fillBillingData(null, billingAddressBean.getAddressCountryCode(), billingAddressBean.getCity(), billingAddressBean.getAddress(), billingAddressBean.getZipCode(), customerEmail);
        }
        bean.setUseCreditCard(Boolean.valueOf(true));
        CheckoutResultBean resultBean = gatewayService.prepareOnlinePaymentCheckout(bean);
        return resultBean;
    }

    public MbCheckoutResultBean generateMBPaymentReference(BigDecimal bigDecimal, DateTime dateTime, DateTime dateTime2, String string) throws OnlinePaymentsGatewayCommunicationException {
        return (MbCheckoutResultBean)advice$generateMBPaymentReference.perform((Callable)new SibsOnlinePaymentsGateway$callable$generateMBPaymentReference(this, bigDecimal, dateTime, dateTime2, string));
    }

    static /* synthetic */ MbCheckoutResultBean advised$generateMBPaymentReference(SibsOnlinePaymentsGateway this_, BigDecimal amount, DateTime validFrom, DateTime validTo, String merchantTransactionId) throws OnlinePaymentsGatewayCommunicationException {
        SIBSOnlinePaymentsGatewayService gatewayService = this_.gatewayService();
        MbPrepareCheckoutInputBean inputBean = new MbPrepareCheckoutInputBean(amount, merchantTransactionId, validFrom, validTo);
        CustomerDataInputBean customerInputBean = null;
        MbCheckoutResultBean requestResult = gatewayService.generateMBPaymentReference(inputBean, customerInputBean);
        return requestResult;
    }

    public MbWayCheckoutResultBean generateMbwayReference(BigDecimal amount, String merchantTransactionId, String phoneNumber) throws OnlinePaymentsGatewayCommunicationException {
        SIBSOnlinePaymentsGatewayService gatewayService = this.gatewayService();
        MbWayPrepareCheckoutInputBean inputBean = new MbWayPrepareCheckoutInputBean(amount, merchantTransactionId, phoneNumber);
        inputBean.setAmount(amount);
        inputBean.setMerchantTransactionId(merchantTransactionId);
        inputBean.setPhoneNumber(phoneNumber);
        MbWayCheckoutResultBean mbwayCheckoutResult = gatewayService.generateMbWayPayment(inputBean, null);
        return mbwayCheckoutResult;
    }

    public PaymentStateBean handleWebhookNotificationRequest(String initializationVector, String authTag, String encryptedPayload) throws Exception {
        SIBSOnlinePaymentsGatewayService gatewayService = this.gatewayService();
        PaymentStateBean notificationBean = gatewayService.handleNotificationRequest(initializationVector, authTag, encryptedPayload);
        return notificationBean;
    }

    private SIBSOnlinePaymentsGatewayService gatewayService() {
        SIBSInitializeServiceBean initializeServiceBean = new SIBSInitializeServiceBean(this.getSibsEntityId(), this.getBearerToken(), this.getSibsEndpointUrl(), this.getPaymentCodePool().getEntityReferenceCode(), this.getPaymentCodePool().getFinantialInstitution().getCurrency().getIsoCode(), this.translateEnviromentMode());
        initializeServiceBean.setAesKey(this.getAesKey());
        SIBSOnlinePaymentsGatewayService gatewayService = OnlinePaymentServiceFactory.createSIBSOnlinePaymentGatewayService((SIBSInitializeServiceBean)initializeServiceBean);
        return gatewayService;
    }

    private SibsEnvironmentMode translateEnviromentMode() {
        if (this.getEnviromentMode() == SibsOnlinePaymentsGatewayEnviromentMode.PRODUCTION) {
            return SibsEnvironmentMode.PRODUCTION;
        }
        if (this.getEnviromentMode() == SibsOnlinePaymentsGatewayEnviromentMode.TEST_MODE_EXTERNAL) {
            return SibsEnvironmentMode.TEST_MODE_EXTERNAL;
        }
        if (this.getEnviromentMode() == SibsOnlinePaymentsGatewayEnviromentMode.TEST_MODE_INTERNAL) {
            return SibsEnvironmentMode.TEST_MODE_INTERNAL;
        }
        throw new RuntimeException("SibsOnlinePaymentsGateway.translateEnviromentMode() unkown environment mode");
    }

    public static SibsOnlinePaymentsGateway create(PaymentCodePool paymentCodePool, ForwardPaymentConfiguration forwardPaymentConfiguration, String sibsEntityId, String sibsEndpointUrl, String merchantIdPrefix, String bearerToken, String aesKey, PaymentMethod mbwayPaymentMethod, DocumentNumberSeries mbwayDocumentSeries, boolean mbwayActive) {
        return new SibsOnlinePaymentsGateway(paymentCodePool, forwardPaymentConfiguration, sibsEntityId, sibsEndpointUrl, merchantIdPrefix, bearerToken, aesKey, mbwayPaymentMethod, mbwayDocumentSeries, mbwayActive);
    }

    public static Stream<SibsOnlinePaymentsGateway> findAll() {
        return FenixFramework.getDomainRoot().getSibsOnlinePaymentsGatewaySet().stream();
    }

    public static Stream<SibsOnlinePaymentsGateway> findByMerchantIdPrefix(String merchantIdPrefix) {
        return SibsOnlinePaymentsGateway.findAll().filter(e -> merchantIdPrefix.toLowerCase().equals(e.getMerchantTransactionIdPrefix().toLowerCase()));
    }

    public static boolean isMbwayServiceActive(FinantialInstitution finantialInstitution) {
        Optional<ForwardPaymentConfiguration> optional = ForwardPaymentConfiguration.findUniqueActive(finantialInstitution);
        return optional.isPresent() && optional.get().getSibsOnlinePaymentsGateway() != null && Boolean.TRUE.equals(optional.get().getSibsOnlinePaymentsGateway().getMbwayActive());
    }
}

