/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.sibsonlinepaymentsgateway;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.onlinepaymentsgateway.api.MbWayCheckoutResultBean;
import org.fenixedu.onlinepaymentsgateway.api.PaymentStateBean;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.IPaymentProcessorForInvoiceEntries;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.MbwayPaymentRequest$callable$create;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.MbwayPaymentRequest$callable$createLog;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.MbwayPaymentRequest$callable$createMbwayPaymentRequest;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.MbwayPaymentRequest$callable$processMbwayTransaction;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.MbwayPaymentRequest$callable$processPayment;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.MbwayPaymentRequest_Base;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.MbwayTransaction;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGateway;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGatewayLog;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class MbwayPaymentRequest
extends MbwayPaymentRequest_Base
implements IPaymentProcessorForInvoiceEntries {
    public static final Advice advice$processPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$processMbwayTransaction = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
    public static final Advice advice$createMbwayPaymentRequest = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$createLog = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    public MbwayPaymentRequest() {
        this.setCreationDate(new DateTime());
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected MbwayPaymentRequest(SibsOnlinePaymentsGateway sibsOnlinePaymentsGateway, DebtAccount debtAccount, Set<InvoiceEntry> invoiceEntries, BigDecimal payableAmount, String phoneNumber, String sibsMerchantTransactionId, String sibsReferenceId) {
        this();
        this.setSibsOnlinePaymentsGateway(sibsOnlinePaymentsGateway);
        this.setDebtAccount(debtAccount);
        this.getInvoiceEntriesSet().addAll(invoiceEntries);
        this.setPayableAmount(payableAmount);
        this.setPhoneNumber(phoneNumber);
        this.setSibsMerchantTransactionId(sibsMerchantTransactionId);
        this.setSibsReferenceId(sibsReferenceId);
        this.setState(PaymentReferenceCodeStateType.USED);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.domainRoot.required", new String[0]);
        }
        if (this.getCreationDate() == null) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.creationDate.required", new String[0]);
        }
        if (this.getSibsOnlinePaymentsGateway() == null) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.sibsOnlinePaymentsGateway.required", new String[0]);
        }
        if (this.getDebtAccount() == null) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.debtAccount.required", new String[0]);
        }
        if (this.getInvoiceEntriesSet().isEmpty()) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.invoiceEntriesSet.required", new String[0]);
        }
        if (this.getPayableAmount() == null || !TreasuryConstants.isPositive(this.getPayableAmount())) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.payableAmount.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getPhoneNumber())) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phoneNumber.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getSibsMerchantTransactionId())) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.sibsMerchantTransaction.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)this.getSibsReferenceId())) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.sibsReferenceId.required", new String[0]);
        }
        if (MbwayPaymentRequest.findBySibsMerchantTransactionId(this.getSibsMerchantTransactionId()).count() > 1L) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.sibsMerchantTransactionId.not.unique", new String[0]);
        }
        if (MbwayPaymentRequest.findBySibsReferenceId(this.getSibsReferenceId()).count() > 1L) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.sibsReferenceId.not.unique", new String[0]);
        }
        MbwayPaymentRequest.checkParametersAreValid(this.getDebtAccount(), this.getInvoiceEntriesSet());
    }

    @Override
    public Set<SettlementNote> internalProcessPaymentInNormalPaymentMixingLegacyInvoices(String username, BigDecimal amount, DateTime paymentDate, String sibsTransactionId, String comments, Set<InvoiceEntry> invoiceEntriesToPay) {
        Set<SettlementNote> result = IPaymentProcessorForInvoiceEntries.super.internalProcessPaymentInNormalPaymentMixingLegacyInvoices(username, amount, paymentDate, sibsTransactionId, comments, invoiceEntriesToPay);
        this.setState(PaymentReferenceCodeStateType.PROCESSED);
        return result;
    }

    @Override
    public Set<SettlementNote> internalProcessPaymentInRestrictedPaymentMixingLegacyInvoices(String username, BigDecimal amount, DateTime paymentDate, String sibsTransactionId, String comments, Set<InvoiceEntry> invoiceEntriesToPay) {
        Set<SettlementNote> result = IPaymentProcessorForInvoiceEntries.super.internalProcessPaymentInRestrictedPaymentMixingLegacyInvoices(username, amount, paymentDate, sibsTransactionId, comments, invoiceEntriesToPay);
        this.setState(PaymentReferenceCodeStateType.PROCESSED);
        return result;
    }

    private Set<SettlementNote> processPayment(String string, BigDecimal bigDecimal, DateTime dateTime, String string2, String string3) {
        return (Set)advice$processPayment.perform((Callable)new MbwayPaymentRequest$callable$processPayment(this, string, bigDecimal, dateTime, string2, string3));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ Set advised$processPayment(MbwayPaymentRequest this_, String username, BigDecimal amount, DateTime paymentDate, String sibsTransactionId, String comments) {
        if (!TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices()) {
            return this_.internalProcessPaymentInNormalPaymentMixingLegacyInvoices(username, amount, paymentDate, sibsTransactionId, comments, this_.getInvoiceEntriesSet());
        }
        return this_.internalProcessPaymentInRestrictedPaymentMixingLegacyInvoices(username, amount, paymentDate, sibsTransactionId, comments, this_.getInvoiceEntriesSet());
    }

    public void processMbwayTransaction(SibsOnlinePaymentsGatewayLog sibsOnlinePaymentsGatewayLog, PaymentStateBean paymentStateBean) {
        Object object = advice$processMbwayTransaction.perform((Callable)new MbwayPaymentRequest$callable$processMbwayTransaction(this, sibsOnlinePaymentsGatewayLog, paymentStateBean));
    }

    static /* synthetic */ void advised$processMbwayTransaction(MbwayPaymentRequest this_, SibsOnlinePaymentsGatewayLog log, PaymentStateBean bean) {
        if (!bean.getMerchantTransactionId().equals(this_.getSibsMerchantTransactionId())) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.processMbwayTransaction.merchantTransactionId.not.equal", new String[0]);
        }
        FenixFramework.atomic(() -> {
            SibsOnlinePaymentsGateway sibsOnlinePaymentsGateway = this.getSibsOnlinePaymentsGateway();
            DebtAccount debtAccount = this.getDebtAccount();
            log.associateSibsOnlinePaymentGatewayAndDebtAccount(sibsOnlinePaymentsGateway, debtAccount);
        });
        BigDecimal amount = bean.getAmount();
        DateTime paymentDate = bean.getPaymentDate();
        FenixFramework.atomic(() -> log.savePaymentInfo(amount, paymentDate));
        if (amount == null || !TreasuryConstants.isPositive(amount)) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.processMbwayTransaction.invalid.amount", new String[0]);
        }
        if (paymentDate == null) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.processMbwayTransaction.invalid.payment.date", new String[0]);
        }
        if (MbwayTransaction.isTransactionProcessingDuplicate(bean.getTransactionId())) {
            FenixFramework.atomic(() -> log.markAsDuplicatedTransaction());
        } else {
            FenixFramework.atomic(() -> {
                String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
                Set<SettlementNote> settlementNotes = this.processPayment(StringUtils.isNotEmpty((String)loggedUsername) ? loggedUsername : "unknown", amount, paymentDate, bean.getTransactionId(), bean.getMerchantTransactionId());
                MbwayTransaction.create(this, bean.getTransactionId(), amount, paymentDate, settlementNotes);
                log.markSettlementNotesCreated(settlementNotes);
            });
        }
    }

    @Override
    public DocumentNumberSeries getDocumentSeriesForPayments() {
        return this.getSibsOnlinePaymentsGateway().getMbwayDocumentSeries();
    }

    @Override
    public DocumentNumberSeries getDocumentSeriesInterestDebits() {
        return DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), this.getDocumentSeriesForPayments().getSeries());
    }

    @Override
    public Map<String, String> fillPaymentEntryPropertiesMap(String sibsTransactionId) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("SibsTransactionId", sibsTransactionId);
        return result;
    }

    @Override
    public Set<Customer> getReferencedCustomers() {
        return IPaymentProcessorForInvoiceEntries.getReferencedCustomers(this.getInvoiceEntriesSet());
    }

    @Override
    public PaymentMethod getPaymentMethod() {
        return this.getSibsOnlinePaymentsGateway().getMbwayPaymentMethod();
    }

    @Override
    public String fillPaymentEntryMethodId() {
        return "";
    }

    public static MbwayPaymentRequest create(SibsOnlinePaymentsGateway sibsOnlinePaymentsGateway, DebtAccount debtAccount, Set<InvoiceEntry> set, String string, String string2) {
        return (MbwayPaymentRequest)advice$create.perform((Callable)new MbwayPaymentRequest$callable$create(sibsOnlinePaymentsGateway, debtAccount, set, string, string2));
    }

    static /* synthetic */ MbwayPaymentRequest advised$create(SibsOnlinePaymentsGateway sibsOnlinePaymentsGateway, DebtAccount debtAccount, Set<InvoiceEntry> invoiceEntries, String countryPrefix, String localPhoneNumber) {
        if (!SibsOnlinePaymentsGateway.isMbwayServiceActive(debtAccount.getFinantialInstitution())) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.not.active", new String[0]);
        }
        MbwayPaymentRequest.checkParametersAreValid(debtAccount, invoiceEntries);
        if (StringUtils.isEmpty((String)countryPrefix)) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.countryPrefix.required", new String[0]);
        }
        if (StringUtils.isEmpty((String)localPhoneNumber)) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.required", new String[0]);
        }
        if (!countryPrefix.matches("\\d+")) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.countryPrefix.number.format.required", new String[0]);
        }
        if (!localPhoneNumber.matches("\\d+")) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.phone.number.format.required", new String[0]);
        }
        String phoneNumber = String.format("%s#%s", countryPrefix, localPhoneNumber);
        if (!Boolean.TRUE.equals(sibsOnlinePaymentsGateway.getForwardPaymentConfiguration().isActive())) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.forwardPaymentConfiguration.not.active", new String[0]);
        }
        BigDecimal payableAmount = invoiceEntries.stream().map(e -> e.getOpenAmountWithInterests()).reduce(BigDecimal.ZERO, BigDecimal::add);
        String merchantTransactionId = sibsOnlinePaymentsGateway.generateNewMerchantTransactionId();
        SibsOnlinePaymentsGatewayLog log = MbwayPaymentRequest.createLog(sibsOnlinePaymentsGateway, debtAccount);
        try {
            FenixFramework.atomic(() -> {
                log.saveMerchantTransactionId(merchantTransactionId);
                log.logRequestSendDate();
            });
            MbWayCheckoutResultBean checkoutResultBean = sibsOnlinePaymentsGateway.generateMbwayReference(payableAmount, merchantTransactionId, phoneNumber);
            String sibsReferenceId = checkoutResultBean.getTransactionId();
            FenixFramework.atomic(() -> {
                log.logRequestReceiveDateAndData(checkoutResultBean.getTransactionId(), checkoutResultBean.isOperationSuccess(), false, checkoutResultBean.getPaymentGatewayResultCode(), checkoutResultBean.getOperationResultDescription());
                log.saveRequestAndResponsePayload(checkoutResultBean.getRequestLog(), checkoutResultBean.getResponseLog());
            });
            if (!checkoutResultBean.isOperationSuccess()) {
                throw new TreasuryDomainException("error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor.request.not.successful", new String[0]);
            }
            return MbwayPaymentRequest.createMbwayPaymentRequest(sibsOnlinePaymentsGateway, debtAccount, invoiceEntries, phoneNumber, payableAmount, merchantTransactionId, sibsReferenceId);
        }
        catch (Exception e2) {
            boolean isOnlinePaymentsGatewayException = e2 instanceof OnlinePaymentsGatewayCommunicationException;
            FenixFramework.atomic(() -> {
                log.logRequestReceiveDateAndData(null, false, false, null, null);
                log.markExceptionOccuredAndSaveLog(e2);
                if (isOnlinePaymentsGatewayException) {
                    log.saveRequestAndResponsePayload(((OnlinePaymentsGatewayCommunicationException)e2).getRequestLog(), ((OnlinePaymentsGatewayCommunicationException)e2).getResponseLog());
                }
            });
            if (e2 instanceof TreasuryDomainException) {
                throw (TreasuryDomainException)((Object)e2);
            }
            String message = "error.SibsOnlinePaymentsGatewayPaymentCodeGenerator.generateNewCodeFor." + (isOnlinePaymentsGatewayException ? "gateway.communication" : "unknown");
            throw new TreasuryDomainException((Throwable)e2, message, new String[0]);
        }
    }

    private static void checkParametersAreValid(DebtAccount debtAccount, Set<InvoiceEntry> invoiceEntries) {
        for (InvoiceEntry invoiceEntry : invoiceEntries) {
            DebitEntry debitEntry = (DebitEntry)((Object)invoiceEntry);
            if (debitEntry.getDebtAccount() != debtAccount) {
                throw new TreasuryDomainException("error.MbwayPaymentRequest.debit.entry.not.same.debt.account", new String[0]);
            }
            if (TreasuryConstants.isGreaterThan(debitEntry.getOpenAmount(), BigDecimal.ZERO)) continue;
            throw new TreasuryDomainException("error.MbwayPaymentRequest.debit.entry.open.amount.must.be.greater.than.zero", new String[0]);
        }
        if (IPaymentProcessorForInvoiceEntries.getReferencedCustomers(invoiceEntries).size() > 1) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.referencedCustomers.only.one.allowed", new String[0]);
        }
        SettlementNote.checkMixingOfInvoiceEntriesExportedInLegacyERP(invoiceEntries);
    }

    private static MbwayPaymentRequest createMbwayPaymentRequest(SibsOnlinePaymentsGateway sibsOnlinePaymentsGateway, DebtAccount debtAccount, Set<InvoiceEntry> set, String string, BigDecimal bigDecimal, String string2, String string3) {
        return (MbwayPaymentRequest)advice$createMbwayPaymentRequest.perform((Callable)new MbwayPaymentRequest$callable$createMbwayPaymentRequest(sibsOnlinePaymentsGateway, debtAccount, set, string, bigDecimal, string2, string3));
    }

    static /* synthetic */ MbwayPaymentRequest advised$createMbwayPaymentRequest(SibsOnlinePaymentsGateway sibsOnlinePaymentsGateway, DebtAccount debtAccount, Set<InvoiceEntry> invoiceEntries, String phoneNumber, BigDecimal payableAmount, String merchantTransactionId, String sibsReferenceId) {
        return new MbwayPaymentRequest(sibsOnlinePaymentsGateway, debtAccount, invoiceEntries, payableAmount, phoneNumber, merchantTransactionId, sibsReferenceId);
    }

    private static SibsOnlinePaymentsGatewayLog createLog(SibsOnlinePaymentsGateway sibsOnlinePaymentsGateway, DebtAccount debtAccount) {
        return (SibsOnlinePaymentsGatewayLog)((Object)advice$createLog.perform((Callable)new MbwayPaymentRequest$callable$createLog(sibsOnlinePaymentsGateway, debtAccount)));
    }

    static /* synthetic */ SibsOnlinePaymentsGatewayLog advised$createLog(SibsOnlinePaymentsGateway sibsGateway, DebtAccount debtAccount) {
        return SibsOnlinePaymentsGatewayLog.createLogForRequestPaymentCode(sibsGateway, debtAccount);
    }

    public static Stream<MbwayPaymentRequest> findAll() {
        return FenixFramework.getDomainRoot().getMbwayPaymentRequestsSet().stream();
    }

    public static Stream<MbwayPaymentRequest> findBySibsMerchantTransactionId(String sibsMerchantTransactionId) {
        return MbwayPaymentRequest.findAll().filter(r -> r.getSibsMerchantTransactionId().equals(sibsMerchantTransactionId));
    }

    public static Stream<MbwayPaymentRequest> findBySibsReferenceId(String sibsReferenceId) {
        return MbwayPaymentRequest.findAll().filter(r -> r.getSibsReferenceId().equals(sibsReferenceId));
    }

    public static Optional<MbwayPaymentRequest> findUniqueBySibsReferenceId(String sibsReferenceId) {
        return MbwayPaymentRequest.findBySibsReferenceId(sibsReferenceId).findFirst();
    }

    public static Optional<MbwayPaymentRequest> findUniqueBySibsMerchantTransactionId(String sibsMerchantTransactionId) {
        return MbwayPaymentRequest.findBySibsMerchantTransactionId(sibsMerchantTransactionId).findFirst();
    }
}

