/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.SibsOutputFile$CalculatePaymentCodes$callable$run;
import org.fenixedu.treasury.domain.paymentcodes.SibsOutputFile$CalculatePaymentCodes$callable$txDo;
import org.fenixedu.treasury.domain.paymentcodes.SibsOutputFile$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.SibsOutputFile$callable$edit;
import org.fenixedu.treasury.domain.paymentcodes.SibsOutputFile_Base;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.payments.sibs.outgoing.SibsOutgoingPaymentFile;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsOutputFile
extends SibsOutputFile_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "text/plain";
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public SibsOutputFile() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
    }

    public static SibsOutputFile create(FinantialInstitution finantialInstitution, DateTime lastSuccessfulSentDateTime) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        SibsOutputFile file = new SibsOutputFile();
        try {
            StringBuilder errorsBuilder = new StringBuilder();
            byte[] paymentFileContents = file.createPaymentFile(finantialInstitution, lastSuccessfulSentDateTime, errorsBuilder).getBytes("ASCII");
            services.createFile(file, file.outgoingFilename(), CONTENT_TYPE, paymentFileContents);
            file.setFinantialInstitution(finantialInstitution);
            file.setLastSuccessfulExportation(lastSuccessfulSentDateTime);
            file.setErrorLog(errorsBuilder.toString());
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder();
            builder.append(e.getLocalizedMessage()).append("\n");
            for (StackTraceElement el : e.getStackTrace()) {
                builder.append(el.toString()).append("\n");
            }
            services.createFile(file, file.outgoingFilename(), CONTENT_TYPE, new byte[0]);
            file.setFinantialInstitution(finantialInstitution);
            file.setLastSuccessfulExportation(lastSuccessfulSentDateTime);
            file.setErrorLog(builder.toString());
        }
        return file;
    }

    protected String createPaymentFile(FinantialInstitution finantialInstiution, DateTime lastSuccessfulSentDateTime, StringBuilder errorsBuilder) {
        SibsOutgoingPaymentFile sibsOutgoingPaymentFile = new SibsOutgoingPaymentFile(finantialInstiution.getSibsConfiguration().getSourceInstitutionId(), finantialInstiution.getSibsConfiguration().getDestinationInstitutionId(), finantialInstiution.getSibsConfiguration().getEntityReferenceCode(), lastSuccessfulSentDateTime);
        for (PaymentReferenceCode referenceCode : this.getNotPayedReferenceCodes(finantialInstiution, errorsBuilder)) {
            this.addCalculatedPaymentCodesFromEvent(sibsOutgoingPaymentFile, referenceCode, errorsBuilder);
        }
        this.invalidateOldPaymentCodes(sibsOutgoingPaymentFile, finantialInstiution, errorsBuilder);
        return sibsOutgoingPaymentFile.render();
    }

    private Set<PaymentReferenceCode> getNotPayedReferenceCodes(FinantialInstitution finantialInstitution, StringBuilder errorsBuilder) {
        HashSet<PaymentReferenceCode> result = new HashSet<PaymentReferenceCode>();
        for (PaymentCodePool pool : finantialInstitution.getPaymentCodePoolsSet()) {
            List<PaymentReferenceCode> paymentCodesToExport = pool.getPaymentCodesToExport(new LocalDate());
            result.addAll(paymentCodesToExport);
        }
        return result;
    }

    private void invalidateOldPaymentCodes(SibsOutgoingPaymentFile sibsOutgoingPaymentFile, FinantialInstitution finantialInstitution, StringBuilder errorsBuilder) {
        HashSet<PaymentReferenceCode> result = new HashSet<PaymentReferenceCode>();
        for (PaymentCodePool pool : finantialInstitution.getPaymentCodePoolsSet()) {
            if (!pool.getInvalidateAnnuledCodesInSibsOutputFiles()) continue;
            List<PaymentReferenceCode> paymentCodesToExport = pool.getAnnulledPaymentCodesToExport(new LocalDate());
            for (PaymentReferenceCode oldCode : paymentCodesToExport) {
                sibsOutgoingPaymentFile.addLine(oldCode.getReferenceCode(), BigDecimal.valueOf(0.01), BigDecimal.valueOf(0.01), new DateTime().minusDays(5).toLocalDate(), new DateTime().minusDays(5).toLocalDate());
            }
            result.addAll(paymentCodesToExport);
        }
    }

    protected void addPaymentCode(SibsOutgoingPaymentFile file, PaymentReferenceCode paymentCode, StringBuilder errorsBuilder) {
        try {
            file.addAssociatedPaymentCode(paymentCode);
            file.addLine(paymentCode.getReferenceCode(), paymentCode.getMinAmount(), paymentCode.getMaxAmount(), paymentCode.getBeginDate(), paymentCode.getEndDate());
        }
        catch (Throwable e) {
            this.appendToErrors(errorsBuilder, paymentCode.getExternalId(), e);
        }
    }

    private void appendToErrors(StringBuilder errorsBuilder, String externalId, Throwable e) {
        errorsBuilder.append("Error in : " + externalId + "-" + e.getLocalizedMessage()).append("\n");
        this.setErrorLog(errorsBuilder.toString());
    }

    protected void addCalculatedPaymentCodesFromEvent(SibsOutgoingPaymentFile file, PaymentReferenceCode referenceCode, StringBuilder errorsBuilder) {
        try {
            CalculatePaymentCodes thread = new CalculatePaymentCodes(referenceCode.getExternalId(), errorsBuilder, file);
            thread.start();
            thread.join();
        }
        catch (Throwable e) {
            this.appendToErrors(errorsBuilder, referenceCode.getExternalId(), e);
        }
    }

    private String outgoingFilename() {
        return String.format("SIBS-%s.txt", new DateTime().toString("dd-MM-yyyy_H_m_s"));
    }

    @Override
    public boolean isAccessible(String username) {
        return true;
    }

    protected void init(FinantialInstitution finantialInstitution, String errorLog, String infoLog, String printedPaymentCodes) {
        this.setFinantialInstitution(finantialInstitution);
        this.setErrorLog(errorLog);
        this.setInfoLog(infoLog);
        this.setPrintedPaymentCodes(printedPaymentCodes);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.SibsOutputFile.finantialInstitution.required", new String[0]);
        }
    }

    public void edit(FinantialInstitution finantialInstitution, String string, String string2, String string3) {
        Object object = advice$edit.perform((Callable)new SibsOutputFile$callable$edit(this, finantialInstitution, string, string2, string3));
    }

    static /* synthetic */ void advised$edit(SibsOutputFile this_, FinantialInstitution finantialInstitution, String errorLog, String infoLog, String printedPaymentCodes) {
        this_.setFinantialInstitution(finantialInstitution);
        this_.setErrorLog(errorLog);
        this_.setInfoLog(infoLog);
        this_.setPrintedPaymentCodes(printedPaymentCodes);
        this_.checkRules();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    @Override
    public void delete() {
        Object object = advice$delete.perform((Callable)new SibsOutputFile$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(SibsOutputFile this_) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        TreasuryDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        this_.setFinantialInstitution(null);
        this_.setDomainRoot(null);
        services.deleteFile(this_);
        super.deleteDomainObject();
    }

    public static Stream<SibsOutputFile> findAll() {
        return FenixFramework.getDomainRoot().getSibsOutputFilesSet().stream();
    }

    public static Stream<SibsOutputFile> findByFinantialInstitution(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getSibsOutputFilesSet().stream();
    }

    public static Stream<SibsOutputFile> findByErrorLog(String errorLog) {
        return SibsOutputFile.findAll().filter(i -> errorLog.equalsIgnoreCase(i.getErrorLog()));
    }

    public static Stream<SibsOutputFile> findByInfoLog(String infoLog) {
        return SibsOutputFile.findAll().filter(i -> infoLog.equalsIgnoreCase(i.getInfoLog()));
    }

    private class CalculatePaymentCodes
    extends Thread {
        private final String paymentReferenceCodeId;
        private final StringBuilder errorsBuilder;
        private final SibsOutgoingPaymentFile sibsFile;
        public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        public static final Advice advice$txDo = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

        public CalculatePaymentCodes(String paymentReferenceCodeId, StringBuilder errorsBuilder, SibsOutgoingPaymentFile sibsFile) {
            this.paymentReferenceCodeId = paymentReferenceCodeId;
            this.errorsBuilder = errorsBuilder;
            this.sibsFile = sibsFile;
        }

        @Override
        public void run() {
            Object object = advice$run.perform((Callable)new SibsOutputFile$CalculatePaymentCodes$callable$run(this));
        }

        static /* synthetic */ void advised$run(CalculatePaymentCodes this_) {
            try {
                this_.txDo();
            }
            catch (Throwable e) {
                this_.SibsOutputFile.this.appendToErrors(this_.errorsBuilder, this_.paymentReferenceCodeId, e);
            }
        }

        private void txDo() {
            Object object = advice$txDo.perform((Callable)new SibsOutputFile$CalculatePaymentCodes$callable$txDo(this));
        }

        static /* synthetic */ void advised$txDo(CalculatePaymentCodes this_) {
            PaymentReferenceCode referenceCode = (PaymentReferenceCode)FenixFramework.getDomainObject((String)this_.paymentReferenceCodeId);
            this_.sibsFile.addAssociatedPaymentCode(referenceCode);
            this_.sibsFile.addLine(referenceCode.getReferenceCode(), referenceCode.getMinAmount(), referenceCode.getMaxAmount(), referenceCode.getBeginDate(), referenceCode.getEndDate());
        }
    }
}

