/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile$callable$create;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile$callable$createSibsInputFile;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.SibsInputFile_Base;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.payments.sibs.incomming.SibsIncommingPaymentFile;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsInputFile
extends SibsInputFile_Base
implements IGenericFile {
    public static final String CONTENT_TYPE = "text/plain";
    public static final Comparator<SibsInputFile> COMPARATOR_BY_DATE;
    public static final Advice advice$delete;
    public static final Advice advice$create;
    public static final Advice advice$createSibsInputFile;

    protected SibsInputFile() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
        this.setCreationDate(new DateTime());
    }

    protected SibsInputFile(FinantialInstitution finantialInstitution, DateTime whenProcessedBySIBS, String displayName, String filename, byte[] content, String uploader) {
        this();
        this.init(finantialInstitution, whenProcessedBySIBS, displayName, filename, content, uploader);
    }

    protected void init(FinantialInstitution finantialInstitution, DateTime whenProcessedBySIBS, String displayName, String filename, byte[] content, String uploader) {
        TreasuryPlataformDependentServicesFactory.implementation().createFile(this, filename, CONTENT_TYPE, content);
        this.setWhenProcessedBySibs(whenProcessedBySIBS);
        this.setUploaderUsername(uploader);
        this.setFinantialInstitution(finantialInstitution);
        this.checkRules();
    }

    private void checkRules() {
    }

    public boolean isDeletable() {
        return true;
    }

    @Override
    public void delete() {
        Object object = advice$delete.perform((Callable)new SibsInputFile$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(SibsInputFile this_) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.SibsInputFile.cannot.delete", new String[0]);
        }
        this_.setDomainRoot(null);
        this_.setFinantialInstitution(null);
        services.deleteFile(this_);
        super.deleteDomainObject();
    }

    public static SibsInputFile create(FinantialInstitution finantialInstitution, DateTime dateTime, String string, String string2, byte[] byArray, String string3) {
        return (SibsInputFile)advice$create.perform((Callable)new SibsInputFile$callable$create(finantialInstitution, dateTime, string, string2, byArray, string3));
    }

    static /* synthetic */ SibsInputFile advised$create(FinantialInstitution finantialInstitution, DateTime whenProcessedBySIBS, String displayName, String filename, byte[] content, String uploader) {
        return new SibsInputFile(finantialInstitution, whenProcessedBySIBS, displayName, filename, content, uploader);
    }

    public static SibsInputFile createSibsInputFile(DateTime dateTime, String string, String string2, byte[] byArray) {
        return (SibsInputFile)advice$createSibsInputFile.perform((Callable)new SibsInputFile$callable$createSibsInputFile(dateTime, string, string2, byArray));
    }

    static /* synthetic */ SibsInputFile advised$createSibsInputFile(DateTime whenProcessedBySibs, String originalSibsFilename, String sibsName, byte[] sibsContent) {
        PaymentCodePool pool = null;
        try {
            String entityCode;
            SibsIncommingPaymentFile file = SibsIncommingPaymentFile.parse(originalSibsFilename, sibsContent);
            if (file.getHeader().getWhenProcessedBySibs().toDateTimeAtMidnight().compareTo((ReadableInstant)whenProcessedBySibs) != 0) {
                whenProcessedBySibs = file.getHeader().getWhenProcessedBySibs().toDateTimeAtMidnight();
            }
            if ((pool = (PaymentCodePool)PaymentCodePool.findByEntityCode(entityCode = file.getHeader().getEntityCode()).findFirst().orElse(null)) == null) {
                throw new TreasuryDomainException("label.error.administration.payments.sibs.managesibsinputfile.error.in.sibs.inputfile.poolNull", entityCode);
            }
            String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
            SibsInputFile sibsInputFile = SibsInputFile.create(pool.getFinantialInstitution(), whenProcessedBySibs, sibsName, originalSibsFilename, sibsContent, loggedUsername);
            return sibsInputFile;
        }
        catch (RuntimeException ex) {
            throw new TreasuryDomainException("label.error.administration.payments.sibs.managesibsinputfile.error.in.sibs.inputfile", ex.getLocalizedMessage());
        }
    }

    public static Stream<SibsInputFile> findAll() {
        return FenixFramework.getDomainRoot().getSibsInputFilesSet().stream();
    }

    @Override
    public boolean isAccessible(String username) {
        return TreasuryAccessControlAPI.isBackOfficeMember(username, this.getFinantialInstitution());
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createSibsInputFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_DATE = (o1, o2) -> {
            int c = o1.getCreationDate().compareTo((ReadableInstant)o2.getCreationDate());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
    }
}

