/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments.implementations;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.URL;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment;
import org.fenixedu.treasury.domain.forwardpayments.implementations.MapUtil;
import org.fenixedu.treasury.domain.forwardpayments.implementations.TPAVirtualImplementation;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.joda.time.DateTime;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TPAInvocationUtil {
    private ForwardPayment forwardPayment;
    private static final Map<String, PropInfo> propsInfo = Maps.newHashMap();
    private static final List<String> INNER_REPONSE_NODES;

    public TPAInvocationUtil(ForwardPayment forwardPayment) {
        this.forwardPayment = forwardPayment;
    }

    public Map<String, String> mapAuthenticationRequest() {
        TPAVirtualImplementation implementation = (TPAVirtualImplementation)this.forwardPayment.getForwardPaymentConfiguration().implementation();
        LinkedHashMap params = Maps.newLinkedHashMap();
        params.put("A030", this.padding("H3D0", 4));
        params.put("A001", this.padding(this.forwardPayment.getForwardPaymentConfiguration().getVirtualTPAId(), 9));
        params.put("C007", this.padding(this.forwardPayment.getReferenceNumber(), 15));
        params.put("A105", this.padding("9782", 4));
        params.put("A061", this.padding(this.forwardPayment.getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(this.forwardPayment.getAmount()).toString(), 8));
        params.put("C046", "");
        params.put("C012", implementation.getReturnURL(this.forwardPayment));
        String c013 = this.hmacsha1(params);
        params.put("C013", c013);
        return params;
    }

    public Map<String, String> postAuthorizationRequest(LinkedHashMap<String, String> requestMap) {
        LinkedHashMap params = Maps.newLinkedHashMap();
        params.put("A030", "M001");
        params.put("A001", this.padding(this.forwardPayment.getForwardPaymentConfiguration().getVirtualTPAId(), 9));
        params.put("C007", this.padding(this.forwardPayment.getReferenceNumber(), 15));
        params.put("A061", this.padding(this.forwardPayment.getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(this.forwardPayment.getAmount()).toString(), 8));
        params.put("A105", this.padding("9782", 4));
        String c013 = this.hmacsha1(params);
        params.put("C013", c013);
        requestMap.putAll(params);
        return this.post(params, true);
    }

    public Map<String, String> postPaymentStatus(LinkedHashMap<String, String> requestData) {
        LinkedHashMap params = Maps.newLinkedHashMap();
        params.put("A030", "M020");
        params.put("A001", this.padding(this.forwardPayment.getForwardPaymentConfiguration().getVirtualTPAId(), 9));
        params.put("C007", this.padding(this.forwardPayment.getReferenceNumber(), 15));
        String c013 = this.hmacsha1(params);
        params.put("C013", c013);
        requestData.putAll(params);
        return this.post(params, true);
    }

    public Map<String, String> postPayment(DateTime authorizationDate, LinkedHashMap<String, String> requestData) {
        LinkedHashMap params = Maps.newLinkedHashMap();
        params.put("A030", "M002");
        params.put("A001", this.padding(this.forwardPayment.getForwardPaymentConfiguration().getVirtualTPAId(), 9));
        params.put("C007", this.padding(this.forwardPayment.getReferenceNumber(), 15));
        params.put("A061", this.padding(this.forwardPayment.getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(this.forwardPayment.getAmount()).toString(), 8));
        params.put("A105", this.padding("9782", 4));
        params.put("A037", authorizationDate.toString("yyyyMMddHHmmss"));
        String c013 = this.hmacsha1(params);
        params.put("C013", c013);
        requestData.putAll(params);
        return this.post(params, true);
    }

    private Map<String, String> post(LinkedHashMap<String, String> params, boolean isXml) {
        try {
            String strLine;
            URL url = new URL(this.forwardPayment.getForwardPaymentConfiguration().getVirtualTPAMOXXURL());
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            try {
                connection.setSSLSocketFactory(this.getFactory());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(512);
            PrintWriter out = new PrintWriter(byteStream, true);
            out.print(this.httpsParams(params));
            out.flush();
            String lengthString = String.valueOf(byteStream.size());
            connection.setRequestProperty("Content-Length", lengthString);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("Content-Language", "pt-PT");
            byteStream.writeTo(connection.getOutputStream());
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String strResult = "";
            while ((strLine = in.readLine()) != null) {
                strResult = strResult + strLine;
            }
            in.close();
            return this.convertStringToMap(strResult, isXml);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String padding(String str, int length) {
        boolean paddingLeft = true;
        char paddingChar = '0';
        if (str == null) {
            return "";
        }
        if (str.length() > length) {
            throw new RuntimeException("length exceeded");
        }
        String strToPadding = "";
        for (int i = 0; i != length - str.length(); ++i) {
            strToPadding = strToPadding + paddingChar;
        }
        if (paddingLeft) {
            return strToPadding + str;
        }
        return str + strToPadding;
    }

    private Map<String, String> convertStringToMap(String strResult, boolean isXml) {
        HashMap result = Maps.newHashMap();
        if (isXml) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = factory.newDocumentBuilder();
                InputSource inputSource = new InputSource(new StringReader(strResult));
                Document document = documentBuilder.parse(inputSource);
                NodeList nodeList = document.getChildNodes().item(0).getChildNodes();
                this.getXMLResponseNodeValues(result, nodeList);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            String[] keyValues;
            for (String kv : keyValues = strResult.split("&")) {
                String[] kvS = kv.split("=");
                if (kvS.length != 2) continue;
                result.put(kvS[0].trim(), kvS[1].trim());
            }
        }
        return result;
    }

    private void getXMLResponseNodeValues(Map<String, String> result, NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (propsInfo.keySet().contains(node.getNodeName())) {
                result.put(node.getNodeName(), nodeList.item(i).getTextContent());
                continue;
            }
            if (!INNER_REPONSE_NODES.contains(node.getNodeName())) continue;
            this.getXMLResponseNodeValues(result, node.getChildNodes());
        }
    }

    private boolean isForms(String strResult) {
        return true;
    }

    private boolean isXml(String strResult) {
        return false;
    }

    private String httpsParams(Map<String, String> params) {
        String paramsStr = MapUtil.mapToString(params);
        return paramsStr;
    }

    private SSLSocketFactory getFactory() throws Exception {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        String pKeyPassword = this.forwardPayment.getForwardPaymentConfiguration().getVirtualTPACertificatePassword();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        InputStream keyInput = services.getFileStream(this.forwardPayment.getForwardPaymentConfiguration().getVirtualTPACertificate());
        keyStore.load(keyInput, pKeyPassword.toCharArray());
        keyInput.close();
        keyManagerFactory.init(keyStore, pKeyPassword.toCharArray());
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
        return context.getSocketFactory();
    }

    public String hmacsha1(LinkedHashMap<String, String> params) {
        String strMensagemASCII = "";
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String strFieldResquestName = entry.getKey();
            String strFieldResquestValue = entry.getValue();
            if ("A061".equals(strFieldResquestName)) {
                strFieldResquestValue = strFieldResquestValue.replace("\\.", "");
            }
            String strFieldResquestType = propsInfo.get(strFieldResquestName).t;
            int intFieldResquestSize = propsInfo.get(strFieldResquestName).s;
            String strValueFieldResquestPadded = "";
            if ("N".equals(strFieldResquestType)) {
                strFieldResquestValue = strFieldResquestValue.replace(".", "");
                strValueFieldResquestPadded = this.padding(strFieldResquestValue, intFieldResquestSize);
            } else {
                strValueFieldResquestPadded = strFieldResquestValue.trim();
            }
            strMensagemASCII = strMensagemASCII + strValueFieldResquestPadded;
        }
        HMac hmac = new HMac((Digest)new SHA1Digest());
        hmac.init((CipherParameters)new KeyParameter(this.forwardPayment.getForwardPaymentConfiguration().getVirtualTPAMerchantId().getBytes()));
        hmac.update(strMensagemASCII.getBytes(), 0, strMensagemASCII.getBytes().length);
        byte[] resBuf = new byte[hmac.getMacSize()];
        hmac.doFinal(resBuf, 0);
        return new String(Hex.encode((byte[])resBuf));
    }

    private int[] sha1(int[] arrMessage) {
        if (arrMessage == null) {
            return null;
        }
        try {
            MessageDigest objMessageDigest = MessageDigest.getInstance("SHA1");
            byte[] arrBytes = new byte[arrMessage.length];
            for (int i = 0; i != arrMessage.length; ++i) {
                arrBytes[i] = (byte)arrMessage[i];
            }
            objMessageDigest.update(arrBytes);
            byte[] arrBytesSHA = objMessageDigest.digest();
            int[] arrInts = new int[arrBytesSHA.length];
            int i = 0;
            while (i != arrBytesSHA.length) {
                int n = i++;
                arrBytesSHA[n] = (byte)(arrBytesSHA[n] & 0xFF);
            }
            return arrInts;
        }
        catch (Exception e) {
            System.out.println("calcSHA1():: " + e.getMessage());
            return null;
        }
    }

    static {
        propsInfo.put("A001", new PropInfo("N", 9));
        propsInfo.put("A030", new PropInfo("C", 4));
        propsInfo.put("A031", new PropInfo("N", 3));
        propsInfo.put("A032", new PropInfo("N", 3));
        propsInfo.put("A037", new PropInfo("N", 14));
        propsInfo.put("A038", new PropInfo("N", 3));
        propsInfo.put("A050", new PropInfo("N", 2));
        propsInfo.put("A052", new PropInfo("N", 3));
        propsInfo.put("A053", new PropInfo("N", 10));
        propsInfo.put("A054", new PropInfo("C", 10));
        propsInfo.put("A061", new PropInfo("N", 8));
        propsInfo.put("A077", new PropInfo("C", 16));
        propsInfo.put("A078", new PropInfo("C", 16));
        propsInfo.put("A085", new PropInfo("C", 10));
        propsInfo.put("A089", new PropInfo("N", 10));
        propsInfo.put("A103", new PropInfo("N", 8));
        propsInfo.put("A105", new PropInfo("N", 4));
        propsInfo.put("A149", new PropInfo("C", 1));
        propsInfo.put("A3148", new PropInfo("N", 1));
        propsInfo.put("A7706", new PropInfo("C", 44));
        propsInfo.put("A7707", new PropInfo("N", 1));
        propsInfo.put("C003", new PropInfo("C", 16));
        propsInfo.put("C004", new PropInfo("N", 6));
        propsInfo.put("C005", new PropInfo("N", 3));
        propsInfo.put("C007", new PropInfo("N", 15));
        propsInfo.put("C012", new PropInfo("C", 128));
        propsInfo.put("C013", new PropInfo("C", 40));
        propsInfo.put("C016", new PropInfo("N", 2));
        propsInfo.put("C017", new PropInfo("N", 2));
        propsInfo.put("C025", new PropInfo("N", 7));
        propsInfo.put("C026", new PropInfo("C", 6));
        propsInfo.put("C042", new PropInfo("N", 1));
        propsInfo.put("C046", new PropInfo("C", 128));
        propsInfo.put("C108", new PropInfo("N", 3));
        propsInfo.put("XA086", new PropInfo("C", 42));
        INNER_REPONSE_NODES = Lists.newArrayList((Object[])new String[]{"XA086", "M120V01OC"});
    }

    private static final class PropInfo {
        private String t;
        private Integer s;

        public PropInfo(String t, Integer s) {
            this.t = t;
            this.s = s;
        }
    }
}

